// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_VertexC_HeaderFile
#define _Graphic3d_VertexC_HeaderFile

#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Quantity_Color;
class Graphic3d_Vertex;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation and update of a point <br>
//!	    with a colour value. <br>//! Returns the color of this point. <br>
class Graphic3d_VertexC  : public Graphic3d_Vertex {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty point <br>
Standard_EXPORT Graphic3d_VertexC();

//! Creates a point with coordinates <AX>, <AY>, <AZ> and <br>
//!	    with colour <AColor>. <br>
Standard_EXPORT Graphic3d_VertexC(const Standard_Real AX,const Standard_Real AY,const Standard_Real AZ,const Quantity_Color& AColor);

//! Creates a point situated in <APoint> and <br>
//!	    for which the colour is <AColor>. <br>
Standard_EXPORT Graphic3d_VertexC(const Graphic3d_Vertex& APoint,const Quantity_Color& AColor);

//! Modifies the colour of the point <me>. <br>
Standard_EXPORT   void SetColor(const Quantity_Color& ColorNew) ;

//! Returns the colour of the point <me>. <br>
Standard_EXPORT   Quantity_Color Color() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Quantity_Color MyColor;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
