// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_TypeFilter_HeaderFile
#define _AIS_TypeFilter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_TypeFilter_HeaderFile
#include <Handle_AIS_TypeFilter.hxx>
#endif

#ifndef _AIS_KindOfInteractive_HeaderFile
#include <AIS_KindOfInteractive.hxx>
#endif
#ifndef _SelectMgr_Filter_HeaderFile
#include <SelectMgr_Filter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_SelectMgr_EntityOwner_HeaderFile
#include <Handle_SelectMgr_EntityOwner.hxx>
#endif
class SelectMgr_EntityOwner;


//! Selects Interactive Objects through their types. The <br>
//! filter questions each Interactive Object in local context <br>
//! to determine whether it has an non-null owner, and if <br>
//! so, whether it is of the desired type. If the object <br>
//! returns true in each case, it is kept. If not, it is rejected. <br>
//! By default, the   interactive object has a None   type <br>
//! and a signature of 0. A filter for type specifies a <br>
//! choice of type out of a range at any level enumerated <br>
//! for type or kind. The choice could be for kind of <br>
//! interactive object, of dimension, of unit, or type of axis, <br>
//! plane or attribute. <br>
//! If you want to give a particular type and signature to <br>
//! your Interactive Object, you must redefine two virtual <br>
//! methods:   Type and Signature. <br>
//! This filter is used in both Neutral Point and open local contexts. <br>
//! In the Collector viewer, you can only locate <br>
//! Interactive Objects which answer positively to the <br>
//! positioned filters when a local context is open. <br>
//! Warning <br>
//! When you close a local context, all temporary <br>
//! interactive objects are deleted, all selection modes <br>
//! concerning the context are cancelled, and all content <br>
//! filters are emptied. <br>
class AIS_TypeFilter : public SelectMgr_Filter {

public:
 // Methods PUBLIC
 // 

//! Initializes filter for type, aGivenKind. <br>
Standard_EXPORT AIS_TypeFilter(const AIS_KindOfInteractive aGivenKind);

//! Returns False if the transient is not an Interactive <br>
//! Object, or if the type of the Interactive Object is not <br>
//! the same as that stored in the filter. <br>
Standard_EXPORT virtual  Standard_Boolean IsOk(const Handle(SelectMgr_EntityOwner)& anobj) const;
//Standard_EXPORT ~AIS_TypeFilter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
AIS_KindOfInteractive myKind;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
