/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuniqueapplication.h>

#include "oooqs2.h"

static const char description[] =
   I18N_NOOP( "OpenOffice.org Quickstarter 2 for KDE\n"
   "\n\"Good things come to those who wait\"-Release" );

static const char version[] = "1.0";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
   KCmdLineLastOption
};

int main( int argc, char **argv )
{
   KAboutData about( "oooqs2",
      I18N_NOOP( "OpenOffice.org Quickstarter 2" ), version, description,
      KAboutData::License_GPL, "(C) 2006 Christian Nitschkowski", 0, 0,
      "christian.nitschkowski@kdemail.net" );
   about.addAuthor( "Christian Nitschkowski", 0,
      "christian.nitschkowski@kdemail.net" );
   about.addCredit( "Jessica Dawidowski", "Beta Testing" );
   KCmdLineArgs::init( argc, argv, &about );
   KCmdLineArgs::addCmdLineOptions( options );

   KUniqueApplication app;
   app.disableSessionManagement();
   app.dcopClient()->registerAs( app.name(), false );
   app.dcopClient()->setDefaultObject( "OOoQs2Iface" );

   OOoQs2 *mainWin = 0;

   KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

   mainWin = new OOoQs2( &about );
   app.setMainWidget( mainWin );
   mainWin->show();

   args->clear();

   return app.exec();
}
