############################################################################
#    Copyright (C) 2008-2009 by David Palacio                              #
#    dpalacio@uninorte.edu.co                                              #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          #
############################################################################

require 'korundum4'
require 'reader'

def kdeapp
    about = KDE::AboutData.new(
        'omaque', # app internal name
        'omaque', # translation catalog name
        KDE.ki18n( 'Omaque' ), # name to be displayed
        '1.0', #version
        KDE.ki18n( 'An extra comic reader based on Okular' ), #description
        KDE::AboutData::License_GPL_V3, #license
        KDE.ki18n( '(c) 2008-2009 David Palacio' ) # copyright statement
    ) #AboutData
    KDE::CmdLineArgs.init(ARGV, about)
    options = KDE::CmdLineOptions.new
    options.add '+[file]', KDE.ki18n('Comicbook to open')
    KDE::CmdLineArgs.add_cmd_line_options options
    KDE::Application.new
end
kdeapp

args = KDE::CmdLineArgs.parsed_args
url = args.count > 0 ?
    args.url(0) :
    nil
main = Reader::MainWindow.new
main.object_name = 'OmaqueReader#'
main.show
main.open_comic_book url if url
$kapp.exec
