/*
 * Copyright (c) OSGi Alliance (2001, 2009). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javax.swing.event;
public interface DocumentEvent {
	public interface ElementChange {
		javax.swing.text.Element[] getChildrenAdded();
		javax.swing.text.Element[] getChildrenRemoved();
		javax.swing.text.Element getElement();
		int getIndex();
	}
	public static final class EventType {
		public final static javax.swing.event.DocumentEvent.EventType CHANGE; static { CHANGE = null; }
		public final static javax.swing.event.DocumentEvent.EventType INSERT; static { INSERT = null; }
		public final static javax.swing.event.DocumentEvent.EventType REMOVE; static { REMOVE = null; }
		private EventType() { } /* generated constructor to prevent compiler adding default public constructor */
	}
	javax.swing.event.DocumentEvent.ElementChange getChange(javax.swing.text.Element var0);
	javax.swing.text.Document getDocument();
	int getLength();
	int getOffset();
	javax.swing.event.DocumentEvent.EventType getType();
}

