/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "instantaneousgesturearea.h"

#include "gestureevent.h"

InstantaneousGestureArea::InstantaneousGestureArea(QDeclarativeItem* parent,
                                                   Primitive primitive)
  : GestureArea(parent, primitive) {
}

bool InstantaneousGestureArea::IsGestureEventHandled(GestureEvent* event) {
  bool handled = GestureArea::IsGestureEventHandled(event);

  emit gestureOccurred(event);
  return (handled || receivers(SIGNAL(gestureOccurred(GestureEvent*))) > 0) &&
         event->accepted();
}

void InstantaneousGestureArea::HandleGestureUpdateEvent(bool end,
                                                     GestureEvent* event) {
  qWarning("Attempted to handle update/end event for instantaneous gesture");
}

