

%  This example demonstrates the use of vtkCardinalSpline.
%  It creates random points and connects them with a spline

vtk_init;
vtkColors;

%  This will be used later to get random numbers.
math = vtkMath();

%  Total number of points.
numberOfInputPoints = 10;

%  One spline for each direction.
aSplineX = vtkCardinalSpline();
aSplineY = vtkCardinalSpline();
aSplineZ = vtkCardinalSpline();

%  Generate random (pivot) points and add the corresponding
%  coordinates to the splines.
%  aSplineX will interpolate the x values of the points
%  aSplineY will interpolate the y values of the points
%  aSplineZ will interpolate the z values of the points
inputPoints = vtkPoints();
for i = 0:numberOfInputPoints;
    x = math.Random(0, 1);
    y = math.Random(0, 1);
    z = math.Random(0, 1);
    aSplineX.AddPoint(i, x);
    aSplineY.AddPoint(i, y);
    aSplineZ.AddPoint(i, z);
    inputPoints.InsertPoint(i, x, y, z);
end

%  The following section will create glyphs for the pivot points
%  in order to make the effect of the spline more clear.

%  Create a polydata to be glyphed.
inputData = vtkPolyData();
inputData.SetPoints(inputPoints);

%  Use sphere as glyph source.
balls = vtkSphereSource();
balls.SetRadius(.01);
balls.SetPhiResolution(10);
balls.SetThetaResolution(10);

glyphPoints = vtkGlyph3D();
glyphPoints.SetInput(inputData);
glyphPoints.SetSource(balls.GetOutput());

glyphMapper = vtkPolyDataMapper();
glyphMapper.SetInput(glyphPoints.GetOutput());

glyph = vtkActor();
glyph.SetMapper(glyphMapper);
glyph.GetProperty().SetDiffuseColor(tomato);
glyph.GetProperty().SetSpecular(.3);
glyph.GetProperty().SetSpecularPower(30);

%  Generate the polyline for the spline.
points = vtkPoints();
profileData = vtkPolyData();

%  Number of points on the spline
numberOfOutputPoints = 400;

%  Interpolate x, y and z by using the three spline filters and
%  create new points
for i = 0:numberOfOutputPoints;
    t = (numberOfInputPoints-1.0)/(numberOfOutputPoints-1.0)*i;
    points.InsertPoint(i, aSplineX.Evaluate(t), aSplineY.Evaluate(t),aSplineZ.Evaluate(t));
end

%  Create the polyline.
lines = vtkCellArray();
lines.InsertNextCell(numberOfOutputPoints);
for i = 0:numberOfOutputPoints
    lines.InsertCellPoint(i);
end
profileData.SetPoints(points);
profileData.SetLines(lines);

%  Add thickness to the resulting line.
profileTubes = vtkTubeFilter();
profileTubes.SetNumberOfSides(8);
profileTubes.SetInput(profileData);
profileTubes.SetRadius(.005);

profileMapper = vtkPolyDataMapper();
profileMapper.SetInput(profileTubes.GetOutput());

profile = vtkActor();
profile.SetMapper(profileMapper);
profile.GetProperty().SetDiffuseColor(banana);
profile.GetProperty().SetSpecular(.3);
profile.GetProperty().SetSpecularPower(30);

%  Now create the RenderWindow, Renderer and Interactor
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);

iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors
ren.AddActor(glyph);
ren.AddActor(profile);

renWin.SetSize(500, 500);


% renWin.Render();
vtkInitializeInteractor(iren);
