%%NAME
%%  ehtmlnew  -  create new html file
%%
%%SYNOPSIS
%%  ehtmlnew(htmlFileName [,background [,reload]])
%%
%%PARAMETER(S)
%%  htmlFileName   name of html-file
%%  background     color vector or image filename string
%%                 default: [1 1 1]
%%  reload         auto reload; if 0 then no reload else time interval in sec
%%                 default: 0
%%GLOBAL PARAMETER(S)
%%  eFileName
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function [htmlFileName]=ehtmlnew(htmlFileName,background,reload)
  if (nargin<1)||(nargin>4)
    eusage('ehtmlnew(htmlFileName, [,background [,reload]])');
  end
  eglobpar;
  if exist('eFac')
    if isempty(eFac)
      einit;
    end
  else
    einit;
  end
  if nargin<2
    background=[1 1 1]; % white background
  end
  if nargin<3
    reload=0;
  end

  htmlFile=fopen(htmlFileName,'w');
  fprintf(htmlFile,'<HTML>\n<HEAD>\n');
  fprintf(htmlFile,'<! created by ehtml*.m of EpsTk>\n');
  if reload>0
    fprintf(htmlFile,'<meta http-equiv=\"refresh\" content=\"%d\">\n',reload);
  end
  fprintf(htmlFile,'</HEAD>\n');
  if ischar(background)
    fprintf(htmlFile,'<BODY BACKGROUND=\"%s\">\n',background);
  else
    background=fix(background*255); 
    fprintf(htmlFile,'<BODY BGCOLOR=\"#%02x%02x%02x\">\n', ...
            background(1),background(2),background(3));
  end
  fprintf(htmlFile,'<CENTER>\n');
  fprintf(htmlFile,'</CENTER></BODY>\n<HTML>\n');
  fclose(htmlFile);
  end
