// -*- C++ -*-

// Copyright 2006 Deutsches Forschungszentrum fuer Kuenstliche Intelligenz
// or its licensors, as applicable.
//
// You may not use this file except under the terms of the accompanying license.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you
// may not use this file except in compliance with the License. You may
// obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Project: bpnet -- Neural Network Classifier
// File: grouping.h
// Purpose: train and recognize lines
// Responsible: Hagen Kaprykowsky (kapry@iupr.net)
// Reviewer: Yves Rangoni (rangoni@iupr.net)
// Primary Repository:
// Web Sites: www.iupr.org, www.dfki.de

#ifndef grouping_h__
#define grouping_h__

#include "colib.h"

namespace ocropus {
    colib::IRecognizeLine *make_NewGroupingLineOCR(colib::ICharacterClassifier *classifier, 
        colib::ISegmentLine *segmenter, 
        bool use_line_info = true);
}

#endif
