// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gp_XYZ_HeaderFile
#define _gp_XYZ_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class Standard_OutOfRange;
class gp_Mat;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(gp_XYZ);


//!  This class describes a cartesian coordinate entity in <br>
//!  3D space {X,Y,Z}. This entity is used for algebraic <br>
//!  calculation. This entity can be transformed <br>
//!  with a "Trsf" or a  "GTrsf" from package "gp". <br>
//! It is used in vectorial computations or for holding this type <br>
//! of information in data structures. <br>
class gp_XYZ  {

public:
  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates an XYZ object with zero co-ordinates (0,0,0) <br>
      gp_XYZ();
  //! creates an XYZ with given coordinates <br>
      gp_XYZ(const Standard_Real X,const Standard_Real Y,const Standard_Real Z);
  //! For this XYZ object, assigns <br>
//!   the values X, Y and Z to its three coordinates <br>
        void SetCoord(const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;
  
//!  modifies the coordinate of range Index <br>
//!  Index = 1 => X is modified <br>
//!  Index = 2 => Y is modified <br>
//!  Index = 3 => Z is modified <br>
//!  Raises OutOfRange if Index != {1, 2, 3}. <br>
        void SetCoord(const Standard_Integer Index,const Standard_Real Xi) ;
  //! Assigns the given value to the X coordinate <br>
        void SetX(const Standard_Real X) ;
  //! Assigns the given value to the Y coordinate <br>
        void SetY(const Standard_Real Y) ;
  //! Assigns the given value to the Z coordinate <br>
        void SetZ(const Standard_Real Z) ;
  
//!  returns the coordinate of range Index : <br>
//!  Index = 1 => X is returned <br>
//!  Index = 2 => Y is returned <br>
//!  Index = 3 => Z is returned <br>
//! <br>
//! Raises OutOfRange if Index != {1, 2, 3}. <br>
        Standard_Real Coord(const Standard_Integer Index) const;
  
        void Coord(Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;
  //! Returns the X coordinate <br>
        Standard_Real X() const;
  //! Returns the Y coordinate <br>
        Standard_Real Y() const;
  //! Returns the Z coordinate <br>
        Standard_Real Z() const;
  //! computes Sqrt (X*X + Y*Y + Z*Z) where X, Y and Z are the three coordinates of this XYZ object. <br>
        Standard_Real Modulus() const;
  //! Computes X*X + Y*Y + Z*Z where X, Y and Z are the three coordinates of this XYZ object. <br>
        Standard_Real SquareModulus() const;
  
//!  Returns True if he coordinates of this XYZ object are <br>
//! equal to the respective coordinates Other, <br>
//! within the specified tolerance Tolerance. I.e.: <br>
//!  abs(<me>.X() - Other.X()) <= Tolerance and <br>
//!  abs(<me>.Y() - Other.Y()) <= Tolerance and <br>
//!  abs(<me>.Z() - Other.Z()) <= Tolerance. <br>
  Standard_EXPORT     Standard_Boolean IsEqual(const gp_XYZ& Other,const Standard_Real Tolerance) const;
  
//! <me>.X() = <me>.X() + Other.X() <br>
//! <me>.Y() = <me>.Y() + Other.Y() <br>
//! <me>.Z() = <me>.Z() + Other.Z() <br>
        void Add(const gp_XYZ& Other) ;
      void operator +=(const gp_XYZ& Other) 
{
  Add(Other);
}
  
//! new.X() = <me>.X() + Other.X() <br>
//! new.Y() = <me>.Y() + Other.Y() <br>
//! new.Z() = <me>.Z() + Other.Z() <br>
        gp_XYZ Added(const gp_XYZ& Other) const;
      gp_XYZ operator +(const gp_XYZ& Other) const
{
  return Added(Other);
}
  
//! <me>.X() = <me>.Y() * Other.Z() - <me>.Z() * Other.Y() <br>
//! <me>.Y() = <me>.Z() * Other.X() - <me>.X() * Other.Z() <br>
//! <me>.Z() = <me>.X() * Other.Y() - <me>.Y() * Other.X() <br>
        void Cross(const gp_XYZ& Right) ;
      void operator ^=(const gp_XYZ& Right) 
{
  Cross(Right);
}
  
//! new.X() = <me>.Y() * Other.Z() - <me>.Z() * Other.Y() <br>
//! new.Y() = <me>.Z() * Other.X() - <me>.X() * Other.Z() <br>
//! new.Z() = <me>.X() * Other.Y() - <me>.Y() * Other.X() <br>
        gp_XYZ Crossed(const gp_XYZ& Right) const;
      gp_XYZ operator ^(const gp_XYZ& Right) const
{
  return Crossed(Right);
}
  
//!  Computes the magnitude of the cross product between <me> and <br>
//!  Right. Returns || <me> ^ Right || <br>
        Standard_Real CrossMagnitude(const gp_XYZ& Right) const;
  
//!  Computes the square magnitude of the cross product between <me> and <br>
//!  Right. Returns || <me> ^ Right ||**2 <br>
        Standard_Real CrossSquareMagnitude(const gp_XYZ& Right) const;
  //! Triple vector product <br>
//!  Computes <me> = <me>.Cross(Coord1.Cross(Coord2)) <br>
        void CrossCross(const gp_XYZ& Coord1,const gp_XYZ& Coord2) ;
  //! Triple vector product <br>
//!  computes New = <me>.Cross(Coord1.Cross(Coord2)) <br>
        gp_XYZ CrossCrossed(const gp_XYZ& Coord1,const gp_XYZ& Coord2) const;
  //! divides <me> by a real. <br>
        void Divide(const Standard_Real Scalar) ;
      void operator /=(const Standard_Real Scalar) 
{
  Divide(Scalar);
}
  //! divides <me> by a real. <br>
        gp_XYZ Divided(const Standard_Real Scalar) const;
      gp_XYZ operator /(const Standard_Real Scalar) const
{
  return Divided(Scalar);
}
  //! computes the scalar product between <me> and Other <br>
        Standard_Real Dot(const gp_XYZ& Other) const;
      Standard_Real operator *(const gp_XYZ& Other) const
{
  return Dot(Other);
}
  //! computes the triple scalar product <br>
        Standard_Real DotCross(const gp_XYZ& Coord1,const gp_XYZ& Coord2) const;
  
//!  <me>.X() = <me>.X() * Scalar; <br>
//!  <me>.Y() = <me>.Y() * Scalar; <br>
//!  <me>.Z() = <me>.Z() * Scalar; <br>
        void Multiply(const Standard_Real Scalar) ;
      void operator *=(const Standard_Real Scalar) 
{
  Multiply(Scalar);
}
  
//!  <me>.X() = <me>.X() * Other.X(); <br>
//!  <me>.Y() = <me>.Y() * Other.Y(); <br>
//!  <me>.Z() = <me>.Z() * Other.Z(); <br>
        void Multiply(const gp_XYZ& Other) ;
      void operator *=(const gp_XYZ& Other) 
{
  Multiply(Other);
}
  //! <me> = Matrix * <me> <br>
        void Multiply(const gp_Mat& Matrix) ;
      void operator *=(const gp_Mat& Matrix) 
{
  Multiply(Matrix);
}
  
//!  New.X() = <me>.X() * Scalar; <br>
//!  New.Y() = <me>.Y() * Scalar; <br>
//!  New.Z() = <me>.Z() * Scalar; <br>
        gp_XYZ Multiplied(const Standard_Real Scalar) const;
      gp_XYZ operator *(const Standard_Real Scalar) const
{
  return Multiplied(Scalar);
}
  
//!  new.X() = <me>.X() * Other.X(); <br>
//!  new.Y() = <me>.Y() * Other.Y(); <br>
//!  new.Z() = <me>.Z() * Other.Z(); <br>
        gp_XYZ Multiplied(const gp_XYZ& Other) const;
  //!  New = Matrix * <me> <br>
        gp_XYZ Multiplied(const gp_Mat& Matrix) const;
      gp_XYZ operator *(const gp_Mat& Matrix) const
{
  return Multiplied(Matrix);
}
  
//!  <me>.X() = <me>.X()/ <me>.Modulus() <br>
//!  <me>.Y() = <me>.Y()/ <me>.Modulus() <br>
//!  <me>.Z() = <me>.Z()/ <me>.Modulus() <br>//! Raised if <me>.Modulus() <= Resolution from gp <br>
        void Normalize() ;
  
//!  New.X() = <me>.X()/ <me>.Modulus() <br>
//!  New.Y() = <me>.Y()/ <me>.Modulus() <br>
//!  New.Z() = <me>.Z()/ <me>.Modulus() <br>//! Raised if <me>.Modulus() <= Resolution from gp <br>
        gp_XYZ Normalized() const;
  
//!  <me>.X() = -<me>.X() <br>
//!  <me>.Y() = -<me>.Y() <br>
//!  <me>.Z() = -<me>.Z() <br>
        void Reverse() ;
  
//!  New.X() = -<me>.X() <br>
//!  New.Y() = -<me>.Y() <br>
//!  New.Z() = -<me>.Z() <br>
        gp_XYZ Reversed() const;
  
//!  <me>.X() = <me>.X() - Other.X() <br>
//!  <me>.Y() = <me>.Y() - Other.Y() <br>
//!  <me>.Z() = <me>.Z() - Other.Z() <br>
        void Subtract(const gp_XYZ& Right) ;
      void operator -=(const gp_XYZ& Right) 
{
  Subtract(Right);
}
  
//!  new.X() = <me>.X() - Other.X() <br>
//!  new.Y() = <me>.Y() - Other.Y() <br>
//!  new.Z() = <me>.Z() - Other.Z() <br>
        gp_XYZ Subtracted(const gp_XYZ& Right) const;
      gp_XYZ operator -(const gp_XYZ& Right) const
{
  return Subtracted(Right);
}
  
//!  <me> is set to the following linear form : <br>
//!  A1 * XYZ1 + A2 * XYZ2 + A3 * XYZ3 + XYZ4 <br>
        void SetLinearForm(const Standard_Real A1,const gp_XYZ& XYZ1,const Standard_Real A2,const gp_XYZ& XYZ2,const Standard_Real A3,const gp_XYZ& XYZ3,const gp_XYZ& XYZ4) ;
  
//!  <me> is set to the following linear form : <br>
//!  A1 * XYZ1 + A2 * XYZ2 + A3 * XYZ3 <br>
        void SetLinearForm(const Standard_Real A1,const gp_XYZ& XYZ1,const Standard_Real A2,const gp_XYZ& XYZ2,const Standard_Real A3,const gp_XYZ& XYZ3) ;
  
//!  <me> is set to the following linear form : <br>
//!  A1 * XYZ1 + A2 * XYZ2 + XYZ3 <br>
        void SetLinearForm(const Standard_Real A1,const gp_XYZ& XYZ1,const Standard_Real A2,const gp_XYZ& XYZ2,const gp_XYZ& XYZ3) ;
  
//!  <me> is set to the following linear form : <br>
//!  A1 * XYZ1 + A2 * XYZ2 <br>
        void SetLinearForm(const Standard_Real A1,const gp_XYZ& XYZ1,const Standard_Real A2,const gp_XYZ& XYZ2) ;
  
//!  <me> is set to the following linear form : <br>
//!  A1 * XYZ1 + XYZ2 <br>
        void SetLinearForm(const Standard_Real A1,const gp_XYZ& XYZ1,const gp_XYZ& XYZ2) ;
  
//!  <me> is set to the following linear form : <br>
//!  XYZ1 + XYZ2 <br>
        void SetLinearForm(const gp_XYZ& XYZ1,const gp_XYZ& XYZ2) ;
    Standard_Real _CSFDB_Getgp_XYZx() const { return x; }
    void _CSFDB_Setgp_XYZx(const Standard_Real p) { x = p; }
    Standard_Real _CSFDB_Getgp_XYZy() const { return y; }
    void _CSFDB_Setgp_XYZy(const Standard_Real p) { y = p; }
    Standard_Real _CSFDB_Getgp_XYZz() const { return z; }
    void _CSFDB_Setgp_XYZz(const Standard_Real p) { z = p; }



protected:




private: 


Standard_Real x;
Standard_Real y;
Standard_Real z;


};


#include <gp_XYZ.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
