// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Law_BSplineKnotSplitting_HeaderFile
#define _Law_BSplineKnotSplitting_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Law_BSpline_HeaderFile
#include <Handle_Law_BSpline.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColStd_HArray1OfInteger;
class Standard_DimensionError;
class Standard_RangeError;
class Law_BSpline;
class TColStd_Array1OfInteger;



//!  For a B-spline curve the discontinuities are localised at the <br>
//!  knot values and between two knots values the B-spline is <br>
//!  infinitely continuously differentiable. <br>
//!  At a knot of range index the continuity is equal to : <br>
//!  Degree - Mult (Index)   where  Degree is the degree of the <br>
//!  basis B-spline functions and Mult the multiplicity of the knot <br>
//!  of range Index. <br>
//!  If for your computation you need to have B-spline curves with a <br>
//!  minima of continuity it can be interesting to know between which <br>
//!  knot values, a B-spline curve arc, has a continuity of given order. <br>
//!  This algorithm computes the indexes of the knots where you should <br>
//!  split the curve, to obtain arcs with a constant continuity given <br>
//!  at the construction time. The splitting values are in the range <br>
//!  [FirstUKnotValue, LastUKnotValue] (See class B-spline curve from <br>
//!  package Geom). <br>
//!  If you just want to compute the local derivatives on the curve you <br>
//!  don't need to create the B-spline curve arcs, you can use the <br>
//!  functions LocalD1, LocalD2, LocalD3, LocalDN of the class <br>
//!  BSplineCurve. <br>
class Law_BSplineKnotSplitting  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!  Locates the knot values which correspond to the segmentation of <br>
//!  the curve into arcs with a continuity equal to ContinuityRange. <br>
//!  Raised if ContinuityRange is not greater or equal zero. <br>
  Standard_EXPORT   Law_BSplineKnotSplitting(const Handle(Law_BSpline)& BasisLaw,const Standard_Integer ContinuityRange);
  
//!  Returns the number of knots corresponding to the splitting. <br>
  Standard_EXPORT     Standard_Integer NbSplits() const;
  
//!  Returns the indexes of the BSpline curve knots corresponding to <br>
//!  the splitting. <br>
//!  Raised if the length of SplitValues is not equal to NbSPlit. <br>
  Standard_EXPORT     void Splitting(TColStd_Array1OfInteger& SplitValues) const;
  
//!  Returns the index of the knot corresponding to the splitting <br>
//!  of range Index. <br>
//!  Raised if Index < 1 or Index > NbSplits <br>
  Standard_EXPORT     Standard_Integer SplitValue(const Standard_Integer Index) const;





protected:





private:



Handle_TColStd_HArray1OfInteger splitIndexes;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
