// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _LocOpe_CSIntersector_HeaderFile
#define _LocOpe_CSIntersector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class TopoDS_Shape;
class LocOpe_SequenceOfLin;
class LocOpe_SequenceOfCirc;
class TColGeom_SequenceOfCurve;
class LocOpe_PntFace;


//! This class provides the intersection between a set <br>
//!          of axis or a circle and the faces of a shape.  The <br>
//!          intersection  points  are   sorted  in  increasing <br>
//!          parameter along each axis or circle. <br>
class LocOpe_CSIntersector  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Empty constructor. <br>
      LocOpe_CSIntersector();
  //! Creates  and performs the intersection     betwwen <br>
//!          <Ax1> and <S>. <br>
      LocOpe_CSIntersector(const TopoDS_Shape& S);
  //! Performs the intersection between <Ax1 and <S>. <br>
  Standard_EXPORT     void Init(const TopoDS_Shape& S) ;
  
  Standard_EXPORT     void Perform(const LocOpe_SequenceOfLin& Slin) ;
  
  Standard_EXPORT     void Perform(const LocOpe_SequenceOfCirc& Scir) ;
  
  Standard_EXPORT     void Perform(const TColGeom_SequenceOfCurve& Scur) ;
  //! Returns <Standard_True>  if the  intersection  has <br>
//!          been done. <br>
        Standard_Boolean IsDone() const;
  //! Returns  the number of   intersection point on the <br>
//!          element of range <I>. <br>
  Standard_EXPORT     Standard_Integer NbPoints(const Standard_Integer I) const;
  //! Returns the intersection point of range <Index> on <br>
//!          element of range   <I>. The points   are sorted in <br>
//!          increasing order of parameter along the axis. <br>
  Standard_EXPORT    const LocOpe_PntFace& Point(const Standard_Integer I,const Standard_Integer Index) const;
  //! On  the element of range   <I>, searches the first <br>
//!          intersection   point  located after  the parameter <br>
//!          <From>,   wich orientation is not TopAbs_EXTERNAL. <br>
//!          If  found, returns <Standard_True>.  <Or> contains <br>
//!          the orientation    of  the  point,  <IndFrom>  and <br>
//!          <IndTo> represents  the interval  of index in  the <br>
//!          sequence  of intersection  point corresponding  to <br>
//!          the  point. (IndFrom <=   IndTo). <Tol> is used to <br>
//!          determine if 2 parameters are equal. <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
  Standard_EXPORT     Standard_Boolean LocalizeAfter(const Standard_Integer I,const Standard_Real From,const Standard_Real Tol,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;
  //! On the element  of range  <I>, searches the  first <br>
//!          intersection point   located before  the parameter <br>
//!          <From>,  wich orientation  is not TopAbs_EXTERNAL. <br>
//!          If found,  returns <Standard_True>.  <Or> contains <br>
//!          the   orientation  of   the point,  <IndFrom>  and <br>
//!          <IndTo> represents the interval   of index in  the <br>
//!          sequence of  intersection  point corresponding  to <br>
//!          the point (IndFrom  <=  IndTo). <Tol> is   used to <br>
//!          determine if 2 parameters are equal. <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
  Standard_EXPORT     Standard_Boolean LocalizeBefore(const Standard_Integer I,const Standard_Real From,const Standard_Real Tol,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;
  //! On the  element of  range <I>, searches  the first <br>
//!          intersection      point  located after the   index <br>
//!          <FromInd> ( >=  FromInd + 1), wich  orientation is <br>
//!          not    TopAbs_EXTERNAL.      If    found,  returns <br>
//!          <Standard_True>.  <Or> contains the orientation of <br>
//!          the  point, <IndFrom>  and <IndTo> represents  the <br>
//!          interval of index in  the sequence of intersection <br>
//!          point corresponding   to the  point.  (IndFrom  <= <br>
//!          IndTo). <Tol> is used to determine if 2 parameters <br>
//!          are equal. <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
  Standard_EXPORT     Standard_Boolean LocalizeAfter(const Standard_Integer I,const Standard_Integer FromInd,const Standard_Real Tol,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;
  //! On  the element of  range  <I>, searches the first <br>
//!          intersection  point    located  before  the  index <br>
//!          <FromInd>  (  <= FromInd -1),  wich orientation is <br>
//!          not   TopAbs_EXTERNAL.  If    found,       returns <br>
//!          <Standard_True>.  <Or> contains the orientation of <br>
//!          the  point, <IndFrom>  and  <IndTo> represents the <br>
//!          interval of  index in the sequence of intersection <br>
//!          point  corresponding to   the  point  (IndFrom  <= <br>
//!          IndTo). <Tol> is used to determine if 2 parameters <br>
//!          are equal. <br>
//! <br>
//!          Otherwise, returns <Standard_False>. <br>
  Standard_EXPORT     Standard_Boolean LocalizeBefore(const Standard_Integer I,const Standard_Integer FromInd,const Standard_Real Tol,TopAbs_Orientation& Or,Standard_Integer& IndFrom,Standard_Integer& IndTo) const;
  
  Standard_EXPORT     void Destroy() ;
~LocOpe_CSIntersector()
{
  Destroy();
}





protected:





private:



Standard_Boolean myDone;
TopoDS_Shape myShape;
Standard_Address myPoints;
Standard_Integer myNbelem;


};


#include <LocOpe_CSIntersector.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
