// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Graphic2d_Marker_HeaderFile
#define _Graphic2d_Marker_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Graphic2d_Marker_HeaderFile
#include <Handle_Graphic2d_Marker.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
class Graphic2d_MarkerDefinitionError;
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;


//! The primitive Marker <br>
class Graphic2d_Marker : public Graphic2d_Line {

public:

  //! Creates a pixel point marker at position <X>,<Y> <br>
  Standard_EXPORT   Graphic2d_Marker(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Quantity_Length X,const Quantity_Length Y);
  //! Creates the predefined marker index <anIndex> <br>
//!	    at position <X>,<Y> and size <aWidth>,<aHeight>. <br>
//!	    Angle is measured counterclockwise with 0 radian <br>
//!	    at 3 o'clock. <br>
  Standard_EXPORT   Graphic2d_Marker(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Standard_Integer anIndex,const Quantity_Length X,const Quantity_Length Y,const Quantity_Length aWidth,const Quantity_Length anHeight,const Quantity_PlaneAngle anAngle = 0.0);
  //! returns the coordinates of the position of the marker <br>
  Standard_EXPORT     void Position(Quantity_Length& X,Quantity_Length& Y) const;
  //! returns the width and height of the marker <br>
  Standard_EXPORT     void Size(Quantity_Length& aW,Quantity_Length& aH) const;
  //! returns the index of marker in the map of markers <br>
  Standard_EXPORT     Standard_Integer Index() const;
  //! returns the angle of the marker <br>
  Standard_EXPORT     Quantity_PlaneAngle Angle() const;
  
  Standard_EXPORT   virtual  void Save(Aspect_FStream& aFStream) const;




  DEFINE_STANDARD_RTTI(Graphic2d_Marker)

protected:

  //! Draws the marker <me>. <br>
  Standard_EXPORT     void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;
  //! Returns Standard_True if the marker <me> is picked, <br>
//!	    Standard_False if not. <br>
//!  Warning: Checks only if the point <X>, <Y> is in the <br>
//!	    boundary rectangle of <me> <br>
  Standard_EXPORT     Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;
  
  Standard_EXPORT   virtual  void DrawVertex(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Integer anIndex) ;



private: 


Standard_Integer myMarkIndex;
Standard_ShortReal myX;
Standard_ShortReal myY;
Standard_ShortReal myWidth;
Standard_ShortReal myHeight;
Standard_ShortReal myAngle;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
