// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Convert_CylinderToBSplineSurface_HeaderFile
#define _Convert_CylinderToBSplineSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Convert_ElementarySurfaceToBSplineSurface_HeaderFile
#include <Convert_ElementarySurfaceToBSplineSurface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_Cylinder;



//!  This algorithm converts a bounded cylinder into a rational <br>
//!  B-spline surface. The cylinder is a Cylinder from package gp. <br>
//!  The parametrization of the cylinder is  : <br>
//!  P (U, V) = Loc + V * Zdir + Radius * (Xdir*Cos(U) + Ydir*Sin(U)) <br>
//!  where Loc is the location point of the cylinder, Xdir, Ydir and <br>
//!  Zdir are the normalized directions of the local cartesian <br>
//!  coordinate system of the cylinder (Zdir is the direction of the <br>
//!  cylinder's axis). The U parametrization range is U [0, 2PI]. <br>
//! KeyWords : <br>
//!  Convert, Cylinder, BSplineSurface. <br>
class Convert_CylinderToBSplineSurface  : public Convert_ElementarySurfaceToBSplineSurface {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!  The equivalent B-splineSurface as the same orientation as the <br>
//!  cylinder in the U and V parametric directions. <br>
//!  Raised if U1 = U2 or U1 = U2 + 2.0 * Pi <br>
//!  Raised if V1 = V2. <br>
  Standard_EXPORT   Convert_CylinderToBSplineSurface(const gp_Cylinder& Cyl,const Standard_Real U1,const Standard_Real U2,const Standard_Real V1,const Standard_Real V2);
  
//!  The equivalent B-splineSurface as the same orientation as the <br>
//!  cylinder in the U and V parametric directions. <br>
//!  Raised if V1 = V2. <br>
  Standard_EXPORT   Convert_CylinderToBSplineSurface(const gp_Cylinder& Cyl,const Standard_Real V1,const Standard_Real V2);





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
