#include <cctbx/sgtbx/brick.h>
#include <scitbx/rational.h>

namespace cctbx { namespace sgtbx {

  namespace raw_bricks {
  namespace {

    struct entry
    {
      int sg_number;
      const char *hall_symbol;
      int points[3][2];
    };

    static const entry table[] = {
// BEGIN_COMPILED_IN_REFERENCE_DATA
{  1," P 1",{{0,49},{0,49},{0,49}}}, // P 1
{  2,"-P 1",{{0,49},{0,24},{0,49}}}, // P -1
{  3," P 2y",{{0,24},{0,49},{0,49}}}, // P 1 2 1
{  3," P 2",{{0,49},{0,24},{0,49}}}, // P 1 1 2
{  3," P 2x",{{0,49},{0,24},{0,49}}}, // P 2 1 1
{  4," P 2yb",{{0,49},{0,25},{0,49}}}, // P 1 21 1
{  4," P 2c",{{0,49},{0,24},{0,49}}}, // P 1 1 21
{  4," P 2xa",{{0,49},{0,24},{0,49}}}, // P 21 1 1
{  5," C 2y",{{0,24},{0,25},{0,49}}}, // C 1 2 1
{  5," C 2y (x-y,x+y,z)",{{0,49},{0,49},{0,24}}},
{  5," A 2y",{{0,24},{0,25},{0,49}}}, // A 1 2 1
{  5," C 2y (z,x-y,x+y)",{{0,24},{0,49},{0,49}}},
{  5," I 2y",{{0,24},{0,25},{0,49}}}, // I 1 2 1
{  5," C 2y (-x+y,z,x+y+z)",{{0,49},{0,24},{0,49}}},
{  5," A 2",{{0,49},{0,12},{0,49}}}, // A 1 1 2
{  5," C 2y (z,x+y,-x+y)",{{0,24},{0,49},{0,49}}},
{  5," B 2",{{0,25},{0,24},{0,49}}}, // B 1 1 2
{  5," C 2y (-x+y,z,x+y)",{{0,49},{0,24},{0,49}}},
{  5," I 2",{{0,49},{0,12},{0,49}}}, // I 1 1 2
{  5," C 2y (x+y,-x+y+z,z)",{{0,49},{0,49},{0,24}}},
{  5," B 2x",{{0,25},{0,24},{0,49}}}, // B 2 1 1
{  5," C 2y (x+y,z,x-y)",{{0,49},{0,24},{0,49}}},
{  5," C 2x",{{0,49},{0,12},{0,49}}}, // C 2 1 1
{  5," C 2y (x+y,-x+y,z)",{{0,49},{0,49},{0,24}}},
{  5," I 2x",{{0,49},{0,12},{0,49}}}, // I 2 1 1
{  5," C 2y (z,x+y,-x+y+z)",{{0,24},{0,49},{0,49}}},
{  6," P -2y",{{0,49},{0,24},{0,49}}}, // P 1 m 1
{  6," P -2",{{0,49},{0,49},{0,24}}}, // P 1 1 m
{  6," P -2x",{{0,24},{0,49},{0,49}}}, // P m 1 1
{  7," P -2yc",{{0,49},{0,24},{0,49}}}, // P 1 c 1
{  7," P -2yac",{{0,49},{0,24},{0,49}}}, // P 1 n 1
{  7," P -2ya",{{0,49},{0,24},{0,49}}}, // P 1 a 1
{  7," P -2a",{{0,25},{0,49},{0,49}}}, // P 1 1 a
{  7," P -2ab",{{0,49},{0,25},{0,49}}}, // P 1 1 n
{  7," P -2b",{{0,49},{0,25},{0,49}}}, // P 1 1 b
{  7," P -2xb",{{0,49},{0,25},{0,49}}}, // P b 1 1
{  7," P -2xbc",{{0,49},{0,25},{0,49}}}, // P n 1 1
{  7," P -2xc",{{0,24},{0,49},{0,49}}}, // P c 1 1
{  8," C -2y",{{0,49},{0,12},{0,49}}}, // C 1 m 1
{  8," C -2y (x-y,x+y,z)",{{0,49},{0,49},{0,49}}},
{  8," A -2y",{{0,49},{0,12},{0,49}}}, // A 1 m 1
{  8," C -2y (z,x-y,x+y)",{{0,49},{0,49},{0,49}}},
{  8," I -2y",{{0,49},{0,12},{0,49}}}, // I 1 m 1
{  8," C -2y (-x+y,z,x+y+z)",{{0,49},{0,49},{0,49}}},
{  8," A -2",{{0,49},{0,25},{0,24}}}, // A 1 1 m
{  8," C -2y (z,x+y,-x+y)",{{0,49},{0,49},{0,49}}},
{  8," B -2",{{0,25},{0,49},{0,24}}}, // B 1 1 m
{  8," C -2y (-x+y,z,x+y)",{{0,49},{0,49},{0,49}}},
{  8," I -2",{{0,49},{0,25},{0,24}}}, // I 1 1 m
{  8," C -2y (x+y,-x+y+z,z)",{{0,49},{0,49},{0,49}}},
{  8," B -2x",{{0,12},{0,49},{0,49}}}, // B m 1 1
{  8," C -2y (x+y,z,x-y)",{{0,49},{0,49},{0,49}}},
{  8," C -2x",{{0,24},{0,25},{0,49}}}, // C m 1 1
{  8," C -2y (x+y,-x+y,z)",{{0,49},{0,49},{0,49}}},
{  8," I -2x",{{0,24},{0,25},{0,49}}}, // I m 1 1
{  8," C -2y (z,x+y,-x+y+z)",{{0,49},{0,49},{0,49}}},
{  9," C -2yc",{{0,49},{0,12},{0,49}}}, // C 1 c 1
{  9," C -2yc (x-y,x+y,z)",{{0,49},{0,49},{0,25}}},
{  9," A -2yab",{{0,49},{0,12},{0,49}}}, // A 1 n 1
{  9," C -2yc (z,x-y+z,x+y+z)",{{0,25},{0,49},{0,49}}},
{  9," I -2ya",{{0,49},{0,12},{0,49}}}, // I 1 a 1
{  9," C -2yc (-x+y,z,x+y+z)",{{0,49},{0,25},{0,49}}},
{  9," A -2ya",{{0,49},{0,12},{0,49}}}, // A 1 a 1
{  9," C -2yc (z,x-y,x+y)",{{0,25},{0,49},{0,49}}},
{  9," C -2yac",{{0,49},{0,12},{0,49}}}, // C 1 n 1
{  9," C -2yc (x-y+z,x+y+z,z)",{{0,49},{0,49},{0,25}}},
{  9," I -2yc",{{0,49},{0,12},{0,49}}}, // I 1 c 1
{  9," C -2yc (-x+y+z,z,x+y)",{{0,49},{0,25},{0,49}}},
{  9," A -2a",{{0,25},{0,25},{0,49}}}, // A 1 1 a
{  9," C -2yc (z,x+y,-x+y)",{{0,25},{0,49},{0,49}}},
{  9," B -2ab",{{0,25},{0,25},{0,49}}}, // B 1 1 n
{  9," C -2yc (-x+y-z,z,x+y+z)",{{0,49},{0,25},{0,49}}},
{  9," I -2b",{{0,25},{0,25},{0,49}}}, // I 1 1 b
{  9," C -2yc (x+y+z,-x+y,z)",{{0,49},{0,49},{0,25}}},
{  9," B -2b",{{0,25},{0,25},{0,49}}}, // B 1 1 b
{  9," C -2yc (-x+y,z,x+y)",{{0,49},{0,25},{0,49}}},
{  9," A -2ab",{{0,25},{0,25},{0,49}}}, // A 1 1 n
{  9," C -2yc (z,x+y-z,-x+y+z)",{{0,25},{0,49},{0,49}}},
{  9," I -2a",{{0,25},{0,25},{0,49}}}, // I 1 1 a
{  9," C -2yc (x+y,-x+y+z,z)",{{0,49},{0,49},{0,25}}},
{  9," B -2xb",{{0,25},{0,25},{0,49}}}, // B b 1 1
{  9," C -2yc (x+y,z,x-y)",{{0,49},{0,25},{0,49}}},
{  9," C -2xac",{{0,12},{0,49},{0,49}}}, // C n 1 1
{  9," C -2yc (x+y-z,-x+y+z,z)",{{0,49},{0,49},{0,25}}},
{  9," I -2xc",{{0,24},{0,25},{0,49}}}, // I c 1 1
{  9," C -2yc (z,x+y+z,-x+y)",{{0,25},{0,49},{0,49}}},
{  9," C -2xc",{{0,24},{0,25},{0,49}}}, // C c 1 1
{  9," C -2yc (x+y,-x+y,z)",{{0,49},{0,49},{0,25}}},
{  9," B -2xab",{{0,25},{0,25},{0,49}}}, // B n 1 1
{  9," C -2yc (x+y+z,z,x-y+z)",{{0,49},{0,25},{0,49}}},
{  9," I -2xb",{{0,12},{0,49},{0,49}}}, // I b 1 1
{  9," C -2yc (z,x+y,-x+y+z)",{{0,25},{0,49},{0,49}}},
{ 10,"-P 2y",{{0,24},{0,24},{0,49}}}, // P 1 2/m 1
{ 10,"-P 2",{{0,49},{0,24},{0,24}}}, // P 1 1 2/m
{ 10,"-P 2x",{{0,24},{0,24},{0,49}}}, // P 2/m 1 1
{ 11,"-P 2yb",{{0,49},{0,12},{0,49}}}, // P 1 21/m 1
{ 11,"-P 2c",{{0,49},{0,24},{12,36}}}, // P 1 1 21/m
{ 11,"-P 2xa",{{0,12},{0,49},{0,49}}}, // P 21/m 1 1
{ 12,"-C 2y",{{0,24},{0,12},{0,49}}}, // C 1 2/m 1
{ 12,"-C 2y (x-y,x+y,z)",{{0,49},{0,24},{0,49}}},
{ 12,"-A 2y",{{0,24},{0,12},{0,49}}}, // A 1 2/m 1
{ 12,"-C 2y (z,x-y,x+y)",{{0,49},{0,24},{0,49}}},
{ 12,"-I 2y",{{0,24},{0,12},{0,49}}}, // I 1 2/m 1
{ 12,"-C 2y (-x+y,z,x+y+z)",{{0,49},{0,24},{0,49}}},
{ 12,"-A 2",{{0,49},{0,12},{0,24}}}, // A 1 1 2/m
{ 12,"-C 2y (z,x+y,-x+y)",{{0,49},{0,24},{0,49}}},
{ 12,"-B 2",{{0,25},{0,24},{0,24}}}, // B 1 1 2/m
{ 12,"-C 2y (-x+y,z,x+y)",{{0,49},{0,24},{0,49}}},
{ 12,"-I 2",{{0,49},{0,12},{0,24}}}, // I 1 1 2/m
{ 12,"-C 2y (x+y,-x+y+z,z)",{{0,49},{0,24},{0,49}}},
{ 12,"-B 2x",{{0,12},{0,24},{0,49}}}, // B 2/m 1 1
{ 12,"-C 2y (x+y,z,x-y)",{{0,49},{0,24},{0,49}}},
{ 12,"-C 2x",{{0,24},{0,12},{0,49}}}, // C 2/m 1 1
{ 12,"-C 2y (x+y,-x+y,z)",{{0,49},{0,24},{0,49}}},
{ 12,"-I 2x",{{0,24},{0,12},{0,49}}}, // I 2/m 1 1
{ 12,"-C 2y (z,x+y,-x+y+z)",{{0,49},{0,24},{0,49}}},
{ 13,"-P 2yc",{{0,24},{0,24},{0,49}}}, // P 1 2/c 1
{ 13,"-P 2yac",{{0,12},{0,49},{0,49}}}, // P 1 2/n 1
{ 13,"-P 2ya",{{0,12},{0,49},{0,49}}}, // P 1 2/a 1
{ 13,"-P 2a",{{0,25},{0,24},{0,49}}}, // P 1 1 2/a
{ 13,"-P 2ab",{{0,49},{0,12},{0,49}}}, // P 1 1 2/n
{ 13,"-P 2b",{{0,49},{0,12},{0,49}}}, // P 1 1 2/b
{ 13,"-P 2xb",{{0,49},{0,12},{0,49}}}, // P 2/b 1 1
{ 13,"-P 2xbc",{{0,49},{0,12},{0,49}}}, // P 2/n 1 1
{ 13,"-P 2xc",{{0,24},{0,24},{0,49}}}, // P 2/c 1 1
{ 14,"-P 2ybc",{{0,49},{0,12},{0,49}}}, // P 1 21/c 1
{ 14,"-P 2yn",{{0,49},{0,12},{0,49}}}, // P 1 21/n 1
{ 14,"-P 2yab",{{0,49},{0,12},{0,49}}}, // P 1 21/a 1
{ 14,"-P 2ac",{{0,25},{0,24},{0,49}}}, // P 1 1 21/a
{ 14,"-P 2n",{{0,49},{0,12},{0,49}}}, // P 1 1 21/n
{ 14,"-P 2bc",{{0,49},{0,12},{0,49}}}, // P 1 1 21/b
{ 14,"-P 2xab",{{0,49},{0,12},{0,49}}}, // P 21/b 1 1
{ 14,"-P 2xn",{{0,49},{0,12},{0,49}}}, // P 21/n 1 1
{ 14,"-P 2xac",{{0,12},{0,49},{0,49}}}, // P 21/c 1 1
{ 15,"-C 2yc",{{0,24},{0,12},{0,49}}}, // C 1 2/c 1
{ 15,"-C 2yc (x-y,x+y,z)",{{0,49},{0,24},{12,36}}},
{ 15,"-A 2yab",{{0,12},{0,25},{0,49}}}, // A 1 2/n 1
{ 15,"-C 2yc (z,x-y+z,x+y+z)",{{0,12},{0,49},{0,49}}},
{ 15,"-I 2ya",{{0,12},{12,36},{0,49}}}, // I 1 2/a 1
{ 15,"-C 2yc (-x+y,z,x+y+z)",{{0,49},{0,12},{0,49}}},
{ 15,"-A 2ya",{{0,12},{0,25},{0,49}}}, // A 1 2/a 1
{ 15,"-C 2yc (z,x-y,x+y)",{{0,12},{0,49},{0,49}}},
{ 15,"-C 2yac",{{0,12},{12,36},{0,49}}}, // C 1 2/n 1
{ 15,"-C 2yc (x-y+z,x+y+z,z)",{{0,49},{0,24},{12,36}}},
{ 15,"-I 2yc",{{0,24},{0,12},{0,49}}}, // I 1 2/c 1
{ 15,"-C 2yc (-x+y+z,z,x+y)",{{0,49},{0,12},{0,49}}},
{ 15,"-A 2a",{{0,25},{0,12},{0,49}}}, // A 1 1 2/a
{ 15,"-C 2yc (z,x+y,-x+y)",{{0,12},{0,49},{0,49}}},
{ 15,"-B 2ab",{{0,25},{0,12},{0,49}}}, // B 1 1 2/n
{ 15,"-C 2yc (-x+y-z,z,x+y+z)",{{0,49},{0,12},{0,49}}},
{ 15,"-I 2b",{{0,25},{0,12},{0,49}}}, // I 1 1 2/b
{ 15,"-C 2yc (x+y+z,-x+y,z)",{{0,24},{-8,41},{-12,12}}},
{ 15,"-B 2b",{{0,25},{0,12},{0,49}}}, // B 1 1 2/b
{ 15,"-C 2yc (-x+y,z,x+y)",{{0,49},{0,12},{0,49}}},
{ 15,"-A 2ab",{{0,25},{0,12},{0,49}}}, // A 1 1 2/n
{ 15,"-C 2yc (z,x+y-z,-x+y+z)",{{0,12},{0,49},{0,49}}},
{ 15,"-I 2a",{{0,25},{0,12},{0,49}}}, // I 1 1 2/a
{ 15,"-C 2yc (x+y,-x+y+z,z)",{{0,24},{-8,41},{-12,12}}},
{ 15,"-B 2xb",{{0,25},{0,12},{0,49}}}, // B 2/b 1 1
{ 15,"-C 2yc (x+y,z,x-y)",{{0,49},{0,12},{0,49}}},
{ 15,"-C 2xac",{{0,12},{12,36},{0,49}}}, // C 2/n 1 1
{ 15,"-C 2yc (x+y-z,-x+y+z,z)",{{-8,41},{0,24},{12,36}}},
{ 15,"-I 2xc",{{0,24},{0,12},{0,49}}}, // I 2/c 1 1
{ 15,"-C 2yc (z,x+y+z,-x+y)",{{0,12},{0,49},{0,49}}},
{ 15,"-C 2xc",{{0,24},{0,12},{0,49}}}, // C 2/c 1 1
{ 15,"-C 2yc (x+y,-x+y,z)",{{-8,41},{0,24},{12,36}}},
{ 15,"-B 2xab",{{0,25},{0,12},{0,49}}}, // B 2/n 1 1
{ 15,"-C 2yc (x+y+z,z,x-y+z)",{{0,49},{0,12},{0,49}}},
{ 15,"-I 2xb",{{12,36},{0,12},{0,49}}}, // I 2/b 1 1
{ 15,"-C 2yc (z,x+y,-x+y+z)",{{0,12},{0,49},{0,49}}},
{ 16," P 2 2",{{0,24},{0,24},{0,49}}}, // P 2 2 2
{ 17," P 2c 2",{{0,24},{0,24},{0,49}}}, // P 2 2 21
{ 17," P 2a 2a",{{0,24},{0,24},{0,49}}}, // P 21 2 2
{ 17," P 2 2b",{{0,49},{0,12},{0,49}}}, // P 2 21 2
{ 18," P 2 2ab",{{0,49},{0,12},{0,49}}}, // P 21 21 2
{ 18," P 2bc 2",{{0,49},{0,12},{0,49}}}, // P 2 21 21
{ 18," P 2ac 2ac",{{0,24},{0,24},{0,49}}}, // P 21 2 21
{ 19," P 2ac 2ab",{{0,49},{0,12},{0,49}}}, // P 21 21 21
{ 20," C 2c 2",{{0,24},{0,12},{0,49}}}, // C 2 2 21
{ 20," C 2c 2 (x-y,x+y,z)",{{0,49},{0,49},{0,12}}},
{ 20," A 2a 2a",{{0,24},{0,12},{0,49}}}, // A 21 2 2
{ 20," C 2c 2 (z,x+y,-x+y)",{{0,12},{0,49},{0,49}}},
{ 20," B 2 2b",{{0,25},{0,12},{0,49}}}, // B 2 21 2
{ 20," C 2c 2 (x+y,z,x-y)",{{0,49},{0,12},{0,49}}},
{ 21," C 2 2",{{0,24},{0,12},{0,49}}}, // C 2 2 2
{ 21," C 2 2 (x-y,x+y,z)",{{0,49},{0,24},{0,24}}},
{ 21," A 2 2",{{0,24},{0,12},{0,49}}}, // A 2 2 2
{ 21," C 2 2 (z,x-y,x+y)",{{0,24},{0,24},{0,49}}},
{ 21," B 2 2",{{0,12},{0,24},{0,49}}}, // B 2 2 2
{ 21," C 2 2 (-x+y,z,x+y)",{{0,24},{0,24},{0,49}}},
{ 22," F 2 2",{{0,12},{0,12},{0,49}}}, // F 2 2 2
{ 22," F 2 2 (-x+y+z,x-y+z,x+y-z)",{{-12,24},{12,48},{-4,45}}},
{ 23," I 2 2",{{0,24},{0,12},{0,49}}}, // I 2 2 2
{ 23," I 2 2 (y+z,x+z,x+y)",{{0,36},{0,36},{0,37}}},
{ 24," I 2b 2c",{{0,12},{0,24},{0,49}}}, // I 21 21 21
{ 24," I 2b 2c (y+z,x+z,x+y)",{{-6,43},{-12,12},{-6,43}}},
{ 25," P 2 -2",{{0,24},{0,24},{0,49}}}, // P m m 2
{ 25," P -2 2",{{0,49},{0,24},{0,24}}}, // P 2 m m
{ 25," P -2 -2",{{0,24},{0,49},{0,24}}}, // P m 2 m
{ 26," P 2c -2",{{0,24},{0,24},{0,49}}}, // P m c 21
{ 26," P 2c -2c",{{0,24},{0,24},{0,49}}}, // P c m 21
{ 26," P -2a 2a",{{0,25},{0,24},{0,49}}}, // P 21 m a
{ 26," P -2 2a",{{0,49},{0,24},{0,24}}}, // P 21 a m
{ 26," P -2 -2b",{{0,49},{0,25},{0,24}}}, // P b 21 m
{ 26," P -2b -2",{{0,24},{0,25},{0,49}}}, // P m 21 b
{ 27," P 2 -2c",{{0,24},{0,24},{0,49}}}, // P c c 2
{ 27," P -2a 2",{{0,25},{0,24},{0,49}}}, // P 2 a a
{ 27," P -2b -2b",{{0,24},{0,25},{0,49}}}, // P b 2 b
{ 28," P 2 -2a",{{0,12},{0,49},{0,49}}}, // P m a 2
{ 28," P 2 -2b",{{0,49},{0,12},{0,49}}}, // P b m 2
{ 28," P -2b 2",{{0,49},{0,12},{0,49}}}, // P 2 m b
{ 28," P -2c 2",{{0,49},{0,24},{12,36}}}, // P 2 c m
{ 28," P -2c -2c",{{0,24},{0,49},{12,36}}}, // P c 2 m
{ 28," P -2a -2a",{{0,12},{0,49},{0,49}}}, // P m 2 a
{ 29," P 2c -2ac",{{0,12},{0,49},{0,49}}}, // P c a 21
{ 29," P 2c -2b",{{0,49},{0,12},{0,49}}}, // P b c 21
{ 29," P -2b 2a",{{0,49},{0,12},{0,49}}}, // P 21 a b
{ 29," P -2ac 2a",{{0,25},{0,24},{0,49}}}, // P 21 c a
{ 29," P -2bc -2c",{{0,24},{0,25},{0,49}}}, // P c 21 b
{ 29," P -2a -2ab",{{0,25},{0,25},{0,49}}}, // P b 21 a
{ 30," P 2 -2bc",{{0,49},{0,12},{0,49}}}, // P n c 2
{ 30," P 2 -2ac",{{0,12},{0,49},{0,49}}}, // P c n 2
{ 30," P -2ac 2",{{0,25},{0,24},{0,49}}}, // P 2 n a
{ 30," P -2ab 2",{{0,49},{0,12},{0,49}}}, // P 2 a n
{ 30," P -2ab -2ab",{{0,24},{0,25},{0,49}}}, // P b 2 n
{ 30," P -2bc -2bc",{{0,24},{0,25},{0,49}}}, // P n 2 b
{ 31," P 2ac -2",{{0,24},{0,24},{0,49}}}, // P m n 21
{ 31," P 2bc -2bc",{{0,49},{0,12},{0,49}}}, // P n m 21
{ 31," P -2ab 2ab",{{0,49},{0,12},{0,49}}}, // P 21 m n
{ 31," P -2 2ac",{{0,49},{0,24},{0,24}}}, // P 21 n m
{ 31," P -2 -2bc",{{0,49},{0,25},{0,24}}}, // P n 21 m
{ 31," P -2ab -2",{{0,24},{0,25},{0,49}}}, // P m 21 n
{ 32," P 2 -2ab",{{0,49},{0,12},{0,49}}}, // P b a 2
{ 32," P -2bc 2",{{0,49},{0,12},{0,49}}}, // P 2 c b
{ 32," P -2ac -2ac",{{0,12},{0,49},{0,49}}}, // P c 2 a
{ 33," P 2c -2n",{{0,49},{0,12},{0,49}}}, // P n a 21
{ 33," P 2c -2ab",{{0,49},{0,12},{0,49}}}, // P b n 21
{ 33," P -2bc 2a",{{0,49},{0,12},{0,49}}}, // P 21 n b
{ 33," P -2n 2a",{{0,49},{0,12},{0,49}}}, // P 21 c n
{ 33," P -2n -2ac",{{0,12},{0,49},{0,49}}}, // P c 21 n
{ 33," P -2ac -2n",{{0,25},{0,25},{0,49}}}, // P n 21 a
{ 34," P 2 -2n",{{0,49},{0,12},{0,49}}}, // P n n 2
{ 34," P -2n 2",{{0,49},{0,12},{0,49}}}, // P 2 n n
{ 34," P -2n -2n",{{0,24},{0,25},{0,49}}}, // P n 2 n
{ 35," C 2 -2",{{0,24},{0,12},{0,49}}}, // C m m 2
{ 35," C 2 -2 (x-y,x+y,z)",{{0,49},{0,24},{0,49}}},
{ 35," A -2 2",{{0,49},{0,12},{0,24}}}, // A 2 m m
{ 35," C 2 -2 (z,x-y,x+y)",{{0,49},{0,24},{0,49}}},
{ 35," B -2 -2",{{0,12},{0,49},{0,24}}}, // B m 2 m
{ 35," C 2 -2 (-x+y,z,x+y)",{{0,24},{0,49},{0,49}}},
{ 36," C 2c -2",{{0,24},{0,12},{0,49}}}, // C m c 21
{ 36," C 2c -2 (x-y,x+y,z)",{{0,49},{0,24},{0,49}}},
{ 36," C 2c -2c",{{0,24},{0,12},{0,49}}}, // C c m 21
{ 36," C 2c -2 (x+y,-x+y,z)",{{0,49},{0,24},{0,49}}},
{ 36," A -2a 2a",{{0,25},{0,12},{0,49}}}, // A 21 m a
{ 36," C 2c -2 (z,x+y,-x+y)",{{0,49},{0,24},{0,49}}},
{ 36," A -2 2a",{{0,49},{0,12},{0,24}}}, // A 21 a m
{ 36," C 2c -2 (z,x-y,x+y)",{{0,49},{0,24},{0,49}}},
{ 36," B -2 -2b",{{0,25},{0,25},{0,24}}}, // B b 21 m
{ 36," C 2c -2 (x+y,z,x-y)",{{0,49},{0,25},{0,49}}},
{ 36," B -2b -2",{{0,12},{0,25},{0,49}}}, // B m 21 b
{ 36," C 2c -2 (-x+y,z,x+y)",{{0,49},{0,25},{0,49}}},
{ 37," C 2 -2c",{{0,24},{0,12},{0,49}}}, // C c c 2
{ 37," C 2 -2c (x-y,x+y,z)",{{0,49},{0,24},{0,25}}},
{ 37," A -2a 2",{{0,25},{0,12},{0,49}}}, // A 2 a a
{ 37," C 2 -2c (z,x-y,x+y)",{{0,25},{0,24},{0,49}}},
{ 37," B -2b -2b",{{0,12},{0,25},{0,49}}}, // B b 2 b
{ 37," C 2 -2c (-x+y,z,x+y)",{{0,24},{0,25},{0,49}}},
{ 38," A 2 -2",{{0,24},{0,12},{0,49}}}, // A m m 2
{ 38," A 2 -2 (x,y+z,-y+z)",{{0,24},{0,49},{0,49}}},
{ 38," B 2 -2",{{0,12},{0,24},{0,49}}}, // B m m 2
{ 38," A 2 -2 (-y+z,x,y+z)",{{0,49},{0,24},{0,49}}},
{ 38," B -2 2",{{0,25},{0,24},{0,24}}}, // B 2 m m
{ 38," A 2 -2 (y+z,x,y-z)",{{0,49},{0,24},{0,49}}},
{ 38," C -2 2",{{0,49},{0,12},{0,24}}}, // C 2 m m
{ 38," A 2 -2 (y+z,-y+z,x)",{{0,49},{0,49},{0,24}}},
{ 38," C -2 -2",{{0,24},{0,25},{0,24}}}, // C m 2 m
{ 38," A 2 -2 (y-z,y+z,x)",{{0,49},{0,49},{0,24}}},
{ 38," A -2 -2",{{0,24},{0,25},{0,24}}}, // A m 2 m
{ 38," A 2 -2 (x,y-z,y+z)",{{0,24},{0,49},{0,49}}},
{ 39," A 2 -2b",{{0,24},{0,12},{0,49}}}, // A b m 2
{ 39," A 2 -2b (x,y+z,-y+z)",{{0,49},{0,25},{0,49}}},
{ 39," B 2 -2a",{{0,12},{0,24},{0,49}}}, // B m a 2
{ 39," A 2 -2b (-y+z,x,y+z)",{{0,49},{0,24},{0,49}}},
{ 39," B -2a 2",{{0,25},{0,24},{12,36}}}, // B 2 c m
{ 39," A 2 -2b (y+z,x,y-z)",{{0,49},{0,24},{0,49}}},
{ 39," C -2a 2",{{0,25},{0,12},{0,49}}}, // C 2 m b
{ 39," A 2 -2b (y+z,-y+z,x)",{{0,49},{0,25},{0,49}}},
{ 39," C -2a -2a",{{0,12},{0,25},{0,49}}}, // C m 2 a
{ 39," A 2 -2b (y-z,y+z,x)",{{0,49},{0,25},{0,49}}},
{ 39," A -2b -2b",{{0,24},{0,25},{12,36}}}, // A c 2 m
{ 39," A 2 -2b (x,y-z,y+z)",{{0,49},{0,25},{0,49}}},
{ 40," A 2 -2a",{{0,12},{0,25},{0,49}}}, // A m a 2
{ 40," A 2 -2a (x,y+z,-y+z)",{{0,12},{0,49},{0,49}}},
{ 40," B 2 -2b",{{0,25},{0,12},{0,49}}}, // B b m 2
{ 40," A 2 -2a (-y+z,x,y+z)",{{0,49},{0,12},{0,49}}},
{ 40," B -2b 2",{{0,25},{0,12},{0,49}}}, // B 2 m b
{ 40," A 2 -2a (y+z,x,y-z)",{{0,49},{0,12},{0,49}}},
{ 40," C -2c 2",{{0,49},{0,12},{12,36}}}, // C 2 c m
{ 40," A 2 -2a (y+z,-y+z,x)",{{0,49},{0,49},{0,12}}},
{ 40," C -2c -2c",{{0,24},{0,25},{12,36}}}, // C c 2 m
{ 40," A 2 -2a (y-z,y+z,x)",{{0,49},{0,49},{0,12}}},
{ 40," A -2a -2a",{{0,12},{0,25},{0,49}}}, // A m 2 a
{ 40," A 2 -2a (x,y-z,y+z)",{{0,12},{0,49},{0,49}}},
{ 41," A 2 -2ab",{{0,12},{0,25},{0,49}}}, // A b a 2
{ 41," A 2 -2ab (x,y+z,-y+z)",{{0,24},{0,25},{0,49}}},
{ 41," B 2 -2ab",{{0,25},{0,12},{0,49}}}, // B b a 2
{ 41," A 2 -2ab (-y+z,x,y+z)",{{0,49},{0,12},{0,49}}},
{ 41," B -2ab 2",{{0,25},{0,12},{0,49}}}, // B 2 c b
{ 41," A 2 -2ab (y+z,x,y-z)",{{0,49},{0,12},{0,49}}},
{ 41," C -2ac 2",{{0,25},{0,12},{0,49}}}, // C 2 c b
{ 41," A 2 -2ab (y+z,-y+z,x)",{{0,49},{0,25},{0,24}}},
{ 41," C -2ac -2ac",{{0,12},{0,25},{0,49}}}, // C c 2 a
{ 41," A 2 -2ab (y-z,y+z,x)",{{0,49},{0,25},{0,24}}},
{ 41," A -2ab -2ab",{{0,12},{0,25},{0,49}}}, // A c 2 a
{ 41," A 2 -2ab (x,y-z,y+z)",{{0,24},{0,25},{0,49}}},
{ 42," F 2 -2",{{0,12},{0,12},{0,49}}}, // F m m 2
{ 42," F 2 -2 (-x+y+z,x-y+z,x+y-z)",{{0,49},{0,49},{0,49}}},
{ 42," F -2 2",{{0,25},{0,12},{0,24}}}, // F 2 m m
{ 42," F 2 -2 (x+y-z,-x+y+z,x-y+z)",{{0,49},{0,49},{0,49}}},
{ 42," F -2 -2",{{0,12},{0,25},{0,24}}}, // F m 2 m
{ 42," F 2 -2 (x-y+z,x+y-z,-x+y+z)",{{0,49},{0,49},{0,49}}},
{ 43," F 2 -2d",{{0,25},{0,6},{0,49}}}, // F d d 2
{ 43," F 2 -2d (-x+y+z,x-y+z,x+y-z)",{{-12,25},{12,49},{1,36}}},
{ 43," F -2d 2",{{0,25},{0,6},{0,49}}}, // F 2 d d
{ 43," F 2 -2d (x+y-z,-x+y+z,x-y+z)",{{0,37},{-13,24},{13,48}}},
{ 43," F -2d -2d",{{0,12},{0,13},{0,49}}}, // F d 2 d
{ 43," F 2 -2d (x-y+z,x+y-z,-x+y+z)",{{-12,25},{1,36},{12,49}}},
{ 44," I 2 -2",{{0,24},{0,12},{0,49}}}, // I m m 2
{ 44," I 2 -2 (y+z,x+z,x+y)",{{0,49},{0,49},{0,24}}},
{ 44," I -2 2",{{0,49},{0,12},{0,24}}}, // I 2 m m
{ 44," I 2 -2 (x+y,y+z,x+z)",{{0,24},{0,49},{0,49}}},
{ 44," I -2 -2",{{0,24},{0,25},{0,24}}}, // I m 2 m
{ 44," I 2 -2 (x+z,x+y,y+z)",{{0,49},{0,24},{0,49}}},
{ 45," I 2 -2c",{{0,24},{0,12},{0,49}}}, // I b a 2
{ 45," I 2 -2c (y+z,x+z,x+y)",{{0,49},{0,25},{0,49}}},
{ 45," I -2a 2",{{0,25},{0,12},{0,49}}}, // I 2 c b
{ 45," I 2 -2c (x+y,y+z,x+z)",{{0,49},{0,25},{0,49}}},
{ 45," I -2b -2b",{{0,12},{0,25},{0,49}}}, // I c 2 a
{ 45," I 2 -2c (x+z,x+y,y+z)",{{0,49},{0,24},{1,49}}},
{ 46," I 2 -2a",{{0,12},{12,36},{0,49}}}, // I m a 2
{ 46," I 2 -2a (y+z,x+z,x+y)",{{0,49},{0,25},{0,49}}},
{ 46," I 2 -2b",{{0,12},{12,36},{0,49}}}, // I b m 2
{ 46," I 2 -2a (-x+z,y+z,-x+y)",{{0,25},{0,49},{0,49}}},
{ 46," I -2b 2",{{0,25},{0,12},{0,49}}}, // I 2 m b
{ 46," I 2 -2a (x+y,y+z,x+z)",{{0,24},{0,49},{0,49}}},
{ 46," I -2c 2",{{0,49},{0,12},{12,36}}}, // I 2 c m
{ 46," I 2 -2a (-x+y,-x+z,y+z)",{{0,49},{0,25},{0,49}}},
{ 46," I -2c -2c",{{0,24},{0,25},{12,36}}}, // I c 2 m
{ 46," I 2 -2a (x+z,x+y,y+z)",{{0,49},{0,24},{0,49}}},
{ 46," I -2a -2a",{{0,12},{0,25},{0,49}}}, // I m 2 a
{ 46," I 2 -2a (-y+z,x-y,x+z)",{{0,49},{0,24},{0,49}}},
{ 47,"-P 2 2",{{0,24},{0,24},{0,24}}}, // P m m m
{ 48," P 2 2 -1n",{{0,24},{0,12},{0,49}}}, // P n n n :1
{ 48,"-P 2ab 2bc",{{0,12},{12,36},{0,49}}}, // P n n n :2
{ 49,"-P 2 2c",{{0,24},{0,24},{0,24}}}, // P c c m
{ 49,"-P 2a 2",{{0,12},{0,24},{0,49}}}, // P m a a
{ 49,"-P 2b 2b",{{0,24},{0,12},{0,49}}}, // P b m b
{ 50," P 2 2 -1ab",{{0,24},{0,12},{0,49}}}, // P b a n :1
{ 50,"-P 2ab 2b",{{0,12},{12,36},{0,49}}}, // P b a n :2
{ 50," P 2 2 -1bc",{{0,24},{0,12},{0,49}}}, // P n c b :1
{ 50,"-P 2b 2bc",{{0,24},{0,12},{0,49}}}, // P n c b :2
{ 50," P 2 2 -1ac",{{0,12},{0,24},{0,49}}}, // P c n a :1
{ 50,"-P 2a 2c",{{0,12},{0,24},{0,49}}}, // P c n a :2
{ 51,"-P 2a 2a",{{0,12},{0,24},{0,49}}}, // P m m a
{ 51,"-P 2b 2",{{0,24},{0,12},{0,49}}}, // P m m b
{ 51,"-P 2 2b",{{0,49},{0,12},{0,24}}}, // P b m m
{ 51,"-P 2c 2c",{{0,24},{0,24},{12,36}}}, // P c m m
{ 51,"-P 2c 2",{{0,24},{0,24},{12,36}}}, // P m c m
{ 51,"-P 2 2a",{{0,12},{0,49},{0,24}}}, // P m a m
{ 52,"-P 2a 2bc",{{0,25},{0,12},{0,49}}}, // P n n a
{ 52,"-P 2b 2n",{{0,12},{0,25},{0,49}}}, // P n n b
{ 52,"-P 2n 2b",{{0,12},{12,36},{0,49}}}, // P b n n
{ 52,"-P 2ab 2c",{{0,24},{0,12},{0,49}}}, // P c n n
{ 52,"-P 2ab 2n",{{0,24},{0,12},{0,49}}}, // P n c n
{ 52,"-P 2n 2bc",{{0,12},{12,36},{0,49}}}, // P n a n
{ 53,"-P 2ac 2",{{0,12},{0,24},{0,49}}}, // P m n a
{ 53,"-P 2bc 2bc",{{0,24},{0,12},{0,49}}}, // P n m b
{ 53,"-P 2ab 2ab",{{0,24},{0,12},{0,49}}}, // P b m n
{ 53,"-P 2 2ac",{{0,12},{0,49},{0,24}}}, // P c n m
{ 53,"-P 2 2bc",{{0,49},{0,12},{0,24}}}, // P n c m
{ 53,"-P 2ab 2",{{0,24},{0,12},{0,49}}}, // P m a n
{ 54,"-P 2a 2ac",{{0,12},{0,24},{0,49}}}, // P c c a
{ 54,"-P 2b 2c",{{0,24},{0,12},{0,49}}}, // P c c b
{ 54,"-P 2a 2b",{{0,25},{0,12},{0,49}}}, // P b a a
{ 54,"-P 2ac 2c",{{0,12},{0,24},{0,49}}}, // P c a a
{ 54,"-P 2bc 2b",{{0,24},{0,12},{0,49}}}, // P b c b
{ 54,"-P 2b 2ab",{{0,12},{0,25},{0,49}}}, // P b a b
{ 55,"-P 2 2ab",{{0,49},{0,12},{0,24}}}, // P b a m
{ 55,"-P 2bc 2",{{0,24},{0,12},{0,49}}}, // P m c b
{ 55,"-P 2ac 2ac",{{0,12},{0,24},{0,49}}}, // P c m a
{ 56,"-P 2ab 2ac",{{0,12},{12,36},{0,49}}}, // P c c n
{ 56,"-P 2ac 2bc",{{0,25},{0,12},{0,49}}}, // P n a a
{ 56,"-P 2bc 2ab",{{0,12},{0,25},{0,49}}}, // P b n b
{ 57,"-P 2c 2b",{{0,49},{0,12},{12,36}}}, // P b c m
{ 57,"-P 2c 2ac",{{0,12},{0,49},{12,36}}}, // P c a m
{ 57,"-P 2ac 2a",{{0,12},{0,24},{0,49}}}, // P m c a
{ 57,"-P 2b 2a",{{0,12},{0,25},{0,49}}}, // P m a b
{ 57,"-P 2a 2ab",{{0,25},{0,12},{0,49}}}, // P b m a
{ 57,"-P 2bc 2c",{{0,24},{0,12},{0,49}}}, // P c m b
{ 58,"-P 2 2n",{{0,49},{0,12},{0,24}}}, // P n n m
{ 58,"-P 2n 2",{{0,24},{0,12},{0,49}}}, // P m n n
{ 58,"-P 2n 2n",{{0,24},{0,12},{0,49}}}, // P n m n
{ 59," P 2 2ab -1ab",{{0,24},{0,12},{0,49}}}, // P m m n :1
{ 59,"-P 2ab 2a",{{0,12},{12,36},{0,49}}}, // P m m n :2
{ 59," P 2bc 2 -1bc",{{0,49},{0,12},{0,24}}}, // P n m m :1
{ 59,"-P 2c 2bc",{{0,49},{0,12},{12,36}}}, // P n m m :2
{ 59," P 2ac 2ac -1ac",{{0,24},{0,24},{0,24}}}, // P m n m :1
{ 59,"-P 2c 2a",{{0,12},{0,49},{12,36}}}, // P m n m :2
{ 60,"-P 2n 2ab",{{0,24},{0,12},{0,49}}}, // P b c n
{ 60,"-P 2n 2c",{{0,24},{0,12},{0,49}}}, // P c a n
{ 60,"-P 2a 2n",{{0,25},{0,12},{0,49}}}, // P n c a
{ 60,"-P 2bc 2n",{{0,12},{0,25},{0,49}}}, // P n a b
{ 60,"-P 2ac 2b",{{0,25},{0,12},{0,49}}}, // P b n a
{ 60,"-P 2b 2ac",{{0,12},{0,25},{0,49}}}, // P c n b
{ 61,"-P 2ac 2ab",{{0,25},{0,12},{0,49}}}, // P b c a
{ 61,"-P 2bc 2ac",{{0,12},{0,25},{0,49}}}, // P c a b
{ 62,"-P 2ac 2n",{{0,25},{0,12},{0,49}}}, // P n m a
{ 62,"-P 2bc 2a",{{0,12},{0,25},{0,49}}}, // P m n b
{ 62,"-P 2c 2ab",{{0,49},{0,12},{12,36}}}, // P b n m
{ 62,"-P 2n 2ac",{{0,12},{12,36},{0,49}}}, // P c m n
{ 62,"-P 2n 2a",{{0,12},{12,36},{0,49}}}, // P m c n
{ 62,"-P 2c 2n",{{0,49},{0,12},{12,36}}}, // P n a m
{ 63,"-C 2c 2",{{0,24},{0,12},{12,36}}}, // C m c m
{ 63,"-C 2c 2 (x-y,x+y,z)",{{0,49},{0,24},{12,36}}},
{ 63,"-C 2c 2c",{{0,24},{0,12},{12,36}}}, // C c m m
{ 63,"-C 2c 2 (x+y,-x+y,z)",{{0,49},{0,24},{12,36}}},
{ 63,"-A 2a 2a",{{0,12},{0,12},{0,49}}}, // A m m a
{ 63,"-C 2c 2 (z,x+y,-x+y)",{{0,12},{0,49},{0,49}}},
{ 63,"-A 2 2a",{{0,12},{0,25},{0,24}}}, // A m a m
{ 63,"-C 2c 2 (z,x-y,x+y)",{{0,12},{0,49},{0,49}}},
{ 63,"-B 2 2b",{{0,25},{0,12},{0,24}}}, // B b m m
{ 63,"-C 2c 2 (x+y,z,x-y)",{{0,49},{0,12},{0,49}}},
{ 63,"-B 2b 2",{{0,12},{0,12},{0,49}}}, // B m m b
{ 63,"-C 2c 2 (-x+y,z,x+y)",{{0,49},{0,12},{0,49}}},
{ 64,"-C 2ac 2",{{0,12},{0,12},{0,49}}}, // C m c a
{ 64,"-C 2ac 2 (x-y,x+y,z)",{{0,49},{0,12},{0,49}}},
{ 64,"-C 2ac 2ac",{{0,12},{0,12},{0,49}}}, // C c m b
{ 64,"-C 2ac 2 (x+y,-x+y,z)",{{0,49},{0,12},{0,49}}},
{ 64,"-A 2ab 2ab",{{0,12},{0,12},{0,49}}}, // A b m a
{ 64,"-C 2ac 2 (z,x+y,-x+y)",{{0,49},{0,12},{0,49}}},
{ 64,"-A 2 2ab",{{0,12},{0,25},{0,24}}}, // A c a m
{ 64,"-C 2ac 2 (z,x-y,x+y)",{{0,49},{0,12},{0,49}}},
{ 64,"-B 2 2ab",{{0,25},{0,12},{0,24}}}, // B b c m
{ 64,"-C 2ac 2 (x+y,z,x-y)",{{0,49},{0,12},{0,49}}},
{ 64,"-B 2ab 2",{{0,12},{0,12},{0,49}}}, // B m a b
{ 64,"-C 2ac 2 (-x+y,z,x+y)",{{0,49},{0,12},{0,49}}},
{ 65,"-C 2 2",{{0,24},{0,12},{0,24}}}, // C m m m
{ 65,"-C 2 2 (x-y,x+y,z)",{{0,49},{0,24},{0,24}}},
{ 65,"-A 2 2",{{0,24},{0,12},{0,24}}}, // A m m m
{ 65,"-C 2 2 (z,x-y,x+y)",{{0,24},{0,24},{0,49}}},
{ 65,"-B 2 2",{{0,12},{0,24},{0,24}}}, // B m m m
{ 65,"-C 2 2 (-x+y,z,x+y)",{{0,24},{0,24},{0,49}}},
{ 66,"-C 2 2c",{{0,24},{0,12},{0,24}}}, // C c c m
{ 66,"-C 2 2c (x-y,x+y,z)",{{0,49},{0,24},{0,12}}},
{ 66,"-A 2a 2",{{0,12},{0,12},{0,49}}}, // A m a a
{ 66,"-C 2 2c (z,x-y,x+y)",{{0,12},{0,24},{0,49}}},
{ 66,"-B 2b 2b",{{0,12},{0,12},{0,49}}}, // B b m b
{ 66,"-C 2 2c (-x+y,z,x+y)",{{0,24},{0,12},{0,49}}},
{ 67,"-C 2a 2",{{0,12},{0,12},{0,49}}}, // C m m a
{ 67,"-C 2a 2 (x-y,x+y,z)",{{0,49},{0,12},{0,49}}},
{ 67,"-C 2a 2a",{{0,12},{0,12},{0,49}}}, // C m m b
{ 67,"-C 2a 2 (x+y,-x+y,z)",{{0,49},{0,12},{0,49}}},
{ 67,"-A 2b 2b",{{0,24},{0,12},{12,36}}}, // A b m m
{ 67,"-C 2a 2 (z,x+y,-x+y)",{{0,49},{0,12},{0,49}}},
{ 67,"-A 2 2b",{{0,24},{0,12},{0,24}}}, // A c m m
{ 67,"-C 2a 2 (z,x-y,x+y)",{{0,49},{0,12},{0,49}}},
{ 67,"-B 2 2a",{{0,12},{0,24},{0,24}}}, // B m c m
{ 67,"-C 2a 2 (x+y,z,x-y)",{{0,12},{0,49},{0,49}}},
{ 67,"-B 2a 2",{{0,12},{0,24},{12,36}}}, // B m a m
{ 67,"-C 2a 2 (-x+y,z,x+y)",{{0,12},{0,49},{0,49}}},
{ 68," C 2 2 -1ac",{{0,12},{0,12},{0,49}}}, // C c c a :1
{ 68,"-C 2a 2ac (x-y-1/4,x+y-3/4,z+1/4)",{{0,49},{0,12},{0,24}}},
{ 68,"-C 2a 2ac",{{0,12},{0,12},{0,49}}}, // C c c a :2
{ 68,"-C 2a 2ac (x-y,x+y,z)",{{0,49},{0,12},{12,36}}},
{ 68," C 2 2 -1ac",{{0,12},{0,12},{0,49}}}, // C c c a :1
{ 68,"-C 2a 2ac (x-y-1/4,x+y-3/4,z+1/4)",{{0,49},{0,12},{0,24}}},
{ 68,"-C 2a 2c",{{0,12},{0,12},{0,49}}}, // C c c b :2
{ 68,"-C 2a 2ac (x+y,-x+y,z)",{{0,49},{0,12},{12,36}}},
{ 68," A 2 2 -1ab",{{0,12},{0,12},{0,49}}}, // A b a a :1
{ 68,"-C 2a 2ac (z+1/4,x-y-1/4,x+y-3/4)",{{0,24},{0,12},{0,49}}},
{ 68,"-A 2a 2b",{{0,12},{0,12},{0,49}}}, // A b a a :2
{ 68,"-C 2a 2ac (z,x+y,-x+y)",{{0,12},{12,36},{0,49}}},
{ 68," A 2 2 -1ab",{{0,12},{0,12},{0,49}}}, // A b a a :1
{ 68,"-C 2a 2ac (z+1/4,x-y-1/4,x+y-3/4)",{{0,24},{0,12},{0,49}}},
{ 68,"-A 2ab 2b",{{0,12},{0,12},{0,49}}}, // A c a a :2
{ 68,"-C 2a 2ac (z,x-y,x+y)",{{0,12},{12,36},{0,49}}},
{ 68," B 2 2 -1ab",{{0,12},{0,12},{0,49}}}, // B b c b :1
{ 68,"-C 2a 2ac (-x+y+1/4,z+1/4,x+y-3/4)",{{0,24},{0,12},{0,49}}},
{ 68,"-B 2ab 2b",{{0,12},{0,12},{0,49}}}, // B b c b :2
{ 68,"-C 2a 2ac (x+y,z,x-y)",{{12,36},{0,12},{0,49}}},
{ 68," B 2 2 -1ab",{{0,12},{0,12},{0,49}}}, // B b c b :1
{ 68,"-C 2a 2ac (-x+y+1/4,z+1/4,x+y-3/4)",{{0,24},{0,12},{0,49}}},
{ 68,"-B 2b 2ab",{{0,12},{0,12},{0,49}}}, // B b a b :2
{ 68,"-C 2a 2ac (-x+y,z,x+y)",{{12,36},{0,12},{0,49}}},
{ 69,"-F 2 2",{{0,12},{0,12},{0,24}}}, // F m m m
{ 69,"-F 2 2 (-x+y+z,x-y+z,x+y-z)",{{0,49},{0,24},{0,49}}},
{ 70," F 2 2 -1d",{{0,12},{0,6},{0,49}}}, // F d d d :1
{ 70,"-F 2uv 2vw (-x+y+z+1/8,x-y+z+1/8,x+y-z+1/8)",{{-7,24},{12,30},{-6,43}}},
{ 70,"-F 2uv 2vw",{{0,6},{6,18},{0,49}}}, // F d d d :2
{ 70,"-F 2uv 2vw (-x+y+z,x-y+z,x+y-z)",{{0,18},{6,37},{0,49}}},
{ 71,"-I 2 2",{{0,24},{0,12},{0,24}}}, // I m m m
{ 71,"-I 2 2 (y+z,x+z,x+y)",{{0,36},{0,36},{0,37}}},
{ 72,"-I 2 2c",{{0,24},{0,12},{0,24}}}, // I b a m
{ 72,"-I 2 2c (y+z,x+z,x+y)",{{0,49},{0,12},{0,49}}},
{ 72,"-I 2a 2",{{0,12},{0,12},{0,49}}}, // I m c b
{ 72,"-I 2 2c (x+y,y+z,x+z)",{{0,49},{0,12},{0,49}}},
{ 72,"-I 2b 2b",{{0,12},{0,12},{0,49}}}, // I c m a
{ 72,"-I 2 2c (x+z,x+y,y+z)",{{0,12},{0,49},{0,49}}},
{ 73,"-I 2b 2c",{{0,12},{0,12},{0,49}}}, // I b c a
{ 73,"-I 2b 2c (y+z,x+z,x+y)",{{1,36},{-12,0},{-6,43}}},
{ 73,"-I 2a 2b",{{0,12},{0,12},{0,49}}}, // I c a b
{ 73,"-I 2b 2c (-y+z,x-y,x+z)",{{1,36},{-12,0},{-6,43}}},
{ 74,"-I 2b 2",{{0,12},{0,12},{0,49}}}, // I m m a
{ 74,"-I 2b 2 (y+z,x+z,x+y)",{{0,24},{-6,43},{-12,12}}},
{ 74,"-I 2a 2a",{{0,12},{0,12},{0,49}}}, // I m m b
{ 74,"-I 2b 2 (-x+z,y+z,-x+y)",{{0,24},{-6,43},{-12,12}}},
{ 74,"-I 2c 2c",{{0,24},{0,12},{12,36}}}, // I b m m
{ 74,"-I 2b 2 (x+y,y+z,x+z)",{{0,12},{0,49},{0,49}}},
{ 74,"-I 2 2b",{{0,12},{12,36},{0,24}}}, // I c m m
{ 74,"-I 2b 2 (-x+y,-x+z,y+z)",{{0,12},{0,49},{0,49}}},
{ 74,"-I 2 2a",{{0,12},{12,36},{0,24}}}, // I m c m
{ 74,"-I 2b 2 (x+z,x+y,y+z)",{{0,49},{0,12},{0,49}}},
{ 74,"-I 2c 2",{{0,24},{0,12},{12,36}}}, // I m a m
{ 74,"-I 2b 2 (-y+z,x-y,x+z)",{{0,49},{0,12},{0,49}}},
{ 75," P 4",{{0,24},{0,24},{0,49}}}, // P 4
{ 76," P 4w",{{0,24},{0,24},{0,49}}}, // P 41
{ 77," P 4c",{{0,24},{0,24},{0,49}}}, // P 42
{ 78," P 4cw",{{0,24},{0,24},{0,49}}}, // P 43
{ 79," I 4",{{0,24},{0,12},{0,49}}}, // I 4
{ 79," I 4 (y+z,x+z,x+y)",{{0,49},{0,49},{0,24}}},
{ 80," I 4bw",{{0,12},{12,36},{0,49}}}, // I 41
{ 80," I 4bw (y+z,x+z,x+y)",{{0,37},{0,49},{0,24}}},
{ 81," P -4",{{0,24},{0,24},{0,49}}}, // P -4
{ 82," I -4",{{0,24},{0,12},{0,49}}}, // I -4
{ 82," I -4 (y+z,x+z,x+y)",{{0,49},{0,36},{0,24}}},
{ 83,"-P 4",{{0,24},{0,24},{0,24}}}, // P 4/m
{ 84,"-P 4c",{{0,24},{0,24},{0,24}}}, // P 42/m
{ 85," P 4ab -1ab",{{0,24},{0,12},{0,49}}}, // P 4/n :1
{ 85,"-P 4a",{{0,12},{12,36},{0,49}}}, // P 4/n :2
{ 86," P 4n -1n",{{0,24},{0,12},{0,49}}}, // P 42/n :1
{ 86,"-P 4bc",{{0,12},{12,36},{0,49}}}, // P 42/n :2
{ 87,"-I 4",{{0,24},{0,12},{0,24}}}, // I 4/m
{ 87,"-I 4 (y+z,x+z,x+y)",{{0,36},{-24,13},{0,24}}},
{ 88," I 4bw -1bw",{{0,12},{0,12},{0,49}}}, // I 41/a :1
{ 88,"-I 4ad (y+z+3/8,x+z+1/8,x+y+1/4)",{{0,18},{0,43},{0,24}}},
{ 88,"-I 4ad",{{0,12},{0,12},{0,49}}}, // I 41/a :2
{ 88,"-I 4ad (y+z,x+z,x+y)",{{-13,30},{24,42},{12,36}}},
{ 89," P 4 2",{{0,24},{0,24},{0,24}}}, // P 4 2 2
{ 90," P 4ab 2ab",{{0,24},{0,24},{0,24}}}, // P 4 21 2
{ 91," P 4w 2c",{{0,24},{0,24},{-6,18}}}, // P 41 2 2
{ 92," P 4abw 2nw",{{0,24},{0,25},{0,24}}}, // P 41 21 2
{ 93," P 4c 2",{{0,24},{0,24},{12,36}}}, // P 42 2 2
{ 94," P 4n 2n",{{0,49},{0,12},{0,24}}}, // P 42 21 2
{ 95," P 4cw 2c",{{0,24},{0,24},{6,30}}}, // P 43 2 2
{ 96," P 4nw 2abw",{{0,24},{0,25},{0,24}}}, // P 43 21 2
{ 97," I 4 2",{{0,24},{0,24},{0,12}}}, // I 4 2 2
{ 97," I 4 2 (y+z,x+z,x+y)",{{0,49},{0,24},{0,24}}},
{ 98," I 4bw 2bw",{{0,12},{-12,12},{0,24}}}, // I 41 2 2
{ 98," I 4bw 2bw (y+z,x+z,x+y)",{{7,43},{6,30},{0,24}}},
{ 99," P 4 -2",{{0,24},{0,24},{0,49}}}, // P 4 m m
{100," P 4 -2ab",{{0,37},{0,12},{0,49}}}, // P 4 b m
{101," P 4c -2c",{{0,24},{0,24},{0,49}}}, // P 42 c m
{102," P 4n -2n",{{0,37},{12,24},{0,49}}}, // P 42 n m
{103," P 4 -2c",{{0,24},{0,24},{0,25}}}, // P 4 c c
{104," P 4 -2n",{{0,24},{0,24},{0,25}}}, // P 4 n c
{105," P 4c -2",{{0,24},{0,24},{0,25}}}, // P 42 m c
{106," P 4c -2ab",{{0,49},{0,12},{0,25}}}, // P 42 b c
{107," I 4 -2",{{0,24},{0,12},{0,49}}}, // I 4 m m
{107," I 4 -2 (y+z,x+z,x+y)",{{0,49},{0,49},{0,24}}},
{108," I 4 -2c",{{0,37},{0,12},{0,25}}}, // I 4 c m
{108," I 4 -2c (y+z,x+z,x+y)",{{0,49},{0,25},{0,24}}},
{109," I 4bw -2",{{0,12},{0,12},{0,49}}}, // I 41 m d
{109," I 4bw -2 (y+z,x+z,x+y)",{{0,49},{0,49},{0,12}}},
{110," I 4bw -2c",{{0,12},{0,12},{0,49}}}, // I 41 c d
{110," I 4bw -2c (y+z,x+z,x+y)",{{0,37},{0,25},{0,25}}},
{111," P -4 2",{{0,24},{0,24},{0,49}}}, // P -4 2 m
{112," P -4 2c",{{0,24},{0,24},{0,25}}}, // P -4 2 c
{113," P -4 2ab",{{0,37},{0,12},{0,49}}}, // P -4 21 m
{114," P -4 2n",{{0,49},{0,12},{0,24}}}, // P -4 21 c
{115," P -4 -2",{{0,24},{0,24},{0,24}}}, // P -4 m 2
{116," P -4 -2c",{{0,24},{0,24},{12,36}}}, // P -4 c 2
{117," P -4 -2ab",{{0,49},{0,12},{0,24}}}, // P -4 b 2
{118," P -4 -2n",{{0,24},{0,24},{12,36}}}, // P -4 n 2
{119," I -4 -2",{{0,24},{0,24},{0,12}}}, // I -4 m 2
{119," I -4 -2 (y+z,x+z,x+y)",{{0,49},{0,36},{0,24}}},
{120," I -4 -2c",{{0,49},{0,12},{0,12}}}, // I -4 c 2
{120," I -4 -2c (y+z,x+z,x+y)",{{0,36},{0,25},{0,24}}},
{121," I -4 2",{{0,37},{12,24},{0,24}}}, // I -4 2 m
{121," I -4 2 (y+z,x+z,x+y)",{{0,49},{0,24},{0,24}}},
{122," I -4 2bw",{{0,12},{0,12},{0,49}}}, // I -4 2 d
{122," I -4 2bw (y+z,x+z,x+y)",{{-6,18},{0,36},{0,24}}},
{123,"-P 4 2",{{0,24},{0,24},{0,24}}}, // P 4/m m m
{124,"-P 4 2c",{{0,24},{0,24},{0,12}}}, // P 4/m c c
{125," P 4 2 -1ab",{{0,37},{0,12},{0,24}}}, // P 4/n b m :1
{125,"-P 4a 2b",{{0,12},{12,49},{0,24}}}, // P 4/n b m :2
{126," P 4 2 -1n",{{0,24},{0,12},{0,24}}}, // P 4/n n c :1
{126,"-P 4a 2bc",{{0,12},{12,36},{12,36}}}, // P 4/n n c :2
{127,"-P 4 2ab",{{0,37},{0,12},{0,24}}}, // P 4/m b m
{128,"-P 4 2n",{{0,24},{0,24},{0,12}}}, // P 4/m n c
{129," P 4ab 2ab -1ab",{{0,24},{0,12},{0,49}}}, // P 4/n m m :1
{129,"-P 4a 2a",{{0,12},{12,36},{0,49}}}, // P 4/n m m :2
{130," P 4ab 2n -1ab",{{0,24},{0,12},{12,36}}}, // P 4/n c c :1
{130,"-P 4a 2ac",{{0,12},{12,36},{12,36}}}, // P 4/n c c :2
{131,"-P 4c 2",{{0,24},{0,24},{0,12}}}, // P 42/m m c
{132,"-P 4c 2c",{{0,24},{0,24},{0,24}}}, // P 42/m c m
{133," P 4n 2c -1n",{{0,24},{0,12},{0,24}}}, // P 42/n b c :1
{133,"-P 4ac 2b",{{0,12},{12,36},{12,36}}}, // P 42/n b c :2
{134," P 4n 2 -1n",{{0,24},{0,12},{0,49}}}, // P 42/n n m :1
{134,"-P 4ac 2bc",{{0,12},{12,36},{0,49}}}, // P 42/n n m :2
{135,"-P 4c 2ab",{{0,49},{0,12},{0,12}}}, // P 42/m b c
{136,"-P 4n 2n",{{0,37},{12,24},{0,24}}}, // P 42/m n m
{137," P 4n 2n -1n",{{0,24},{0,12},{0,24}}}, // P 42/n m c :1
{137,"-P 4ac 2a",{{0,12},{12,36},{12,36}}}, // P 42/n m c :2
{138," P 4n 2ab -1n",{{0,37},{0,12},{12,36}}}, // P 42/n c m :1
{138,"-P 4ac 2ac",{{1,36},{0,12},{0,24}}}, // P 42/n c m :2
{139,"-I 4 2",{{0,24},{0,12},{0,24}}}, // I 4/m m m
{139,"-I 4 2 (y+z,x+z,x+y)",{{0,49},{0,24},{0,24}}},
{140,"-I 4 2c",{{0,37},{0,12},{0,12}}}, // I 4/m c m
{140,"-I 4 2c (y+z,x+z,x+y)",{{0,24},{-12,12},{0,24}}},
{141," I 4bw 2bw -1bw",{{0,12},{0,12},{0,24}}}, // I 41/a m d :1
{141,"-I 4bd 2 (y+z+3/8,x+z-3/8,x+y-1/4)",{{0,43},{0,30},{0,12}}},
{141,"-I 4bd 2",{{0,12},{0,12},{-6,18}}}, // I 41/a m d :2
{141,"-I 4bd 2 (y+z,x+z,x+y)",{{6,49},{-6,24},{12,24}}},
{142," I 4bw 2aw -1bw",{{0,12},{0,12},{12,36}}}, // I 41/a c d :1
{142,"-I 4bd 2c (y+z-1/8,x+z-7/8,x+y-1/4)",{{0,18},{0,18},{0,24}}},
{142,"-I 4bd 2c",{{0,12},{0,12},{6,30}}}, // I 41/a c d :2
{142,"-I 4bd 2c (y+z,x+z,x+y)",{{0,18},{12,30},{12,36}}},
{143," P 3",{{0,32},{0,32},{0,49}}}, // P 3
{144," P 31",{{0,49},{0,49},{0,17}}}, // P 31
{145," P 32",{{0,49},{0,49},{0,17}}}, // P 32
{146," R 3",{{0,16},{0,16},{0,49}}}, // R 3 :H
{146," P 3*",{{0,49},{0,49},{0,49}}}, // R 3 :R
{147,"-P 3",{{0,32},{0,16},{0,49}}}, // P -3
{148,"-R 3",{{0,16},{-8,0},{0,49}}}, // R -3 :H
{148,"-P 3*",{{0,24},{0,24},{0,49}}}, // R -3 :R
{149," P 3 2",{{0,32},{0,32},{0,24}}}, // P 3 1 2
{150," P 3 2\"",{{0,32},{0,16},{0,49}}}, // P 3 2 1
{151," P 31 2 (0 0 4)",{{0,49},{0,49},{0,8}}}, // P 31 1 2
{152," P 31 2\"",{{0,24},{0,49},{0,16}}}, // P 31 2 1
{153," P 32 2 (0 0 2)",{{0,49},{0,49},{0,8}}}, // P 32 1 2
{154," P 32 2\"",{{0,49},{0,24},{0,16}}}, // P 32 2 1
{155," R 3 2\"",{{0,16},{0,16},{0,24}}}, // R 3 2 :H
{155," P 3* 2",{{0,24},{0,24},{0,49}}}, // R 3 2 :R
{156," P 3 -2\"",{{0,32},{0,32},{0,49}}}, // P 3 m 1
{157," P 3 -2",{{0,32},{0,16},{0,49}}}, // P 3 1 m
{158," P 3 -2\"c",{{0,32},{0,32},{0,25}}}, // P 3 c 1
{159," P 3 -2c",{{0,32},{0,16},{0,49}}}, // P 3 1 c
{160," R 3 -2\"",{{0,20},{0,13},{0,49}}}, // R 3 m :H
{160," P 3* -2",{{0,49},{0,49},{0,49}}}, // R 3 m :R
{161," R 3 -2\"c",{{0,16},{0,17},{0,25}}}, // R 3 c :H
{161," P 3* -2n",{{0,25},{0,25},{0,49}}}, // R 3 c :R
{162,"-P 3 2",{{0,32},{0,16},{0,24}}}, // P -3 1 m
{163,"-P 3 2c",{{0,32},{0,16},{12,36}}}, // P -3 1 c
{164,"-P 3 2\"",{{0,24},{-16,0},{0,49}}}, // P -3 m 1
{165,"-P 3 2\"c",{{0,32},{0,16},{0,25}}}, // P -3 c 1
{166,"-R 3 2\"",{{0,16},{0,8},{0,49}}}, // R -3 m :H
{166,"-P 3* 2",{{0,24},{0,24},{0,49}}}, // R -3 m :R
{167,"-R 3 2\"c",{{0,16},{-8,0},{4,28}}}, // R -3 c :H
{167,"-P 3* 2n",{{0,12},{-12,12},{0,37}}}, // R -3 c :R
{168," P 6",{{0,32},{0,16},{0,49}}}, // P 6
{169," P 61",{{0,49},{0,49},{0,9}}}, // P 61
{170," P 65",{{0,49},{0,49},{0,9}}}, // P 65
{171," P 62",{{0,49},{0,24},{0,17}}}, // P 62
{172," P 64",{{0,49},{0,24},{0,17}}}, // P 64
{173," P 6c",{{0,32},{0,16},{0,49}}}, // P 63
{174," P -6",{{0,32},{0,32},{0,24}}}, // P -6
{175,"-P 6",{{0,32},{0,16},{0,24}}}, // P 6/m
{176,"-P 6c",{{0,32},{0,16},{12,36}}}, // P 63/m
{177," P 6 2",{{0,32},{0,16},{0,24}}}, // P 6 2 2
{178," P 61 2 (0 0 5)",{{0,49},{0,24},{-4,4}}}, // P 61 2 2
{179," P 65 2 (0 0 1)",{{0,24},{0,49},{4,12}}}, // P 65 2 2
{180," P 62 2 (0 0 4)",{{0,49},{0,24},{0,8}}}, // P 62 2 2
{181," P 64 2 (0 0 2)",{{0,49},{0,24},{0,8}}}, // P 64 2 2
{182," P 6c 2c",{{0,32},{0,16},{12,36}}}, // P 63 2 2
{183," P 6 -2",{{0,24},{-16,0},{0,49}}}, // P 6 m m
{184," P 6 -2c",{{0,32},{0,16},{0,25}}}, // P 6 c c
{185," P 6c -2",{{0,32},{0,16},{0,25}}}, // P 63 c m
{186," P 6c -2c",{{0,24},{-16,0},{0,49}}}, // P 63 m c
{187," P -6 2",{{0,32},{0,32},{0,24}}}, // P -6 m 2
{188," P -6c 2",{{0,32},{0,32},{0,12}}}, // P -6 c 2
{189," P -6 -2",{{0,32},{0,16},{0,24}}}, // P -6 2 m
{190," P -6c -2c",{{0,32},{0,16},{12,36}}}, // P -6 2 c
{191,"-P 6 2",{{0,24},{-16,0},{0,24}}}, // P 6/m m m
{192,"-P 6 2c",{{0,32},{0,16},{0,12}}}, // P 6/m c c
{193,"-P 6c 2",{{0,32},{0,16},{0,12}}}, // P 63/m c m
{194,"-P 6c 2c",{{0,24},{-16,0},{12,36}}}, // P 63/m m c
{195," P 2 2 3",{{0,24},{0,24},{0,49}}}, // P 2 3
{196," F 2 2 3",{{0,12},{0,12},{0,49}}}, // F 2 3
{196," F 2 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,36},{12,48},{-12,24}}},
{197," I 2 2 3",{{0,12},{0,12},{0,49}}}, // I 2 3
{197," I 2 2 3 (y+z,x+z,x+y)",{{0,24},{0,25},{24,48}}},
{198," P 2ac 2ab 3",{{-12,13},{0,25},{0,36}}}, // P 21 3
{199," I 2b 2c 3",{{0,12},{0,25},{1,37}}}, // I 21 3
{199," I 2b 2c 3 (y+z,x+z,x+y)",{{12,37},{0,12},{0,49}}},
{200,"-P 2 2 3",{{0,24},{0,24},{0,24}}}, // P m -3
{201," P 2 2 3 -1n",{{0,12},{0,12},{0,49}}}, // P n -3 :1
{201,"-P 2ab 2bc 3",{{0,12},{0,12},{0,49}}}, // P n -3 :2
{202,"-F 2 2 3",{{0,12},{0,12},{0,24}}}, // F m -3
{202,"-F 2 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,24},{0,24},{12,48}}},
{203," F 2 2 3 -1d",{{0,6},{0,6},{0,49}}}, // F d -3 :1
{203,"-F 2uv 2vw 3 (-x+y+z+1/8,x-y+z+1/8,x+y-z+1/8)",{{6,24},{12,30},{0,37}}},
{203,"-F 2uv 2vw 3",{{0,6},{0,6},{0,49}}}, // F d -3 :2
{203,"-F 2uv 2vw 3 (-x+y+z,x-y+z,x+y-z)",{{-18,0},{24,42},{-6,30}}},
{204,"-I 2 2 3",{{0,12},{0,12},{0,24}}}, // I m -3
{204,"-I 2 2 3 (y+z,x+z,x+y)",{{0,24},{-16,0},{0,24}}},
{205,"-P 2ac 2ab 3",{{0,24},{0,12},{-12,13}}}, // P a -3
{206,"-I 2b 2c 3",{{0,12},{0,12},{0,25}}}, // I a -3
{206,"-I 2b 2c 3 (y+z,x+z,x+y)",{{6,24},{12,24},{19,48}}},
{207," P 4 2 3",{{0,24},{0,24},{0,24}}}, // P 4 3 2
{208," P 4n 2 3",{{0,12},{0,12},{0,49}}}, // P 42 3 2
{209," F 4 2 3",{{0,12},{0,12},{0,24}}}, // F 4 3 2
{209," F 4 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,24},{0,24},{12,48}}},
{210," F 4d 2 3",{{0,6},{0,6},{0,49}}}, // F 41 3 2
{210," F 4d 2 3 (-x+y+z,x-y+z,x+y-z)",{{6,24},{12,30},{-24,12}}},
{211," I 4 2 3",{{0,12},{0,12},{0,24}}}, // I 4 3 2
{211," I 4 2 3 (y+z,x+z,x+y)",{{0,24},{-16,0},{0,24}}},
{212," P 4acd 2ab 3",{{6,18},{6,18},{0,49}}}, // P 43 3 2
{213," P 4bd 2ab 3",{{6,18},{6,18},{0,49}}}, // P 41 3 2
{214," I 4bd 2c 3",{{-6,6},{0,6},{1,43}}}, // I 41 3 2
{214," I 4bd 2c 3 (y+z,x+z,x+y)",{{0,12},{-12,12},{12,37}}},
{215," P -4 2 3",{{0,24},{0,24},{0,49}}}, // P -4 3 m
{216," F -4 2 3",{{0,12},{0,12},{0,49}}}, // F -4 3 m
{216," F -4 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,36},{12,48},{-12,24}}},
{217," I -4 2 3",{{0,12},{0,12},{0,49}}}, // I -4 3 m
{217," I -4 2 3 (y+z,x+z,x+y)",{{0,24},{0,12},{0,36}}},
{218," P -4n 2 3",{{0,12},{0,12},{0,49}}}, // P -4 3 n
{219," F -4a 2 3",{{0,12},{0,12},{0,25}}}, // F -4 3 c
{219," F -4a 2 3 (-x+y+z,x-y+z,x+y-z)",{{-6,12},{0,18},{12,48}}},
{220," I -4bd 2c 3",{{-6,6},{0,6},{1,43}}}, // I -4 3 d
{220," I -4bd 2c 3 (y+z,x+z,x+y)",{{24,36},{0,18},{7,30}}},
{221,"-P 4 2 3",{{0,24},{0,24},{0,24}}}, // P m -3 m
{222," P 4 2 3 -1n",{{0,12},{0,12},{0,24}}}, // P n -3 n :1
{222,"-P 4a 2bc 3",{{0,12},{0,12},{12,36}}}, // P n -3 n :2
{223,"-P 4n 2 3",{{0,12},{0,12},{0,24}}}, // P m -3 n
{224," P 4n 2 3 -1n",{{0,12},{0,12},{0,49}}}, // P n -3 m :1
{224,"-P 4bc 2bc 3",{{0,12},{0,12},{0,49}}}, // P n -3 m :2
{225,"-F 4 2 3",{{0,12},{0,12},{0,24}}}, // F m -3 m
{225,"-F 4 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,24},{0,24},{12,48}}},
{226,"-F 4a 2 3",{{0,12},{0,12},{0,12}}}, // F m -3 c
{226,"-F 4a 2 3 (-x+y+z,x-y+z,x+y-z)",{{0,24},{0,12},{-12,12}}},
{227," F 4d 2 3 -1d",{{0,6},{0,6},{0,49}}}, // F d -3 m :1
{227,"-F 4vw 2vw 3 (-x+y+z+1/8,x-y+z+1/8,x+y-z+1/8)",{{6,24},{12,30},{0,37}}},
{227,"-F 4vw 2vw 3",{{0,6},{0,6},{0,49}}}, // F d -3 m :2
{227,"-F 4vw 2vw 3 (-x+y+z,x-y+z,x+y-z)",{{-18,0},{24,42},{-6,30}}},
{228," F 4d 2 3 -1ad",{{0,6},{0,6},{0,25}}}, // F d -3 c :1
{228,"-F 4ud 2vw 3 (-x+y+z-1/8,x-y+z-1/8,x+y-z-1/8)",{{6,18},{6,18},{-19,12}}},
{228,"-F 4ud 2vw 3",{{0,6},{0,6},{0,25}}}, // F d -3 c :2
{228,"-F 4ud 2vw 3 (-x+y+z,x-y+z,x+y-z)",{{12,24},{12,24},{-13,18}}},
{229,"-I 4 2 3",{{0,12},{0,12},{0,24}}}, // I m -3 m
{229,"-I 4 2 3 (y+z,x+z,x+y)",{{0,24},{-16,0},{0,24}}},
{230,"-I 4bd 2c 3",{{0,6},{-6,0},{7,43}}}, // I a -3 d
{230,"-I 4bd 2c 3 (y+z,x+z,x+y)",{{-12,0},{0,12},{1,24}}},
{0, 0, {{0,0},{0,0},{0,0}}}
// END_COMPILED_IN_REFERENCE_DATA
    };

  } // namespace <anonymous>
  } // namespace raw_bricks

  brick_point::brick_point(int raw_point)
  {
    value_ = boost::rational<int>(raw_point / 2, 24);
    off_ = raw_point % 2;
  }

  namespace {

    const raw_bricks::entry*
    find_raw_brick(sgtbx::space_group_type const& space_group_type)
    {
      int sg_number = space_group_type.number();
      for (const raw_bricks::entry* b = raw_bricks::table; b->sg_number; b++) {
        if (b->sg_number > sg_number) break;
        if (b->sg_number == sg_number) {
          space_group tab_sg(b->hall_symbol, false, false, false,
                             space_group_type.group().t_den());
          if (space_group_type.group() == tab_sg) return b;
        }
      }
      return 0;
    }

  }

  brick::brick(sgtbx::space_group_type const& space_group_type)
  {
    const raw_bricks::entry* raw_brick = find_raw_brick(space_group_type);
    if (raw_brick == 0) {
      throw error(
        "Brick is not available for the given space group representation.");
    }
    for(std::size_t i=0;i<3;i++) {
      for(std::size_t j=0;j<2;j++) {
        points_[i][j] = brick_point(raw_brick->points[i][j]);
      }
    }
  }

  brick_point
  brick::operator()(std::size_t i_axis, std::size_t i_min_max) const
  {
    CCTBX_ASSERT(i_axis < 3);
    CCTBX_ASSERT(i_min_max < 2);
    return points_[i_axis][i_min_max];
  }

  std::string
  brick::as_string() const
  {
    std::string result;
    for(std::size_t i=0;i<3;i++) {
      result += scitbx::format(points_[i][0].value());
      result += "<";
      if (!points_[i][0].off()) result += "=";
      result += "xyz"[i];
      result += "<";
      if (!points_[i][1].off()) result += "=";
      result += scitbx::format(points_[i][1].value());
      if (i < 2) result += "; ";
    }
    return result;
  }

  bool
  brick::is_inside(scitbx::vec3<boost::rational<int> > const& point) const
  {
    for(std::size_t i=0;i<3;i++) {
      if (!points_[i][0].off()) {
        if (!(points_[i][0].value() <= point[i])) return false;
      }
      else {
        if (!(points_[i][0].value() <  point[i])) return false;
      }
      if (!points_[i][1].off()) {
        if (!(point[i] <= points_[i][1].value())) return false;
      }
      else {
        if (!(point[i] <  points_[i][1].value())) return false;
      }
    }
    return true;
  }

  bool
  brick::is_inside(tr_vec const& point) const
  {
    typedef boost::rational<int> rational;
    int den = point.den();
    return is_inside(scitbx::vec3<rational>(
      rational(point[0], den),
      rational(point[1], den),
      rational(point[2], den)));
  }

}} // namespace cctbx::sgtbx
