#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include "flashlogo.h"

/* #define DEBUG */

int main(int argc, char **argv)
{
	FILE *outputfile;
	int fsize = flashsize();
	struct logoblock logo1;
	struct logoblock2 logo2;
	int c;
	int bigimage = 0;
	int logoflags, logomagic, logox, logoy;

#ifdef DEBUG
	if (sizeof(struct logoblock) != 65536) {
		fprintf(stderr, "%s: bad logo structure size... recompile? (%i)\n", argv[0], sizeof(struct logoblock));
		exit(1);
	}
#endif

	while (1) {
		static struct option long_options[] = {
			{"full64", 0, 0, 'f'},
			{"help", 0, 0, 'h'},
			{"version", 0, 0, 'v'},
			{0, 0, 0, 0}
		};

		c = getopt_long(argc, argv, "", long_options, NULL);

		if (c == -1)
			break;

		switch (c) {
		case 'h':
			printf("Usage: %s [OPTIONS]... [FILE]\n"
				"Read the current startup graphic behaviour and optionally write the startup\n"
				"graphic to FILE.\n"
				"\n"
				"      --full64         read logo from its separate flash segment at 0xE0000.\n"
				"      --help           display this help and exit.\n"
				"      --version        output version information and exit.\n" "\n", argv[0]);
			exit(1);
		case 'f':
			bigimage = 1;
			break;
		case 'v':
			printf("logoread 2.00\n");
			exit(1);
		case '?':
			fprintf(stderr, "Try `%s --help' for more information.\n", argv[0]);
			exit(1);
		}
	}

	if (fsize < 0) {
		fprintf(stderr, "%s: unable to access flash device.\n", argv[0]);
		exit(1);
	}

	printf("Flash size: %i bytes.\n", fsize);

	printf("Checking for logo presence... ");

	if (bigimage) {
		flashread((char *) &logo1, fsize - 128 * 1024, 65536);
		logomagic = logo1.magic;
		logox = logo1.x;
		logoy = logo1.y;
		logoflags = logo1.flags;
	} else {
		flashread((char *) &logo2, fsize - 62 * 1024, 65536 - 2 * 1024);
		logomagic = logo2.magic;
		logox = logo2.x;
		logoy = logo2.y;
		logoflags = logo2.flags;
	}

	if (logomagic != LB_MAGIC) {
		printf(" not found; use logowrite to write logo.\n");
		exit(1);
	} else
		printf("Found.\n\n");

	printf("Options set:\n");

	if (logoflags & LB_SHOWGIF)
		printf("\t* Display user image\n");

	if (logoflags & LB_SHOWNW)
		printf("\t* Display NetWinder logo\n");

	if (logoflags & LB_NOSOUND)
		printf("\t* Do not play startup tune\n");

	if (!logoflags)
		printf("\t* None\n");

	printf("\nCoordinates for user image display: (%u, %u)\n\n", logox, logoy);

	if (logoflags & LB_SHOWGIF) {
		outputfile = fopen(argv[optind], "wb");

		if (outputfile) {
			printf("Saving logo... ");

			if (bigimage)
				fwrite(&(logo1.data), logo1.size, 1, outputfile);
			else
				fwrite(&(logo2.data2), logo2.size, 1, outputfile);
			fclose(outputfile);

			printf("Done.\n");
		}
	}

	return 0;
}
