/* NVTV Philips TV-I2C header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_ph1_saa7102.h,v 1.2 2003/06/11 16:06:28 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Routines to access the Philips Model1 (SAA7102 etc.) encoder chip 
 * registers via the I2C bus.
 *
 */

#ifndef _TV_PH1_H
#define _TV_PH1_H

#include "tv_chip.h"
#include "tv_common.h"

void TVPhInitRegs (TVEncoderObj *this);
void TVPhCreate (TVEncoderObj *this, TVChip chip, void* ctrl);
void TVPhSetPort (TVEncoderObj *this, int port);
void TVPhGetPort (TVEncoderObj *this, int *port);

void TVPh1InitRegs (TVEncoderObj *this, int flags);
void TVPh1SetRegs (TVEncoderObj *this, TVEncoderRegs *r, TVState state);
void TVPh1GetRegs (TVEncoderObj *this, TVEncoderRegs *r);
void TVPh1SetPort (TVEncoderObj *this, int port);
void TVPh1GetPort (TVEncoderObj *this, int *port);
void TVPh1SetState (TVEncoderObj *this, TVEncoderRegs *r, TVState state);
long TVPh1GetStatus (TVEncoderObj *this, int index);
TVConnect TVPh1GetConnect (TVEncoderObj *this);
void TVPh1SetHWConfig (TVEncoderObj *this, int config);
void TVPh1GetHWConfig (TVEncoderObj *this, int *config);

char *TVDetectPhilips (I2CDevPtr dev, TVChip *encoder);

extern TVEncoderObj tvPh1Template;

#endif /* _TV_PH1_H */
