--
-- Table structure for table `conntrack_ulog`
--

DROP TABLE IF EXISTS `conntrack_ulog`;
CREATE TABLE `conntrack_ulog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `raw_mac` varchar(80) default NULL,
  `oob_time_sec` int(10) unsigned default NULL,
  `oob_time_usec` int(10) unsigned default NULL,
  `oob_prefix` varchar(32) default NULL,
  `oob_mark` int(10) unsigned default NULL,
  `oob_in` varchar(32) default NULL,
  `oob_out` varchar(32) default NULL,
  `ip_saddr` binary(16) default NULL,
  `ip_daddr` binary(16) default NULL,
  `ip_protocol` tinyint(3) unsigned default NULL,
  `ip_tos` tinyint(3) unsigned default NULL,
  `ip_ttl` tinyint(3) unsigned default NULL,
  `ip_totlen` smallint(5) unsigned default NULL,
  `ip_ihl` tinyint(3) unsigned default NULL,
  `ip_csum` smallint(5) unsigned default NULL,
  `ip_id` smallint(5) unsigned default NULL,
  `ip_fragoff` smallint(5) unsigned default NULL,
  `tcp_sport` smallint(5) unsigned default NULL,
  `tcp_dport` smallint(5) unsigned default NULL,
  `tcp_seq` int(10) unsigned default NULL,
  `tcp_ackseq` int(10) unsigned default NULL,
  `tcp_window` smallint(5) unsigned default NULL,
  `tcp_urg` tinyint(4) default NULL,
  `tcp_urgp` smallint(5) unsigned default NULL,
  `tcp_ack` tinyint(4) default NULL,
  `tcp_psh` tinyint(4) default NULL,
  `tcp_rst` tinyint(4) default NULL,
  `tcp_syn` tinyint(4) default NULL,
  `tcp_fin` tinyint(4) default NULL,
  `udp_sport` smallint(5) unsigned default NULL,
  `udp_dport` smallint(5) unsigned default NULL,
  `udp_len` smallint(5) unsigned default NULL,
  `icmp_type` tinyint(3) unsigned default NULL,
  `icmp_code` tinyint(3) unsigned default NULL,
  `icmp_echoid` smallint(5) unsigned default NULL,
  `icmp_echoseq` smallint(5) unsigned default NULL,
  `icmp_gateway` int(10) unsigned default NULL,
  `icmp_fragmtu` smallint(5) unsigned default NULL,
  `pwsniff_user` varchar(30) default NULL,
  `pwsniff_pass` varchar(30) default NULL,
  `ahesp_spi` int(10) unsigned default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `state` smallint(6) unsigned default NULL,
  `end_timestamp` datetime default NULL,
  `start_timestamp` datetime default NULL,
  `username` varchar(30) default NULL,
  `user_id` smallint(5) unsigned default NULL,
  `client_os` varchar(100) default NULL,
  `client_app` varchar(256) default NULL,
  `packets_in` int(10) default NULL,
  `packets_out` int(10) default NULL,
  `bytes_in` int(10) default NULL,
  `bytes_out` int(10) default NULL,
  UNIQUE KEY `id` (`id`),
  KEY `index_id` (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip_saddr` (`ip_saddr`),
  KEY `udp_dport` (`udp_dport`),
  KEY `tcp_dport` (`tcp_dport`),
  KEY `oob_time_sec` (`oob_time_sec`)
) ENGINE=MyISAM AUTO_INCREMENT=739 DEFAULT CHARSET=latin1;


