# -*- coding: utf-8 -*-

"""
Copyright(C) 2007-2008 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: csv.py 12149 2008-01-11 17:18:26Z romain $
"""

from nevow import tags, loaders, rend, inevow, static
import table
from frags import FragmentFactory
from pages import BasePage
from tools import Args, trans

MAX_RESULTS = 100

class CSVFragment(table.TableFragment):

    docFactory = loaders.stan(tags.invisible(data=tags.directive('table'))[
                                tags.invisible(render=tags.directive('table'))
                                ])

    def __init__(self, name, function, title, urlbase, args, icon='', switch=True):
        """ Init.
            @param function [string] this is the name of the table (TODO: rename?)
            @param title [string] title of table.
            @param icon [string] if specified, a picture will be showed before title name. (file in img/)
            @param multitable [bool] if True, we will use multitable arguments formats (Tablename_arg)
            @param switch [bool] if this fragment can be showed with a table or an other type of graph
        """
        try:
            args['limit'] = int(MAX_RESULTS)
        except:
            pass
        table.TableFragment.__init__(self, name, function, title, urlbase, args, icon, switch)

    def render_table(self, context, data):

        if hasattr(data, 'table'):
            self.table = data
        elif isinstance(data, list) and hasattr(data[0], 'table'):
            self.table = data[0]
        else:
            return ''

        render = u''
        for head in self.table.columns:
            try:
                head = trans(context, Args().arg_types[head].label)
            except:
                pass

            render += u'"%s";' % unicode(head).replace(u'"', u'""')

        render += u'\n'

        for line in self.table.table:
            for cell in line:
                if isinstance(cell, tuple):
                    cell = cell[0]
                if cell is None:
                    cell = ''
                render += u'"%s";' % unicode(cell).replace(u'"', u'""')
            render += u'\n'

        return render

class CSVPage(BasePage):
    """ This Fragment can be called with http://localhost:8080/nulog/frag/.
    """

    docFactory = loaders.stan(tags.invisible(render=tags.directive('content')))

    def childFactory(self, ctx, childSegment):
        return CSVPage(self.conf, self.langconfig, self.AvatarId, childSegment)

    def renderHTTP(self, ctx):

        request = inevow.IRequest(ctx)
        request.setHeader("content-type", 'text/csv')

        return BasePage.renderHTTP(self, ctx)

    def render_content(self, ctx, data):

        args = ctx.locate(inevow.IRequest).args
        args = dict((i, args[i][0]) for i in args)

        args['~render'] = 'csv'
        title = None
        img = None

        frag = FragmentFactory(ctx, 'csv', self.content, title, self.conf.get('Links', 'url'), args, img, switch=True, divid=False)

        return frag
