/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef SYSTEM_H

#define SYSTEM_H
#include "config.h"

#include <gtk/gtk.h>
#include <cairo.h>
#include "measure.h"

class NedMainWindow;
class NedPage;
class NedStaff;
class NedClipBoard;
class NedCommandList;
class NedChordOrRest;
class NedBbox;
class part;

#define MAX_POSITIONS 4096
#define MAX_MEASURES 40
//#define WITH_WEIGHTS


class NedSystem {
	public:
		NedSystem(NedPage *page, double ypos, double width, int nr, unsigned int start_measure_number, bool start);
		~NedSystem();
		void draw(cairo_t *cr, bool first_page);
		NedMainWindow *getMainWindow();
		NedPage *getPage() {return m_page;}
		void resetPositionPointers();
		void prepareForImport();
		bool testLineOverflow(double indent);
		void appendElementsOfMeasureLength(part *parts, unsigned int meas_duration);
		void removeLastImported();
		bool handleImportedTuplets();
		void handleStaffElements();
		void removeUnneededAccidentals();
		bool trySelect (double x, double y);
		bool tryInsertOrErease (double x, double y);
		bool findLine(double x, double y, int *ypos, int *line, int *bottom);
		double getHeight();
		double getYPos() {return m_ypos;}
		int getSystemNumber() {return m_system_number;}
		void setSystemNumber(int number) {m_system_number = number;}
		void changePageInfo(NedPage *page) {m_page = page;}
		int getNumberOfStaffs();
		void appendStaff(NedCommandList *command_list, int p_staff_nr = -1);
		void removeLastStaff();
		void deleteStaff(int staff_number);
		void restoreStaff(int staff_number);
		void shiftStaff(int staff_number, unsigned int position);
		bool reposit(int pass, int measure_number, NedCommandList *command_list = NULL, NedSystem **next_system  = NULL);
		void renumberMeasures(int *measure_number, GList *special_measures, bool force);
		int getNumberOfFirstMeasure();
		int getNumberOfLastMeasure();
		unsigned long long getSystemEndTime();
		void checkForElementsToSplit(NedCommandList *command_list);
		void collectDestinationVoices(NedClipBoard *board);
		bool collectFirstMeasure(NedClipBoard *board);
		void findSelectedSystems(NedBbox *sel_rect, int *number_of_first_selected_staff, 
			int *number_of_last_selected_staff, NedSystem **first_selected_system, NedSystem **last_selected_system);
		void collectSelectionRectangleElements(double xp, NedBbox *sel_rect, GList **sel_group,
			NedSystem *first_selected_system, NedSystem *last_selected_system, bool is_first_selected_page,
			bool is_last_selected_page);
		void pasteElements(NedCommandList *command_list, GList **elements, int from_staff, int to_staff, unsigned long long start_midi_time);
		bool hasTupletConflict(unsigned int meas_duration, GList **elements, int from_staff, int to_staff, unsigned long long start_midi_time);
		bool findFromTo(GList *clipboard, NedSystem **min_sys, NedSystem **max_sys);
		bool truncateAtStart(NedCommandList *command_list, unsigned long long midi_time);
		bool findStartMeasureLimits(GList *clipboard, unsigned long long *start_midi);
		bool findEndMeasureLimits(GList *clipboard, unsigned long long *end_midi);
		void deleteItemsFromTo(NedCommandList *command_list, bool is_first, bool is_last, unsigned long long start_midi, unsigned long long end_midi);
		void removeNotesFromTo(NedCommandList *command_list, GList *items, bool is_first, bool is_last);
		void insertBlocks(NedCommandList *command_list, int blockcount, unsigned long long midi_time);
		void testForPageBackwardTies(NedCommandList *command_list);
		double computeMidDist(double y);
		NedMeasure *getMeasure(unsigned int midi_time);
		NedMeasure *getMeasureNr(int m_number) {return &(m_measures[m_number]);}
		bool findTimeOfMeasure(int meas_num, unsigned long long *meas_time);
		int getMeasureCount() {return m_measure_count;}
		bool tryChangeLength(NedChordOrRest *chord_or_rest);
		double placeStaffs(double staffpos);
		NedStaff *findStaff(double x, double y, NedMeasure **measure);
		void empty();
		void shiftY(double offs) {m_ypos += offs;}
		void saveSystem(FILE *fp);
		void restoreSystem(FILE *fp);
		void prepareReplay();
		unsigned int getWholeMidiLength();
		void resetUntouched() {m_isUntouched = FALSE;}
		bool isUntouched() {return m_isUntouched;}
		void setWidth(double w);
		void do_remove_staff(NedStaff *staff);
		void do_append_staff(NedStaff *staff);
		void setAndUpdateClefTypeAndKeySig(int *clef_and_key_array);
		void fill_up(double indent, NedCommandList *command_list);
		GList *getFirstChordOrRest(int staff_nr, int voice_nr, int lyrics_line, bool lyrics_required);
		GList *getLastChordOrRest(int staff_nr, int voice_nr, int lyrics_line, bool lyrics_required);
		NedStaff *getStaff(int nr);
		double m_system_start;
	private:
		void drawBrace (cairo_t *cr, double leftx, double indent, double topy, double zoom_factor, double height, double toppos);
		void drawBracket (cairo_t *cr, double leftx, double indent, double topy, double zoom_factor, double height, double toppos);
		bool m_isUntouched;
		bool m_tempUntouched;
		bool m_check_line_compression;
		void do_reposit(bool use_upbeat, double indent);
		void compute_extra_space(double indent);
		GList *m_staffs;
		GList *m_deleted_staffs;
		double m_ypos;
		double m_width;
		int m_system_number;
#ifdef WITH_WEIGHTS
		unsigned int mylog(unsigned int x);
#endif
		NedPage *m_page;
		NedMeasure m_measures[MAX_MEASURES];
		int m_measure_count;
		double m_ori,m_netto;
		double m_extra_space;
		bool m_only_whole_elements;
};

#endif /* SYSTEM_H */
