/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef PAGE_H

#define PAGE_H
#include "config.h"
#include "resource.h"

#include <gtk/gtk.h>
#include <cairo.h>

class NedMainWindow;
class NedClipBoard;
class NedSystem;
class NedStaff;
class NedMeasure;
class NedCommandList;
class part;

class NedPage {
	public:
		NedPage(NedMainWindow *main_window, double width, double height, int nr, unsigned int start_measure_number, bool start);
		~NedPage();
		NedSystem *appendSystem();
		void removeSystem(NedSystem *system);
		void insertSystem(NedSystem *system);
		bool isPageOverflow();
		bool isEmpty() {return g_list_length(m_systems) == 0;}
		void fill_up();
		void draw(cairo_t *cr, double main_width, double main_height);
		double getTopPos();
		double getLeftPos();
		double getWidth() {return m_width;}
		double getHeight() {return m_height;}
		double getXPos() {return m_xpos;}
		unsigned int getNumberOfLastMeasure();
		void setPageNumber(int num) {m_page_number = num; m_xpos = num * (m_width + DEFAULT_BORDER);}
		double getContetXpos();
		double getContentWidth() {return m_width - 2 * LEFT_RIGHT_BORDER;}
		NedMainWindow *getMainWindow() {return m_main_window;}
		void appendElementsOfMeasureLength(part *parts, unsigned int meas_duration);
		void handleStaffElements();
		void removeUnneededAccidentals();
		bool trySelect(double x, double y);
		bool tryInsertOrErease(double x, double y);
		bool findLine(double x, double y, int *ypos, int *line, int *bottom);
		int getPageNumber() {return m_page_number;}
		bool findTimeOfMeasure(int meas_num, unsigned long long *meas_time, unsigned long long *system_offs);
		void resetCollision();
		void findSelectedFirstsLasts(NedBbox *sel_rect, int *number_of_first_selected_staff, int *number_of_last_selected_staff, 
			NedSystem **first_selected_system, NedSystem **last_selected_system,
			NedPage **first_selected_page, NedPage **last_selected_page);
		void collectSelectionRectangleElements(NedBbox *sel_rect, GList **sel_group,
			NedSystem *first_selected_system, NedSystem *last_selected_system,
			NedPage *first_selected_page, NedPage *last_selected_page);
		int getSorting(NedStaff *this_staff, NedSystem *this_system, NedStaff *other_staff, NedSystem *other_system);
		NedSystem *getNextSystem(NedSystem *system, NedCommandList *command_list = NULL);
		NedSystem *getPreviousSystem(NedSystem *system);
		NedSystem *getFirstSystem();
		void renumberSystems();
		bool isFirst(NedSystem *system);
		bool isLast(NedSystem *system);
		bool tryChangeLength(NedChordOrRest *chord_or_rest);
		bool placeStaffs(int pass, NedCommandList *command_list = NULL);
		bool reposit(int pass, NedCommandList *command_list = NULL);
		int getNumberOfStaffs();
		void findLastTouchedSystem(NedSystem **start_of_systems);
		NedStaff *findStaff(double x, double y, NedMeasure **measure);
		void savePage(FILE *fp);
		void restorePage(FILE *fp, unsigned int start_measure_number);
		void prepareReplay();
		void appendStaff(NedCommandList *command_list, int p_staff_nr = -1);
		void removeLastStaff();
		void deleteStaff(int staff_number);
		void restoreStaff(int staff_number);
		void shiftStaff(int staff_number, int position);
		void reconfig_paper(double width, double height);
		void findFromTo(GList *clipboard, NedPage **min_page, NedPage **max_page, NedSystem **min_sys, NedSystem **max_sys);
		void deleteItemsFromTo(NedCommandList *command_list, bool is_first_page, bool is_last_page, NedSystem *min_sys, NedSystem *max_sys,
				unsigned long long start_midi, unsigned long long end_midi);
		void removeNotesFromTo(NedCommandList *command_list, GList *items, bool is_first_page, bool is_last_page,
			NedSystem *min_sys, NedSystem *max_sys);
		void testForPageBackwardTies(NedCommandList *command_list);
		void checkForElementsToSplit(NedCommandList *command_list);
		void setAndUpdateClefTypeAndKeySig(int *clef_and_key_array);
		GList **getSystemsList() {return &m_systems;}
	private:
		void do_place_staffs(double offs);
		GList *m_systems;
		double m_xpos;
		double m_system_diff;
		double m_width, m_height;
		const double default_border;
		int m_page_number;
		bool m_ping_pong;
		NedMainWindow *m_main_window;
};

#endif /* PAGE_H */
