# -*- coding: utf-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import codecs

class Config(dict):

    def get_with_type(self, name, conv, default=None):
        value = self.get(name)
        if value is None:
            return default
        ##assert conv is not None
        try:
            return conv(value)
        except ValueError:
            return default # XXX

    def get(self, name, default=None):
        keylist = name if isinstance(name, list) else [name]
        for key in keylist:
            if key in self:
                return self[key]
        return default

    def __str__(self):
        buf = []
        for item in self.iteritems():
            buf.append('%s,%s\n' % item)
        return ''.join(buf)


def create_from_file(path):
    f = open(path)
    buf = []
    for line in f:
        if not line.strip():
            continue
        buf.append(line)
    f.close()
    return create_from_buffer(buf)

def create_from_buffer(buf):
    dic = Config()
    charset = 'Shift_JIS' # default
    for line in buf:
        try:
            key, value = line.split(',', 1)
        except ValueError:
            continue
        if key.strip() == 'charset':
            try:
                codecs.lookup(charset)
            except:
                print 'Unsupported charset %s' % value.strip()
            else:
                charset = value.strip()
        elif key.strip() in ['refreshundeletemask', 'icon', 'cursor',
                             'shiori', 'makoto']:
            dic[key.strip()] = value.strip()
        else:
            dic[key.strip()] = unicode(value, charset, 'replace').strip()
    return dic

def null_config():
    return Config()
