# -*- coding: utf-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004-2009 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import random


class EntryDatabase:

    def __init__(self, db=None):
        self.__db = db or {}

    def add(self, key, script):
        entries = self.__db.get(key, [])
        entries.append(script)
        self.__db[key] = entries

    def get(self, key, default=None):
        entries = self.__db.get(key, [default])
        return random.choice(entries)

    def is_empty(self):
        return not self.__db


def test():
    entry_db = EntryDatabase()
    print 'is_empty() =', entry_db.is_empty()
    entry_db.add('#temp0', '\hふーん。\e')
    entry_db.add('#temp0', '\hそうなのかぁ。\e')
    entry_db.add('#temp0', '\hほうほう。\e')
    entry_db.add('#temp2', '\hいい感じだね。\e')
    entry_db.add('#temp3', '\hなるほど。\e')
    for i in range(5):
        print '#temp0', entry_db.get('#temp0')
    for key in ['#temp1', '#temp2', '#temp3']:
        print key, entry_db.get(key)
    print 'is_empty() =', entry_db.is_empty()

if __name__ == '__main__':
    test()
