# -*- coding: utf-8 -*-
#
#  yaya.py - a (Real) YAYA loader for ninix
#  Copyright (C) 2004 by linjian
#  Copyright (C) 2004-2009 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys

try:
    import _yaya
except:
    _yaya = None


class Shiori:

    def __init__(self, dll_name):
        self.dll_name = dll_name

    def use_saori(self, saori):
        self.saori = saori

    def find(self, topdir, dll_name): ## FIXME
        result = 0
        if _yaya:
            if os.path.isfile(os.path.join(topdir, 'yaya.txt')):
                result = 205
            elif dll_name is not None and \
                 os.path.isfile(os.path.join(topdir,
                                             ''.join((dll_name[:-3], 'txt')))):
                result = 105
        return result

    def show_description(self):
        sys.stdout.write(
            'Shiori: Real YAYA loader for ninix\n'
            '        Copyright (C) 2004 by linjian\n'
            '        Copyright (C) 2004-2009 by Shyouzou Sugitani\n')

    def get_charset(self, topdir, dll_name): ## FIXME
        charset = 'Shift_JIS'
        f = open(os.path.join(topdir, ''.join((dll_name[:-3], 'txt'))))
        for line in f:
            if 'charset' in line:
                charset = line.split(',')[1]
                charset = charset.strip()
                break
        if charset == 'default':
            charset = 'Shift_JIS'
        return charset

    def load(self, topdir):
        self.dir = topdir
        self.charset = self.get_charset(self.dir, self.dll_name)
        self.saori_list = {}
        if _yaya:
            reload(_yaya)
            if self.dir.endswith(os.sep):
                topdir = self.dir
            else:
                topdir = ''.join((self.dir, os.sep))
            _yaya.setcallback(self.saori_exist,
                              self.saori_load,
                              self.saori_unload,
                              self.saori_request)
            result = _yaya.load_yaya(topdir)
            return result
        else:
            return 0

    def unload(self):
        if _yaya:
            _yaya.unload_yaya()
            for name in self.saori_list.keys():
                if self.saori_list[name][1]:
                    self.saori_list[name][0].unload()
                del self.saori_list[name]

    __req_charset = 'GET SHIORI/3.0\r\n' \
                    'ID: charset\r\n' \
                    'Sender: ninix-aya\r\n' \
                    'SecurityLevel: local\r\n\r\n'

    def request(self, req_string):
        if _yaya:
            if req_string == self.__req_charset:
                return 'SHIORI/3.0 200 OK\r\n' \
                       'Sender: YAYA\r\n' \
                       'Value: %s\r\n\r\n' % self.charset
            return _yaya.request_yaya(req_string)
        else:
            return '' # FIXME

    def saori_exist(self, saori):
        module = self.saori.request(saori)
        if module:
            self.saori_list[saori] = [module, 0]
            return len(self.saori_list)
        else:
            return 0

    def saori_load(self, saori, path):
        result = 0
        if saori in self.saori_list and self.saori_list[saori][1] == 0:
            result = self.saori_list[saori][0].load(path)
            self.saori_list[saori][1] = result
        return result

    def saori_unload(self, saori):
        result = 0
        if saori in self.saori_list and self.saori_list[saori][1] != 0:
            result = self.saori_list[saori][0].unload()
            self.saori_list[saori][1] = 0
        return result

    def saori_request(self, saori, req):
        result = 'SAORI/1.0 500 Internal Server Error'
        if saori in self.saori_list:
            if self.saori_list[saori][1] == 0:
                head, tail = os.path.split(saori)
                self.saori_list[saori][1] = \
                                          self.saori_list[saori][0].load(head)
            if self.saori_list[saori][1]:
                result = self.saori_list[saori][0].request(req)
        return result
