package mlsub.typing.lowlevel;

/**
 * @version $Revision: 1.1 $, $Date: 2000/06/14 13:32:52 $
 * @author Alexandre Frey
 **/
abstract public class LowlevelSolutionHandler {
  private DomainVector _solution = null;
  //  private BitVector garbage;
  //  final void fillSolution(DomainVector _solution) {
  //    this._solution = _solution;
  //  }

  final void handle(DomainVector _solution) {
    this._solution = _solution;
    handle();
  }
    
  
  final protected int getSolutionOf(int x) {
    return _solution.getDomain(x).getLowestSetBit();
  }
  /**
   * Called when a solution is found. handle can then call getSolutionOf(x) to
   * retrieve the solution.
   **/
  abstract protected void handle();
}
