/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.FluidBinding;
import gnu.mapping.FluidConstraint;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;

public class Future
extends Thread {
    Object result;
    Future parent;
    public FluidBinding fluidBindings;
    Environment environment;
    InPort in;
    OutPort out;
    OutPort err;
    Throwable exception;
    Procedure action;
    static Future defaultContext = null;

    public Future(Procedure action, Environment environment) {
        this.action = action;
        Thread parent_thread = Thread.currentThread();
        this.environment = environment;
    }

    public Future(Procedure action, Environment environment, InPort in, OutPort out, OutPort err) {
        this.action = action;
        Thread parent_thread = Thread.currentThread();
        this.environment = environment;
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public Future(Procedure action) {
        Environment parent_env;
        this.action = action;
        this.in = InPort.inDefault();
        this.out = OutPort.outDefault();
        this.err = OutPort.errDefault();
        Thread parent_thread = Thread.currentThread();
        if (parent_thread instanceof Future) {
            this.parent = (Future)parent_thread;
            parent_env = this.parent.environment;
        } else {
            parent_env = Environment.user();
        }
        this.environment = parent_env;
    }

    @Override
    public void run() {
        try {
            this.result = this.action.apply0();
        }
        catch (Throwable ex) {
            this.exception = ex;
        }
    }

    public Object waitForResult() {
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("thread join [force] was interrupted");
        }
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception.toString());
        }
        return this.result;
    }

    public void setFluids(FluidBinding new_fluids) {
        FluidBinding old_fluids = this.fluidBindings;
        FluidBinding fluid = new_fluids;
        while (fluid != old_fluids) {
            Binding binding = fluid.binding;
            Constraint constraint = binding.constraint;
            if (constraint instanceof FluidConstraint) {
                ++((FluidConstraint)constraint).referenceCount;
            } else {
                binding.constraint = new FluidConstraint(constraint);
            }
            fluid = fluid.previous;
        }
        this.fluidBindings = new_fluids;
    }

    public void resetFluids(FluidBinding old_fluids) {
        FluidBinding new_fluids;
        FluidBinding fluid = new_fluids = this.fluidBindings;
        while (fluid != old_fluids) {
            Binding binding = fluid.binding;
            FluidConstraint constraint = (FluidConstraint)binding.constraint;
            if (constraint.referenceCount-- <= 0) {
                binding.constraint = constraint.savedConstraint;
            }
            fluid = fluid.previous;
        }
        this.fluidBindings = old_fluids;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("#<future ");
        buf.append(this.getName());
        buf.append(">");
        return buf.toString();
    }

    static synchronized void getDefaultContext() {
        if (defaultContext == null) {
            defaultContext = new Future(null);
        }
    }

    public static FluidBinding getFluids() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return ((Future)thread).fluidBindings;
        }
        if (defaultContext == null) {
            Future.getDefaultContext();
        }
        return Future.defaultContext.fluidBindings;
    }

    public static Future getContext() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return (Future)thread;
        }
        if (defaultContext == null) {
            Future.getDefaultContext();
        }
        return defaultContext;
    }
}

