/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.ModuleExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.SFormat;

public class ReferenceExp
extends Expression {
    Object symbol;
    Declaration binding;
    static int counter;
    int id = ++counter;
    private static int DONT_DEREFERENCE;
    private static int PROCEDURE_NAME;
    public static int PREFER_BINDING2;

    public String string_name() {
        return this.symbol.toString();
    }

    public final String getName() {
        return this.symbol.toString();
    }

    public final Object getSymbol() {
        return this.symbol;
    }

    public final Declaration getBinding() {
        return this.binding;
    }

    public final void setBinding(Declaration decl) {
        this.binding = decl;
    }

    public final boolean getDontDereference() {
        return (this.flags & DONT_DEREFERENCE) != 0;
    }

    public final void setDontDereference(boolean setting) {
        this.setFlag(setting, DONT_DEREFERENCE);
    }

    public final boolean isProcedureName() {
        return (this.flags & PROCEDURE_NAME) != 0;
    }

    public final void setProcedureName(boolean setting) {
        this.setFlag(setting, PROCEDURE_NAME);
    }

    public ReferenceExp(Object symbol) {
        this.symbol = symbol;
    }

    public ReferenceExp(Object symbol, Declaration binding) {
        this.symbol = symbol;
        this.binding = binding;
    }

    public ReferenceExp(Declaration binding) {
        this.binding = binding;
        this.symbol = binding.getName();
    }

    @Override
    public Object eval(Environment env) {
        if (this.binding != null) {
            if (this.binding.field != null && this.binding.field.getStaticFlag()) {
                try {
                    Object value = this.binding.field.getReflectField().get(null);
                    if (!(value instanceof Binding)) {
                        return value;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!(this.binding.context instanceof ModuleExp) || this.binding.isPrivate()) {
                throw new Error("internal error: ReferenceExp.eval on lexical binding");
            }
        }
        if (this.getDontDereference()) {
            return this.symbol instanceof Binding ? this.symbol : env.getBinding(this.symbol.toString());
        }
        if (this.getFlag(PREFER_BINDING2)) {
            Binding bind = this.symbol instanceof Binding ? (Binding)this.symbol : env.getBinding(this.symbol.toString());
            return this.isProcedureName() ? bind.getFunctionValue() : bind.get();
        }
        return env.getChecked(this.symbol.toString());
    }

    @Override
    public void compile(Compilation comp, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        CodeAttr code = comp.getCode();
        Declaration decl = Declaration.followAliases(this.binding);
        decl.load(comp);
        if (decl.isIndirectBinding() && !this.getDontDereference()) {
            if (!this.isProcedureName()) {
                code.emitInvokeVirtual(Compilation.getLocationMethod);
            } else {
                code.emitInvokeVirtual(Compilation.getProcedureBindingMethod);
            }
        } else if (decl.isFluid() && decl.field == null) {
            code.emitGetField(FluidLetExp.valueField);
        }
        if (target instanceof SeriesTarget && decl.getFlag(262144)) {
            ((SeriesTarget)target).compileFromStackSimple(comp, this.getType());
        } else {
            target.compileFromStack(comp, this.getType());
        }
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkReferenceExp(this);
    }

    @Override
    public void print(OutPort ps) {
        ps.print("(Ref/");
        ps.print(this.id);
        ps.print("/ ");
        SFormat.print(this.symbol, ps);
        ps.print(")");
    }

    @Override
    public Type getType() {
        return this.binding == null || this.binding.isFluid() ? Type.pointer_type : (this.getDontDereference() ? Compilation.typeLocation : this.binding.getType());
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }

    static {
        DONT_DEREFERENCE = 1;
        PROCEDURE_NAME = 2;
        PREFER_BINDING2 = 4;
    }
}

