/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;
    Method makeBindingMethod = null;

    public LetExp(Expression[] i) {
        this.inits = i;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression body) {
        this.body = body;
    }

    static void store_rest(Compilation comp, Declaration decl) {
        if (decl != null) {
            LetExp.store_rest(comp, decl.nextDecl());
            if (decl.needsInit()) {
                decl.initBinding(comp);
            }
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Declaration decl = this.firstDecl();
        int i = 0;
        while (i < this.inits.length) {
            Type varType;
            decl.allocateVariable(code);
            Target varTarget = !decl.needsInit() ? Target.Ignore : ((varType = decl.getType()) == Type.pointer_type ? Target.pushObject : new StackTarget(varType));
            this.inits[i].compile(comp, varTarget);
            ++i;
            decl = decl.nextDecl();
        }
        code.enterScope(this.scope);
        LetExp.store_rest(comp, this.firstDecl());
        this.body.compileWithPosition(comp, target);
        code.popScope();
    }

    @Override
    public final Type getType() {
        return this.body.getType();
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkLetExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.inits = walker.walkExps(this.inits);
        if (walker.exitValue == null) {
            this.body = this.body.walk(walker);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Let", ")", 2);
        out.writeSpaceFill();
        this.printLineColumn(out);
        out.startLogicalBlock("(", false, ")");
        int i = 0;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (i > 0) {
                out.writeSpaceLinear();
            }
            out.print('(');
            out.print(decl.getName());
            out.writeSpaceFill();
            if (this.inits[i] == null) {
                out.print("<null>");
            } else {
                this.inits[i].print(out);
            }
            ++i;
            out.print(')');
        }
        out.endLogicalBlock(")");
        out.writeSpaceLinear();
        this.body.print(out);
        out.endLogicalBlock(")");
    }
}

