/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class BeginExp
extends Expression {
    Expression[] exps;
    int length;

    public BeginExp() {
    }

    public BeginExp(Expression[] ex) {
        this.exps = ex;
        this.length = ex.length;
    }

    public BeginExp(Expression exp0, Expression exp1) {
        this.exps = new Expression[2];
        this.exps[0] = exp0;
        this.exps[1] = exp1;
        this.length = 2;
    }

    public static final Expression canonicalize(Expression exp) {
        if (exp instanceof BeginExp) {
            BeginExp bexp = (BeginExp)exp;
            int len = bexp.length;
            if (len == 0) {
                return QuoteExp.voidExp;
            }
            if (len == 1) {
                return BeginExp.canonicalize(bexp.exps[0]);
            }
        }
        return exp;
    }

    public final void add(Expression exp) {
        if (this.exps == null) {
            this.exps = new Expression[8];
        }
        if (this.length == this.exps.length) {
            Expression[] ex = new Expression[2 * this.length];
            System.arraycopy(this.exps, 0, ex, 0, this.length);
            this.exps = ex;
        }
        this.exps[this.length++] = exp;
    }

    public final Expression[] getExpressions() {
        return this.exps;
    }

    public final void setExpressions(Expression[] exps) {
        this.exps = exps;
        this.length = exps.length;
    }

    @Override
    public Object eval(Environment env) throws Throwable {
        int i;
        int n = this.length;
        for (i = 0; i < n - 1; ++i) {
            this.exps[i].eval(env);
        }
        return this.exps[i].eval(env);
    }

    @Override
    public void compile(Compilation comp, Target target) {
        int i;
        int n = this.length;
        for (i = 0; i < n - 1; ++i) {
            this.exps[i].compileWithPosition(comp, Target.Ignore);
            if (comp.getCode().reachableHere()) continue;
            return;
        }
        this.exps[i].compileWithPosition(comp, target);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkBeginExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.exps = walker.walkExps(this.exps, this.length);
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Begin", ")", 2);
        out.writeSpaceFill();
        this.printLineColumn(out);
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            out.writeSpaceLinear();
            this.exps[i].print(out);
        }
        out.endLogicalBlock(")");
    }

    @Override
    public Type getType() {
        return this.exps[this.length - 1].getType();
    }
}

