/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "RaStore_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(RA_STORE_SIG) = {
	ASN1_SIMPLE(RA_STORE_SIG, signature, ASN1_BIT_STRING),
	ASN1_SIMPLE(RA_STORE_SIG, sig_alg, X509_ALGOR),
}ASN1_SEQUENCE_END(RA_STORE_SIG)
ASN1_SEQUENCE(RA_STORE_PRIVDATAS) = {
	ASN1_SIMPLE(RA_STORE_PRIVDATAS, passwd, ASN1_UTF8STRING),
	ASN1_SIMPLE(RA_STORE_PRIVDATAS, privkey, RSAPrivateKey),
}ASN1_SEQUENCE_END(RA_STORE_PRIVDATAS)
RaStoreSig RaStoreSig::EmptyInstance;
bool RaStoreSig::set_sigAlg(const X509_ALGOR * c_sigAlg)
{
	if(m_sigAlg)
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)c_sigAlg);
	if(!m_sigAlg)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_ALGOR * RaStoreSig::get_sigAlg() const
{
	if(!m_sigAlg)
		((RaStoreSig*)this)->m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

X509_ALGOR * RaStoreSig::get_sigAlg()
{
	if(!m_sigAlg)
		m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

bool RaStoreSig::set_signature(const ASN1_BIT_STRING * c_signature)
{
	if(m_signature)
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_signature);
	if(!m_signature)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * RaStoreSig::get_signature() const
{
	if(!m_signature)
		((RaStoreSig*)this)->m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

ASN1_BIT_STRING * RaStoreSig::get_signature()
{
	if(!m_signature)
		m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

bool RaStoreSig::to_PEM(mString & PemDatas) const
{
	RA_STORE_SIG * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI RA STORE SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool RaStoreSig::from_PEM(const mString & PemDatas)
{
	RA_STORE_SIG * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI RA STORE SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

RaStoreSig::RaStoreSig():NewPKIObject()
{
	resetAll();
}

RaStoreSig::RaStoreSig(const RaStoreSig & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

RaStoreSig::~RaStoreSig()
{
	Clear();
}

void RaStoreSig::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RaStoreSig::freeAll()
{
	if(m_sigAlg)
	{
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	}
	if(m_signature)
	{
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void RaStoreSig::resetAll()
{
	m_sigAlg = NULL;
	m_signature = NULL;
}

bool RaStoreSig::load_Datas(const RA_STORE_SIG * Datas)
{
	Clear();
	if(Datas->sig_alg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), Datas->sig_alg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool RaStoreSig::give_Datas(RA_STORE_SIG ** Datas) const
{
	if(!(*Datas) && !(*Datas = (RA_STORE_SIG*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_sigAlg)
	{
		if((*Datas)->sig_alg)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sig_alg, ASN1_ITEM_rptr(X509_ALGOR));
		if(!((*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (ASN1_VALUE*)m_sigAlg)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sig_alg)
		{
			(*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
			if(!(*Datas)->sig_alg)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_signature)
	{
		if((*Datas)->signature)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_signature)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->signature)
		{
			(*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->signature)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool RaStoreSig::operator=(const RaStoreSig & other)
{
	Clear();
	if(other.m_sigAlg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)other.m_sigAlg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RaStoreSig::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(RA_STORE_SIG);
}
RaStorePrivdatas RaStorePrivdatas::EmptyInstance;
bool RaStorePrivdatas::set_passwd(const mString & c_passwd)
{
	m_passwd = c_passwd;
	return true;
}

const mString & RaStorePrivdatas::get_passwd() const
{
	return m_passwd;
}

mString & RaStorePrivdatas::get_passwd()
{
	return m_passwd;
}

bool RaStorePrivdatas::set_privkey(const RSA * c_privkey)
{
	if(m_privkey)
		ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
	m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (void*)c_privkey);
	if(!m_privkey)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const RSA * RaStorePrivdatas::get_privkey() const
{
	if(!m_privkey)
		((RaStorePrivdatas*)this)->m_privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
	return m_privkey;
}

RSA * RaStorePrivdatas::get_privkey()
{
	if(!m_privkey)
		m_privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
	return m_privkey;
}

bool RaStorePrivdatas::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	RA_STORE_PRIVDATAS * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool RaStorePrivdatas::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	RA_STORE_PRIVDATAS * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

RaStorePrivdatas::RaStorePrivdatas():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

RaStorePrivdatas::RaStorePrivdatas(const RaStorePrivdatas & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

RaStorePrivdatas::~RaStorePrivdatas()
{
	Clear();
}

void RaStorePrivdatas::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RaStorePrivdatas::freeAll()
{
	if(m_privkey)
	{
		ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
	}
}

void RaStorePrivdatas::resetAll()
{
	m_passwd = "";
	m_privkey = NULL;
}

bool RaStorePrivdatas::load_Datas(const RA_STORE_PRIVDATAS * Datas)
{
	Clear();
	if(Datas->passwd)
	{
		m_passwd = Datas->passwd;
	}
	if(Datas->privkey)
	{
		if(m_privkey)
			ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
		m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), Datas->privkey);
		if(!m_privkey)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool RaStorePrivdatas::give_Datas(RA_STORE_PRIVDATAS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (RA_STORE_PRIVDATAS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->passwd && !((*Datas)->passwd = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_passwd.c_ASN1_UTF8STRING(&(*Datas)->passwd))
	{
		ASN1_UTF8STRING_free((*Datas)->passwd);
		(*Datas)->passwd = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_privkey)
	{
		if((*Datas)->privkey)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->privkey, ASN1_ITEM_rptr(RSAPrivateKey));
		if(!((*Datas)->privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (ASN1_VALUE*)m_privkey)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->privkey)
		{
			(*Datas)->privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
			if(!(*Datas)->privkey)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool RaStorePrivdatas::operator=(const RaStorePrivdatas & other)
{
	Clear();
	m_passwd = other.m_passwd;
	if(other.m_privkey)
	{
		if(m_privkey)
			ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
		m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (void*)other.m_privkey);
		if(!m_privkey)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RaStorePrivdatas::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(RA_STORE_PRIVDATAS);
}
