/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Entity_REPOSITORY_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(LOCAL_REPOSITORY_CONF) = {
	ASN1_SIMPLE(LOCAL_REPOSITORY_CONF, conf, ENTITY_CONF),
	ASN1_SIMPLE(LOCAL_REPOSITORY_CONF, cas, INTERNAL_PKI_CA),
}ASN1_SEQUENCE_END(LOCAL_REPOSITORY_CONF)
ASN1_SEQUENCE(LOCAL_REPOSITORY_CONF_BETA4) = {
	ASN1_SIMPLE(LOCAL_REPOSITORY_CONF_BETA4, conf, ENTITY_CONF_BETA4),
	ASN1_SIMPLE(LOCAL_REPOSITORY_CONF_BETA4, cas, INTERNAL_PKI_CA),
}ASN1_SEQUENCE_END(LOCAL_REPOSITORY_CONF_BETA4)
LocalRepositoryConf LocalRepositoryConf::EmptyInstance;
bool LocalRepositoryConf::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalRepositoryConf::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalRepositoryConf::get_cas()
{
	return m_cas;
}

bool LocalRepositoryConf::set_conf(const EntityConf & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConf & LocalRepositoryConf::get_conf() const
{
	return m_conf;
}

EntityConf & LocalRepositoryConf::get_conf()
{
	return m_conf;
}

bool LocalRepositoryConf::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_REPOSITORY_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalRepositoryConf::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_REPOSITORY_CONF * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalRepositoryConf::LocalRepositoryConf():NewPKIObject(), LocalEntityConf()
{
	resetAll();
}

LocalRepositoryConf::LocalRepositoryConf(const LocalRepositoryConf & other):NewPKIObject(), LocalEntityConf()
{
	resetAll();
	*this = other;
}

LocalRepositoryConf::~LocalRepositoryConf()
{
	Clear();
}

void LocalRepositoryConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalRepositoryConf::freeAll()
{
}

void LocalRepositoryConf::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
}

bool LocalRepositoryConf::load_Datas(const LOCAL_REPOSITORY_CONF * Datas)
{
	Clear();
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalRepositoryConf::give_Datas(LOCAL_REPOSITORY_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_REPOSITORY_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LocalRepositoryConf::operator=(const LocalRepositoryConf & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalRepositoryConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_REPOSITORY_CONF);
}
LocalRepositoryConfBeta4 LocalRepositoryConfBeta4::EmptyInstance;
bool LocalRepositoryConfBeta4::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalRepositoryConfBeta4::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalRepositoryConfBeta4::get_cas()
{
	return m_cas;
}

bool LocalRepositoryConfBeta4::set_conf(const EntityConfBeta4 & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConfBeta4 & LocalRepositoryConfBeta4::get_conf() const
{
	return m_conf;
}

EntityConfBeta4 & LocalRepositoryConfBeta4::get_conf()
{
	return m_conf;
}

bool LocalRepositoryConfBeta4::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_REPOSITORY_CONF_BETA4 * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalRepositoryConfBeta4::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_REPOSITORY_CONF_BETA4 * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalRepositoryConfBeta4::LocalRepositoryConfBeta4():NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
}

LocalRepositoryConfBeta4::LocalRepositoryConfBeta4(const LocalRepositoryConfBeta4 & other):NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
	*this = other;
}

LocalRepositoryConfBeta4::~LocalRepositoryConfBeta4()
{
	Clear();
}

void LocalRepositoryConfBeta4::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalRepositoryConfBeta4::freeAll()
{
}

void LocalRepositoryConfBeta4::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
}

bool LocalRepositoryConfBeta4::load_Datas(const LOCAL_REPOSITORY_CONF_BETA4 * Datas)
{
	Clear();
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalRepositoryConfBeta4::give_Datas(LOCAL_REPOSITORY_CONF_BETA4 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_REPOSITORY_CONF_BETA4*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF_BETA4*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BETA4))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF_BETA4));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LocalRepositoryConfBeta4::operator=(const LocalRepositoryConfBeta4 & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalRepositoryConfBeta4::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_REPOSITORY_CONF_BETA4);
}
