/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// AuthModule.h: interface for the AuthModule class.
//
//////////////////////////////////////////////////////////////////////

#ifndef AUTHMODULE_H
#define AUTHMODULE_H

#include <PKI_AUTH_MOD.h>
#include <openssl/dso.h>
#include <ExceptionNewPKI.h>
#include "mString.h"

/*!
	This class represents an authentication module
*/
class AuthModule
{
public:
	/*! \brief This is the constructor.
	 *  \param LibraryPath [IN] The path to the authitication library.
	 *  \param LibraryCmd [IN] The commands for the authitication library.
	 *  \exception ExceptionNewPKI An error occured.
	 */
	AuthModule(const mString & LibraryPath, const mString & LibraryCmd);

	/*! \brief This is the destructor.
	 */
	virtual ~AuthModule();

	/*! \brief This function is called to authenticate an user.
	 *  \param username [IN] The username.
	 *  \param password [IN] The password.
	 *  \return true on success, false on failure.
	 */
	bool Login(const char * username, const char * password);

	/*! \brief This function is called when an user is created.
	 *  \param Username [IN] The username.
	 *  \return true on success, false on failure.
	 */
	bool ValidateUsername(const char * Username);

private:
	DSO * hLib;
	MOD_AUTH_FUNCS * FunctionsList;
	GET_FUNCTIONS_LIST GetFunctionsList;
	mString m_LibraryCmd;
};

#endif // AUTHMODULE_H
