/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/





// PKI_PASSWD.cpp: implementation of the PKI_PASSWD class.
//
//////////////////////////////////////////////////////////////////////

#include "PKI_PASSWD.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PKI_PASSWD::PKI_PASSWD()
{
}

PKI_PASSWD::~PKI_PASSWD()
{
}

char * PKI_PASSWD::CalcSHA1Password(const mString & Password)
{
	unsigned char Result[SALT_LEN + SHA_DIGEST_LENGTH];
	unsigned char * tmpPwd;
	int i;

	int pwd_len = Password.size();
	int tmpPwd_len = pwd_len + SALT_LEN;

	tmpPwd = (unsigned char*)malloc(tmpPwd_len);
	if(!tmpPwd) 
		return NULL;

	//We get a salt
	RAND_bytes(Result, SALT_LEN);

	//We copy salt into intermediate password
	memcpy(tmpPwd, Result, SALT_LEN);
	//We copy the password after the salt
	memcpy(&tmpPwd[SALT_LEN], Password.c_str(), pwd_len);
	
	//We get the SHA1 of (SALT+PASSWORD)
	SHA1(tmpPwd, tmpPwd_len, &Result[SALT_LEN]);

	free(tmpPwd);

	for(i=0; i < (SALT_LEN + SHA_DIGEST_LENGTH); i++)
	{
		sprintf(&(hex_password[i*2]), "%.2x", Result[i]);
	}

	return hex_password;
}

bool PKI_PASSWD::VerifySHA1Password(const mString & Password, const mString & Sha1Password)
{
	unsigned char Result[SALT_LEN + SHA_DIGEST_LENGTH];
	unsigned char * tmpPwd;
	unsigned char sha1[SHA_DIGEST_LENGTH];
	int i;
	char datas[3];
	unsigned char c;
	char * dstBuffer;

	int pwd_len = Password.size();
	int tmpPwd_len = pwd_len + SALT_LEN;

	//We get the length validity of the crypted paswword
	if(Sha1Password.size() != ( (SALT_LEN + SHA_DIGEST_LENGTH) *2 )) return false;

	//We convert the crypted password back to binary
	for(i=0; i < ( (SALT_LEN + SHA_DIGEST_LENGTH) *2 ); i=i+2)
	{
		strncpy(datas, &(Sha1Password.c_str()[i]), 2);
		datas[2]=0;
		c = (unsigned char)strtoul(datas, NULL, 16);
		dstBuffer = (char*)&Result[i/2];
		memcpy(dstBuffer, &c, sizeof(c));
	}




	tmpPwd = (unsigned char*)malloc(tmpPwd_len);
	if(!tmpPwd) 
		return false;

	//We copy salt into intermediate password
	memcpy(tmpPwd, Result, SALT_LEN);
	//We copy the password after the salt
	memcpy(&tmpPwd[SALT_LEN], Password.c_str(), pwd_len);
	
	//We get the SHA1 of (SALT+PASSWORD)
	SHA1(tmpPwd, tmpPwd_len, sha1);

	free(tmpPwd);

	if(memcmp(sha1, &Result[SALT_LEN], SHA_DIGEST_LENGTH) != 0)
		return false;
	else
		return true;
}
