/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "PKI_ERR.h"
#include "lbintl.h"

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR


static ERR_STRING_DATA NEWPKI_str_functs[]=
{
	{ERR_PACK(0,SQL_ERROR_TXT,0),		_lb("Error sent by SQL server: ")},
	{ERR_PACK(0,PKI_ERROR_TXT,0),		_lb("Error sent by PKI server: ")},
	{ERR_PACK(0,OCSP_ERROR_TXT,0),		_lb("Error sent by OCSP server: ")},
	{ERR_PACK(0,CRYPTO_ERROR_TXT,0),	_lb("Error sent by internal crypto: ")},
	{ERR_PACK(0,CLIENT_ERROR_TXT,0),	_lb("Error: ")},
	{ERR_PACK(0,PHP_ERROR_TXT,0),		_lb("Error sent by PHP module: ")},
	{0,NULL}
};


static ERR_STRING_DATA NEWPKI_str_reasons[]=
{
	{ ERROR_DB_INIT,					_lb("Init failed")},
	{ ERROR_DB_CONNECT,					_lb("Connect failed")},
	{ ERROR_DB_SELECT_DB,				_lb("Select DB failed")},
	{ ERROR_DB_SELECT,					_lb("Select failed")},
	{ ERROR_DB_NUMROWS,					_lb("Num rows failed")},
	{ ERROR_DB_FETCHROWS,				_lb("Fetch row failed")},
	{ ERROR_DB_NUMFIELDS,				_lb("Num fields failed")},
	{ ERROR_DB_FETCHFIELD,				_lb("Fetch field failed")},
	{ ERROR_DB_FIELDNAME,				_lb("Unknown colomun")},
	{ ERROR_ABORT,						_lb("Giving up on previous error(s)")}, 
	{ ERROR_UNKNOWN,					_lb("Unknown error")}, 
	{ ERROR_BAD_PARAM,					_lb("One or more parameters are invalid")}, 
	{ ERROR_MALLOC,						_lb("No memory available")}, 
	{ ERROR_GET_DN_SPECIF,				_lb("Could not get the field specificity")}, 
	{ ERROR_DN_FIELD_UNPRESENT,			_lb("This field must be set ")}, 
	{ ERROR_GENERATE_CSR,				_lb("An error occured during the CSR generation")}, 
	{ ERROR_CONVERT_X509REQ_CSR,		_lb("An error occured during the CSR convertion")}, 
	{ ERROR_CONVERT_CSR_X509REQ,		_lb("An error occured during the CSR reading")}, 
	{ ERROR_BAD_POLICY_FORMAT,			_lb("The policy's datas are erroneous")}, 
	{ ERROR_CONVERT_KEY_EVP_PKEY,		_lb("An error occured during the RSA-key reading")}, 
	{ ERROR_GENERATE_BIKEY,				_lb("An error occured during the RSA-key generation")}, 
	{ ERROR_BAD_CSR_SIGNATURE,			_lb("The CSR's signature in invalid")}, 
	{ ERROR_CERTIFY_CSR,				_lb("An error occured during the CSR certification")}, 
	{ ERROR_CERT_ALREADY_SIGNED_DN,		_lb("A certificate with the same DN has already been generated")}, 
	{ ERROR_UNKNOWN_NID,				_lb("The object in unknown")}, 
	{ ERROR_NO_CERT,					_lb("Could not find the certificate")}, 
	{ ERROR_BAD_CERT_STATE,				_lb("The actual CERT state does not allow revocation")}, 
	{ ERROR_BAD_EXT_SYNTAX,				_lb("The syntax of the extension field is invalid")}, 
	{ ERROR_GEN_CRL,					_lb("An error occured during the CRL generation")}, 
	{ ERROR_BAD_PKI_COMMAND,			_lb("Unknown command")}, 
	{ ERROR_BAD_UNKNOWN_USER,			_lb("Unknown user or bad password")}, 
	{ ERROR_CONNECT_FAILED,				_lb("Connection failed")}, 
	{ ERROR_BAD_SOCKET,					_lb("There is a problem with the socket layer")}, 
	{ ERROR_CONNECTION_LOST,			_lb("Connection is down")}, 
	{ ERROR_NO_CONNECTION,				_lb("Not connected")}, 
	{ ERROR_BAD_DATAS,					_lb("The datas type is invalid")}, 
	{ ERROR_NOT_ALLOWED,				_lb("You are not allowed to perform this action")}, 
	{ ERROR_LOAD_KEY,					_lb("Could not load the key")}, 
	{ ERROR_BAD_DATAS_FORMAT,			_lb("The datas of the following field are incorrect")}, 
	{ ERROR_NO_ENGINE,					_lb("You must specify an \"engine\" in the configuration")}, 
	{ ERROR_MISMATCH_KEYS,				_lb("The private key and the public key of the certificate do not match")}, 
	{ ERROR_GEN_P12,					_lb("An error occured during the PKCS12 generation")}, 
	{ ERROR_INIT_SSL,					_lb("An error occured during the NewPKI_SSL initialization")}, 
	{ ERROR_UNKNOWN_ENTITY,				_lb("Unknown Entity")}, 
	{ ERROR_NO_PKI_SSL,					_lb("Could not find the SSL certificate")}, 
	{ ERROR_INVALID_P12_PWD,			_lb("Bad PKCS12 password")}, 
	{ ERROR_RESOURCE_BUSY,				_lb("This resource is being used by another user")}, 
	{ ERROR_NO_MIGRATION_FUNC,			_lb("Could not find the corresponding migration function for the database, please contact developer")},
	{ ERROR_BAD_AUTH_LIB,				_lb("The authentification module is invalid")}, 
	{ ERROR_ENTITY_EXISTS,				_lb("Entity already exists")},
	{ ERROR_BAD_RESPONSE_SIGNATURE,		_lb("The server response signature is invalid !\nPlease contact the PKI administrator")},
	{ ERROR_CONVERT_X509CRL_CRL,		_lb("An error occured during the CRL convertion")}, 
	{ ERROR_CONVERT_CRL_X509CRL,		_lb("An error occured during the CRL reading")}, 
	{ ERROR_NO_REPOSITORY,				_lb("Your PKI must have a repository before creating any other entity type")}, 
	{ ERROR_ENTITY_NOT_READY,			_lb("Entity is not ready to accept commands")}, 
	{ ERROR_UNEXPECTED_CERT,			_lb("Unexpected certificate")}, 
	{ ERROR_MAIL_SERVER_NOT_SET,		_lb("You must configure the mail server before")}, 
	{ ERROR_BAD_ENTRY_SIGNATURE,		_lb("The entry has an invalid signature")}, 
	{ ERROR_BAD_RA_CA_LINK_REP,			_lb("RAs and CAs must be connected to at leas one repository")}, 
	{ ERROR_BAD_PLUG_LIB,				_lb("The plugin module is invalid")}, 
	{ ERROR_GROUP_ALREADY_EXISTS,		_lb("The group already exists")}, 
	{ ERROR_GROUP_UNKNOWN,				_lb("The group doesn't exist")}, 
	{ ERROR_LAST_ENTITY_REPOSITORY,		_lb("This repository is the only one known of the following entity")}, 
	{ ERROR_NOT_UNIQUE_PROFILE,			_lb("The DN of this profile already exists")}, 
	{ ERROR_DN_FIELD_BAD_MATCH,			_lb("The DN field can only have these values")}, 
	{ ERROR_BAD_PASSWORD_LEN,			_lb("The password length doesn't respect the minimum")},
	{ ERROR_BAD_KEY_LEN,				_lb("The key length doesn't respect the minimum")},
	{ ERROR_CA_NOT_CONFIGURED,			_lb("The CA hasn't been created yet, it's not usable")},
	{ ERROR_LDAP,						_lb("LDAP Error")},
	{ ERROR_LDAP_NOT_CONFIGURED,		_lb("LDAP not configured")},
	{ ERROR_GROUP_USED_RA_LDAP_SYNCH,	_lb("This group is used by the following RA\nfor its LDAP synchronization")},
	{0,NULL}
};

#endif

void ERR_load_NEWPKI_strings(void)
{
	static int init=1;

	if (init)
	{
		init=0;
#ifndef OPENSSL_NO_ERR
		ERR_load_strings(ERR_LIB_NEWPKI,NEWPKI_str_functs);
		ERR_load_strings(ERR_LIB_NEWPKI,NEWPKI_str_reasons);
#endif

	}
}


#ifdef _WIN32
	#define ERROR_SEP "\r\n"
#else
	#define ERROR_SEP "\n"
#endif

#define ERROR_LINE_SEP "<------------------------------------------------>"ERROR_SEP

#define FILLUP_PATTERN "%s #%d"ERROR_SEP"%s"ERROR_SEP"[%s:%d]"ERROR_SEP
#define FILLUP_PATTERN_DATAS "%s #%d"ERROR_SEP"%s:%s"ERROR_SEP"[%s:%d]"ERROR_SEP


void ERR_to_mstring(mString & error, bool OnlyString)
{
	unsigned long lastError;
	const char *file,*data="";
	int line,flags;
	char * ret_ErrString;
	char * ret_ErrLib;
	char * FileName;
	ERR_STATE * es;
	int i;
	mString tmpStr;
	
	es = ERR_get_state();
	if(!es)
	{
		error = _lb("Unknown error(s)");
		return;
	}

	if(!OnlyString)
	{
		error = ERROR_LINE_SEP;
	}

	data = NULL;
	//We do this not to erase the error from the queue
	for(i=es->bottom+1; i <= es->top; i++)
	{
		lastError = es->err_buffer[i];

		line = es->err_line[i];
		file = es->err_file[i];
		flags=es->err_data_flags[i];
		data=es->err_data[i];

		ret_ErrString = (char *)ERR_reason_error_string(lastError);
		if(!ret_ErrString)
		{
			if(data && *data && (flags & ERR_TXT_STRING) )
			{
				ret_ErrString = (char*)data;
				data = NULL;
			}
			else
				continue;
		}
		
		ret_ErrLib = (char*)ERR_lib_error_string(lastError);		
		if(!ret_ErrLib)
			ret_ErrLib = (char*)ERR_func_error_string(lastError);
		if(!ret_ErrLib)
			ret_ErrLib = "NewPKI";


		FileName = strrchr(file, PATH_SEPARATOR);
		if(!FileName)
			FileName = (char*)file;
		else
			FileName++;
	
		if(!OnlyString)
		{
			if(data && *data)
			{
				if(tmpStr.sprintf(FILLUP_PATTERN_DATAS, ret_ErrLib, 
									ERR_GET_REASON(lastError), 
									ret_ErrString, 
									data, 
									FileName, 
									line) <= 0)
				{
					continue;
				}
			}
			else
			{
				if(tmpStr.sprintf(FILLUP_PATTERN, ret_ErrLib, 
									ERR_GET_REASON(lastError), 
									ret_ErrString, 
									FileName, 
									line) <= 0)
				{
					continue;
				}
			}

			error += tmpStr;
			error += ERROR_LINE_SEP;
		}
		else
		{
			if(data && *data)
			{
				error += ret_ErrString;
				error += ":";
				error += data;
				error += ERROR_SEP;
			}
			else
			{
				error += ret_ErrString;
				error += ERROR_SEP;
			}
		}
	}
}
