/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Objects.h"
#include <openssl/err.h>

void NewPKI_InitErr()
{
}

void NewPKI_LockErr()
{
}

void NewPKI_UnlockErr()
{
}


int IsValidObject(const mString & ObjectName)
{
	const char * tmpName;
	
	// If object is already known
	if (OBJ_txt2nid(ObjectName.c_str()) != NID_undef) return 1;
	ERR_clear_error();

	// If we don't know it let's see if it
	// an object with syntax 0.objectName
	tmpName = FormatObject(ObjectName.c_str());
	if(tmpName)
	{
		ERR_clear_error();
		if (OBJ_txt2nid(tmpName) != NID_undef) return 1;
	}

	// Let's see if it's an OID
	if(a2d_ASN1_OBJECT(NULL, 0, ObjectName.c_str(), -1) > 0)
	{
		//Add the OID as being a normal object
		if(!OBJ_create(ObjectName.c_str(), ObjectName.c_str(), ObjectName.c_str())) return 1;
		ERR_clear_error();
		return 1;
	}
	ERR_clear_error();
	return 0;
}


const char * FormatObject(const char * Object)
{
	const char * p;
	ERR_STATE * es;
	int top;
	es = ERR_get_state();
	top = es->top;
	// Si c'est un OID on le renvoi tel que
	if(a2d_ASN1_OBJECT(NULL, 0, Object, -1) > 0)
	{
		return Object;
	}
	es->top = top;

	for(p = Object ; *p ; p++)
	{
		if ((*p == ':') || (*p == ',') || (*p == '.')) 
		{
			p++;
			return p;
		}
	}
	return Object;
}

time_t ASN1_TIME_to_timet(char *s)
{
	if(!*s) return 0;

	struct tm tm;
	int offset;

	memset(&tm,'\0',sizeof tm);

	#define g2(p) (((p)[0]-'0')*10+(p)[1]-'0')

	tm.tm_year=g2(s);
	if(tm.tm_year < 50)
	{
		tm.tm_year+=100;
	}

	tm.tm_mon=g2(s+2)-1;
	tm.tm_mday=g2(s+4);
	tm.tm_hour=g2(s+6);
	tm.tm_min=g2(s+8);
	tm.tm_sec=g2(s+10);

	if(s[12] == 'Z')
	{
		offset=0;
	}
	else
	{
		offset=g2(s+13)*60+g2(s+15);
		if(s[12] == '-') offset= -offset;
	}
	#undef g2


	tm.tm_isdst = -1;

	return mktime(&tm);
/*
	time_t local_t;
	time_t ret_t;
	struct tm tm_local;
	struct tm tm_gmt;
	struct tm * tm_curr;


	time(&local_t);

	tm_curr = localtime(&local_t);
	tm_local = *tm_curr;

	tm_curr = gmtime(&local_t);
	tm_gmt = *tm_curr;

	tm.tm_isdst = tm_local.tm_isdst;

	ret_t = mktime(&tm_local) - mktime(&tm_gmt) + tm_local.tm_isdst*3600;

	ret_t = mktime(&tm) - offset*60 + ret_t;

	return ret_t;
*/
}

void time_gmt(time_t * tim)
{
	time_t res;
	struct tm * gmt;
	
	time(&res);
	gmt = gmtime(&res);

	if(!gmt)
	{
		time(tim);
		return;
	}

	gmt->tm_isdst = -1;
	*tim = mktime(gmt);
}

ASN1_TIME *ASN1_TIME_set_localtime(ASN1_TIME *s, time_t t)
{
	char *p;
	struct tm *ts;

	if (s == NULL)
	{
		s=ASN1_TIME_new();
		if (s == NULL)
			return(NULL);
		
		s->type = V_ASN1_UTCTIME;
	}

	ts=localtime(&t);
	if (ts == NULL)
		return(NULL);

	p=(char *)s->data;
	if ((p == NULL) || (s->length < 14))
	{
		p=(char*)malloc(20);
		if (p == NULL) return(NULL);
		if (s->data != NULL)
			free(s->data);
		s->data=(unsigned char *)p;
	}

	sprintf(p,"%02d%02d%02d%02d%02d%02dZ",ts->tm_year%100, ts->tm_mon+1,ts->tm_mday,ts->tm_hour,ts->tm_min,ts->tm_sec);
	s->length=strlen(p);
#ifdef CHARSET_EBCDIC_not
	ebcdic2ascii(s->data, s->data, s->length);
#endif
	return(s);
}

