/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Asn1Logs.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(LOG_ENTRY_BODY) = {
	ASN1_SIMPLE(LOG_ENTRY_BODY, log_status, ASN1_INTEGER),
	ASN1_SIMPLE(LOG_ENTRY_BODY, log_type, ASN1_INTEGER),
	ASN1_SIMPLE(LOG_ENTRY_BODY, user, ASN1_UTF8STRING),
	ASN1_SIMPLE(LOG_ENTRY_BODY, object_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(LOG_ENTRY_BODY, error, ASN1_UTF8STRING),
	ASN1_SIMPLE(LOG_ENTRY_BODY, log_date, ASN1_INTEGER),
}ASN1_SEQUENCE_END(LOG_ENTRY_BODY)
ASN1_SEQUENCE(LOG_ENTRY_SIG) = {
	ASN1_SIMPLE(LOG_ENTRY_SIG, signature, ASN1_BIT_STRING),
	ASN1_SIMPLE(LOG_ENTRY_SIG, sig_alg, X509_ALGOR),
}ASN1_SEQUENCE_END(LOG_ENTRY_SIG)
ASN1_SEQUENCE(LOG_ENTRY) = {
	ASN1_SIMPLE(LOG_ENTRY, log_id, ASN1_INTEGER),
	ASN1_SIMPLE(LOG_ENTRY, body, LOG_ENTRY_BODY),
	ASN1_SIMPLE(LOG_ENTRY, sig, LOG_ENTRY_SIG),
}ASN1_SEQUENCE_END(LOG_ENTRY)
ASN1_SEQUENCE(ADMIN_REQ_ENUM_LOGS) = {
	ASN1_SIMPLE(ADMIN_REQ_ENUM_LOGS, index, ASN1_INTEGER),
	ASN1_SIMPLE(ADMIN_REQ_ENUM_LOGS, max, ASN1_INTEGER),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, object, ASN1_UTF8STRING, 0),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, type, ASN1_INTEGER, 1),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, date_from, ASN1_INTEGER, 2),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, date_to, ASN1_INTEGER, 3),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, status, ASN1_INTEGER, 4),
	ASN1_EXP_OPT(ADMIN_REQ_ENUM_LOGS, user, ASN1_UTF8STRING, 5),
}ASN1_SEQUENCE_END(ADMIN_REQ_ENUM_LOGS)
LogEntryBody LogEntryBody::EmptyInstance;
bool LogEntryBody::set_error(const mString & c_error)
{
	m_error = c_error;
	return true;
}

const mString & LogEntryBody::get_error() const
{
	return m_error;
}

mString & LogEntryBody::get_error()
{
	return m_error;
}

bool LogEntryBody::set_logDate(unsigned long c_logDate)
{
	m_logDate = c_logDate;
	return true;
}

unsigned long LogEntryBody::get_logDate() const
{
	return m_logDate;
}

bool LogEntryBody::set_logStatus(unsigned long c_logStatus)
{
	m_logStatus = c_logStatus;
	return true;
}

unsigned long LogEntryBody::get_logStatus() const
{
	return m_logStatus;
}

bool LogEntryBody::set_logType(unsigned long c_logType)
{
	m_logType = c_logType;
	return true;
}

unsigned long LogEntryBody::get_logType() const
{
	return m_logType;
}

bool LogEntryBody::set_objectName(const mString & c_objectName)
{
	m_objectName = c_objectName;
	return true;
}

const mString & LogEntryBody::get_objectName() const
{
	return m_objectName;
}

mString & LogEntryBody::get_objectName()
{
	return m_objectName;
}

bool LogEntryBody::set_user(const mString & c_user)
{
	m_user = c_user;
	return true;
}

const mString & LogEntryBody::get_user() const
{
	return m_user;
}

mString & LogEntryBody::get_user()
{
	return m_user;
}

LogEntryBody::LogEntryBody():NewPKIObject()
{
	resetAll();
}

LogEntryBody::LogEntryBody(const LogEntryBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

LogEntryBody::~LogEntryBody()
{
	Clear();
}

void LogEntryBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LogEntryBody::freeAll()
{
}

void LogEntryBody::resetAll()
{
	m_error = "";
	m_logDate = 0;
	m_logStatus = 0;
	m_logType = 0;
	m_objectName = "";
	m_user = "";
}

bool LogEntryBody::load_Datas(const LOG_ENTRY_BODY * Datas)
{
	Clear();
	if(Datas->error)
	{
		m_error = Datas->error;
	}
	if(Datas->log_date)
	{
		m_logDate = ASN1_INTEGER_GET(Datas->log_date);
	}
	if(Datas->log_status)
	{
		m_logStatus = ASN1_INTEGER_GET(Datas->log_status);
	}
	if(Datas->log_type)
	{
		m_logType = ASN1_INTEGER_GET(Datas->log_type);
	}
	if(Datas->object_name)
	{
		m_objectName = Datas->object_name;
	}
	if(Datas->user)
	{
		m_user = Datas->user;
	}
	m_isOk=true;
	return true;
}

bool LogEntryBody::give_Datas(LOG_ENTRY_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOG_ENTRY_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->error && !((*Datas)->error = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_error.c_ASN1_UTF8STRING(&(*Datas)->error))
	{
		ASN1_UTF8STRING_free((*Datas)->error);
		(*Datas)->error = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->log_date && !((*Datas)->log_date = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->log_date, m_logDate) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->log_date);
		(*Datas)->log_date = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->log_status && !((*Datas)->log_status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->log_status, m_logStatus) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->log_status);
		(*Datas)->log_status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->log_type && !((*Datas)->log_type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->log_type, m_logType) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->log_type);
		(*Datas)->log_type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->object_name && !((*Datas)->object_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_objectName.c_ASN1_UTF8STRING(&(*Datas)->object_name))
	{
		ASN1_UTF8STRING_free((*Datas)->object_name);
		(*Datas)->object_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->user && !((*Datas)->user = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_user.c_ASN1_UTF8STRING(&(*Datas)->user))
	{
		ASN1_UTF8STRING_free((*Datas)->user);
		(*Datas)->user = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LogEntryBody::operator=(const LogEntryBody & other)
{
	Clear();
	m_error = other.m_error;
	m_logDate = other.m_logDate;
	m_logStatus = other.m_logStatus;
	m_logType = other.m_logType;
	m_objectName = other.m_objectName;
	m_user = other.m_user;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LogEntryBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOG_ENTRY_BODY);
}
LogEntrySig LogEntrySig::EmptyInstance;
bool LogEntrySig::set_sigAlg(const X509_ALGOR * c_sigAlg)
{
	if(m_sigAlg)
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)c_sigAlg);
	if(!m_sigAlg)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_ALGOR * LogEntrySig::get_sigAlg() const
{
	if(!m_sigAlg)
		((LogEntrySig*)this)->m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

X509_ALGOR * LogEntrySig::get_sigAlg()
{
	if(!m_sigAlg)
		m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

bool LogEntrySig::set_signature(const ASN1_BIT_STRING * c_signature)
{
	if(m_signature)
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_signature);
	if(!m_signature)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * LogEntrySig::get_signature() const
{
	if(!m_signature)
		((LogEntrySig*)this)->m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

ASN1_BIT_STRING * LogEntrySig::get_signature()
{
	if(!m_signature)
		m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

bool LogEntrySig::to_PEM(mString & PemDatas) const
{
	LOG_ENTRY_SIG * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI LOG SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LogEntrySig::from_PEM(const mString & PemDatas)
{
	LOG_ENTRY_SIG * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI LOG SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LogEntrySig::LogEntrySig():NewPKIObject()
{
	resetAll();
}

LogEntrySig::LogEntrySig(const LogEntrySig & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

LogEntrySig::~LogEntrySig()
{
	Clear();
}

void LogEntrySig::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LogEntrySig::freeAll()
{
	if(m_sigAlg)
	{
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	}
	if(m_signature)
	{
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void LogEntrySig::resetAll()
{
	m_sigAlg = NULL;
	m_signature = NULL;
}

bool LogEntrySig::load_Datas(const LOG_ENTRY_SIG * Datas)
{
	Clear();
	if(Datas->sig_alg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), Datas->sig_alg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LogEntrySig::give_Datas(LOG_ENTRY_SIG ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOG_ENTRY_SIG*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_sigAlg)
	{
		if((*Datas)->sig_alg)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sig_alg, ASN1_ITEM_rptr(X509_ALGOR));
		if(!((*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (ASN1_VALUE*)m_sigAlg)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sig_alg)
		{
			(*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
			if(!(*Datas)->sig_alg)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_signature)
	{
		if((*Datas)->signature)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_signature)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->signature)
		{
			(*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->signature)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool LogEntrySig::operator=(const LogEntrySig & other)
{
	Clear();
	if(other.m_sigAlg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)other.m_sigAlg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LogEntrySig::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOG_ENTRY_SIG);
}
LogEntry LogEntry::EmptyInstance;
bool LogEntry::set_body(const LogEntryBody & c_body)
{
	m_body = c_body;
	return true;
}

const LogEntryBody & LogEntry::get_body() const
{
	return m_body;
}

LogEntryBody & LogEntry::get_body()
{
	return m_body;
}

bool LogEntry::set_logId(unsigned long c_logId)
{
	m_logId = c_logId;
	return true;
}

unsigned long LogEntry::get_logId() const
{
	return m_logId;
}

bool LogEntry::set_sig(const LogEntrySig & c_sig)
{
	m_sig = c_sig;
	return true;
}

const LogEntrySig & LogEntry::get_sig() const
{
	return m_sig;
}

LogEntrySig & LogEntry::get_sig()
{
	return m_sig;
}

LogEntry::LogEntry():NewPKIObject()
{
	resetAll();
}

LogEntry::LogEntry(const LogEntry & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

LogEntry::~LogEntry()
{
	Clear();
}

void LogEntry::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LogEntry::freeAll()
{
}

void LogEntry::resetAll()
{
	m_body.Clear();
	m_logId = 0;
	m_sig.Clear();
}

bool LogEntry::load_Datas(const LOG_ENTRY * Datas)
{
	Clear();
	if(Datas->body)
	{
		if(!m_body.load_Datas(Datas->body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->log_id)
	{
		m_logId = ASN1_INTEGER_GET(Datas->log_id);
	}
	if(Datas->sig)
	{
		if(!m_sig.load_Datas(Datas->sig))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LogEntry::give_Datas(LOG_ENTRY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOG_ENTRY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->body && !((*Datas)->body = (LOG_ENTRY_BODY*)ASN1_item_new(ASN1_ITEM_rptr(LOG_ENTRY_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.give_Datas(&(*Datas)->body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->body, ASN1_ITEM_rptr(LOG_ENTRY_BODY));
		(*Datas)->body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->log_id && !((*Datas)->log_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->log_id, m_logId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->log_id);
		(*Datas)->log_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->sig && !((*Datas)->sig = (LOG_ENTRY_SIG*)ASN1_item_new(ASN1_ITEM_rptr(LOG_ENTRY_SIG))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_sig.give_Datas(&(*Datas)->sig))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->sig, ASN1_ITEM_rptr(LOG_ENTRY_SIG));
		(*Datas)->sig = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool LogEntry::operator=(const LogEntry & other)
{
	Clear();
	m_body = other.m_body;
	m_logId = other.m_logId;
	m_sig = other.m_sig;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LogEntry::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOG_ENTRY);
}
AdminReqEnumLogs AdminReqEnumLogs::EmptyInstance;
bool AdminReqEnumLogs::set_dateFrom(unsigned long c_dateFrom)
{
	m_dateFrom = c_dateFrom;
	return true;
}

unsigned long AdminReqEnumLogs::get_dateFrom() const
{
	return m_dateFrom;
}

bool AdminReqEnumLogs::set_dateTo(unsigned long c_dateTo)
{
	m_dateTo = c_dateTo;
	return true;
}

unsigned long AdminReqEnumLogs::get_dateTo() const
{
	return m_dateTo;
}

bool AdminReqEnumLogs::set_index(unsigned long c_index)
{
	m_index = c_index;
	return true;
}

unsigned long AdminReqEnumLogs::get_index() const
{
	return m_index;
}

bool AdminReqEnumLogs::set_max(unsigned long c_max)
{
	m_max = c_max;
	return true;
}

unsigned long AdminReqEnumLogs::get_max() const
{
	return m_max;
}

bool AdminReqEnumLogs::set_object(const mString & c_object)
{
	m_object = c_object;
	return true;
}

const mString & AdminReqEnumLogs::get_object() const
{
	return m_object;
}

mString & AdminReqEnumLogs::get_object()
{
	return m_object;
}

bool AdminReqEnumLogs::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long AdminReqEnumLogs::get_status() const
{
	return m_status;
}

bool AdminReqEnumLogs::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long AdminReqEnumLogs::get_type() const
{
	return m_type;
}

bool AdminReqEnumLogs::set_user(const mString & c_user)
{
	m_user = c_user;
	return true;
}

const mString & AdminReqEnumLogs::get_user() const
{
	return m_user;
}

mString & AdminReqEnumLogs::get_user()
{
	return m_user;
}

AdminReqEnumLogs::AdminReqEnumLogs():NewPKIObject()
{
	resetAll();
}

AdminReqEnumLogs::AdminReqEnumLogs(const AdminReqEnumLogs & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

AdminReqEnumLogs::~AdminReqEnumLogs()
{
	Clear();
}

void AdminReqEnumLogs::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void AdminReqEnumLogs::freeAll()
{
}

void AdminReqEnumLogs::resetAll()
{
	m_dateFrom = 0;
	m_dateTo = 0;
	m_index = 0;
	m_max = 0;
	m_object = "";
	m_status = 0;
	m_type = 0;
	m_user = "";
}

bool AdminReqEnumLogs::load_Datas(const ADMIN_REQ_ENUM_LOGS * Datas)
{
	Clear();
	if(Datas->date_from)
	{
		m_dateFrom = ASN1_INTEGER_GET(Datas->date_from);
	}
	if(Datas->date_to)
	{
		m_dateTo = ASN1_INTEGER_GET(Datas->date_to);
	}
	if(Datas->index)
	{
		m_index = ASN1_INTEGER_GET(Datas->index);
	}
	if(Datas->max)
	{
		m_max = ASN1_INTEGER_GET(Datas->max);
	}
	if(Datas->object)
	{
		m_object = Datas->object;
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	if(Datas->user)
	{
		m_user = Datas->user;
	}
	m_isOk=true;
	return true;
}

bool AdminReqEnumLogs::give_Datas(ADMIN_REQ_ENUM_LOGS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ADMIN_REQ_ENUM_LOGS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->date_from && !((*Datas)->date_from = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->date_from, m_dateFrom) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->date_from);
		(*Datas)->date_from = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->date_to && !((*Datas)->date_to = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->date_to, m_dateTo) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->date_to);
		(*Datas)->date_to = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->index && !((*Datas)->index = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->index, m_index) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->index);
		(*Datas)->index = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->max && !((*Datas)->max = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->max, m_max) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->max);
		(*Datas)->max = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->object && !((*Datas)->object = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_object.c_ASN1_UTF8STRING(&(*Datas)->object))
	{
		ASN1_UTF8STRING_free((*Datas)->object);
		(*Datas)->object = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->user && !((*Datas)->user = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_user.c_ASN1_UTF8STRING(&(*Datas)->user))
	{
		ASN1_UTF8STRING_free((*Datas)->user);
		(*Datas)->user = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool AdminReqEnumLogs::operator=(const AdminReqEnumLogs & other)
{
	Clear();
	m_dateFrom = other.m_dateFrom;
	m_dateTo = other.m_dateTo;
	m_index = other.m_index;
	m_max = other.m_max;
	m_object = other.m_object;
	m_status = other.m_status;
	m_type = other.m_type;
	m_user = other.m_user;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * AdminReqEnumLogs::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ADMIN_REQ_ENUM_LOGS);
}
#include "../lbintl.h"

typedef struct md_LOG_MESSAGE_STATUS_ENTRY
{
	LOG_MESSAGE_STATUS uID;
	char * Text;
}LOG_MESSAGE_STATUS_ENTRY;

typedef struct md_LOG_MESSAGE_ENTRY
{
	LOG_MESSAGE_TYPE uID;
	char * Text;
}LOG_MESSAGE_ENTRY;


LOG_MESSAGE_STATUS_ENTRY LogMessagesStatus[]={
	{ LOG_STATUS_TYPE_REQUEST,		_lb("Request") }, 
	{ LOG_STATUS_TYPE_SUCCESS,		_lb("Success") }, 
	{ LOG_STATUS_TYPE_FAILURE,		_lb("Failure") }, 
	{ LOG_STATUS_TYPE_FAILURE,		NULL }
};


LOG_MESSAGE_ENTRY LogMessages[]={
	{ LOG_MESSAGE_TYPE_USER_LOGIN,				_lb("User login") }, 
	{ LOG_MESSAGE_TYPE_USER_ADD,				_lb("User creation") }, 
	{ LOG_MESSAGE_TYPE_USER_MOD,				_lb("User modification") }, 
	{ LOG_MESSAGE_TYPE_PWD_MOD,					_lb("Password modification") }, 
	{ LOG_MESSAGE_TYPE_ENTITY_ADD,				_lb("Entity creation") }, 
	{ LOG_MESSAGE_TYPE_ENTITY_DEL,				_lb("Entity deletion") }, 
	{ LOG_MESSAGE_TYPE_SIGN_ENTITY,				_lb("Signature of a entity certificate request") }, 
	{ LOG_MESSAGE_TYPE_USER_REVOCATION,			_lb("Revocation of an user") }, 
	{ LOG_MESSAGE_TYPE_ENTITY_REVOCATION,		_lb("Revocation of an entity") }, 
	{ LOG_MESSAGE_TYPE_CONFIG_PUSH,				_lb("PKI Configuration push to repository") }, 
	{ LOG_MESSAGE_TYPE_SET_OFFLINE,				_lb("Toggle the PKI offline") }, 
	{ LOG_MESSAGE_TYPE_GET_CONFIGURATION,		_lb("Get PKI configuration") }, 
	{ LOG_MESSAGE_TYPE_CONFIG_IMPORT,			_lb("Importing PKI configuration") },
	{ LOG_MESSAGE_TYPE_ENTITY_CONFIG_GET,		_lb("Retrieval of its configuration by an entity") },
	{ LOG_MESSAGE_TYPE_ENTITY_INIT,				_lb("Entity initialization") },
	{ LOG_MESSAGE_TYPE_SET_REPOSITORIES,		_lb("Repositories info modification") },
	{ LOG_MESSAGE_TYPE_ENTITY_LOAD,				_lb("Entity loading") },
	{ LOG_MESSAGE_TYPE_LOCK_RESOURCE,			_lb("Resource locking") },
	{ LOG_MESSAGE_TYPE_UNLOCK_RESOURCE,			_lb("Resource unlocking") },
	{ LOG_MESSAGE_TYPE_SET_ENTITY_ACL,			_lb("Modification of an entity ACLs") },
	{ LOG_MESSAGE_TYPE_SET_ENTITY_MAIL_CONF,	_lb("Modification of an entity mail configuration") },
	{ LOG_MESSAGE_TYPE_SET_ENTITY_CONF,			_lb("Modification of an entity configuration") },
	{ LOG_MESSAGE_TYPE_SEND_ADMIN_MAIL,			_lb("Sending an admin notification mail") },
	{ LOG_MESSAGE_TYPE_SEND_MAIL,				_lb("Sending an user notification mail") },
	{ LOG_MESSAGE_TYPE_ADD_ADMIN_MAIL_QUEUE,	_lb("Adding an admin notification mail to queue") },
	{ LOG_MESSAGE_TYPE_ADD_MAIL_QUEUE,			_lb("Adding an user notification mail to queue") },
	{ LOG_MESSAGE_TYPE_SET_ENTITY_AUDITS,		_lb("Modification of an entity audits") },
	{ LOG_MESSAGE_TYPE_SET_ENTITIES_LINKS,		_lb("Modification of the entities links") },
	{ LOG_MESSAGE_TYPE_ENTITY_GET_MY_CONF,		_lb("Retrieval of my configuration from a repository") },
	{ LOG_MESSAGE_TYPE_OBJECTS_IMPORT,			_lb("Importing objects") },
	{ LOG_MESSAGE_TYPE_OBJECTS_PUSH,			_lb("Objects push to repository") },
	{ LOG_MESSAGE_TYPE_CREATE_ROOT_CA,			_lb("Creating ROOT CA") },
	{ LOG_MESSAGE_TYPE_GET_MY_REQS,				_lb("Entity retreiving its requests") },
	{ LOG_MESSAGE_TYPE_SIGN_CSR,				_lb("CSR signature") },
	{ LOG_MESSAGE_TYPE_GEN_CRL,					_lb("CRL generation") },
	{ LOG_MESSAGE_TYPE_CREATE_CHILD_CA,			_lb("Creating Child CA") },
	{ LOG_MESSAGE_TYPE_IMPORT_CHILD_CA_CERT,	_lb("Importing Child CA cert") },
	{ LOG_MESSAGE_TYPE_CERT_REVOCATION,			_lb("Revocation of a certificate") }, 
	{ LOG_MESSAGE_TYPE_SET_GROUPS,				_lb("Modification of the groups") }, 
	{ LOG_MESSAGE_TYPE_ADD_GROUP,				_lb("Adding a group") }, 
	{ LOG_MESSAGE_TYPE_DEL_GROUP,				_lb("Deleting a group") }, 
	{ LOG_MESSAGE_TYPE_REN_GROUP,				_lb("Renaming a group") }, 
	{ LOG_MESSAGE_TYPE_GET_LOCAL_CONF,			_lb("User requests local conf") }, 
	{ LOG_MESSAGE_TYPE_IMPORT_PROFILE,			_lb("Importing a new profile") }, 
	{ LOG_MESSAGE_TYPE_GET_MY_RESPS,			_lb("Entity retreiving its responses") },
	{ LOG_MESSAGE_TYPE_INSERT_REQ,				_lb("Entity publishing a request") }, 
	{ LOG_MESSAGE_TYPE_INSERT_RESP,				_lb("Entity publishing a response") }, 
	{ LOG_MESSAGE_TYPE_CERT_REQUEST,			_lb("New certificate request for a profile") }, 
	{ LOG_MESSAGE_TYPE_DELETE_PKCS12,			_lb("Delete PKCS#12") },
	{ LOG_MESSAGE_TYPE_NEW_REQUEST,				_lb("Received new request") },
	{ LOG_MESSAGE_TYPE_CA_CERT,					_lb("Certification request") },
	{ LOG_MESSAGE_TYPE_CA_REV,					_lb("Revocation request") },
	{ LOG_MESSAGE_TYPE_LOADING_PUB_METH,		_lb("Loading publication method") },
	{ LOG_MESSAGE_TYPE_CERT_PUBLICATION,		_lb("Certificate publication request") },
	{ LOG_MESSAGE_TYPE_REV_PUBLICATION,			_lb("Revocation publication request") },
	{ LOG_MESSAGE_TYPE_CRL_PUBLICATION,			_lb("CRL publication request") },
	{ LOG_MESSAGE_TYPE_LDAP_CONNECTION,			_lb("LDAP connection") },
	{ LOG_MESSAGE_TYPE_LDAP_AUTO_SYNCH_START,	_lb("LDAP auto synchronization start") },
	{ LOG_MESSAGE_TYPE_CERT_REV_RESP,			_lb("Revocation response") },
	{ LOG_MESSAGE_TYPE_CERT_SIG_RESP,			_lb("Signature response") },
	{ LOG_MESSAGE_TYPE_CERT_RNW_RESP,			_lb("Renewal response") },
	{ LOG_MESSAGE_TYPE_LDAP_AUTO_SYNCH_IMPRT,	_lb("LDAP auto synchronization profile importation") },
	{ LOG_MESSAGE_TYPE_OCSP_START,				_lb("Starting OCSP Responder") },
	{ LOG_MESSAGE_TYPE_OCSP_STOP,				_lb("Stopping OCSP Responder") },
	{ LOG_MESSAGE_TYPE_OCSP_REQUEST,			_lb("OCSP Request") },
	{ LOG_MESSAGE_TYPE_ADMIN_REQUEST,			_lb("ADMIN Request") },
	{ LOG_MESSAGE_TYPE_DELETE_RESPONSE,			_lb("Response deletion") },
	{ LOG_MESSAGE_TYPE_PROFILE_CHANGE_UID,		_lb("Profile's UID change") },
	{ LOG_MESSAGE_TYPE_PROFILE_CHANGE_OWNER,	_lb("Profile's Owner change") },
	{ LOG_MESSAGE_TYPE_PROFILE_CHANGE_DN,		_lb("Profile's DN change") },
	{ LOG_MESSAGE_TYPE_DELETE_PROFILE,			_lb("Profile deletion") },
	{ LOG_MESSAGE_TYPE_ENTITY_UNLOAD,			_lb("Entity unloading") },
	{ LOG_MESSAGE_TYPE_DELETE_REQUEST,			_lb("Request deletion") },
	{ LOG_MESSAGE_TYPE_IMPORT_CA_P12,			_lb("Importing CA PKCS#12") },
	{ LOG_MESSAGE_TYPE_EE_VAL_REQUEST,			_lb("EE DN Validation Request") },
	{ LOG_MESSAGE_TYPE_DN_VALIDATION,			_lb("DN Validation") },
	{ LOG_MESSAGE_TYPE_WEB_USER_CREATE,			_lb("Web User Creation") },
	{ LOG_MESSAGE_TYPE_WEB_USER_LOGIN,			_lb("Web User Login") },
	{ LOG_MESSAGE_TYPE_EE_DN_PUBLISH,			_lb("EE DN Publication Request") },
	{ LOG_MESSAGE_TYPE_PROFILE_ACCEPT,			_lb("Profile acceptation") },
	{ LOG_MESSAGE_TYPE_PROFILE_REJECT,			_lb("Profile rejection") },
	{ LOG_MESSAGE_TYPE_EE_DN_REMOVE,			_lb("EE DN Removal Request") },
	{ LOG_MESSAGE_TYPE_CERT_SUSPENSION,			_lb("Suspension of a certificate") }, 
	{ LOG_MESSAGE_TYPE_CERT_UNSUSPENSION,		_lb("Unsuspension of a certificate") }, 
	{ LOG_MESSAGE_TYPE_CERT_SUSP_RESP,			_lb("Suspension response") },
	{ LOG_MESSAGE_TYPE_CERT_UNSUSP_RESP,		_lb("Unsuspension response") },
	{ LOG_MESSAGE_TYPE_CA_SUSP,					_lb("Suspension request") },
	{ LOG_MESSAGE_TYPE_CA_UNSUSP,				_lb("Unsuspension request") },
	{ LOG_MESSAGE_TYPE_EE_UPD_CERT_STATE,		_lb("EE Certificate status update request") },
	{ LOG_MESSAGE_TYPE_EE_CERT_PUBLISH,			_lb("EE Certificate publication request") },
	{ LOG_MESSAGE_TYPE_USER_LOGIN,				NULL }
};



char * ASN1_logs_get_TypeString(LOG_MESSAGE_TYPE log_type)
{
	for(int i=0; LogMessages[i].Text; i++)
	{
		if(LogMessages[i].uID == log_type) return LogMessages[i].Text;
	}
	return _lb("Unknown");
}

char * ASN1_logs_get_StatusString(LOG_MESSAGE_STATUS log_status)
{
	for(int i=0; LogMessagesStatus[i].Text; i++)
	{
		if(LogMessagesStatus[i].uID == log_status) return LogMessagesStatus[i].Text;
	}

	return _lb("Unknown");
}

