/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Asn1Conf.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(EMAIL_CONF) = {
	ASN1_SIMPLE(EMAIL_CONF, server, ASN1_UTF8STRING),
	ASN1_SIMPLE(EMAIL_CONF, port, ASN1_INTEGER),
}ASN1_SEQUENCE_END(EMAIL_CONF)
ASN1_SEQUENCE(PKI_ADMIN_ENTRY) = {
	ASN1_SIMPLE(PKI_ADMIN_ENTRY, serial, ASN1_INTEGER),
	ASN1_SIMPLE(PKI_ADMIN_ENTRY, email, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(PKI_ADMIN_ENTRY)
ASN1_SEQUENCE(ENTITY_CONF_BODY_REP_0) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_REP_0, Enabled, ASN1_INTEGER),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_REP_0)
ASN1_CHOICE(ENTITY_CONF_BODY_REP) = {
	ASN1_EXP(ENTITY_CONF_BODY_REP, d.conf0, ENTITY_CONF_BODY_REP_0, CONF_VERSION_0),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_REP)
ASN1_SEQUENCE(ENTITY_CONF_BODY_PKI_0) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_PKI_0, offline, ASN1_INTEGER),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_PKI_0)
ASN1_CHOICE(ENTITY_CONF_BODY_PKI) = {
	ASN1_EXP(ENTITY_CONF_BODY_PKI, d.conf0, ENTITY_CONF_BODY_PKI_0, CONF_VERSION_0),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_PKI)
ASN1_SEQUENCE(EXTERNAL_ENTITY_PLUG) = {
	ASN1_SIMPLE(EXTERNAL_ENTITY_PLUG, LibraryPath, ASN1_UTF8STRING),
	ASN1_SEQUENCE_OF(EXTERNAL_ENTITY_PLUG, Options, PLUG_OPTION),
}ASN1_SEQUENCE_END(EXTERNAL_ENTITY_PLUG)
ASN1_SEQUENCE(ENTITY_CONF_BODY_CA_0) = {
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_CA_0, Exts, EXTENSION_VALUE),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_CA_0, CrlExts, EXTENSION_VALUE),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_0, CrlValidityDays, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_0, CrlValidityHours, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_0, PlugCa, EXTERNAL_ENTITY_PLUG),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_CA_0)
ASN1_SEQUENCE(ENTITY_CONF_BODY_CA_1) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_1, Flags, ASN1_BIT_STRING),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_CA_1, Exts, EXTENSION_VALUE),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_CA_1, CrlExts, EXTENSION_VALUE),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_1, CrlValidityDays, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_1, CrlValidityHours, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_CA_1, PlugCa, EXTERNAL_ENTITY_PLUG),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_CA_1)
ASN1_CHOICE(ENTITY_CONF_BODY_CA) = {
	ASN1_EXP(ENTITY_CONF_BODY_CA, d.conf0, ENTITY_CONF_BODY_CA_0, CONF_VERSION_0),
	ASN1_EXP(ENTITY_CONF_BODY_CA, d.conf1, ENTITY_CONF_BODY_CA_1, CONF_VERSION_1),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_CA)
ASN1_SEQUENCE(ENTITY_CONF_BODY_EE_0) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, Flags, ASN1_BIT_STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, MinKeyLen, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, MinPwdLen, ASN1_INTEGER),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_EE_0, Dn_Specs, DN_SPECS),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_EE_0, Policies, POLICY_VALUE),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, Site_Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, Dn_Val_Disclaimer, ASN1_UTF8STRING),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_EE_0, cas, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_server, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_port, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_username, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_password, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_base, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_filters, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_attr_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_EE_0, ldap_utf8, ASN1_INTEGER),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_EE_0)
ASN1_CHOICE(ENTITY_CONF_BODY_EE) = {
	ASN1_EXP(ENTITY_CONF_BODY_EE, d.conf0, ENTITY_CONF_BODY_EE_0, CONF_VERSION_0),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_EE)
ASN1_SEQUENCE(PUBLICATION_METHOD_INFO) = {
	ASN1_SIMPLE(PUBLICATION_METHOD_INFO, Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(PUBLICATION_METHOD_INFO, Type, ASN1_INTEGER),
	ASN1_SIMPLE(PUBLICATION_METHOD_INFO, LibraryPath, ASN1_UTF8STRING),
	ASN1_SEQUENCE_OF(PUBLICATION_METHOD_INFO, Options, PLUG_OPTION),
}ASN1_SEQUENCE_END(PUBLICATION_METHOD_INFO)
ASN1_SEQUENCE(PUBLICATION_ENTRY) = {
	ASN1_SIMPLE(PUBLICATION_ENTRY, CaName, ASN1_UTF8STRING),
	ASN1_SEQUENCE_OF(PUBLICATION_ENTRY, Methods, PUBLICATION_METHOD_INFO),
}ASN1_SEQUENCE_END(PUBLICATION_ENTRY)
ASN1_SEQUENCE(ENTITY_CONF_BODY_PUB_0) = {
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_PUB_0, Publications, PUBLICATION_ENTRY),
	ASN1_SIMPLE(ENTITY_CONF_BODY_PUB_0, OcspEnabled, ASN1_INTEGER),
	ASN1_EXP_OPT(ENTITY_CONF_BODY_PUB_0, BindAddress, ASN1_UTF8STRING, 1),
	ASN1_EXP_OPT(ENTITY_CONF_BODY_PUB_0, Port, ASN1_INTEGER, 2),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_PUB_0)
ASN1_CHOICE(ENTITY_CONF_BODY_PUB) = {
	ASN1_EXP(ENTITY_CONF_BODY_PUB, d.conf0, ENTITY_CONF_BODY_PUB_0, CONF_VERSION_0),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_PUB)
ASN1_SEQUENCE(ENTITY_CONF_BODY_RA_0) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, Flags, ASN1_BIT_STRING),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_RA_0, DnSpecs, DN_SPECS),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_RA_0, Policies, POLICY_VALUE),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, MinKeyLen, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, MinPwdLen, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, default_validity, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_server, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_port, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_username, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_password, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_base, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_profiles_group, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_filters, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_attr_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_0, ldap_utf8, ASN1_INTEGER),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_RA_0)
ASN1_SEQUENCE(ENTITY_CONF_BODY_RA_1) = {
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, Flags, ASN1_BIT_STRING),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_RA_1, DnSpecs, DN_SPECS),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BODY_RA_1, Policies, POLICY_VALUE),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, MinKeyLen, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, MinPwdLen, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, default_validity, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_server, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_port, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_username, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_password, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_base, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_profiles_group, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_filters, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_attr_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ldap_utf8, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BODY_RA_1, ee_profiles_group, ASN1_INTEGER),
}ASN1_SEQUENCE_END(ENTITY_CONF_BODY_RA_1)
ASN1_CHOICE(ENTITY_CONF_BODY_RA) = {
	ASN1_EXP(ENTITY_CONF_BODY_RA, d.conf0, ENTITY_CONF_BODY_RA_0, CONF_VERSION_0),
	ASN1_EXP(ENTITY_CONF_BODY_RA, d.conf1, ENTITY_CONF_BODY_RA_1, CONF_VERSION_1),
} ASN1_CHOICE_END(ENTITY_CONF_BODY_RA)
ASN1_CHOICE(ENTITY_CONF_BODY) = {
	ASN1_EXP(ENTITY_CONF_BODY, d.ra_conf, ENTITY_CONF_BODY_RA, ENTITY_TYPE_RA),
	ASN1_EXP(ENTITY_CONF_BODY, d.ca_conf, ENTITY_CONF_BODY_CA, ENTITY_TYPE_CA),
	ASN1_EXP(ENTITY_CONF_BODY, d.rep_conf, ENTITY_CONF_BODY_REP, ENTITY_TYPE_REPOSITORY),
	ASN1_EXP(ENTITY_CONF_BODY, d.pub_conf, ENTITY_CONF_BODY_PUB, ENTITY_TYPE_PUBLICATION),
	ASN1_EXP(ENTITY_CONF_BODY, d.conf, ASN1_OCTET_STRING, ENTITY_TYPE_KEY_STORE),
	ASN1_EXP(ENTITY_CONF_BODY, d.pki_conf, ENTITY_CONF_BODY_PKI, ENTITY_TYPE_PKI),
	ASN1_EXP(ENTITY_CONF_BODY, d.conf, ASN1_OCTET_STRING, ENTITY_TYPE_BACKUP),
	ASN1_EXP(ENTITY_CONF_BODY, d.ee_conf, ENTITY_CONF_BODY_EE, ENTITY_TYPE_EE),
} ASN1_CHOICE_END(ENTITY_CONF_BODY)
ASN1_SEQUENCE(USERS_GROUP) = {
	ASN1_SIMPLE(USERS_GROUP, name, ASN1_UTF8STRING),
	ASN1_SIMPLE(USERS_GROUP, serial, ASN1_INTEGER),
	ASN1_SEQUENCE_OF(USERS_GROUP, users_serial, ASN1_INTEGER),
}ASN1_SEQUENCE_END(USERS_GROUP)
ASN1_SEQUENCE(ACL_ENTRY) = {
	ASN1_SIMPLE(ACL_ENTRY, name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ACL_ENTRY, type, ASN1_INTEGER),
	ASN1_SIMPLE(ACL_ENTRY, serial, ASN1_INTEGER),
	ASN1_SIMPLE(ACL_ENTRY, acls, ASN1_BIT_STRING),
}ASN1_SEQUENCE_END(ACL_ENTRY)
ASN1_SEQUENCE(X509_ACL) = {
	ASN1_SEQUENCE_OF(X509_ACL, acl_entries, ACL_ENTRY),
	ASN1_SEQUENCE_OF(X509_ACL, acl_type, ASN1_INTEGER),
	ASN1_SEQUENCE_OF(X509_ACL, AdminSerials, PKI_ADMIN_ENTRY),
}ASN1_SEQUENCE_END(X509_ACL)
ASN1_SEQUENCE(REP_ENTRY_INFO) = {
	ASN1_SIMPLE(REP_ENTRY_INFO, RepositorySSL, X509),
	ASN1_SIMPLE(REP_ENTRY_INFO, Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(REP_ENTRY_INFO, Address, ASN1_UTF8STRING),
	ASN1_SIMPLE(REP_ENTRY_INFO, Port, ASN1_INTEGER),
	ASN1_SIMPLE(REP_ENTRY_INFO, Flags, ASN1_BIT_STRING),
}ASN1_SEQUENCE_END(REP_ENTRY_INFO)
ASN1_SEQUENCE(CA_ENTRY_INFO) = {
	ASN1_SIMPLE(CA_ENTRY_INFO, CaSSL, X509),
	ASN1_SIMPLE(CA_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(CA_ENTRY_INFO)
ASN1_SEQUENCE(CAS_INFO) = {
	ASN1_SEQUENCE_OF(CAS_INFO, list, CA_ENTRY_INFO),
}ASN1_SEQUENCE_END(CAS_INFO)
ASN1_SEQUENCE(RA_ENTRY_INFO) = {
	ASN1_SIMPLE(RA_ENTRY_INFO, RaSSL, X509),
	ASN1_SIMPLE(RA_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(RA_ENTRY_INFO)
ASN1_SEQUENCE(RAS_INFO) = {
	ASN1_SEQUENCE_OF(RAS_INFO, list, RA_ENTRY_INFO),
}ASN1_SEQUENCE_END(RAS_INFO)
ASN1_SEQUENCE(KEY_ENTRY_INFO) = {
	ASN1_SIMPLE(KEY_ENTRY_INFO, KeySSL, X509),
	ASN1_SIMPLE(KEY_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(KEY_ENTRY_INFO)
ASN1_SEQUENCE(KEYS_INFO) = {
	ASN1_SEQUENCE_OF(KEYS_INFO, list, KEY_ENTRY_INFO),
}ASN1_SEQUENCE_END(KEYS_INFO)
ASN1_SEQUENCE(EE_ENTRY_INFO) = {
	ASN1_SIMPLE(EE_ENTRY_INFO, EESSL, X509),
	ASN1_SIMPLE(EE_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(EE_ENTRY_INFO)
ASN1_SEQUENCE(EES_INFO) = {
	ASN1_SEQUENCE_OF(EES_INFO, list, EE_ENTRY_INFO),
}ASN1_SEQUENCE_END(EES_INFO)
ASN1_SEQUENCE(BACKUP_ENTRY_INFO) = {
	ASN1_SIMPLE(BACKUP_ENTRY_INFO, BackupSSL, X509),
	ASN1_SIMPLE(BACKUP_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(BACKUP_ENTRY_INFO)
ASN1_SEQUENCE(BACKUPS_INFO) = {
	ASN1_SEQUENCE_OF(BACKUPS_INFO, list, BACKUP_ENTRY_INFO),
}ASN1_SEQUENCE_END(BACKUPS_INFO)
ASN1_SEQUENCE(PUB_ENTRY_INFO) = {
	ASN1_SIMPLE(PUB_ENTRY_INFO, PubSSL, X509),
	ASN1_SIMPLE(PUB_ENTRY_INFO, PubOCSP, X509),
	ASN1_SIMPLE(PUB_ENTRY_INFO, Name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(PUB_ENTRY_INFO)
ASN1_SEQUENCE(PUBS_INFO) = {
	ASN1_SEQUENCE_OF(PUBS_INFO, list, PUB_ENTRY_INFO),
}ASN1_SEQUENCE_END(PUBS_INFO)
ASN1_SEQUENCE(INTERNAL_PKI_CRL) = {
	ASN1_SIMPLE(INTERNAL_PKI_CRL, RootCaCrl, X509_CRL),
	ASN1_SIMPLE(INTERNAL_PKI_CRL, UsersCaCrl, X509_CRL),
	ASN1_SIMPLE(INTERNAL_PKI_CRL, EntitiesCaCrl, X509_CRL),
	ASN1_SIMPLE(INTERNAL_PKI_CRL, OcspCaCrl, X509_CRL),
}ASN1_SEQUENCE_END(INTERNAL_PKI_CRL)
ASN1_SEQUENCE(INTERNAL_PKI_CA) = {
	ASN1_SIMPLE(INTERNAL_PKI_CA, RootCa, X509),
	ASN1_SIMPLE(INTERNAL_PKI_CA, UsersCa, X509),
	ASN1_SIMPLE(INTERNAL_PKI_CA, EntitiesCa, X509),
	ASN1_SIMPLE(INTERNAL_PKI_CA, OcspCa, X509),
	ASN1_SIMPLE(INTERNAL_PKI_CA, PkiCert, X509),
}ASN1_SEQUENCE_END(INTERNAL_PKI_CA)
ASN1_SEQUENCE(ENTITY_AUDIT_ENTRY) = {
	ASN1_EXP_OPT(ENTITY_AUDIT_ENTRY, object, ASN1_UTF8STRING, 1),
	ASN1_EXP_OPT(ENTITY_AUDIT_ENTRY, type, ASN1_INTEGER, 2),
	ASN1_EXP_OPT(ENTITY_AUDIT_ENTRY, status, ASN1_INTEGER, 3),
	ASN1_EXP_OPT(ENTITY_AUDIT_ENTRY, user, ASN1_UTF8STRING, 4),
}ASN1_SEQUENCE_END(ENTITY_AUDIT_ENTRY)
ASN1_SEQUENCE(ENTITY_CONF) = {
	ASN1_SIMPLE(ENTITY_CONF, Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF, version, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF, acls, X509_ACL),
	ASN1_SIMPLE(ENTITY_CONF, body, ENTITY_CONF_BODY),
	ASN1_SEQUENCE_OF(ENTITY_CONF, Repositories, REP_ENTRY_INFO),
	ASN1_SIMPLE(ENTITY_CONF, Ras, RAS_INFO),
	ASN1_SIMPLE(ENTITY_CONF, Cas, CAS_INFO),
	ASN1_SIMPLE(ENTITY_CONF, KeyStores, KEYS_INFO),
	ASN1_SIMPLE(ENTITY_CONF, EES, EES_INFO),
	ASN1_SIMPLE(ENTITY_CONF, Backups, BACKUPS_INFO),
	ASN1_SIMPLE(ENTITY_CONF, Publications, PUBS_INFO),
	ASN1_SIMPLE(ENTITY_CONF, crls, INTERNAL_PKI_CRL),
	ASN1_SIMPLE(ENTITY_CONF, mail_conf, EMAIL_CONF),
	ASN1_SEQUENCE_OF(ENTITY_CONF, audits, ENTITY_AUDIT_ENTRY),
	ASN1_SEQUENCE_OF(ENTITY_CONF, groups, USERS_GROUP),
}ASN1_SEQUENCE_END(ENTITY_CONF)
ASN1_SEQUENCE(ENTITY_CONF_BETA4) = {
	ASN1_SIMPLE(ENTITY_CONF_BETA4, Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, version, ASN1_INTEGER),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, acls, X509_ACL),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, body, ENTITY_CONF_BODY),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BETA4, Repositories, REP_ENTRY_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, Ras, RAS_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, Cas, CAS_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, KeyStores, KEYS_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, Backups, BACKUPS_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, Publications, PUBS_INFO),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, crls, INTERNAL_PKI_CRL),
	ASN1_SIMPLE(ENTITY_CONF_BETA4, mail_conf, EMAIL_CONF),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BETA4, audits, ENTITY_AUDIT_ENTRY),
	ASN1_SEQUENCE_OF(ENTITY_CONF_BETA4, groups, USERS_GROUP),
}ASN1_SEQUENCE_END(ENTITY_CONF_BETA4)
ASN1_SEQUENCE(ENTITY_CONF_CRYPTED) = {
	ASN1_SIMPLE(ENTITY_CONF_CRYPTED, recipient, X509_PUBKEY),
	ASN1_SIMPLE(ENTITY_CONF_CRYPTED, crypted, ASN1_ENCRYPT_SIGN),
}ASN1_SEQUENCE_END(ENTITY_CONF_CRYPTED)
ASN1_SEQUENCE(EXPORTED_PKI_CONF_BODY) = {
	ASN1_SIMPLE(EXPORTED_PKI_CONF_BODY, version, ASN1_INTEGER),
	ASN1_SEQUENCE_OF(EXPORTED_PKI_CONF_BODY, all_confs, ENTITY_CONF_CRYPTED),
}ASN1_SEQUENCE_END(EXPORTED_PKI_CONF_BODY)
ASN1_SEQUENCE(EXPORTED_PKI_CONF) = {
	ASN1_SIMPLE(EXPORTED_PKI_CONF, confs, EXPORTED_PKI_CONF_BODY),
	ASN1_SIMPLE(EXPORTED_PKI_CONF, sig, X509_SIG),
	ASN1_SEQUENCE_OF(EXPORTED_PKI_CONF, rep_path, X509_PUBKEY),
}ASN1_SEQUENCE_END(EXPORTED_PKI_CONF)
ASN1_SEQUENCE(NEWPKI_PROFILE) = {
	ASN1_SIMPLE(NEWPKI_PROFILE, owner_group_serial, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE, dn, X509_NAME),
	ASN1_SIMPLE(NEWPKI_PROFILE, EE_Validation, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_PROFILE)
ASN1_SEQUENCE(NEWPKI_PROFILE_DATAS_CERT) = {
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, Id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, state, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, type, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, ca_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, flags, ASN1_BIT_STRING),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS_CERT, admin_mail, ASN1_UTF8STRING),
	ASN1_EXP_OPT(NEWPKI_PROFILE_DATAS_CERT, cert, X509, 0),
	ASN1_EXP_OPT(NEWPKI_PROFILE_DATAS_CERT, error, ASN1_UTF8STRING, 1),
	ASN1_EXP_OPT(NEWPKI_PROFILE_DATAS_CERT, p12, PKCS12, 2),
	ASN1_EXP_OPT(NEWPKI_PROFILE_DATAS_CERT, p7b, PKCS7, 3),
}ASN1_SEQUENCE_END(NEWPKI_PROFILE_DATAS_CERT)
ASN1_SEQUENCE(NEWPKI_PROFILE_DATAS) = {
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS, State, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS, Id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS, ee_id, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_PROFILE_DATAS, Profile, NEWPKI_PROFILE),
	ASN1_SEQUENCE_OF(NEWPKI_PROFILE_DATAS, Certs, NEWPKI_PROFILE_DATAS_CERT),
}ASN1_SEQUENCE_END(NEWPKI_PROFILE_DATAS)
ASN1_SEQUENCE(NEWPKI_EE_USER) = {
	ASN1_SIMPLE(NEWPKI_EE_USER, Id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_USER, email, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_EE_USER, dn, X509_NAME),
	ASN1_SIMPLE(NEWPKI_EE_USER, ra_validated, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_USER, activated, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_USER, last_send, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_USER, send_count, ASN1_INTEGER),
	ASN1_SEQUENCE_OF(NEWPKI_EE_USER, Certs, NEWPKI_PROFILE_DATAS_CERT),
}ASN1_SEQUENCE_END(NEWPKI_EE_USER)
EmailConf EmailConf::EmptyInstance;
bool EmailConf::set_port(unsigned long c_port)
{
	m_port = c_port;
	return true;
}

unsigned long EmailConf::get_port() const
{
	return m_port;
}

bool EmailConf::set_server(const mString & c_server)
{
	m_server = c_server;
	return true;
}

const mString & EmailConf::get_server() const
{
	return m_server;
}

mString & EmailConf::get_server()
{
	return m_server;
}

EmailConf::EmailConf():NewPKIObject()
{
	resetAll();
}

EmailConf::EmailConf(const EmailConf & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EmailConf::~EmailConf()
{
	Clear();
}

void EmailConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EmailConf::freeAll()
{
}

void EmailConf::resetAll()
{
	m_port = 0;
	m_server = "";
}

bool EmailConf::load_Datas(const EMAIL_CONF * Datas)
{
	Clear();
	if(Datas->port)
	{
		m_port = ASN1_INTEGER_GET(Datas->port);
	}
	if(Datas->server)
	{
		m_server = Datas->server;
	}
	m_isOk=true;
	return true;
}

bool EmailConf::give_Datas(EMAIL_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EMAIL_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->port && !((*Datas)->port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->port, m_port) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->port);
		(*Datas)->port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->server && !((*Datas)->server = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_server.c_ASN1_UTF8STRING(&(*Datas)->server))
	{
		ASN1_UTF8STRING_free((*Datas)->server);
		(*Datas)->server = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool EmailConf::operator=(const EmailConf & other)
{
	Clear();
	m_port = other.m_port;
	m_server = other.m_server;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EmailConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EMAIL_CONF);
}
PkiAdminEntry PkiAdminEntry::EmptyInstance;
bool PkiAdminEntry::set_email(const mString & c_email)
{
	m_email = c_email;
	return true;
}

const mString & PkiAdminEntry::get_email() const
{
	return m_email;
}

mString & PkiAdminEntry::get_email()
{
	return m_email;
}

bool PkiAdminEntry::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long PkiAdminEntry::get_serial() const
{
	return m_serial;
}

PkiAdminEntry::PkiAdminEntry():NewPKIObject()
{
	resetAll();
}

PkiAdminEntry::PkiAdminEntry(const PkiAdminEntry & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PkiAdminEntry::~PkiAdminEntry()
{
	Clear();
}

void PkiAdminEntry::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PkiAdminEntry::freeAll()
{
}

void PkiAdminEntry::resetAll()
{
	m_email = "";
	m_serial = 0;
}

bool PkiAdminEntry::load_Datas(const PKI_ADMIN_ENTRY * Datas)
{
	Clear();
	if(Datas->email)
	{
		m_email = Datas->email;
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	m_isOk=true;
	return true;
}

bool PkiAdminEntry::give_Datas(PKI_ADMIN_ENTRY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PKI_ADMIN_ENTRY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->email && !((*Datas)->email = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_email.c_ASN1_UTF8STRING(&(*Datas)->email))
	{
		ASN1_UTF8STRING_free((*Datas)->email);
		(*Datas)->email = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool PkiAdminEntry::operator=(const PkiAdminEntry & other)
{
	Clear();
	m_email = other.m_email;
	m_serial = other.m_serial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PkiAdminEntry::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PKI_ADMIN_ENTRY);
}
EntityConfBodyRep0 EntityConfBodyRep0::EmptyInstance;
bool EntityConfBodyRep0::set_enabled(unsigned long c_enabled)
{
	m_enabled = c_enabled;
	return true;
}

unsigned long EntityConfBodyRep0::get_enabled() const
{
	return m_enabled;
}

EntityConfBodyRep0::EntityConfBodyRep0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyRep0::EntityConfBodyRep0(const EntityConfBodyRep0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyRep0::~EntityConfBodyRep0()
{
	Clear();
}

void EntityConfBodyRep0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyRep0::freeAll()
{
}

void EntityConfBodyRep0::resetAll()
{
	m_enabled = 0;
}

bool EntityConfBodyRep0::load_Datas(const ENTITY_CONF_BODY_REP_0 * Datas)
{
	Clear();
	if(Datas->Enabled)
	{
		m_enabled = ASN1_INTEGER_GET(Datas->Enabled);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyRep0::give_Datas(ENTITY_CONF_BODY_REP_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_REP_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Enabled && !((*Datas)->Enabled = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Enabled, m_enabled) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Enabled);
		(*Datas)->Enabled = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBodyRep0::operator=(const EntityConfBodyRep0 & other)
{
	Clear();
	m_enabled = other.m_enabled;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyRep0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP_0);
}
EntityConfBodyRep EntityConfBodyRep::EmptyInstance;
bool EntityConfBodyRep::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyRep::get_type() const
{
	 return m_type;
}

bool EntityConfBodyRep::set_conf0(const EntityConfBodyRep0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyRep0 & EntityConfBodyRep::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyRep0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyRep0 & EntityConfBodyRep::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyRep0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyRep::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyRep0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyRep::EntityConfBodyRep():NewPKIObject()
{
	resetAll();
}

EntityConfBodyRep::EntityConfBodyRep(const EntityConfBodyRep & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyRep::~EntityConfBodyRep()
{
	Clear();
}

void EntityConfBodyRep::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyRep::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
}

void EntityConfBodyRep::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
}

bool EntityConfBodyRep::load_Datas(const ENTITY_CONF_BODY_REP * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyRep::give_Datas(ENTITY_CONF_BODY_REP ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_REP*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_REP_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyRep::operator=(const EntityConfBodyRep & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyRep::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP);
}
EntityConfBodyPki0 EntityConfBodyPki0::EmptyInstance;
bool EntityConfBodyPki0::set_offline(unsigned long c_offline)
{
	m_offline = c_offline;
	return true;
}

unsigned long EntityConfBodyPki0::get_offline() const
{
	return m_offline;
}

EntityConfBodyPki0::EntityConfBodyPki0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyPki0::EntityConfBodyPki0(const EntityConfBodyPki0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyPki0::~EntityConfBodyPki0()
{
	Clear();
}

void EntityConfBodyPki0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyPki0::freeAll()
{
}

void EntityConfBodyPki0::resetAll()
{
	m_offline = 0;
}

bool EntityConfBodyPki0::load_Datas(const ENTITY_CONF_BODY_PKI_0 * Datas)
{
	Clear();
	if(Datas->offline)
	{
		m_offline = ASN1_INTEGER_GET(Datas->offline);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyPki0::give_Datas(ENTITY_CONF_BODY_PKI_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_PKI_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->offline && !((*Datas)->offline = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->offline, m_offline) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->offline);
		(*Datas)->offline = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBodyPki0::operator=(const EntityConfBodyPki0 & other)
{
	Clear();
	m_offline = other.m_offline;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyPki0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI_0);
}
EntityConfBodyPki EntityConfBodyPki::EmptyInstance;
bool EntityConfBodyPki::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyPki::get_type() const
{
	 return m_type;
}

bool EntityConfBodyPki::set_conf0(const EntityConfBodyPki0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyPki0 & EntityConfBodyPki::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyPki0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyPki0 & EntityConfBodyPki::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyPki0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyPki::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyPki0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyPki::EntityConfBodyPki():NewPKIObject()
{
	resetAll();
}

EntityConfBodyPki::EntityConfBodyPki(const EntityConfBodyPki & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyPki::~EntityConfBodyPki()
{
	Clear();
}

void EntityConfBodyPki::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyPki::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
}

void EntityConfBodyPki::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
}

bool EntityConfBodyPki::load_Datas(const ENTITY_CONF_BODY_PKI * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyPki::give_Datas(ENTITY_CONF_BODY_PKI ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_PKI*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_PKI_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyPki::operator=(const EntityConfBodyPki & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyPki::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI);
}
ExternalEntityPlug ExternalEntityPlug::EmptyInstance;
bool ExternalEntityPlug::set_librarypath(const mString & c_librarypath)
{
	m_librarypath = c_librarypath;
	return true;
}

const mString & ExternalEntityPlug::get_librarypath() const
{
	return m_librarypath;
}

mString & ExternalEntityPlug::get_librarypath()
{
	return m_librarypath;
}

bool ExternalEntityPlug::set_options(const mVector< PlugOption > & c_options)
{
	m_options = c_options;
	return true;
}

const mVector< PlugOption > & ExternalEntityPlug::get_options() const
{
	return m_options;
}

mVector< PlugOption > & ExternalEntityPlug::get_options()
{
	return m_options;
}

ExternalEntityPlug::ExternalEntityPlug():NewPKIObject()
{
	resetAll();
}

ExternalEntityPlug::ExternalEntityPlug(const ExternalEntityPlug & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ExternalEntityPlug::~ExternalEntityPlug()
{
	Clear();
}

void ExternalEntityPlug::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ExternalEntityPlug::freeAll()
{
}

void ExternalEntityPlug::resetAll()
{
	m_librarypath = "";
	m_options.clear();
}

bool ExternalEntityPlug::load_Datas(const EXTERNAL_ENTITY_PLUG * Datas)
{
	Clear();
	int i;
	PLUG_OPTION * curroptions;
	if(Datas->LibraryPath)
	{
		m_librarypath = Datas->LibraryPath;
	}
	if(Datas->Options)
	{
		for(i=0; i<SKM_sk_num(PLUG_OPTION, Datas->Options); i++)
		{
			curroptions = SKM_sk_value(PLUG_OPTION, Datas->Options, i);
			if(!curroptions)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_options.insert(m_options.begin() + i);
			if(!m_options[i].load_Datas(curroptions))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool ExternalEntityPlug::give_Datas(EXTERNAL_ENTITY_PLUG ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EXTERNAL_ENTITY_PLUG*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	PLUG_OPTION * curroptions;
	size_t i;
	if(!(*Datas)->LibraryPath && !((*Datas)->LibraryPath = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_librarypath.c_ASN1_UTF8STRING(&(*Datas)->LibraryPath))
	{
		ASN1_UTF8STRING_free((*Datas)->LibraryPath);
		(*Datas)->LibraryPath = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Options && !((*Datas)->Options = SKM_sk_new_null(PLUG_OPTION)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_options.size() ; i++)
	{
		curroptions = NULL;
		if(!m_options[i].give_Datas(&curroptions))
		{
			ASN1_item_free((ASN1_VALUE*)curroptions, ASN1_ITEM_rptr(PLUG_OPTION));
			curroptions = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PLUG_OPTION, (*Datas)->Options, curroptions) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curroptions, ASN1_ITEM_rptr(PLUG_OPTION));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool ExternalEntityPlug::operator=(const ExternalEntityPlug & other)
{
	Clear();
	m_librarypath = other.m_librarypath;
	m_options = other.m_options;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ExternalEntityPlug::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EXTERNAL_ENTITY_PLUG);
}
EntityConfBodyCa0 EntityConfBodyCa0::EmptyInstance;
bool EntityConfBodyCa0::set_crlexts(const mVector< ExtensionValue > & c_crlexts)
{
	m_crlexts = c_crlexts;
	return true;
}

const mVector< ExtensionValue > & EntityConfBodyCa0::get_crlexts() const
{
	return m_crlexts;
}

mVector< ExtensionValue > & EntityConfBodyCa0::get_crlexts()
{
	return m_crlexts;
}

bool EntityConfBodyCa0::set_crlvaliditydays(unsigned long c_crlvaliditydays)
{
	m_crlvaliditydays = c_crlvaliditydays;
	return true;
}

unsigned long EntityConfBodyCa0::get_crlvaliditydays() const
{
	return m_crlvaliditydays;
}

bool EntityConfBodyCa0::set_crlvalidityhours(unsigned long c_crlvalidityhours)
{
	m_crlvalidityhours = c_crlvalidityhours;
	return true;
}

unsigned long EntityConfBodyCa0::get_crlvalidityhours() const
{
	return m_crlvalidityhours;
}

bool EntityConfBodyCa0::set_exts(const mVector< ExtensionValue > & c_exts)
{
	m_exts = c_exts;
	return true;
}

const mVector< ExtensionValue > & EntityConfBodyCa0::get_exts() const
{
	return m_exts;
}

mVector< ExtensionValue > & EntityConfBodyCa0::get_exts()
{
	return m_exts;
}

bool EntityConfBodyCa0::set_plugca(const ExternalEntityPlug & c_plugca)
{
	m_plugca = c_plugca;
	return true;
}

const ExternalEntityPlug & EntityConfBodyCa0::get_plugca() const
{
	return m_plugca;
}

ExternalEntityPlug & EntityConfBodyCa0::get_plugca()
{
	return m_plugca;
}

EntityConfBodyCa0::EntityConfBodyCa0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyCa0::EntityConfBodyCa0(const EntityConfBodyCa0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyCa0::~EntityConfBodyCa0()
{
	Clear();
}

void EntityConfBodyCa0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyCa0::freeAll()
{
}

void EntityConfBodyCa0::resetAll()
{
	m_crlexts.clear();
	m_crlvaliditydays = 0;
	m_crlvalidityhours = 0;
	m_exts.clear();
	m_plugca.Clear();
}

bool EntityConfBodyCa0::load_Datas(const ENTITY_CONF_BODY_CA_0 * Datas)
{
	Clear();
	EXTENSION_VALUE * currexts;
	int i;
	EXTENSION_VALUE * currcrlexts;
	if(Datas->CrlExts)
	{
		for(i=0; i<SKM_sk_num(EXTENSION_VALUE, Datas->CrlExts); i++)
		{
			currcrlexts = SKM_sk_value(EXTENSION_VALUE, Datas->CrlExts, i);
			if(!currcrlexts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_crlexts.insert(m_crlexts.begin() + i);
			if(!m_crlexts[i].load_Datas(currcrlexts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->CrlValidityDays)
	{
		m_crlvaliditydays = ASN1_INTEGER_GET(Datas->CrlValidityDays);
	}
	if(Datas->CrlValidityHours)
	{
		m_crlvalidityhours = ASN1_INTEGER_GET(Datas->CrlValidityHours);
	}
	if(Datas->Exts)
	{
		for(i=0; i<SKM_sk_num(EXTENSION_VALUE, Datas->Exts); i++)
		{
			currexts = SKM_sk_value(EXTENSION_VALUE, Datas->Exts, i);
			if(!currexts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_exts.insert(m_exts.begin() + i);
			if(!m_exts[i].load_Datas(currexts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->PlugCa)
	{
		if(!m_plugca.load_Datas(Datas->PlugCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyCa0::give_Datas(ENTITY_CONF_BODY_CA_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_CA_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	EXTENSION_VALUE * currexts;
	EXTENSION_VALUE * currcrlexts;
	size_t i;
	if(!(*Datas)->CrlExts && !((*Datas)->CrlExts = SKM_sk_new_null(EXTENSION_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_crlexts.size() ; i++)
	{
		currcrlexts = NULL;
		if(!m_crlexts[i].give_Datas(&currcrlexts))
		{
			ASN1_item_free((ASN1_VALUE*)currcrlexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			currcrlexts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(EXTENSION_VALUE, (*Datas)->CrlExts, currcrlexts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currcrlexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->CrlValidityDays && !((*Datas)->CrlValidityDays = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->CrlValidityDays, m_crlvaliditydays) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->CrlValidityDays);
		(*Datas)->CrlValidityDays = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->CrlValidityHours && !((*Datas)->CrlValidityHours = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->CrlValidityHours, m_crlvalidityhours) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->CrlValidityHours);
		(*Datas)->CrlValidityHours = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Exts && !((*Datas)->Exts = SKM_sk_new_null(EXTENSION_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_exts.size() ; i++)
	{
		currexts = NULL;
		if(!m_exts[i].give_Datas(&currexts))
		{
			ASN1_item_free((ASN1_VALUE*)currexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			currexts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(EXTENSION_VALUE, (*Datas)->Exts, currexts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->PlugCa && !((*Datas)->PlugCa = (EXTERNAL_ENTITY_PLUG*)ASN1_item_new(ASN1_ITEM_rptr(EXTERNAL_ENTITY_PLUG))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_plugca.give_Datas(&(*Datas)->PlugCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->PlugCa, ASN1_ITEM_rptr(EXTERNAL_ENTITY_PLUG));
		(*Datas)->PlugCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool EntityConfBodyCa0::operator=(const EntityConfBodyCa0 & other)
{
	Clear();
	m_crlexts = other.m_crlexts;
	m_crlvaliditydays = other.m_crlvaliditydays;
	m_crlvalidityhours = other.m_crlvalidityhours;
	m_exts = other.m_exts;
	m_plugca = other.m_plugca;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyCa0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_0);
}
EntityConfBodyCa1 EntityConfBodyCa1::EmptyInstance;
bool EntityConfBodyCa1::set_crlexts(const mVector< ExtensionValue > & c_crlexts)
{
	m_crlexts = c_crlexts;
	return true;
}

const mVector< ExtensionValue > & EntityConfBodyCa1::get_crlexts() const
{
	return m_crlexts;
}

mVector< ExtensionValue > & EntityConfBodyCa1::get_crlexts()
{
	return m_crlexts;
}

bool EntityConfBodyCa1::set_crlvaliditydays(unsigned long c_crlvaliditydays)
{
	m_crlvaliditydays = c_crlvaliditydays;
	return true;
}

unsigned long EntityConfBodyCa1::get_crlvaliditydays() const
{
	return m_crlvaliditydays;
}

bool EntityConfBodyCa1::set_crlvalidityhours(unsigned long c_crlvalidityhours)
{
	m_crlvalidityhours = c_crlvalidityhours;
	return true;
}

unsigned long EntityConfBodyCa1::get_crlvalidityhours() const
{
	return m_crlvalidityhours;
}

bool EntityConfBodyCa1::set_exts(const mVector< ExtensionValue > & c_exts)
{
	m_exts = c_exts;
	return true;
}

const mVector< ExtensionValue > & EntityConfBodyCa1::get_exts() const
{
	return m_exts;
}

mVector< ExtensionValue > & EntityConfBodyCa1::get_exts()
{
	return m_exts;
}

bool EntityConfBodyCa1::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * EntityConfBodyCa1::get_flags() const
{
	if(!m_flags)
		((EntityConfBodyCa1*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * EntityConfBodyCa1::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool EntityConfBodyCa1::set_plugca(const ExternalEntityPlug & c_plugca)
{
	m_plugca = c_plugca;
	return true;
}

const ExternalEntityPlug & EntityConfBodyCa1::get_plugca() const
{
	return m_plugca;
}

ExternalEntityPlug & EntityConfBodyCa1::get_plugca()
{
	return m_plugca;
}

EntityConfBodyCa1::EntityConfBodyCa1():NewPKIObject()
{
	resetAll();
}

EntityConfBodyCa1::EntityConfBodyCa1(const EntityConfBodyCa1 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyCa1::~EntityConfBodyCa1()
{
	Clear();
}

void EntityConfBodyCa1::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyCa1::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void EntityConfBodyCa1::resetAll()
{
	m_crlexts.clear();
	m_crlvaliditydays = 0;
	m_crlvalidityhours = 0;
	m_exts.clear();
	m_flags = NULL;
	m_plugca.Clear();
}

bool EntityConfBodyCa1::load_Datas(const ENTITY_CONF_BODY_CA_1 * Datas)
{
	Clear();
	EXTENSION_VALUE * currexts;
	int i;
	EXTENSION_VALUE * currcrlexts;
	if(Datas->CrlExts)
	{
		for(i=0; i<SKM_sk_num(EXTENSION_VALUE, Datas->CrlExts); i++)
		{
			currcrlexts = SKM_sk_value(EXTENSION_VALUE, Datas->CrlExts, i);
			if(!currcrlexts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_crlexts.insert(m_crlexts.begin() + i);
			if(!m_crlexts[i].load_Datas(currcrlexts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->CrlValidityDays)
	{
		m_crlvaliditydays = ASN1_INTEGER_GET(Datas->CrlValidityDays);
	}
	if(Datas->CrlValidityHours)
	{
		m_crlvalidityhours = ASN1_INTEGER_GET(Datas->CrlValidityHours);
	}
	if(Datas->Exts)
	{
		for(i=0; i<SKM_sk_num(EXTENSION_VALUE, Datas->Exts); i++)
		{
			currexts = SKM_sk_value(EXTENSION_VALUE, Datas->Exts, i);
			if(!currexts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_exts.insert(m_exts.begin() + i);
			if(!m_exts[i].load_Datas(currexts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->Flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->PlugCa)
	{
		if(!m_plugca.load_Datas(Datas->PlugCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyCa1::give_Datas(ENTITY_CONF_BODY_CA_1 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_CA_1*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	EXTENSION_VALUE * currexts;
	EXTENSION_VALUE * currcrlexts;
	size_t i;
	if(!(*Datas)->CrlExts && !((*Datas)->CrlExts = SKM_sk_new_null(EXTENSION_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_crlexts.size() ; i++)
	{
		currcrlexts = NULL;
		if(!m_crlexts[i].give_Datas(&currcrlexts))
		{
			ASN1_item_free((ASN1_VALUE*)currcrlexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			currcrlexts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(EXTENSION_VALUE, (*Datas)->CrlExts, currcrlexts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currcrlexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->CrlValidityDays && !((*Datas)->CrlValidityDays = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->CrlValidityDays, m_crlvaliditydays) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->CrlValidityDays);
		(*Datas)->CrlValidityDays = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->CrlValidityHours && !((*Datas)->CrlValidityHours = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->CrlValidityHours, m_crlvalidityhours) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->CrlValidityHours);
		(*Datas)->CrlValidityHours = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Exts && !((*Datas)->Exts = SKM_sk_new_null(EXTENSION_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_exts.size() ; i++)
	{
		currexts = NULL;
		if(!m_exts[i].give_Datas(&currexts))
		{
			ASN1_item_free((ASN1_VALUE*)currexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			currexts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(EXTENSION_VALUE, (*Datas)->Exts, currexts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currexts, ASN1_ITEM_rptr(EXTENSION_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_flags)
	{
		if((*Datas)->Flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->Flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->Flags)
		{
			(*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->Flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->PlugCa && !((*Datas)->PlugCa = (EXTERNAL_ENTITY_PLUG*)ASN1_item_new(ASN1_ITEM_rptr(EXTERNAL_ENTITY_PLUG))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_plugca.give_Datas(&(*Datas)->PlugCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->PlugCa, ASN1_ITEM_rptr(EXTERNAL_ENTITY_PLUG));
		(*Datas)->PlugCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool EntityConfBodyCa1::operator=(const EntityConfBodyCa1 & other)
{
	Clear();
	m_crlexts = other.m_crlexts;
	m_crlvaliditydays = other.m_crlvaliditydays;
	m_crlvalidityhours = other.m_crlvalidityhours;
	m_exts = other.m_exts;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_plugca = other.m_plugca;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyCa1::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_1);
}
EntityConfBodyCa EntityConfBodyCa::EmptyInstance;
bool EntityConfBodyCa::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyCa::get_type() const
{
	 return m_type;
}

bool EntityConfBodyCa::set_conf0(const EntityConfBodyCa0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyCa0 & EntityConfBodyCa::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyCa0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyCa0 & EntityConfBodyCa::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyCa0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyCa::set_conf1(const EntityConfBodyCa1 & c_conf1)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf1) = c_conf1;
	m_isOk=true;
	return true;
}

const EntityConfBodyCa1 & EntityConfBodyCa::get_conf1() const
{
	if((m_type != 1) || !m_conf1)
	{
		return EntityConfBodyCa1::EmptyInstance;
	}
	return (*m_conf1);
}

EntityConfBodyCa1 & EntityConfBodyCa::get_conf1()
{
	if((m_type != 1) || !m_conf1)
	{
		return EntityConfBodyCa1::EmptyInstance;
	}
	return (*m_conf1);
}

bool EntityConfBodyCa::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyCa0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_conf1 = new EntityConfBodyCa1();
			if(!m_conf1)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyCa::EntityConfBodyCa():NewPKIObject()
{
	resetAll();
}

EntityConfBodyCa::EntityConfBodyCa(const EntityConfBodyCa & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyCa::~EntityConfBodyCa()
{
	Clear();
}

void EntityConfBodyCa::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyCa::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
	if(m_conf1)
	{
		delete m_conf1;
	}
}

void EntityConfBodyCa::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
	m_conf1 = NULL;
}

bool EntityConfBodyCa::load_Datas(const ENTITY_CONF_BODY_CA * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.conf1)
			{
				if(!(*m_conf1).load_Datas(Datas->d.conf1))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyCa::give_Datas(ENTITY_CONF_BODY_CA ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_CA*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_CA_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.conf1 = (ENTITY_CONF_BODY_CA_1*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_1))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf1).give_Datas(&(*Datas)->d.conf1))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf1, ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA_1));
				(*Datas)->d.conf1 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyCa::operator=(const EntityConfBodyCa & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
		case 1:
			if(!other.m_conf1)
				break;
			(*m_conf1) = *(other.m_conf1);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyCa::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA);
}
EntityConfBodyEe0 EntityConfBodyEe0::EmptyInstance;
bool EntityConfBodyEe0::set_dnSpecs(const mVector< DnSpecs > & c_dnSpecs)
{
	m_dnSpecs = c_dnSpecs;
	return true;
}

const mVector< DnSpecs > & EntityConfBodyEe0::get_dnSpecs() const
{
	return m_dnSpecs;
}

mVector< DnSpecs > & EntityConfBodyEe0::get_dnSpecs()
{
	return m_dnSpecs;
}

bool EntityConfBodyEe0::set_dnValDisclaimer(const mString & c_dnValDisclaimer)
{
	m_dnValDisclaimer = c_dnValDisclaimer;
	return true;
}

const mString & EntityConfBodyEe0::get_dnValDisclaimer() const
{
	return m_dnValDisclaimer;
}

mString & EntityConfBodyEe0::get_dnValDisclaimer()
{
	return m_dnValDisclaimer;
}

bool EntityConfBodyEe0::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * EntityConfBodyEe0::get_flags() const
{
	if(!m_flags)
		((EntityConfBodyEe0*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * EntityConfBodyEe0::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool EntityConfBodyEe0::set_minkeylen(unsigned long c_minkeylen)
{
	m_minkeylen = c_minkeylen;
	return true;
}

unsigned long EntityConfBodyEe0::get_minkeylen() const
{
	return m_minkeylen;
}

bool EntityConfBodyEe0::set_minpwdlen(unsigned long c_minpwdlen)
{
	m_minpwdlen = c_minpwdlen;
	return true;
}

unsigned long EntityConfBodyEe0::get_minpwdlen() const
{
	return m_minpwdlen;
}

bool EntityConfBodyEe0::set_policies(const mVector< PolicyValue > & c_policies)
{
	m_policies = c_policies;
	return true;
}

const mVector< PolicyValue > & EntityConfBodyEe0::get_policies() const
{
	return m_policies;
}

mVector< PolicyValue > & EntityConfBodyEe0::get_policies()
{
	return m_policies;
}

bool EntityConfBodyEe0::set_siteName(const mString & c_siteName)
{
	m_siteName = c_siteName;
	return true;
}

const mString & EntityConfBodyEe0::get_siteName() const
{
	return m_siteName;
}

mString & EntityConfBodyEe0::get_siteName()
{
	return m_siteName;
}

bool EntityConfBodyEe0::set_cas(const mVector< mString > & c_cas)
{
	m_cas = c_cas;
	return true;
}

const mVector< mString > & EntityConfBodyEe0::get_cas() const
{
	return m_cas;
}

mVector< mString > & EntityConfBodyEe0::get_cas()
{
	return m_cas;
}

bool EntityConfBodyEe0::set_ldapAttrName(const mString & c_ldapAttrName)
{
	m_ldapAttrName = c_ldapAttrName;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapAttrName() const
{
	return m_ldapAttrName;
}

mString & EntityConfBodyEe0::get_ldapAttrName()
{
	return m_ldapAttrName;
}

bool EntityConfBodyEe0::set_ldapBase(const mString & c_ldapBase)
{
	m_ldapBase = c_ldapBase;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapBase() const
{
	return m_ldapBase;
}

mString & EntityConfBodyEe0::get_ldapBase()
{
	return m_ldapBase;
}

bool EntityConfBodyEe0::set_ldapFilters(const mString & c_ldapFilters)
{
	m_ldapFilters = c_ldapFilters;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapFilters() const
{
	return m_ldapFilters;
}

mString & EntityConfBodyEe0::get_ldapFilters()
{
	return m_ldapFilters;
}

bool EntityConfBodyEe0::set_ldapPassword(const mString & c_ldapPassword)
{
	m_ldapPassword = c_ldapPassword;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapPassword() const
{
	return m_ldapPassword;
}

mString & EntityConfBodyEe0::get_ldapPassword()
{
	return m_ldapPassword;
}

bool EntityConfBodyEe0::set_ldapPort(unsigned long c_ldapPort)
{
	m_ldapPort = c_ldapPort;
	return true;
}

unsigned long EntityConfBodyEe0::get_ldapPort() const
{
	return m_ldapPort;
}

bool EntityConfBodyEe0::set_ldapServer(const mString & c_ldapServer)
{
	m_ldapServer = c_ldapServer;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapServer() const
{
	return m_ldapServer;
}

mString & EntityConfBodyEe0::get_ldapServer()
{
	return m_ldapServer;
}

bool EntityConfBodyEe0::set_ldapUsername(const mString & c_ldapUsername)
{
	m_ldapUsername = c_ldapUsername;
	return true;
}

const mString & EntityConfBodyEe0::get_ldapUsername() const
{
	return m_ldapUsername;
}

mString & EntityConfBodyEe0::get_ldapUsername()
{
	return m_ldapUsername;
}

bool EntityConfBodyEe0::set_ldapUtf8(unsigned long c_ldapUtf8)
{
	m_ldapUtf8 = c_ldapUtf8;
	return true;
}

unsigned long EntityConfBodyEe0::get_ldapUtf8() const
{
	return m_ldapUtf8;
}

EntityConfBodyEe0::EntityConfBodyEe0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyEe0::EntityConfBodyEe0(const EntityConfBodyEe0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyEe0::~EntityConfBodyEe0()
{
	Clear();
}

void EntityConfBodyEe0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyEe0::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void EntityConfBodyEe0::resetAll()
{
	m_dnSpecs.clear();
	m_dnValDisclaimer = "";
	m_flags = NULL;
	m_minkeylen = 0;
	m_minpwdlen = 0;
	m_policies.clear();
	m_siteName = "";
	m_cas.clear();
	m_ldapAttrName = "";
	m_ldapBase = "";
	m_ldapFilters = "";
	m_ldapPassword = "";
	m_ldapPort = 0;
	m_ldapServer = "";
	m_ldapUsername = "";
	m_ldapUtf8 = 0;
}

bool EntityConfBodyEe0::load_Datas(const ENTITY_CONF_BODY_EE_0 * Datas)
{
	Clear();
	ASN1_UTF8STRING * currcas;
	POLICY_VALUE * currpolicies;
	int i;
	DN_SPECS * currdnSpecs;
	if(Datas->Dn_Specs)
	{
		for(i=0; i<SKM_sk_num(DN_SPECS, Datas->Dn_Specs); i++)
		{
			currdnSpecs = SKM_sk_value(DN_SPECS, Datas->Dn_Specs, i);
			if(!currdnSpecs)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_dnSpecs.insert(m_dnSpecs.begin() + i);
			if(!m_dnSpecs[i].load_Datas(currdnSpecs))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Dn_Val_Disclaimer)
	{
		m_dnValDisclaimer = Datas->Dn_Val_Disclaimer;
	}
	if(Datas->Flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->Flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->MinKeyLen)
	{
		m_minkeylen = ASN1_INTEGER_GET(Datas->MinKeyLen);
	}
	if(Datas->MinPwdLen)
	{
		m_minpwdlen = ASN1_INTEGER_GET(Datas->MinPwdLen);
	}
	if(Datas->Policies)
	{
		for(i=0; i<SKM_sk_num(POLICY_VALUE, Datas->Policies); i++)
		{
			currpolicies = SKM_sk_value(POLICY_VALUE, Datas->Policies, i);
			if(!currpolicies)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_policies.insert(m_policies.begin() + i);
			if(!m_policies[i].load_Datas(currpolicies))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Site_Name)
	{
		m_siteName = Datas->Site_Name;
	}
	if(Datas->cas)
	{
		for(i=0; i<SKM_sk_num(ASN1_UTF8STRING, Datas->cas); i++)
		{
			currcas = SKM_sk_value(ASN1_UTF8STRING, Datas->cas, i);
			if(!currcas)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_cas.insert(m_cas.begin() + i);
			m_cas[i] = currcas;
		}
	}
	if(Datas->ldap_attr_name)
	{
		m_ldapAttrName = Datas->ldap_attr_name;
	}
	if(Datas->ldap_base)
	{
		m_ldapBase = Datas->ldap_base;
	}
	if(Datas->ldap_filters)
	{
		m_ldapFilters = Datas->ldap_filters;
	}
	if(Datas->ldap_password)
	{
		m_ldapPassword = Datas->ldap_password;
	}
	if(Datas->ldap_port)
	{
		m_ldapPort = ASN1_INTEGER_GET(Datas->ldap_port);
	}
	if(Datas->ldap_server)
	{
		m_ldapServer = Datas->ldap_server;
	}
	if(Datas->ldap_username)
	{
		m_ldapUsername = Datas->ldap_username;
	}
	if(Datas->ldap_utf8)
	{
		m_ldapUtf8 = ASN1_INTEGER_GET(Datas->ldap_utf8);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyEe0::give_Datas(ENTITY_CONF_BODY_EE_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_EE_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ASN1_UTF8STRING * currcas;
	POLICY_VALUE * currpolicies;
	DN_SPECS * currdnSpecs;
	size_t i;
	if(!(*Datas)->Dn_Specs && !((*Datas)->Dn_Specs = SKM_sk_new_null(DN_SPECS)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_dnSpecs.size() ; i++)
	{
		currdnSpecs = NULL;
		if(!m_dnSpecs[i].give_Datas(&currdnSpecs))
		{
			ASN1_item_free((ASN1_VALUE*)currdnSpecs, ASN1_ITEM_rptr(DN_SPECS));
			currdnSpecs = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(DN_SPECS, (*Datas)->Dn_Specs, currdnSpecs) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currdnSpecs, ASN1_ITEM_rptr(DN_SPECS));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->Dn_Val_Disclaimer && !((*Datas)->Dn_Val_Disclaimer = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_dnValDisclaimer.c_ASN1_UTF8STRING(&(*Datas)->Dn_Val_Disclaimer))
	{
		ASN1_UTF8STRING_free((*Datas)->Dn_Val_Disclaimer);
		(*Datas)->Dn_Val_Disclaimer = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_flags)
	{
		if((*Datas)->Flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->Flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->Flags)
		{
			(*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->Flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->MinKeyLen && !((*Datas)->MinKeyLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinKeyLen, m_minkeylen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinKeyLen);
		(*Datas)->MinKeyLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->MinPwdLen && !((*Datas)->MinPwdLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinPwdLen, m_minpwdlen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinPwdLen);
		(*Datas)->MinPwdLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Policies && !((*Datas)->Policies = SKM_sk_new_null(POLICY_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_policies.size() ; i++)
	{
		currpolicies = NULL;
		if(!m_policies[i].give_Datas(&currpolicies))
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			currpolicies = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(POLICY_VALUE, (*Datas)->Policies, currpolicies) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->Site_Name && !((*Datas)->Site_Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_siteName.c_ASN1_UTF8STRING(&(*Datas)->Site_Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Site_Name);
		(*Datas)->Site_Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->cas && !((*Datas)->cas = SKM_sk_new_null(ASN1_UTF8STRING)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_cas.size() ; i++)
	{
		currcas = NULL;
		if(!m_cas[i].c_ASN1_UTF8STRING(&currcas))
		{
			ASN1_UTF8STRING_free(currcas);
			currcas = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ASN1_UTF8STRING, (*Datas)->cas, currcas) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currcas, ASN1_ITEM_rptr(ASN1_UTF8STRING));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->ldap_attr_name && !((*Datas)->ldap_attr_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapAttrName.c_ASN1_UTF8STRING(&(*Datas)->ldap_attr_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_attr_name);
		(*Datas)->ldap_attr_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_base && !((*Datas)->ldap_base = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapBase.c_ASN1_UTF8STRING(&(*Datas)->ldap_base))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_base);
		(*Datas)->ldap_base = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_filters && !((*Datas)->ldap_filters = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapFilters.c_ASN1_UTF8STRING(&(*Datas)->ldap_filters))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_filters);
		(*Datas)->ldap_filters = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_password && !((*Datas)->ldap_password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapPassword.c_ASN1_UTF8STRING(&(*Datas)->ldap_password))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_password);
		(*Datas)->ldap_password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_port && !((*Datas)->ldap_port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_port, m_ldapPort) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_port);
		(*Datas)->ldap_port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_server && !((*Datas)->ldap_server = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapServer.c_ASN1_UTF8STRING(&(*Datas)->ldap_server))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_server);
		(*Datas)->ldap_server = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_username && !((*Datas)->ldap_username = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUsername.c_ASN1_UTF8STRING(&(*Datas)->ldap_username))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_username);
		(*Datas)->ldap_username = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_utf8 && !((*Datas)->ldap_utf8 = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_utf8, m_ldapUtf8) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_utf8);
		(*Datas)->ldap_utf8 = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBodyEe0::operator=(const EntityConfBodyEe0 & other)
{
	Clear();
	m_dnSpecs = other.m_dnSpecs;
	m_dnValDisclaimer = other.m_dnValDisclaimer;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_minkeylen = other.m_minkeylen;
	m_minpwdlen = other.m_minpwdlen;
	m_policies = other.m_policies;
	m_siteName = other.m_siteName;
	m_cas = other.m_cas;
	m_ldapAttrName = other.m_ldapAttrName;
	m_ldapBase = other.m_ldapBase;
	m_ldapFilters = other.m_ldapFilters;
	m_ldapPassword = other.m_ldapPassword;
	m_ldapPort = other.m_ldapPort;
	m_ldapServer = other.m_ldapServer;
	m_ldapUsername = other.m_ldapUsername;
	m_ldapUtf8 = other.m_ldapUtf8;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyEe0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE_0);
}
EntityConfBodyEe EntityConfBodyEe::EmptyInstance;
bool EntityConfBodyEe::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyEe::get_type() const
{
	 return m_type;
}

bool EntityConfBodyEe::set_conf0(const EntityConfBodyEe0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyEe0 & EntityConfBodyEe::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyEe0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyEe0 & EntityConfBodyEe::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyEe0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyEe::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyEe0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyEe::EntityConfBodyEe():NewPKIObject()
{
	resetAll();
}

EntityConfBodyEe::EntityConfBodyEe(const EntityConfBodyEe & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyEe::~EntityConfBodyEe()
{
	Clear();
}

void EntityConfBodyEe::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyEe::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
}

void EntityConfBodyEe::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
}

bool EntityConfBodyEe::load_Datas(const ENTITY_CONF_BODY_EE * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyEe::give_Datas(ENTITY_CONF_BODY_EE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_EE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_EE_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyEe::operator=(const EntityConfBodyEe & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyEe::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE);
}
PublicationMethodInfo PublicationMethodInfo::EmptyInstance;
bool PublicationMethodInfo::set_librarypath(const mString & c_librarypath)
{
	m_librarypath = c_librarypath;
	return true;
}

const mString & PublicationMethodInfo::get_librarypath() const
{
	return m_librarypath;
}

mString & PublicationMethodInfo::get_librarypath()
{
	return m_librarypath;
}

bool PublicationMethodInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & PublicationMethodInfo::get_name() const
{
	return m_name;
}

mString & PublicationMethodInfo::get_name()
{
	return m_name;
}

bool PublicationMethodInfo::set_options(const mVector< PlugOption > & c_options)
{
	m_options = c_options;
	return true;
}

const mVector< PlugOption > & PublicationMethodInfo::get_options() const
{
	return m_options;
}

mVector< PlugOption > & PublicationMethodInfo::get_options()
{
	return m_options;
}

bool PublicationMethodInfo::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long PublicationMethodInfo::get_type() const
{
	return m_type;
}

PublicationMethodInfo::PublicationMethodInfo():NewPKIObject()
{
	resetAll();
}

PublicationMethodInfo::PublicationMethodInfo(const PublicationMethodInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PublicationMethodInfo::~PublicationMethodInfo()
{
	Clear();
}

void PublicationMethodInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PublicationMethodInfo::freeAll()
{
}

void PublicationMethodInfo::resetAll()
{
	m_librarypath = "";
	m_name = "";
	m_options.clear();
	m_type = 0;
}

bool PublicationMethodInfo::load_Datas(const PUBLICATION_METHOD_INFO * Datas)
{
	Clear();
	int i;
	PLUG_OPTION * curroptions;
	if(Datas->LibraryPath)
	{
		m_librarypath = Datas->LibraryPath;
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->Options)
	{
		for(i=0; i<SKM_sk_num(PLUG_OPTION, Datas->Options); i++)
		{
			curroptions = SKM_sk_value(PLUG_OPTION, Datas->Options, i);
			if(!curroptions)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_options.insert(m_options.begin() + i);
			if(!m_options[i].load_Datas(curroptions))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Type)
	{
		m_type = ASN1_INTEGER_GET(Datas->Type);
	}
	m_isOk=true;
	return true;
}

bool PublicationMethodInfo::give_Datas(PUBLICATION_METHOD_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PUBLICATION_METHOD_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	PLUG_OPTION * curroptions;
	size_t i;
	if(!(*Datas)->LibraryPath && !((*Datas)->LibraryPath = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_librarypath.c_ASN1_UTF8STRING(&(*Datas)->LibraryPath))
	{
		ASN1_UTF8STRING_free((*Datas)->LibraryPath);
		(*Datas)->LibraryPath = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Options && !((*Datas)->Options = SKM_sk_new_null(PLUG_OPTION)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_options.size() ; i++)
	{
		curroptions = NULL;
		if(!m_options[i].give_Datas(&curroptions))
		{
			ASN1_item_free((ASN1_VALUE*)curroptions, ASN1_ITEM_rptr(PLUG_OPTION));
			curroptions = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PLUG_OPTION, (*Datas)->Options, curroptions) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curroptions, ASN1_ITEM_rptr(PLUG_OPTION));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->Type && !((*Datas)->Type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Type);
		(*Datas)->Type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool PublicationMethodInfo::operator=(const PublicationMethodInfo & other)
{
	Clear();
	m_librarypath = other.m_librarypath;
	m_name = other.m_name;
	m_options = other.m_options;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PublicationMethodInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PUBLICATION_METHOD_INFO);
}
PublicationEntry PublicationEntry::EmptyInstance;
bool PublicationEntry::set_caname(const mString & c_caname)
{
	m_caname = c_caname;
	return true;
}

const mString & PublicationEntry::get_caname() const
{
	return m_caname;
}

mString & PublicationEntry::get_caname()
{
	return m_caname;
}

bool PublicationEntry::set_methods(const mVector< PublicationMethodInfo > & c_methods)
{
	m_methods = c_methods;
	return true;
}

const mVector< PublicationMethodInfo > & PublicationEntry::get_methods() const
{
	return m_methods;
}

mVector< PublicationMethodInfo > & PublicationEntry::get_methods()
{
	return m_methods;
}

PublicationEntry::PublicationEntry():NewPKIObject()
{
	resetAll();
}

PublicationEntry::PublicationEntry(const PublicationEntry & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PublicationEntry::~PublicationEntry()
{
	Clear();
}

void PublicationEntry::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PublicationEntry::freeAll()
{
}

void PublicationEntry::resetAll()
{
	m_caname = "";
	m_methods.clear();
}

bool PublicationEntry::load_Datas(const PUBLICATION_ENTRY * Datas)
{
	Clear();
	int i;
	PUBLICATION_METHOD_INFO * currmethods;
	if(Datas->CaName)
	{
		m_caname = Datas->CaName;
	}
	if(Datas->Methods)
	{
		for(i=0; i<SKM_sk_num(PUBLICATION_METHOD_INFO, Datas->Methods); i++)
		{
			currmethods = SKM_sk_value(PUBLICATION_METHOD_INFO, Datas->Methods, i);
			if(!currmethods)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_methods.insert(m_methods.begin() + i);
			if(!m_methods[i].load_Datas(currmethods))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool PublicationEntry::give_Datas(PUBLICATION_ENTRY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PUBLICATION_ENTRY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	PUBLICATION_METHOD_INFO * currmethods;
	size_t i;
	if(!(*Datas)->CaName && !((*Datas)->CaName = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caname.c_ASN1_UTF8STRING(&(*Datas)->CaName))
	{
		ASN1_UTF8STRING_free((*Datas)->CaName);
		(*Datas)->CaName = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Methods && !((*Datas)->Methods = SKM_sk_new_null(PUBLICATION_METHOD_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_methods.size() ; i++)
	{
		currmethods = NULL;
		if(!m_methods[i].give_Datas(&currmethods))
		{
			ASN1_item_free((ASN1_VALUE*)currmethods, ASN1_ITEM_rptr(PUBLICATION_METHOD_INFO));
			currmethods = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PUBLICATION_METHOD_INFO, (*Datas)->Methods, currmethods) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currmethods, ASN1_ITEM_rptr(PUBLICATION_METHOD_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool PublicationEntry::operator=(const PublicationEntry & other)
{
	Clear();
	m_caname = other.m_caname;
	m_methods = other.m_methods;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PublicationEntry::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PUBLICATION_ENTRY);
}
EntityConfBodyPub0 EntityConfBodyPub0::EmptyInstance;
bool EntityConfBodyPub0::set_bindaddress(const mString & c_bindaddress)
{
	m_bindaddress = c_bindaddress;
	return true;
}

const mString & EntityConfBodyPub0::get_bindaddress() const
{
	return m_bindaddress;
}

mString & EntityConfBodyPub0::get_bindaddress()
{
	return m_bindaddress;
}

bool EntityConfBodyPub0::set_ocspenabled(unsigned long c_ocspenabled)
{
	m_ocspenabled = c_ocspenabled;
	return true;
}

unsigned long EntityConfBodyPub0::get_ocspenabled() const
{
	return m_ocspenabled;
}

bool EntityConfBodyPub0::set_port(unsigned long c_port)
{
	m_port = c_port;
	return true;
}

unsigned long EntityConfBodyPub0::get_port() const
{
	return m_port;
}

bool EntityConfBodyPub0::set_publications(const mVector< PublicationEntry > & c_publications)
{
	m_publications = c_publications;
	return true;
}

const mVector< PublicationEntry > & EntityConfBodyPub0::get_publications() const
{
	return m_publications;
}

mVector< PublicationEntry > & EntityConfBodyPub0::get_publications()
{
	return m_publications;
}

EntityConfBodyPub0::EntityConfBodyPub0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyPub0::EntityConfBodyPub0(const EntityConfBodyPub0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyPub0::~EntityConfBodyPub0()
{
	Clear();
}

void EntityConfBodyPub0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyPub0::freeAll()
{
}

void EntityConfBodyPub0::resetAll()
{
	m_bindaddress = "";
	m_ocspenabled = 0;
	m_port = 0;
	m_publications.clear();
}

bool EntityConfBodyPub0::load_Datas(const ENTITY_CONF_BODY_PUB_0 * Datas)
{
	Clear();
	int i;
	PUBLICATION_ENTRY * currpublications;
	if(Datas->BindAddress)
	{
		m_bindaddress = Datas->BindAddress;
	}
	if(Datas->OcspEnabled)
	{
		m_ocspenabled = ASN1_INTEGER_GET(Datas->OcspEnabled);
	}
	if(Datas->Port)
	{
		m_port = ASN1_INTEGER_GET(Datas->Port);
	}
	if(Datas->Publications)
	{
		for(i=0; i<SKM_sk_num(PUBLICATION_ENTRY, Datas->Publications); i++)
		{
			currpublications = SKM_sk_value(PUBLICATION_ENTRY, Datas->Publications, i);
			if(!currpublications)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_publications.insert(m_publications.begin() + i);
			if(!m_publications[i].load_Datas(currpublications))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyPub0::give_Datas(ENTITY_CONF_BODY_PUB_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_PUB_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	PUBLICATION_ENTRY * currpublications;
	size_t i;
	if(!(*Datas)->BindAddress && !((*Datas)->BindAddress = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_bindaddress.c_ASN1_UTF8STRING(&(*Datas)->BindAddress))
	{
		ASN1_UTF8STRING_free((*Datas)->BindAddress);
		(*Datas)->BindAddress = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->OcspEnabled && !((*Datas)->OcspEnabled = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->OcspEnabled, m_ocspenabled) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->OcspEnabled);
		(*Datas)->OcspEnabled = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Port && !((*Datas)->Port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Port, m_port) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Port);
		(*Datas)->Port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Publications && !((*Datas)->Publications = SKM_sk_new_null(PUBLICATION_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_publications.size() ; i++)
	{
		currpublications = NULL;
		if(!m_publications[i].give_Datas(&currpublications))
		{
			ASN1_item_free((ASN1_VALUE*)currpublications, ASN1_ITEM_rptr(PUBLICATION_ENTRY));
			currpublications = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PUBLICATION_ENTRY, (*Datas)->Publications, currpublications) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currpublications, ASN1_ITEM_rptr(PUBLICATION_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool EntityConfBodyPub0::operator=(const EntityConfBodyPub0 & other)
{
	Clear();
	m_bindaddress = other.m_bindaddress;
	m_ocspenabled = other.m_ocspenabled;
	m_port = other.m_port;
	m_publications = other.m_publications;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyPub0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB_0);
}
EntityConfBodyPub EntityConfBodyPub::EmptyInstance;
bool EntityConfBodyPub::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyPub::get_type() const
{
	 return m_type;
}

bool EntityConfBodyPub::set_conf0(const EntityConfBodyPub0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyPub0 & EntityConfBodyPub::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyPub0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyPub0 & EntityConfBodyPub::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyPub0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyPub::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyPub0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyPub::EntityConfBodyPub():NewPKIObject()
{
	resetAll();
}

EntityConfBodyPub::EntityConfBodyPub(const EntityConfBodyPub & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyPub::~EntityConfBodyPub()
{
	Clear();
}

void EntityConfBodyPub::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyPub::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
}

void EntityConfBodyPub::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
}

bool EntityConfBodyPub::load_Datas(const ENTITY_CONF_BODY_PUB * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyPub::give_Datas(ENTITY_CONF_BODY_PUB ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_PUB*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_PUB_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyPub::operator=(const EntityConfBodyPub & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyPub::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB);
}
EntityConfBodyRa0 EntityConfBodyRa0::EmptyInstance;
bool EntityConfBodyRa0::set_dnspecs(const mVector< DnSpecs > & c_dnspecs)
{
	m_dnspecs = c_dnspecs;
	return true;
}

const mVector< DnSpecs > & EntityConfBodyRa0::get_dnspecs() const
{
	return m_dnspecs;
}

mVector< DnSpecs > & EntityConfBodyRa0::get_dnspecs()
{
	return m_dnspecs;
}

bool EntityConfBodyRa0::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * EntityConfBodyRa0::get_flags() const
{
	if(!m_flags)
		((EntityConfBodyRa0*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * EntityConfBodyRa0::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool EntityConfBodyRa0::set_minkeylen(unsigned long c_minkeylen)
{
	m_minkeylen = c_minkeylen;
	return true;
}

unsigned long EntityConfBodyRa0::get_minkeylen() const
{
	return m_minkeylen;
}

bool EntityConfBodyRa0::set_minpwdlen(unsigned long c_minpwdlen)
{
	m_minpwdlen = c_minpwdlen;
	return true;
}

unsigned long EntityConfBodyRa0::get_minpwdlen() const
{
	return m_minpwdlen;
}

bool EntityConfBodyRa0::set_policies(const mVector< PolicyValue > & c_policies)
{
	m_policies = c_policies;
	return true;
}

const mVector< PolicyValue > & EntityConfBodyRa0::get_policies() const
{
	return m_policies;
}

mVector< PolicyValue > & EntityConfBodyRa0::get_policies()
{
	return m_policies;
}

bool EntityConfBodyRa0::set_defaultValidity(unsigned long c_defaultValidity)
{
	m_defaultValidity = c_defaultValidity;
	return true;
}

unsigned long EntityConfBodyRa0::get_defaultValidity() const
{
	return m_defaultValidity;
}

bool EntityConfBodyRa0::set_ldapAttrName(const mString & c_ldapAttrName)
{
	m_ldapAttrName = c_ldapAttrName;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapAttrName() const
{
	return m_ldapAttrName;
}

mString & EntityConfBodyRa0::get_ldapAttrName()
{
	return m_ldapAttrName;
}

bool EntityConfBodyRa0::set_ldapBase(const mString & c_ldapBase)
{
	m_ldapBase = c_ldapBase;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapBase() const
{
	return m_ldapBase;
}

mString & EntityConfBodyRa0::get_ldapBase()
{
	return m_ldapBase;
}

bool EntityConfBodyRa0::set_ldapFilters(const mString & c_ldapFilters)
{
	m_ldapFilters = c_ldapFilters;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapFilters() const
{
	return m_ldapFilters;
}

mString & EntityConfBodyRa0::get_ldapFilters()
{
	return m_ldapFilters;
}

bool EntityConfBodyRa0::set_ldapPassword(const mString & c_ldapPassword)
{
	m_ldapPassword = c_ldapPassword;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapPassword() const
{
	return m_ldapPassword;
}

mString & EntityConfBodyRa0::get_ldapPassword()
{
	return m_ldapPassword;
}

bool EntityConfBodyRa0::set_ldapPort(unsigned long c_ldapPort)
{
	m_ldapPort = c_ldapPort;
	return true;
}

unsigned long EntityConfBodyRa0::get_ldapPort() const
{
	return m_ldapPort;
}

bool EntityConfBodyRa0::set_ldapProfilesGroup(unsigned long c_ldapProfilesGroup)
{
	m_ldapProfilesGroup = c_ldapProfilesGroup;
	return true;
}

unsigned long EntityConfBodyRa0::get_ldapProfilesGroup() const
{
	return m_ldapProfilesGroup;
}

bool EntityConfBodyRa0::set_ldapServer(const mString & c_ldapServer)
{
	m_ldapServer = c_ldapServer;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapServer() const
{
	return m_ldapServer;
}

mString & EntityConfBodyRa0::get_ldapServer()
{
	return m_ldapServer;
}

bool EntityConfBodyRa0::set_ldapUsername(const mString & c_ldapUsername)
{
	m_ldapUsername = c_ldapUsername;
	return true;
}

const mString & EntityConfBodyRa0::get_ldapUsername() const
{
	return m_ldapUsername;
}

mString & EntityConfBodyRa0::get_ldapUsername()
{
	return m_ldapUsername;
}

bool EntityConfBodyRa0::set_ldapUtf8(unsigned long c_ldapUtf8)
{
	m_ldapUtf8 = c_ldapUtf8;
	return true;
}

unsigned long EntityConfBodyRa0::get_ldapUtf8() const
{
	return m_ldapUtf8;
}

EntityConfBodyRa0::EntityConfBodyRa0():NewPKIObject()
{
	resetAll();
}

EntityConfBodyRa0::EntityConfBodyRa0(const EntityConfBodyRa0 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyRa0::~EntityConfBodyRa0()
{
	Clear();
}

void EntityConfBodyRa0::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyRa0::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void EntityConfBodyRa0::resetAll()
{
	m_dnspecs.clear();
	m_flags = NULL;
	m_minkeylen = 0;
	m_minpwdlen = 0;
	m_policies.clear();
	m_defaultValidity = 0;
	m_ldapAttrName = "";
	m_ldapBase = "";
	m_ldapFilters = "";
	m_ldapPassword = "";
	m_ldapPort = 0;
	m_ldapProfilesGroup = 0;
	m_ldapServer = "";
	m_ldapUsername = "";
	m_ldapUtf8 = 0;
}

bool EntityConfBodyRa0::load_Datas(const ENTITY_CONF_BODY_RA_0 * Datas)
{
	Clear();
	POLICY_VALUE * currpolicies;
	int i;
	DN_SPECS * currdnspecs;
	if(Datas->DnSpecs)
	{
		for(i=0; i<SKM_sk_num(DN_SPECS, Datas->DnSpecs); i++)
		{
			currdnspecs = SKM_sk_value(DN_SPECS, Datas->DnSpecs, i);
			if(!currdnspecs)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_dnspecs.insert(m_dnspecs.begin() + i);
			if(!m_dnspecs[i].load_Datas(currdnspecs))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->Flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->MinKeyLen)
	{
		m_minkeylen = ASN1_INTEGER_GET(Datas->MinKeyLen);
	}
	if(Datas->MinPwdLen)
	{
		m_minpwdlen = ASN1_INTEGER_GET(Datas->MinPwdLen);
	}
	if(Datas->Policies)
	{
		for(i=0; i<SKM_sk_num(POLICY_VALUE, Datas->Policies); i++)
		{
			currpolicies = SKM_sk_value(POLICY_VALUE, Datas->Policies, i);
			if(!currpolicies)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_policies.insert(m_policies.begin() + i);
			if(!m_policies[i].load_Datas(currpolicies))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->default_validity)
	{
		m_defaultValidity = ASN1_INTEGER_GET(Datas->default_validity);
	}
	if(Datas->ldap_attr_name)
	{
		m_ldapAttrName = Datas->ldap_attr_name;
	}
	if(Datas->ldap_base)
	{
		m_ldapBase = Datas->ldap_base;
	}
	if(Datas->ldap_filters)
	{
		m_ldapFilters = Datas->ldap_filters;
	}
	if(Datas->ldap_password)
	{
		m_ldapPassword = Datas->ldap_password;
	}
	if(Datas->ldap_port)
	{
		m_ldapPort = ASN1_INTEGER_GET(Datas->ldap_port);
	}
	if(Datas->ldap_profiles_group)
	{
		m_ldapProfilesGroup = ASN1_INTEGER_GET(Datas->ldap_profiles_group);
	}
	if(Datas->ldap_server)
	{
		m_ldapServer = Datas->ldap_server;
	}
	if(Datas->ldap_username)
	{
		m_ldapUsername = Datas->ldap_username;
	}
	if(Datas->ldap_utf8)
	{
		m_ldapUtf8 = ASN1_INTEGER_GET(Datas->ldap_utf8);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyRa0::give_Datas(ENTITY_CONF_BODY_RA_0 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_RA_0*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	POLICY_VALUE * currpolicies;
	DN_SPECS * currdnspecs;
	size_t i;
	if(!(*Datas)->DnSpecs && !((*Datas)->DnSpecs = SKM_sk_new_null(DN_SPECS)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_dnspecs.size() ; i++)
	{
		currdnspecs = NULL;
		if(!m_dnspecs[i].give_Datas(&currdnspecs))
		{
			ASN1_item_free((ASN1_VALUE*)currdnspecs, ASN1_ITEM_rptr(DN_SPECS));
			currdnspecs = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(DN_SPECS, (*Datas)->DnSpecs, currdnspecs) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currdnspecs, ASN1_ITEM_rptr(DN_SPECS));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_flags)
	{
		if((*Datas)->Flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->Flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->Flags)
		{
			(*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->Flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->MinKeyLen && !((*Datas)->MinKeyLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinKeyLen, m_minkeylen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinKeyLen);
		(*Datas)->MinKeyLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->MinPwdLen && !((*Datas)->MinPwdLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinPwdLen, m_minpwdlen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinPwdLen);
		(*Datas)->MinPwdLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Policies && !((*Datas)->Policies = SKM_sk_new_null(POLICY_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_policies.size() ; i++)
	{
		currpolicies = NULL;
		if(!m_policies[i].give_Datas(&currpolicies))
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			currpolicies = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(POLICY_VALUE, (*Datas)->Policies, currpolicies) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->default_validity && !((*Datas)->default_validity = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->default_validity, m_defaultValidity) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->default_validity);
		(*Datas)->default_validity = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_attr_name && !((*Datas)->ldap_attr_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapAttrName.c_ASN1_UTF8STRING(&(*Datas)->ldap_attr_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_attr_name);
		(*Datas)->ldap_attr_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_base && !((*Datas)->ldap_base = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapBase.c_ASN1_UTF8STRING(&(*Datas)->ldap_base))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_base);
		(*Datas)->ldap_base = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_filters && !((*Datas)->ldap_filters = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapFilters.c_ASN1_UTF8STRING(&(*Datas)->ldap_filters))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_filters);
		(*Datas)->ldap_filters = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_password && !((*Datas)->ldap_password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapPassword.c_ASN1_UTF8STRING(&(*Datas)->ldap_password))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_password);
		(*Datas)->ldap_password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_port && !((*Datas)->ldap_port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_port, m_ldapPort) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_port);
		(*Datas)->ldap_port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_profiles_group && !((*Datas)->ldap_profiles_group = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_profiles_group, m_ldapProfilesGroup) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_profiles_group);
		(*Datas)->ldap_profiles_group = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_server && !((*Datas)->ldap_server = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapServer.c_ASN1_UTF8STRING(&(*Datas)->ldap_server))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_server);
		(*Datas)->ldap_server = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_username && !((*Datas)->ldap_username = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUsername.c_ASN1_UTF8STRING(&(*Datas)->ldap_username))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_username);
		(*Datas)->ldap_username = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_utf8 && !((*Datas)->ldap_utf8 = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_utf8, m_ldapUtf8) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_utf8);
		(*Datas)->ldap_utf8 = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBodyRa0::operator=(const EntityConfBodyRa0 & other)
{
	Clear();
	m_dnspecs = other.m_dnspecs;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_minkeylen = other.m_minkeylen;
	m_minpwdlen = other.m_minpwdlen;
	m_policies = other.m_policies;
	m_defaultValidity = other.m_defaultValidity;
	m_ldapAttrName = other.m_ldapAttrName;
	m_ldapBase = other.m_ldapBase;
	m_ldapFilters = other.m_ldapFilters;
	m_ldapPassword = other.m_ldapPassword;
	m_ldapPort = other.m_ldapPort;
	m_ldapProfilesGroup = other.m_ldapProfilesGroup;
	m_ldapServer = other.m_ldapServer;
	m_ldapUsername = other.m_ldapUsername;
	m_ldapUtf8 = other.m_ldapUtf8;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyRa0::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_0);
}
EntityConfBodyRa1 EntityConfBodyRa1::EmptyInstance;
bool EntityConfBodyRa1::set_dnspecs(const mVector< DnSpecs > & c_dnspecs)
{
	m_dnspecs = c_dnspecs;
	return true;
}

const mVector< DnSpecs > & EntityConfBodyRa1::get_dnspecs() const
{
	return m_dnspecs;
}

mVector< DnSpecs > & EntityConfBodyRa1::get_dnspecs()
{
	return m_dnspecs;
}

bool EntityConfBodyRa1::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * EntityConfBodyRa1::get_flags() const
{
	if(!m_flags)
		((EntityConfBodyRa1*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * EntityConfBodyRa1::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool EntityConfBodyRa1::set_minkeylen(unsigned long c_minkeylen)
{
	m_minkeylen = c_minkeylen;
	return true;
}

unsigned long EntityConfBodyRa1::get_minkeylen() const
{
	return m_minkeylen;
}

bool EntityConfBodyRa1::set_minpwdlen(unsigned long c_minpwdlen)
{
	m_minpwdlen = c_minpwdlen;
	return true;
}

unsigned long EntityConfBodyRa1::get_minpwdlen() const
{
	return m_minpwdlen;
}

bool EntityConfBodyRa1::set_policies(const mVector< PolicyValue > & c_policies)
{
	m_policies = c_policies;
	return true;
}

const mVector< PolicyValue > & EntityConfBodyRa1::get_policies() const
{
	return m_policies;
}

mVector< PolicyValue > & EntityConfBodyRa1::get_policies()
{
	return m_policies;
}

bool EntityConfBodyRa1::set_defaultValidity(unsigned long c_defaultValidity)
{
	m_defaultValidity = c_defaultValidity;
	return true;
}

unsigned long EntityConfBodyRa1::get_defaultValidity() const
{
	return m_defaultValidity;
}

bool EntityConfBodyRa1::set_eeProfilesGroup(unsigned long c_eeProfilesGroup)
{
	m_eeProfilesGroup = c_eeProfilesGroup;
	return true;
}

unsigned long EntityConfBodyRa1::get_eeProfilesGroup() const
{
	return m_eeProfilesGroup;
}

bool EntityConfBodyRa1::set_ldapAttrName(const mString & c_ldapAttrName)
{
	m_ldapAttrName = c_ldapAttrName;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapAttrName() const
{
	return m_ldapAttrName;
}

mString & EntityConfBodyRa1::get_ldapAttrName()
{
	return m_ldapAttrName;
}

bool EntityConfBodyRa1::set_ldapBase(const mString & c_ldapBase)
{
	m_ldapBase = c_ldapBase;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapBase() const
{
	return m_ldapBase;
}

mString & EntityConfBodyRa1::get_ldapBase()
{
	return m_ldapBase;
}

bool EntityConfBodyRa1::set_ldapFilters(const mString & c_ldapFilters)
{
	m_ldapFilters = c_ldapFilters;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapFilters() const
{
	return m_ldapFilters;
}

mString & EntityConfBodyRa1::get_ldapFilters()
{
	return m_ldapFilters;
}

bool EntityConfBodyRa1::set_ldapPassword(const mString & c_ldapPassword)
{
	m_ldapPassword = c_ldapPassword;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapPassword() const
{
	return m_ldapPassword;
}

mString & EntityConfBodyRa1::get_ldapPassword()
{
	return m_ldapPassword;
}

bool EntityConfBodyRa1::set_ldapPort(unsigned long c_ldapPort)
{
	m_ldapPort = c_ldapPort;
	return true;
}

unsigned long EntityConfBodyRa1::get_ldapPort() const
{
	return m_ldapPort;
}

bool EntityConfBodyRa1::set_ldapProfilesGroup(unsigned long c_ldapProfilesGroup)
{
	m_ldapProfilesGroup = c_ldapProfilesGroup;
	return true;
}

unsigned long EntityConfBodyRa1::get_ldapProfilesGroup() const
{
	return m_ldapProfilesGroup;
}

bool EntityConfBodyRa1::set_ldapServer(const mString & c_ldapServer)
{
	m_ldapServer = c_ldapServer;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapServer() const
{
	return m_ldapServer;
}

mString & EntityConfBodyRa1::get_ldapServer()
{
	return m_ldapServer;
}

bool EntityConfBodyRa1::set_ldapUsername(const mString & c_ldapUsername)
{
	m_ldapUsername = c_ldapUsername;
	return true;
}

const mString & EntityConfBodyRa1::get_ldapUsername() const
{
	return m_ldapUsername;
}

mString & EntityConfBodyRa1::get_ldapUsername()
{
	return m_ldapUsername;
}

bool EntityConfBodyRa1::set_ldapUtf8(unsigned long c_ldapUtf8)
{
	m_ldapUtf8 = c_ldapUtf8;
	return true;
}

unsigned long EntityConfBodyRa1::get_ldapUtf8() const
{
	return m_ldapUtf8;
}

EntityConfBodyRa1::EntityConfBodyRa1():NewPKIObject()
{
	resetAll();
}

EntityConfBodyRa1::EntityConfBodyRa1(const EntityConfBodyRa1 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyRa1::~EntityConfBodyRa1()
{
	Clear();
}

void EntityConfBodyRa1::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyRa1::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void EntityConfBodyRa1::resetAll()
{
	m_dnspecs.clear();
	m_flags = NULL;
	m_minkeylen = 0;
	m_minpwdlen = 0;
	m_policies.clear();
	m_defaultValidity = 0;
	m_eeProfilesGroup = 0;
	m_ldapAttrName = "";
	m_ldapBase = "";
	m_ldapFilters = "";
	m_ldapPassword = "";
	m_ldapPort = 0;
	m_ldapProfilesGroup = 0;
	m_ldapServer = "";
	m_ldapUsername = "";
	m_ldapUtf8 = 0;
}

bool EntityConfBodyRa1::load_Datas(const ENTITY_CONF_BODY_RA_1 * Datas)
{
	Clear();
	POLICY_VALUE * currpolicies;
	int i;
	DN_SPECS * currdnspecs;
	if(Datas->DnSpecs)
	{
		for(i=0; i<SKM_sk_num(DN_SPECS, Datas->DnSpecs); i++)
		{
			currdnspecs = SKM_sk_value(DN_SPECS, Datas->DnSpecs, i);
			if(!currdnspecs)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_dnspecs.insert(m_dnspecs.begin() + i);
			if(!m_dnspecs[i].load_Datas(currdnspecs))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->Flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->MinKeyLen)
	{
		m_minkeylen = ASN1_INTEGER_GET(Datas->MinKeyLen);
	}
	if(Datas->MinPwdLen)
	{
		m_minpwdlen = ASN1_INTEGER_GET(Datas->MinPwdLen);
	}
	if(Datas->Policies)
	{
		for(i=0; i<SKM_sk_num(POLICY_VALUE, Datas->Policies); i++)
		{
			currpolicies = SKM_sk_value(POLICY_VALUE, Datas->Policies, i);
			if(!currpolicies)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_policies.insert(m_policies.begin() + i);
			if(!m_policies[i].load_Datas(currpolicies))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->default_validity)
	{
		m_defaultValidity = ASN1_INTEGER_GET(Datas->default_validity);
	}
	if(Datas->ee_profiles_group)
	{
		m_eeProfilesGroup = ASN1_INTEGER_GET(Datas->ee_profiles_group);
	}
	if(Datas->ldap_attr_name)
	{
		m_ldapAttrName = Datas->ldap_attr_name;
	}
	if(Datas->ldap_base)
	{
		m_ldapBase = Datas->ldap_base;
	}
	if(Datas->ldap_filters)
	{
		m_ldapFilters = Datas->ldap_filters;
	}
	if(Datas->ldap_password)
	{
		m_ldapPassword = Datas->ldap_password;
	}
	if(Datas->ldap_port)
	{
		m_ldapPort = ASN1_INTEGER_GET(Datas->ldap_port);
	}
	if(Datas->ldap_profiles_group)
	{
		m_ldapProfilesGroup = ASN1_INTEGER_GET(Datas->ldap_profiles_group);
	}
	if(Datas->ldap_server)
	{
		m_ldapServer = Datas->ldap_server;
	}
	if(Datas->ldap_username)
	{
		m_ldapUsername = Datas->ldap_username;
	}
	if(Datas->ldap_utf8)
	{
		m_ldapUtf8 = ASN1_INTEGER_GET(Datas->ldap_utf8);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyRa1::give_Datas(ENTITY_CONF_BODY_RA_1 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_RA_1*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	POLICY_VALUE * currpolicies;
	DN_SPECS * currdnspecs;
	size_t i;
	if(!(*Datas)->DnSpecs && !((*Datas)->DnSpecs = SKM_sk_new_null(DN_SPECS)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_dnspecs.size() ; i++)
	{
		currdnspecs = NULL;
		if(!m_dnspecs[i].give_Datas(&currdnspecs))
		{
			ASN1_item_free((ASN1_VALUE*)currdnspecs, ASN1_ITEM_rptr(DN_SPECS));
			currdnspecs = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(DN_SPECS, (*Datas)->DnSpecs, currdnspecs) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currdnspecs, ASN1_ITEM_rptr(DN_SPECS));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_flags)
	{
		if((*Datas)->Flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->Flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->Flags)
		{
			(*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->Flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->MinKeyLen && !((*Datas)->MinKeyLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinKeyLen, m_minkeylen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinKeyLen);
		(*Datas)->MinKeyLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->MinPwdLen && !((*Datas)->MinPwdLen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->MinPwdLen, m_minpwdlen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->MinPwdLen);
		(*Datas)->MinPwdLen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Policies && !((*Datas)->Policies = SKM_sk_new_null(POLICY_VALUE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_policies.size() ; i++)
	{
		currpolicies = NULL;
		if(!m_policies[i].give_Datas(&currpolicies))
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			currpolicies = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(POLICY_VALUE, (*Datas)->Policies, currpolicies) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currpolicies, ASN1_ITEM_rptr(POLICY_VALUE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->default_validity && !((*Datas)->default_validity = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->default_validity, m_defaultValidity) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->default_validity);
		(*Datas)->default_validity = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ee_profiles_group && !((*Datas)->ee_profiles_group = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ee_profiles_group, m_eeProfilesGroup) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ee_profiles_group);
		(*Datas)->ee_profiles_group = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_attr_name && !((*Datas)->ldap_attr_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapAttrName.c_ASN1_UTF8STRING(&(*Datas)->ldap_attr_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_attr_name);
		(*Datas)->ldap_attr_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_base && !((*Datas)->ldap_base = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapBase.c_ASN1_UTF8STRING(&(*Datas)->ldap_base))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_base);
		(*Datas)->ldap_base = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_filters && !((*Datas)->ldap_filters = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapFilters.c_ASN1_UTF8STRING(&(*Datas)->ldap_filters))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_filters);
		(*Datas)->ldap_filters = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_password && !((*Datas)->ldap_password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapPassword.c_ASN1_UTF8STRING(&(*Datas)->ldap_password))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_password);
		(*Datas)->ldap_password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_port && !((*Datas)->ldap_port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_port, m_ldapPort) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_port);
		(*Datas)->ldap_port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_profiles_group && !((*Datas)->ldap_profiles_group = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_profiles_group, m_ldapProfilesGroup) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_profiles_group);
		(*Datas)->ldap_profiles_group = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_server && !((*Datas)->ldap_server = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapServer.c_ASN1_UTF8STRING(&(*Datas)->ldap_server))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_server);
		(*Datas)->ldap_server = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_username && !((*Datas)->ldap_username = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUsername.c_ASN1_UTF8STRING(&(*Datas)->ldap_username))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_username);
		(*Datas)->ldap_username = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_utf8 && !((*Datas)->ldap_utf8 = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ldap_utf8, m_ldapUtf8) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ldap_utf8);
		(*Datas)->ldap_utf8 = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBodyRa1::operator=(const EntityConfBodyRa1 & other)
{
	Clear();
	m_dnspecs = other.m_dnspecs;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_minkeylen = other.m_minkeylen;
	m_minpwdlen = other.m_minpwdlen;
	m_policies = other.m_policies;
	m_defaultValidity = other.m_defaultValidity;
	m_eeProfilesGroup = other.m_eeProfilesGroup;
	m_ldapAttrName = other.m_ldapAttrName;
	m_ldapBase = other.m_ldapBase;
	m_ldapFilters = other.m_ldapFilters;
	m_ldapPassword = other.m_ldapPassword;
	m_ldapPort = other.m_ldapPort;
	m_ldapProfilesGroup = other.m_ldapProfilesGroup;
	m_ldapServer = other.m_ldapServer;
	m_ldapUsername = other.m_ldapUsername;
	m_ldapUtf8 = other.m_ldapUtf8;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyRa1::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_1);
}
EntityConfBodyRa EntityConfBodyRa::EmptyInstance;
bool EntityConfBodyRa::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBodyRa::get_type() const
{
	 return m_type;
}

bool EntityConfBodyRa::set_conf0(const EntityConfBodyRa0 & c_conf0)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf0) = c_conf0;
	m_isOk=true;
	return true;
}

const EntityConfBodyRa0 & EntityConfBodyRa::get_conf0() const
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyRa0::EmptyInstance;
	}
	return (*m_conf0);
}

EntityConfBodyRa0 & EntityConfBodyRa::get_conf0()
{
	if((m_type != 0) || !m_conf0)
	{
		return EntityConfBodyRa0::EmptyInstance;
	}
	return (*m_conf0);
}

bool EntityConfBodyRa::set_conf1(const EntityConfBodyRa1 & c_conf1)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf1) = c_conf1;
	m_isOk=true;
	return true;
}

const EntityConfBodyRa1 & EntityConfBodyRa::get_conf1() const
{
	if((m_type != 1) || !m_conf1)
	{
		return EntityConfBodyRa1::EmptyInstance;
	}
	return (*m_conf1);
}

EntityConfBodyRa1 & EntityConfBodyRa::get_conf1()
{
	if((m_type != 1) || !m_conf1)
	{
		return EntityConfBodyRa1::EmptyInstance;
	}
	return (*m_conf1);
}

bool EntityConfBodyRa::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_conf0 = new EntityConfBodyRa0();
			if(!m_conf0)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_conf1 = new EntityConfBodyRa1();
			if(!m_conf1)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBodyRa::EntityConfBodyRa():NewPKIObject()
{
	resetAll();
}

EntityConfBodyRa::EntityConfBodyRa(const EntityConfBodyRa & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBodyRa::~EntityConfBodyRa()
{
	Clear();
}

void EntityConfBodyRa::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBodyRa::freeAll()
{
	if(m_conf0)
	{
		delete m_conf0;
	}
	if(m_conf1)
	{
		delete m_conf1;
	}
}

void EntityConfBodyRa::resetAll()
{
	m_type = -1;
	m_conf0 = NULL;
	m_conf1 = NULL;
}

bool EntityConfBodyRa::load_Datas(const ENTITY_CONF_BODY_RA * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.conf0)
			{
				if(!(*m_conf0).load_Datas(Datas->d.conf0))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.conf1)
			{
				if(!(*m_conf1).load_Datas(Datas->d.conf1))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBodyRa::give_Datas(ENTITY_CONF_BODY_RA ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY_RA*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.conf0 = (ENTITY_CONF_BODY_RA_0*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_0))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf0).give_Datas(&(*Datas)->d.conf0))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf0, ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_0));
				(*Datas)->d.conf0 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.conf1 = (ENTITY_CONF_BODY_RA_1*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_1))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf1).give_Datas(&(*Datas)->d.conf1))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf1, ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA_1));
				(*Datas)->d.conf1 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBodyRa::operator=(const EntityConfBodyRa & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_conf0)
				break;
			(*m_conf0) = *(other.m_conf0);
			break;
		case 1:
			if(!other.m_conf1)
				break;
			(*m_conf1) = *(other.m_conf1);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBodyRa::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA);
}
EntityConfBody EntityConfBody::EmptyInstance;
bool EntityConfBody::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int EntityConfBody::get_type() const
{
	 return m_type;
}

bool EntityConfBody::set_caConf(const EntityConfBodyCa & c_caConf)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_caConf) = c_caConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyCa & EntityConfBody::get_caConf() const
{
	if((m_type != 1) || !m_caConf)
	{
		return EntityConfBodyCa::EmptyInstance;
	}
	return (*m_caConf);
}

EntityConfBodyCa & EntityConfBody::get_caConf()
{
	if((m_type != 1) || !m_caConf)
	{
		return EntityConfBodyCa::EmptyInstance;
	}
	return (*m_caConf);
}

bool EntityConfBody::set_conf(const Asn1OctetString & c_conf)
{
	if(m_type != 4 && m_type != 6)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf) = c_conf;
	m_isOk=true;
	return true;
}

const Asn1OctetString & EntityConfBody::get_conf() const
{
	if((m_type != 4 && m_type != 6) || !m_conf)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_conf);
}

Asn1OctetString & EntityConfBody::get_conf()
{
	if((m_type != 4 && m_type != 6) || !m_conf)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_conf);
}

bool EntityConfBody::set_eeConf(const EntityConfBodyEe & c_eeConf)
{
	if(m_type != 7)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeConf) = c_eeConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyEe & EntityConfBody::get_eeConf() const
{
	if((m_type != 7) || !m_eeConf)
	{
		return EntityConfBodyEe::EmptyInstance;
	}
	return (*m_eeConf);
}

EntityConfBodyEe & EntityConfBody::get_eeConf()
{
	if((m_type != 7) || !m_eeConf)
	{
		return EntityConfBodyEe::EmptyInstance;
	}
	return (*m_eeConf);
}

bool EntityConfBody::set_pkiConf(const EntityConfBodyPki & c_pkiConf)
{
	if(m_type != 5)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_pkiConf) = c_pkiConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyPki & EntityConfBody::get_pkiConf() const
{
	if((m_type != 5) || !m_pkiConf)
	{
		return EntityConfBodyPki::EmptyInstance;
	}
	return (*m_pkiConf);
}

EntityConfBodyPki & EntityConfBody::get_pkiConf()
{
	if((m_type != 5) || !m_pkiConf)
	{
		return EntityConfBodyPki::EmptyInstance;
	}
	return (*m_pkiConf);
}

bool EntityConfBody::set_pubConf(const EntityConfBodyPub & c_pubConf)
{
	if(m_type != 3)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_pubConf) = c_pubConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyPub & EntityConfBody::get_pubConf() const
{
	if((m_type != 3) || !m_pubConf)
	{
		return EntityConfBodyPub::EmptyInstance;
	}
	return (*m_pubConf);
}

EntityConfBodyPub & EntityConfBody::get_pubConf()
{
	if((m_type != 3) || !m_pubConf)
	{
		return EntityConfBodyPub::EmptyInstance;
	}
	return (*m_pubConf);
}

bool EntityConfBody::set_raConf(const EntityConfBodyRa & c_raConf)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_raConf) = c_raConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyRa & EntityConfBody::get_raConf() const
{
	if((m_type != 0) || !m_raConf)
	{
		return EntityConfBodyRa::EmptyInstance;
	}
	return (*m_raConf);
}

EntityConfBodyRa & EntityConfBody::get_raConf()
{
	if((m_type != 0) || !m_raConf)
	{
		return EntityConfBodyRa::EmptyInstance;
	}
	return (*m_raConf);
}

bool EntityConfBody::set_repConf(const EntityConfBodyRep & c_repConf)
{
	if(m_type != 2)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_repConf) = c_repConf;
	m_isOk=true;
	return true;
}

const EntityConfBodyRep & EntityConfBody::get_repConf() const
{
	if((m_type != 2) || !m_repConf)
	{
		return EntityConfBodyRep::EmptyInstance;
	}
	return (*m_repConf);
}

EntityConfBodyRep & EntityConfBody::get_repConf()
{
	if((m_type != 2) || !m_repConf)
	{
		return EntityConfBodyRep::EmptyInstance;
	}
	return (*m_repConf);
}

bool EntityConfBody::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 1:
			m_caConf = new EntityConfBodyCa();
			if(!m_caConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 4:
		case 6:
			m_conf = new Asn1OctetString();
			if(!m_conf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 7:
			m_eeConf = new EntityConfBodyEe();
			if(!m_eeConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 5:
			m_pkiConf = new EntityConfBodyPki();
			if(!m_pkiConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 3:
			m_pubConf = new EntityConfBodyPub();
			if(!m_pubConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 0:
			m_raConf = new EntityConfBodyRa();
			if(!m_raConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
			m_repConf = new EntityConfBodyRep();
			if(!m_repConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

EntityConfBody::EntityConfBody():NewPKIObject()
{
	resetAll();
}

EntityConfBody::EntityConfBody(const EntityConfBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfBody::~EntityConfBody()
{
	Clear();
}

void EntityConfBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBody::freeAll()
{
	if(m_caConf)
	{
		delete m_caConf;
	}
	if(m_conf)
	{
		delete m_conf;
	}
	if(m_eeConf)
	{
		delete m_eeConf;
	}
	if(m_pkiConf)
	{
		delete m_pkiConf;
	}
	if(m_pubConf)
	{
		delete m_pubConf;
	}
	if(m_raConf)
	{
		delete m_raConf;
	}
	if(m_repConf)
	{
		delete m_repConf;
	}
}

void EntityConfBody::resetAll()
{
	m_type = -1;
	m_caConf = NULL;
	m_conf = NULL;
	m_eeConf = NULL;
	m_pkiConf = NULL;
	m_pubConf = NULL;
	m_raConf = NULL;
	m_repConf = NULL;
}

bool EntityConfBody::load_Datas(const ENTITY_CONF_BODY * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 1:
			if(Datas->d.ca_conf)
			{
				if(!(*m_caConf).load_Datas(Datas->d.ca_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 4:
		case 6:
			if(Datas->d.conf)
			{
				if(!(*m_conf).load_Datas(Datas->d.conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 7:
			if(Datas->d.ee_conf)
			{
				if(!(*m_eeConf).load_Datas(Datas->d.ee_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 5:
			if(Datas->d.pki_conf)
			{
				if(!(*m_pkiConf).load_Datas(Datas->d.pki_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 3:
			if(Datas->d.pub_conf)
			{
				if(!(*m_pubConf).load_Datas(Datas->d.pub_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 0:
			if(Datas->d.ra_conf)
			{
				if(!(*m_raConf).load_Datas(Datas->d.ra_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
			if(Datas->d.rep_conf)
			{
				if(!(*m_repConf).load_Datas(Datas->d.rep_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool EntityConfBody::give_Datas(ENTITY_CONF_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 1:
			if(!((*Datas)->d.ca_conf = (ENTITY_CONF_BODY_CA*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_caConf).give_Datas(&(*Datas)->d.ca_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ca_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_CA));
				(*Datas)->d.ca_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 4:
		case 6:
			if(!((*Datas)->d.conf = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf).give_Datas(&(*Datas)->d.conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
				(*Datas)->d.conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 7:
			if(!((*Datas)->d.ee_conf = (ENTITY_CONF_BODY_EE*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeConf).give_Datas(&(*Datas)->d.ee_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_EE));
				(*Datas)->d.ee_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 5:
			if(!((*Datas)->d.pki_conf = (ENTITY_CONF_BODY_PKI*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_pkiConf).give_Datas(&(*Datas)->d.pki_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.pki_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_PKI));
				(*Datas)->d.pki_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 3:
			if(!((*Datas)->d.pub_conf = (ENTITY_CONF_BODY_PUB*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_pubConf).give_Datas(&(*Datas)->d.pub_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.pub_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_PUB));
				(*Datas)->d.pub_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 0:
			if(!((*Datas)->d.ra_conf = (ENTITY_CONF_BODY_RA*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_raConf).give_Datas(&(*Datas)->d.ra_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ra_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_RA));
				(*Datas)->d.ra_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
			if(!((*Datas)->d.rep_conf = (ENTITY_CONF_BODY_REP*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_repConf).give_Datas(&(*Datas)->d.rep_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.rep_conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY_REP));
				(*Datas)->d.rep_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool EntityConfBody::operator=(const EntityConfBody & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 1:
			if(!other.m_caConf)
				break;
			(*m_caConf) = *(other.m_caConf);
			break;
		case 4:
		case 6:
			if(!other.m_conf)
				break;
			(*m_conf) = *(other.m_conf);
			break;
		case 7:
			if(!other.m_eeConf)
				break;
			(*m_eeConf) = *(other.m_eeConf);
			break;
		case 5:
			if(!other.m_pkiConf)
				break;
			(*m_pkiConf) = *(other.m_pkiConf);
			break;
		case 3:
			if(!other.m_pubConf)
				break;
			(*m_pubConf) = *(other.m_pubConf);
			break;
		case 0:
			if(!other.m_raConf)
				break;
			(*m_raConf) = *(other.m_raConf);
			break;
		case 2:
			if(!other.m_repConf)
				break;
			(*m_repConf) = *(other.m_repConf);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BODY);
}
UsersGroup UsersGroup::EmptyInstance;
bool UsersGroup::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & UsersGroup::get_name() const
{
	return m_name;
}

mString & UsersGroup::get_name()
{
	return m_name;
}

bool UsersGroup::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long UsersGroup::get_serial() const
{
	return m_serial;
}

bool UsersGroup::set_usersSerial(const mVector< unsigned long > & c_usersSerial)
{
	m_usersSerial = c_usersSerial;
	return true;
}

const mVector< unsigned long > & UsersGroup::get_usersSerial() const
{
	return m_usersSerial;
}

mVector< unsigned long > & UsersGroup::get_usersSerial()
{
	return m_usersSerial;
}

UsersGroup::UsersGroup():NewPKIObject()
{
	resetAll();
}

UsersGroup::UsersGroup(const UsersGroup & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

UsersGroup::~UsersGroup()
{
	Clear();
}

void UsersGroup::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void UsersGroup::freeAll()
{
}

void UsersGroup::resetAll()
{
	m_name = "";
	m_serial = 0;
	m_usersSerial.clear();
}

bool UsersGroup::load_Datas(const USERS_GROUP * Datas)
{
	Clear();
	int i;
	ASN1_INTEGER * currusersSerial;
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	if(Datas->users_serial)
	{
		for(i=0; i<SKM_sk_num(ASN1_INTEGER, Datas->users_serial); i++)
		{
			currusersSerial = SKM_sk_value(ASN1_INTEGER, Datas->users_serial, i);
			if(!currusersSerial)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_usersSerial.insert(m_usersSerial.begin() + i);
			m_usersSerial[i] = ASN1_INTEGER_GET(currusersSerial);
		}
	}
	m_isOk=true;
	return true;
}

bool UsersGroup::give_Datas(USERS_GROUP ** Datas) const
{
	if(!(*Datas) && !(*Datas = (USERS_GROUP*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ASN1_INTEGER * currusersSerial;
	size_t i;
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->users_serial && !((*Datas)->users_serial = SKM_sk_new_null(ASN1_INTEGER)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_usersSerial.size() ; i++)
	{
		currusersSerial = ASN1_INTEGER_new();
		if(!currusersSerial)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(ASN1_INTEGER_set(currusersSerial, m_usersSerial[i]) <= 0)
		{
			ASN1_INTEGER_free(currusersSerial);
			currusersSerial = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
		if(SKM_sk_push(ASN1_INTEGER, (*Datas)->users_serial, currusersSerial) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currusersSerial, ASN1_ITEM_rptr(ASN1_INTEGER));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool UsersGroup::operator=(const UsersGroup & other)
{
	Clear();
	m_name = other.m_name;
	m_serial = other.m_serial;
	m_usersSerial = other.m_usersSerial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * UsersGroup::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(USERS_GROUP);
}
AclEntry AclEntry::EmptyInstance;
bool AclEntry::set_acls(const ASN1_BIT_STRING * c_acls)
{
	if(m_acls)
		ASN1_item_free((ASN1_VALUE*)m_acls, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_acls = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_acls);
	if(!m_acls)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * AclEntry::get_acls() const
{
	if(!m_acls)
		((AclEntry*)this)->m_acls = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_acls;
}

ASN1_BIT_STRING * AclEntry::get_acls()
{
	if(!m_acls)
		m_acls = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_acls;
}

bool AclEntry::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & AclEntry::get_name() const
{
	return m_name;
}

mString & AclEntry::get_name()
{
	return m_name;
}

bool AclEntry::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long AclEntry::get_serial() const
{
	return m_serial;
}

bool AclEntry::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long AclEntry::get_type() const
{
	return m_type;
}

AclEntry::AclEntry():NewPKIObject()
{
	resetAll();
}

AclEntry::AclEntry(const AclEntry & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

AclEntry::~AclEntry()
{
	Clear();
}

void AclEntry::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void AclEntry::freeAll()
{
	if(m_acls)
	{
		ASN1_item_free((ASN1_VALUE*)m_acls, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void AclEntry::resetAll()
{
	m_acls = NULL;
	m_name = "";
	m_serial = 0;
	m_type = 0;
}

bool AclEntry::load_Datas(const ACL_ENTRY * Datas)
{
	Clear();
	if(Datas->acls)
	{
		if(m_acls)
			ASN1_item_free((ASN1_VALUE*)m_acls, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_acls = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->acls);
		if(!m_acls)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	m_isOk=true;
	return true;
}

bool AclEntry::give_Datas(ACL_ENTRY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ACL_ENTRY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_acls)
	{
		if((*Datas)->acls)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->acls, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->acls = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_acls)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->acls)
		{
			(*Datas)->acls = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->acls)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool AclEntry::operator=(const AclEntry & other)
{
	Clear();
	if(other.m_acls)
	{
		if(m_acls)
			ASN1_item_free((ASN1_VALUE*)m_acls, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_acls = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_acls);
		if(!m_acls)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_name = other.m_name;
	m_serial = other.m_serial;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * AclEntry::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ACL_ENTRY);
}
X509Acl X509Acl::EmptyInstance;
bool X509Acl::set_adminserials(const mVector< PkiAdminEntry > & c_adminserials)
{
	m_adminserials = c_adminserials;
	return true;
}

const mVector< PkiAdminEntry > & X509Acl::get_adminserials() const
{
	return m_adminserials;
}

mVector< PkiAdminEntry > & X509Acl::get_adminserials()
{
	return m_adminserials;
}

bool X509Acl::set_aclEntries(const mVector< AclEntry > & c_aclEntries)
{
	m_aclEntries = c_aclEntries;
	return true;
}

const mVector< AclEntry > & X509Acl::get_aclEntries() const
{
	return m_aclEntries;
}

mVector< AclEntry > & X509Acl::get_aclEntries()
{
	return m_aclEntries;
}

bool X509Acl::set_aclType(const mVector< unsigned long > & c_aclType)
{
	m_aclType = c_aclType;
	return true;
}

const mVector< unsigned long > & X509Acl::get_aclType() const
{
	return m_aclType;
}

mVector< unsigned long > & X509Acl::get_aclType()
{
	return m_aclType;
}

X509Acl::X509Acl():NewPKIObject()
{
	resetAll();
}

X509Acl::X509Acl(const X509Acl & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

X509Acl::~X509Acl()
{
	Clear();
}

void X509Acl::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void X509Acl::freeAll()
{
}

void X509Acl::resetAll()
{
	m_adminserials.clear();
	m_aclEntries.clear();
	m_aclType.clear();
}

bool X509Acl::load_Datas(const X509_ACL * Datas)
{
	Clear();
	ASN1_INTEGER * curraclType;
	ACL_ENTRY * curraclEntries;
	int i;
	PKI_ADMIN_ENTRY * curradminserials;
	if(Datas->AdminSerials)
	{
		for(i=0; i<SKM_sk_num(PKI_ADMIN_ENTRY, Datas->AdminSerials); i++)
		{
			curradminserials = SKM_sk_value(PKI_ADMIN_ENTRY, Datas->AdminSerials, i);
			if(!curradminserials)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_adminserials.insert(m_adminserials.begin() + i);
			if(!m_adminserials[i].load_Datas(curradminserials))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->acl_entries)
	{
		for(i=0; i<SKM_sk_num(ACL_ENTRY, Datas->acl_entries); i++)
		{
			curraclEntries = SKM_sk_value(ACL_ENTRY, Datas->acl_entries, i);
			if(!curraclEntries)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_aclEntries.insert(m_aclEntries.begin() + i);
			if(!m_aclEntries[i].load_Datas(curraclEntries))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->acl_type)
	{
		for(i=0; i<SKM_sk_num(ASN1_INTEGER, Datas->acl_type); i++)
		{
			curraclType = SKM_sk_value(ASN1_INTEGER, Datas->acl_type, i);
			if(!curraclType)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_aclType.insert(m_aclType.begin() + i);
			m_aclType[i] = ASN1_INTEGER_GET(curraclType);
		}
	}
	m_isOk=true;
	return true;
}

bool X509Acl::give_Datas(X509_ACL ** Datas) const
{
	if(!(*Datas) && !(*Datas = (X509_ACL*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ASN1_INTEGER * curraclType;
	ACL_ENTRY * curraclEntries;
	PKI_ADMIN_ENTRY * curradminserials;
	size_t i;
	if(!(*Datas)->AdminSerials && !((*Datas)->AdminSerials = SKM_sk_new_null(PKI_ADMIN_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_adminserials.size() ; i++)
	{
		curradminserials = NULL;
		if(!m_adminserials[i].give_Datas(&curradminserials))
		{
			ASN1_item_free((ASN1_VALUE*)curradminserials, ASN1_ITEM_rptr(PKI_ADMIN_ENTRY));
			curradminserials = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PKI_ADMIN_ENTRY, (*Datas)->AdminSerials, curradminserials) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curradminserials, ASN1_ITEM_rptr(PKI_ADMIN_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->acl_entries && !((*Datas)->acl_entries = SKM_sk_new_null(ACL_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_aclEntries.size() ; i++)
	{
		curraclEntries = NULL;
		if(!m_aclEntries[i].give_Datas(&curraclEntries))
		{
			ASN1_item_free((ASN1_VALUE*)curraclEntries, ASN1_ITEM_rptr(ACL_ENTRY));
			curraclEntries = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ACL_ENTRY, (*Datas)->acl_entries, curraclEntries) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraclEntries, ASN1_ITEM_rptr(ACL_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->acl_type && !((*Datas)->acl_type = SKM_sk_new_null(ASN1_INTEGER)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_aclType.size() ; i++)
	{
		curraclType = ASN1_INTEGER_new();
		if(!curraclType)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(ASN1_INTEGER_set(curraclType, m_aclType[i]) <= 0)
		{
			ASN1_INTEGER_free(curraclType);
			curraclType = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
		if(SKM_sk_push(ASN1_INTEGER, (*Datas)->acl_type, curraclType) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraclType, ASN1_ITEM_rptr(ASN1_INTEGER));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool X509Acl::operator=(const X509Acl & other)
{
	Clear();
	m_adminserials = other.m_adminserials;
	m_aclEntries = other.m_aclEntries;
	m_aclType = other.m_aclType;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * X509Acl::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(X509_ACL);
}
RepEntryInfo RepEntryInfo::EmptyInstance;
bool RepEntryInfo::set_address(const mString & c_address)
{
	m_address = c_address;
	return true;
}

const mString & RepEntryInfo::get_address() const
{
	return m_address;
}

mString & RepEntryInfo::get_address()
{
	return m_address;
}

bool RepEntryInfo::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * RepEntryInfo::get_flags() const
{
	if(!m_flags)
		((RepEntryInfo*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * RepEntryInfo::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool RepEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & RepEntryInfo::get_name() const
{
	return m_name;
}

mString & RepEntryInfo::get_name()
{
	return m_name;
}

bool RepEntryInfo::set_port(unsigned long c_port)
{
	m_port = c_port;
	return true;
}

unsigned long RepEntryInfo::get_port() const
{
	return m_port;
}

bool RepEntryInfo::set_repositoryssl(const PKI_CERT & c_repositoryssl)
{
	m_repositoryssl = c_repositoryssl;
	return true;
}

const PKI_CERT & RepEntryInfo::get_repositoryssl() const
{
	return m_repositoryssl;
}

PKI_CERT & RepEntryInfo::get_repositoryssl()
{
	return m_repositoryssl;
}

RepEntryInfo::RepEntryInfo():NewPKIObject()
{
	resetAll();
}

RepEntryInfo::RepEntryInfo(const RepEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

RepEntryInfo::~RepEntryInfo()
{
	Clear();
}

void RepEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RepEntryInfo::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void RepEntryInfo::resetAll()
{
	m_address = "";
	m_flags = NULL;
	m_name = "";
	m_port = 0;
	m_repositoryssl.Clear();
}

bool RepEntryInfo::load_Datas(const REP_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->Address)
	{
		m_address = Datas->Address;
	}
	if(Datas->Flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->Flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->Port)
	{
		m_port = ASN1_INTEGER_GET(Datas->Port);
	}
	if(Datas->RepositorySSL)
	{
		if(!m_repositoryssl.load_Datas(Datas->RepositorySSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool RepEntryInfo::give_Datas(REP_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (REP_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Address && !((*Datas)->Address = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_address.c_ASN1_UTF8STRING(&(*Datas)->Address))
	{
		ASN1_UTF8STRING_free((*Datas)->Address);
		(*Datas)->Address = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_flags)
	{
		if((*Datas)->Flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->Flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->Flags)
		{
			(*Datas)->Flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->Flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Port && !((*Datas)->Port = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Port, m_port) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Port);
		(*Datas)->Port = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->RepositorySSL && !((*Datas)->RepositorySSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_repositoryssl.give_Datas(&(*Datas)->RepositorySSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->RepositorySSL, ASN1_ITEM_rptr(X509));
		(*Datas)->RepositorySSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool RepEntryInfo::operator=(const RepEntryInfo & other)
{
	Clear();
	m_address = other.m_address;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_name = other.m_name;
	m_port = other.m_port;
	m_repositoryssl = other.m_repositoryssl;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RepEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(REP_ENTRY_INFO);
}
CaEntryInfo CaEntryInfo::EmptyInstance;
bool CaEntryInfo::set_cassl(const PKI_CERT & c_cassl)
{
	m_cassl = c_cassl;
	return true;
}

const PKI_CERT & CaEntryInfo::get_cassl() const
{
	return m_cassl;
}

PKI_CERT & CaEntryInfo::get_cassl()
{
	return m_cassl;
}

bool CaEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & CaEntryInfo::get_name() const
{
	return m_name;
}

mString & CaEntryInfo::get_name()
{
	return m_name;
}

CaEntryInfo::CaEntryInfo():NewPKIObject()
{
	resetAll();
}

CaEntryInfo::CaEntryInfo(const CaEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CaEntryInfo::~CaEntryInfo()
{
	Clear();
}

void CaEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CaEntryInfo::freeAll()
{
}

void CaEntryInfo::resetAll()
{
	m_cassl.Clear();
	m_name = "";
}

bool CaEntryInfo::load_Datas(const CA_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->CaSSL)
	{
		if(!m_cassl.load_Datas(Datas->CaSSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	m_isOk=true;
	return true;
}

bool CaEntryInfo::give_Datas(CA_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CA_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->CaSSL && !((*Datas)->CaSSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cassl.give_Datas(&(*Datas)->CaSSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->CaSSL, ASN1_ITEM_rptr(X509));
		(*Datas)->CaSSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool CaEntryInfo::operator=(const CaEntryInfo & other)
{
	Clear();
	m_cassl = other.m_cassl;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CaEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CA_ENTRY_INFO);
}
CasInfo CasInfo::EmptyInstance;
bool CasInfo::set_list(const mVector< CaEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< CaEntryInfo > & CasInfo::get_list() const
{
	return m_list;
}

mVector< CaEntryInfo > & CasInfo::get_list()
{
	return m_list;
}

CasInfo::CasInfo():NewPKIObject()
{
	resetAll();
}

CasInfo::CasInfo(const CasInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CasInfo::~CasInfo()
{
	Clear();
}

void CasInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CasInfo::freeAll()
{
}

void CasInfo::resetAll()
{
	m_list.clear();
}

bool CasInfo::load_Datas(const CAS_INFO * Datas)
{
	Clear();
	int i;
	CA_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(CA_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(CA_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool CasInfo::give_Datas(CAS_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CAS_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	CA_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(CA_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(CA_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(CA_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(CA_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool CasInfo::operator=(const CasInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CasInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CAS_INFO);
}
RaEntryInfo RaEntryInfo::EmptyInstance;
bool RaEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & RaEntryInfo::get_name() const
{
	return m_name;
}

mString & RaEntryInfo::get_name()
{
	return m_name;
}

bool RaEntryInfo::set_rassl(const PKI_CERT & c_rassl)
{
	m_rassl = c_rassl;
	return true;
}

const PKI_CERT & RaEntryInfo::get_rassl() const
{
	return m_rassl;
}

PKI_CERT & RaEntryInfo::get_rassl()
{
	return m_rassl;
}

RaEntryInfo::RaEntryInfo():NewPKIObject()
{
	resetAll();
}

RaEntryInfo::RaEntryInfo(const RaEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

RaEntryInfo::~RaEntryInfo()
{
	Clear();
}

void RaEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RaEntryInfo::freeAll()
{
}

void RaEntryInfo::resetAll()
{
	m_name = "";
	m_rassl.Clear();
}

bool RaEntryInfo::load_Datas(const RA_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->RaSSL)
	{
		if(!m_rassl.load_Datas(Datas->RaSSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool RaEntryInfo::give_Datas(RA_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (RA_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->RaSSL && !((*Datas)->RaSSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_rassl.give_Datas(&(*Datas)->RaSSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->RaSSL, ASN1_ITEM_rptr(X509));
		(*Datas)->RaSSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool RaEntryInfo::operator=(const RaEntryInfo & other)
{
	Clear();
	m_name = other.m_name;
	m_rassl = other.m_rassl;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RaEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(RA_ENTRY_INFO);
}
RasInfo RasInfo::EmptyInstance;
bool RasInfo::set_list(const mVector< RaEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< RaEntryInfo > & RasInfo::get_list() const
{
	return m_list;
}

mVector< RaEntryInfo > & RasInfo::get_list()
{
	return m_list;
}

RasInfo::RasInfo():NewPKIObject()
{
	resetAll();
}

RasInfo::RasInfo(const RasInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

RasInfo::~RasInfo()
{
	Clear();
}

void RasInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RasInfo::freeAll()
{
}

void RasInfo::resetAll()
{
	m_list.clear();
}

bool RasInfo::load_Datas(const RAS_INFO * Datas)
{
	Clear();
	int i;
	RA_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(RA_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(RA_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool RasInfo::give_Datas(RAS_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (RAS_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	RA_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(RA_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(RA_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(RA_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(RA_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool RasInfo::operator=(const RasInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RasInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(RAS_INFO);
}
KeyEntryInfo KeyEntryInfo::EmptyInstance;
bool KeyEntryInfo::set_keyssl(const PKI_CERT & c_keyssl)
{
	m_keyssl = c_keyssl;
	return true;
}

const PKI_CERT & KeyEntryInfo::get_keyssl() const
{
	return m_keyssl;
}

PKI_CERT & KeyEntryInfo::get_keyssl()
{
	return m_keyssl;
}

bool KeyEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & KeyEntryInfo::get_name() const
{
	return m_name;
}

mString & KeyEntryInfo::get_name()
{
	return m_name;
}

KeyEntryInfo::KeyEntryInfo():NewPKIObject()
{
	resetAll();
}

KeyEntryInfo::KeyEntryInfo(const KeyEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

KeyEntryInfo::~KeyEntryInfo()
{
	Clear();
}

void KeyEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void KeyEntryInfo::freeAll()
{
}

void KeyEntryInfo::resetAll()
{
	m_keyssl.Clear();
	m_name = "";
}

bool KeyEntryInfo::load_Datas(const KEY_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->KeySSL)
	{
		if(!m_keyssl.load_Datas(Datas->KeySSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	m_isOk=true;
	return true;
}

bool KeyEntryInfo::give_Datas(KEY_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (KEY_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->KeySSL && !((*Datas)->KeySSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_keyssl.give_Datas(&(*Datas)->KeySSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->KeySSL, ASN1_ITEM_rptr(X509));
		(*Datas)->KeySSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool KeyEntryInfo::operator=(const KeyEntryInfo & other)
{
	Clear();
	m_keyssl = other.m_keyssl;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * KeyEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(KEY_ENTRY_INFO);
}
KeysInfo KeysInfo::EmptyInstance;
bool KeysInfo::set_list(const mVector< KeyEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< KeyEntryInfo > & KeysInfo::get_list() const
{
	return m_list;
}

mVector< KeyEntryInfo > & KeysInfo::get_list()
{
	return m_list;
}

KeysInfo::KeysInfo():NewPKIObject()
{
	resetAll();
}

KeysInfo::KeysInfo(const KeysInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

KeysInfo::~KeysInfo()
{
	Clear();
}

void KeysInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void KeysInfo::freeAll()
{
}

void KeysInfo::resetAll()
{
	m_list.clear();
}

bool KeysInfo::load_Datas(const KEYS_INFO * Datas)
{
	Clear();
	int i;
	KEY_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(KEY_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(KEY_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool KeysInfo::give_Datas(KEYS_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (KEYS_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	KEY_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(KEY_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(KEY_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(KEY_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(KEY_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool KeysInfo::operator=(const KeysInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * KeysInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(KEYS_INFO);
}
EeEntryInfo EeEntryInfo::EmptyInstance;
bool EeEntryInfo::set_eessl(const PKI_CERT & c_eessl)
{
	m_eessl = c_eessl;
	return true;
}

const PKI_CERT & EeEntryInfo::get_eessl() const
{
	return m_eessl;
}

PKI_CERT & EeEntryInfo::get_eessl()
{
	return m_eessl;
}

bool EeEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & EeEntryInfo::get_name() const
{
	return m_name;
}

mString & EeEntryInfo::get_name()
{
	return m_name;
}

EeEntryInfo::EeEntryInfo():NewPKIObject()
{
	resetAll();
}

EeEntryInfo::EeEntryInfo(const EeEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EeEntryInfo::~EeEntryInfo()
{
	Clear();
}

void EeEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EeEntryInfo::freeAll()
{
}

void EeEntryInfo::resetAll()
{
	m_eessl.Clear();
	m_name = "";
}

bool EeEntryInfo::load_Datas(const EE_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->EESSL)
	{
		if(!m_eessl.load_Datas(Datas->EESSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	m_isOk=true;
	return true;
}

bool EeEntryInfo::give_Datas(EE_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EE_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->EESSL && !((*Datas)->EESSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_eessl.give_Datas(&(*Datas)->EESSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->EESSL, ASN1_ITEM_rptr(X509));
		(*Datas)->EESSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool EeEntryInfo::operator=(const EeEntryInfo & other)
{
	Clear();
	m_eessl = other.m_eessl;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EeEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EE_ENTRY_INFO);
}
EesInfo EesInfo::EmptyInstance;
bool EesInfo::set_list(const mVector< EeEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< EeEntryInfo > & EesInfo::get_list() const
{
	return m_list;
}

mVector< EeEntryInfo > & EesInfo::get_list()
{
	return m_list;
}

EesInfo::EesInfo():NewPKIObject()
{
	resetAll();
}

EesInfo::EesInfo(const EesInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EesInfo::~EesInfo()
{
	Clear();
}

void EesInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EesInfo::freeAll()
{
}

void EesInfo::resetAll()
{
	m_list.clear();
}

bool EesInfo::load_Datas(const EES_INFO * Datas)
{
	Clear();
	int i;
	EE_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(EE_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(EE_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool EesInfo::give_Datas(EES_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EES_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	EE_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(EE_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(EE_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(EE_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(EE_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool EesInfo::operator=(const EesInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EesInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EES_INFO);
}
BackupEntryInfo BackupEntryInfo::EmptyInstance;
bool BackupEntryInfo::set_backupssl(const PKI_CERT & c_backupssl)
{
	m_backupssl = c_backupssl;
	return true;
}

const PKI_CERT & BackupEntryInfo::get_backupssl() const
{
	return m_backupssl;
}

PKI_CERT & BackupEntryInfo::get_backupssl()
{
	return m_backupssl;
}

bool BackupEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & BackupEntryInfo::get_name() const
{
	return m_name;
}

mString & BackupEntryInfo::get_name()
{
	return m_name;
}

BackupEntryInfo::BackupEntryInfo():NewPKIObject()
{
	resetAll();
}

BackupEntryInfo::BackupEntryInfo(const BackupEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

BackupEntryInfo::~BackupEntryInfo()
{
	Clear();
}

void BackupEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void BackupEntryInfo::freeAll()
{
}

void BackupEntryInfo::resetAll()
{
	m_backupssl.Clear();
	m_name = "";
}

bool BackupEntryInfo::load_Datas(const BACKUP_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->BackupSSL)
	{
		if(!m_backupssl.load_Datas(Datas->BackupSSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	m_isOk=true;
	return true;
}

bool BackupEntryInfo::give_Datas(BACKUP_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (BACKUP_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->BackupSSL && !((*Datas)->BackupSSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_backupssl.give_Datas(&(*Datas)->BackupSSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->BackupSSL, ASN1_ITEM_rptr(X509));
		(*Datas)->BackupSSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool BackupEntryInfo::operator=(const BackupEntryInfo & other)
{
	Clear();
	m_backupssl = other.m_backupssl;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * BackupEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(BACKUP_ENTRY_INFO);
}
BackupsInfo BackupsInfo::EmptyInstance;
bool BackupsInfo::set_list(const mVector< BackupEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< BackupEntryInfo > & BackupsInfo::get_list() const
{
	return m_list;
}

mVector< BackupEntryInfo > & BackupsInfo::get_list()
{
	return m_list;
}

BackupsInfo::BackupsInfo():NewPKIObject()
{
	resetAll();
}

BackupsInfo::BackupsInfo(const BackupsInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

BackupsInfo::~BackupsInfo()
{
	Clear();
}

void BackupsInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void BackupsInfo::freeAll()
{
}

void BackupsInfo::resetAll()
{
	m_list.clear();
}

bool BackupsInfo::load_Datas(const BACKUPS_INFO * Datas)
{
	Clear();
	int i;
	BACKUP_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(BACKUP_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(BACKUP_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool BackupsInfo::give_Datas(BACKUPS_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (BACKUPS_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	BACKUP_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(BACKUP_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(BACKUP_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(BACKUP_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(BACKUP_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool BackupsInfo::operator=(const BackupsInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * BackupsInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(BACKUPS_INFO);
}
PubEntryInfo PubEntryInfo::EmptyInstance;
bool PubEntryInfo::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & PubEntryInfo::get_name() const
{
	return m_name;
}

mString & PubEntryInfo::get_name()
{
	return m_name;
}

bool PubEntryInfo::set_pubocsp(const PKI_CERT & c_pubocsp)
{
	m_pubocsp = c_pubocsp;
	return true;
}

const PKI_CERT & PubEntryInfo::get_pubocsp() const
{
	return m_pubocsp;
}

PKI_CERT & PubEntryInfo::get_pubocsp()
{
	return m_pubocsp;
}

bool PubEntryInfo::set_pubssl(const PKI_CERT & c_pubssl)
{
	m_pubssl = c_pubssl;
	return true;
}

const PKI_CERT & PubEntryInfo::get_pubssl() const
{
	return m_pubssl;
}

PKI_CERT & PubEntryInfo::get_pubssl()
{
	return m_pubssl;
}

PubEntryInfo::PubEntryInfo():NewPKIObject()
{
	resetAll();
}

PubEntryInfo::PubEntryInfo(const PubEntryInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PubEntryInfo::~PubEntryInfo()
{
	Clear();
}

void PubEntryInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PubEntryInfo::freeAll()
{
}

void PubEntryInfo::resetAll()
{
	m_name = "";
	m_pubocsp.Clear();
	m_pubssl.Clear();
}

bool PubEntryInfo::load_Datas(const PUB_ENTRY_INFO * Datas)
{
	Clear();
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->PubOCSP)
	{
		if(!m_pubocsp.load_Datas(Datas->PubOCSP))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->PubSSL)
	{
		if(!m_pubssl.load_Datas(Datas->PubSSL))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool PubEntryInfo::give_Datas(PUB_ENTRY_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PUB_ENTRY_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->PubOCSP && !((*Datas)->PubOCSP = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_pubocsp.give_Datas(&(*Datas)->PubOCSP))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->PubOCSP, ASN1_ITEM_rptr(X509));
		(*Datas)->PubOCSP = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->PubSSL && !((*Datas)->PubSSL = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_pubssl.give_Datas(&(*Datas)->PubSSL))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->PubSSL, ASN1_ITEM_rptr(X509));
		(*Datas)->PubSSL = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool PubEntryInfo::operator=(const PubEntryInfo & other)
{
	Clear();
	m_name = other.m_name;
	m_pubocsp = other.m_pubocsp;
	m_pubssl = other.m_pubssl;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PubEntryInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PUB_ENTRY_INFO);
}
PubsInfo PubsInfo::EmptyInstance;
bool PubsInfo::set_list(const mVector< PubEntryInfo > & c_list)
{
	m_list = c_list;
	return true;
}

const mVector< PubEntryInfo > & PubsInfo::get_list() const
{
	return m_list;
}

mVector< PubEntryInfo > & PubsInfo::get_list()
{
	return m_list;
}

PubsInfo::PubsInfo():NewPKIObject()
{
	resetAll();
}

PubsInfo::PubsInfo(const PubsInfo & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PubsInfo::~PubsInfo()
{
	Clear();
}

void PubsInfo::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PubsInfo::freeAll()
{
}

void PubsInfo::resetAll()
{
	m_list.clear();
}

bool PubsInfo::load_Datas(const PUBS_INFO * Datas)
{
	Clear();
	int i;
	PUB_ENTRY_INFO * currlist;
	if(Datas->list)
	{
		for(i=0; i<SKM_sk_num(PUB_ENTRY_INFO, Datas->list); i++)
		{
			currlist = SKM_sk_value(PUB_ENTRY_INFO, Datas->list, i);
			if(!currlist)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_list.insert(m_list.begin() + i);
			if(!m_list[i].load_Datas(currlist))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool PubsInfo::give_Datas(PUBS_INFO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PUBS_INFO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	PUB_ENTRY_INFO * currlist;
	size_t i;
	if(!(*Datas)->list && !((*Datas)->list = SKM_sk_new_null(PUB_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_list.size() ; i++)
	{
		currlist = NULL;
		if(!m_list[i].give_Datas(&currlist))
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(PUB_ENTRY_INFO));
			currlist = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(PUB_ENTRY_INFO, (*Datas)->list, currlist) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currlist, ASN1_ITEM_rptr(PUB_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool PubsInfo::operator=(const PubsInfo & other)
{
	Clear();
	m_list = other.m_list;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PubsInfo::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PUBS_INFO);
}
InternalPkiCrl InternalPkiCrl::EmptyInstance;
bool InternalPkiCrl::set_entitiescacrl(const PKI_CRL & c_entitiescacrl)
{
	m_entitiescacrl = c_entitiescacrl;
	return true;
}

const PKI_CRL & InternalPkiCrl::get_entitiescacrl() const
{
	return m_entitiescacrl;
}

PKI_CRL & InternalPkiCrl::get_entitiescacrl()
{
	return m_entitiescacrl;
}

bool InternalPkiCrl::set_ocspcacrl(const PKI_CRL & c_ocspcacrl)
{
	m_ocspcacrl = c_ocspcacrl;
	return true;
}

const PKI_CRL & InternalPkiCrl::get_ocspcacrl() const
{
	return m_ocspcacrl;
}

PKI_CRL & InternalPkiCrl::get_ocspcacrl()
{
	return m_ocspcacrl;
}

bool InternalPkiCrl::set_rootcacrl(const PKI_CRL & c_rootcacrl)
{
	m_rootcacrl = c_rootcacrl;
	return true;
}

const PKI_CRL & InternalPkiCrl::get_rootcacrl() const
{
	return m_rootcacrl;
}

PKI_CRL & InternalPkiCrl::get_rootcacrl()
{
	return m_rootcacrl;
}

bool InternalPkiCrl::set_userscacrl(const PKI_CRL & c_userscacrl)
{
	m_userscacrl = c_userscacrl;
	return true;
}

const PKI_CRL & InternalPkiCrl::get_userscacrl() const
{
	return m_userscacrl;
}

PKI_CRL & InternalPkiCrl::get_userscacrl()
{
	return m_userscacrl;
}

InternalPkiCrl::InternalPkiCrl():NewPKIObject()
{
	resetAll();
}

InternalPkiCrl::InternalPkiCrl(const InternalPkiCrl & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

InternalPkiCrl::~InternalPkiCrl()
{
	Clear();
}

void InternalPkiCrl::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalPkiCrl::freeAll()
{
}

void InternalPkiCrl::resetAll()
{
	m_entitiescacrl.Clear();
	m_ocspcacrl.Clear();
	m_rootcacrl.Clear();
	m_userscacrl.Clear();
}

bool InternalPkiCrl::load_Datas(const INTERNAL_PKI_CRL * Datas)
{
	Clear();
	if(Datas->EntitiesCaCrl)
	{
		if(!m_entitiescacrl.load_Datas(Datas->EntitiesCaCrl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->OcspCaCrl)
	{
		if(!m_ocspcacrl.load_Datas(Datas->OcspCaCrl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->RootCaCrl)
	{
		if(!m_rootcacrl.load_Datas(Datas->RootCaCrl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->UsersCaCrl)
	{
		if(!m_userscacrl.load_Datas(Datas->UsersCaCrl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalPkiCrl::give_Datas(INTERNAL_PKI_CRL ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_PKI_CRL*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->EntitiesCaCrl && !((*Datas)->EntitiesCaCrl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entitiescacrl.give_Datas(&(*Datas)->EntitiesCaCrl))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->EntitiesCaCrl, ASN1_ITEM_rptr(X509_CRL));
		(*Datas)->EntitiesCaCrl = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->OcspCaCrl && !((*Datas)->OcspCaCrl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ocspcacrl.give_Datas(&(*Datas)->OcspCaCrl))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->OcspCaCrl, ASN1_ITEM_rptr(X509_CRL));
		(*Datas)->OcspCaCrl = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->RootCaCrl && !((*Datas)->RootCaCrl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_rootcacrl.give_Datas(&(*Datas)->RootCaCrl))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->RootCaCrl, ASN1_ITEM_rptr(X509_CRL));
		(*Datas)->RootCaCrl = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->UsersCaCrl && !((*Datas)->UsersCaCrl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_userscacrl.give_Datas(&(*Datas)->UsersCaCrl))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->UsersCaCrl, ASN1_ITEM_rptr(X509_CRL));
		(*Datas)->UsersCaCrl = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool InternalPkiCrl::operator=(const InternalPkiCrl & other)
{
	Clear();
	m_entitiescacrl = other.m_entitiescacrl;
	m_ocspcacrl = other.m_ocspcacrl;
	m_rootcacrl = other.m_rootcacrl;
	m_userscacrl = other.m_userscacrl;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalPkiCrl::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_PKI_CRL);
}
InternalPkiCa InternalPkiCa::EmptyInstance;
bool InternalPkiCa::set_entitiesca(const PKI_CERT & c_entitiesca)
{
	m_entitiesca = c_entitiesca;
	return true;
}

const PKI_CERT & InternalPkiCa::get_entitiesca() const
{
	return m_entitiesca;
}

PKI_CERT & InternalPkiCa::get_entitiesca()
{
	return m_entitiesca;
}

bool InternalPkiCa::set_ocspca(const PKI_CERT & c_ocspca)
{
	m_ocspca = c_ocspca;
	return true;
}

const PKI_CERT & InternalPkiCa::get_ocspca() const
{
	return m_ocspca;
}

PKI_CERT & InternalPkiCa::get_ocspca()
{
	return m_ocspca;
}

bool InternalPkiCa::set_pkicert(const PKI_CERT & c_pkicert)
{
	m_pkicert = c_pkicert;
	return true;
}

const PKI_CERT & InternalPkiCa::get_pkicert() const
{
	return m_pkicert;
}

PKI_CERT & InternalPkiCa::get_pkicert()
{
	return m_pkicert;
}

bool InternalPkiCa::set_rootca(const PKI_CERT & c_rootca)
{
	m_rootca = c_rootca;
	return true;
}

const PKI_CERT & InternalPkiCa::get_rootca() const
{
	return m_rootca;
}

PKI_CERT & InternalPkiCa::get_rootca()
{
	return m_rootca;
}

bool InternalPkiCa::set_usersca(const PKI_CERT & c_usersca)
{
	m_usersca = c_usersca;
	return true;
}

const PKI_CERT & InternalPkiCa::get_usersca() const
{
	return m_usersca;
}

PKI_CERT & InternalPkiCa::get_usersca()
{
	return m_usersca;
}

InternalPkiCa::InternalPkiCa():NewPKIObject()
{
	resetAll();
}

InternalPkiCa::InternalPkiCa(const InternalPkiCa & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

InternalPkiCa::~InternalPkiCa()
{
	Clear();
}

void InternalPkiCa::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalPkiCa::freeAll()
{
}

void InternalPkiCa::resetAll()
{
	m_entitiesca.Clear();
	m_ocspca.Clear();
	m_pkicert.Clear();
	m_rootca.Clear();
	m_usersca.Clear();
}

bool InternalPkiCa::load_Datas(const INTERNAL_PKI_CA * Datas)
{
	Clear();
	if(Datas->EntitiesCa)
	{
		if(!m_entitiesca.load_Datas(Datas->EntitiesCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->OcspCa)
	{
		if(!m_ocspca.load_Datas(Datas->OcspCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->PkiCert)
	{
		if(!m_pkicert.load_Datas(Datas->PkiCert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->RootCa)
	{
		if(!m_rootca.load_Datas(Datas->RootCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->UsersCa)
	{
		if(!m_usersca.load_Datas(Datas->UsersCa))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalPkiCa::give_Datas(INTERNAL_PKI_CA ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_PKI_CA*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->EntitiesCa && !((*Datas)->EntitiesCa = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entitiesca.give_Datas(&(*Datas)->EntitiesCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->EntitiesCa, ASN1_ITEM_rptr(X509));
		(*Datas)->EntitiesCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->OcspCa && !((*Datas)->OcspCa = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ocspca.give_Datas(&(*Datas)->OcspCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->OcspCa, ASN1_ITEM_rptr(X509));
		(*Datas)->OcspCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->PkiCert && !((*Datas)->PkiCert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_pkicert.give_Datas(&(*Datas)->PkiCert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->PkiCert, ASN1_ITEM_rptr(X509));
		(*Datas)->PkiCert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->RootCa && !((*Datas)->RootCa = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_rootca.give_Datas(&(*Datas)->RootCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->RootCa, ASN1_ITEM_rptr(X509));
		(*Datas)->RootCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->UsersCa && !((*Datas)->UsersCa = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_usersca.give_Datas(&(*Datas)->UsersCa))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->UsersCa, ASN1_ITEM_rptr(X509));
		(*Datas)->UsersCa = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool InternalPkiCa::operator=(const InternalPkiCa & other)
{
	Clear();
	m_entitiesca = other.m_entitiesca;
	m_ocspca = other.m_ocspca;
	m_pkicert = other.m_pkicert;
	m_rootca = other.m_rootca;
	m_usersca = other.m_usersca;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalPkiCa::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_PKI_CA);
}
EntityAuditEntry EntityAuditEntry::EmptyInstance;
bool EntityAuditEntry::set_object(const mString & c_object)
{
	m_object = c_object;
	return true;
}

const mString & EntityAuditEntry::get_object() const
{
	return m_object;
}

mString & EntityAuditEntry::get_object()
{
	return m_object;
}

bool EntityAuditEntry::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long EntityAuditEntry::get_status() const
{
	return m_status;
}

bool EntityAuditEntry::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long EntityAuditEntry::get_type() const
{
	return m_type;
}

bool EntityAuditEntry::set_user(const mString & c_user)
{
	m_user = c_user;
	return true;
}

const mString & EntityAuditEntry::get_user() const
{
	return m_user;
}

mString & EntityAuditEntry::get_user()
{
	return m_user;
}

EntityAuditEntry::EntityAuditEntry():NewPKIObject()
{
	resetAll();
}

EntityAuditEntry::EntityAuditEntry(const EntityAuditEntry & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityAuditEntry::~EntityAuditEntry()
{
	Clear();
}

void EntityAuditEntry::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityAuditEntry::freeAll()
{
}

void EntityAuditEntry::resetAll()
{
	m_object = "";
	m_status = 0;
	m_type = 0;
	m_user = "";
}

bool EntityAuditEntry::load_Datas(const ENTITY_AUDIT_ENTRY * Datas)
{
	Clear();
	if(Datas->object)
	{
		m_object = Datas->object;
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	if(Datas->user)
	{
		m_user = Datas->user;
	}
	m_isOk=true;
	return true;
}

bool EntityAuditEntry::give_Datas(ENTITY_AUDIT_ENTRY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_AUDIT_ENTRY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->object && !((*Datas)->object = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_object.c_ASN1_UTF8STRING(&(*Datas)->object))
	{
		ASN1_UTF8STRING_free((*Datas)->object);
		(*Datas)->object = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->user && !((*Datas)->user = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_user.c_ASN1_UTF8STRING(&(*Datas)->user))
	{
		ASN1_UTF8STRING_free((*Datas)->user);
		(*Datas)->user = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool EntityAuditEntry::operator=(const EntityAuditEntry & other)
{
	Clear();
	m_object = other.m_object;
	m_status = other.m_status;
	m_type = other.m_type;
	m_user = other.m_user;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityAuditEntry::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY);
}
EntityConf EntityConf::EmptyInstance;
bool EntityConf::set_backups(const BackupsInfo & c_backups)
{
	m_backups = c_backups;
	return true;
}

const BackupsInfo & EntityConf::get_backups() const
{
	return m_backups;
}

BackupsInfo & EntityConf::get_backups()
{
	return m_backups;
}

bool EntityConf::set_cas(const CasInfo & c_cas)
{
	m_cas = c_cas;
	return true;
}

const CasInfo & EntityConf::get_cas() const
{
	return m_cas;
}

CasInfo & EntityConf::get_cas()
{
	return m_cas;
}

bool EntityConf::set_ees(const EesInfo & c_ees)
{
	m_ees = c_ees;
	return true;
}

const EesInfo & EntityConf::get_ees() const
{
	return m_ees;
}

EesInfo & EntityConf::get_ees()
{
	return m_ees;
}

bool EntityConf::set_keystores(const KeysInfo & c_keystores)
{
	m_keystores = c_keystores;
	return true;
}

const KeysInfo & EntityConf::get_keystores() const
{
	return m_keystores;
}

KeysInfo & EntityConf::get_keystores()
{
	return m_keystores;
}

bool EntityConf::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & EntityConf::get_name() const
{
	return m_name;
}

mString & EntityConf::get_name()
{
	return m_name;
}

bool EntityConf::set_publications(const PubsInfo & c_publications)
{
	m_publications = c_publications;
	return true;
}

const PubsInfo & EntityConf::get_publications() const
{
	return m_publications;
}

PubsInfo & EntityConf::get_publications()
{
	return m_publications;
}

bool EntityConf::set_ras(const RasInfo & c_ras)
{
	m_ras = c_ras;
	return true;
}

const RasInfo & EntityConf::get_ras() const
{
	return m_ras;
}

RasInfo & EntityConf::get_ras()
{
	return m_ras;
}

bool EntityConf::set_repositories(const mVector< RepEntryInfo > & c_repositories)
{
	m_repositories = c_repositories;
	return true;
}

const mVector< RepEntryInfo > & EntityConf::get_repositories() const
{
	return m_repositories;
}

mVector< RepEntryInfo > & EntityConf::get_repositories()
{
	return m_repositories;
}

bool EntityConf::set_acls(const X509Acl & c_acls)
{
	m_acls = c_acls;
	return true;
}

const X509Acl & EntityConf::get_acls() const
{
	return m_acls;
}

X509Acl & EntityConf::get_acls()
{
	return m_acls;
}

bool EntityConf::set_audits(const mVector< EntityAuditEntry > & c_audits)
{
	m_audits = c_audits;
	return true;
}

const mVector< EntityAuditEntry > & EntityConf::get_audits() const
{
	return m_audits;
}

mVector< EntityAuditEntry > & EntityConf::get_audits()
{
	return m_audits;
}

bool EntityConf::set_body(const EntityConfBody & c_body)
{
	m_body = c_body;
	return true;
}

const EntityConfBody & EntityConf::get_body() const
{
	return m_body;
}

EntityConfBody & EntityConf::get_body()
{
	return m_body;
}

bool EntityConf::set_crls(const InternalPkiCrl & c_crls)
{
	m_crls = c_crls;
	return true;
}

const InternalPkiCrl & EntityConf::get_crls() const
{
	return m_crls;
}

InternalPkiCrl & EntityConf::get_crls()
{
	return m_crls;
}

bool EntityConf::set_groups(const mVector< UsersGroup > & c_groups)
{
	m_groups = c_groups;
	return true;
}

const mVector< UsersGroup > & EntityConf::get_groups() const
{
	return m_groups;
}

mVector< UsersGroup > & EntityConf::get_groups()
{
	return m_groups;
}

bool EntityConf::set_mailConf(const EmailConf & c_mailConf)
{
	m_mailConf = c_mailConf;
	return true;
}

const EmailConf & EntityConf::get_mailConf() const
{
	return m_mailConf;
}

EmailConf & EntityConf::get_mailConf()
{
	return m_mailConf;
}

bool EntityConf::set_version(unsigned long c_version)
{
	m_version = c_version;
	return true;
}

unsigned long EntityConf::get_version() const
{
	return m_version;
}

bool EntityConf::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	ENTITY_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool EntityConf::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	ENTITY_CONF * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

EntityConf::EntityConf():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

EntityConf::EntityConf(const EntityConf & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

EntityConf::~EntityConf()
{
	Clear();
}

void EntityConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConf::freeAll()
{
}

void EntityConf::resetAll()
{
	m_backups.Clear();
	m_cas.Clear();
	m_ees.Clear();
	m_keystores.Clear();
	m_name = "";
	m_publications.Clear();
	m_ras.Clear();
	m_repositories.clear();
	m_acls.Clear();
	m_audits.clear();
	m_body.Clear();
	m_crls.Clear();
	m_groups.clear();
	m_mailConf.Clear();
	m_version = 0;
}

bool EntityConf::load_Datas(const ENTITY_CONF * Datas)
{
	Clear();
	USERS_GROUP * currgroups;
	ENTITY_AUDIT_ENTRY * curraudits;
	int i;
	REP_ENTRY_INFO * currrepositories;
	if(Datas->Backups)
	{
		if(!m_backups.load_Datas(Datas->Backups))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Cas)
	{
		if(!m_cas.load_Datas(Datas->Cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->EES)
	{
		if(!m_ees.load_Datas(Datas->EES))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->KeyStores)
	{
		if(!m_keystores.load_Datas(Datas->KeyStores))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->Publications)
	{
		if(!m_publications.load_Datas(Datas->Publications))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Ras)
	{
		if(!m_ras.load_Datas(Datas->Ras))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Repositories)
	{
		for(i=0; i<SKM_sk_num(REP_ENTRY_INFO, Datas->Repositories); i++)
		{
			currrepositories = SKM_sk_value(REP_ENTRY_INFO, Datas->Repositories, i);
			if(!currrepositories)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_repositories.insert(m_repositories.begin() + i);
			if(!m_repositories[i].load_Datas(currrepositories))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->acls)
	{
		if(!m_acls.load_Datas(Datas->acls))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->audits)
	{
		for(i=0; i<SKM_sk_num(ENTITY_AUDIT_ENTRY, Datas->audits); i++)
		{
			curraudits = SKM_sk_value(ENTITY_AUDIT_ENTRY, Datas->audits, i);
			if(!curraudits)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_audits.insert(m_audits.begin() + i);
			if(!m_audits[i].load_Datas(curraudits))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->body)
	{
		if(!m_body.load_Datas(Datas->body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->crls)
	{
		if(!m_crls.load_Datas(Datas->crls))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->groups)
	{
		for(i=0; i<SKM_sk_num(USERS_GROUP, Datas->groups); i++)
		{
			currgroups = SKM_sk_value(USERS_GROUP, Datas->groups, i);
			if(!currgroups)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_groups.insert(m_groups.begin() + i);
			if(!m_groups[i].load_Datas(currgroups))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->mail_conf)
	{
		if(!m_mailConf.load_Datas(Datas->mail_conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->version)
	{
		m_version = ASN1_INTEGER_GET(Datas->version);
	}
	m_isOk=true;
	return true;
}

bool EntityConf::give_Datas(ENTITY_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	USERS_GROUP * currgroups;
	ENTITY_AUDIT_ENTRY * curraudits;
	REP_ENTRY_INFO * currrepositories;
	size_t i;
	if(!(*Datas)->Backups && !((*Datas)->Backups = (BACKUPS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(BACKUPS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_backups.give_Datas(&(*Datas)->Backups))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Backups, ASN1_ITEM_rptr(BACKUPS_INFO));
		(*Datas)->Backups = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Cas && !((*Datas)->Cas = (CAS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(CAS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->Cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Cas, ASN1_ITEM_rptr(CAS_INFO));
		(*Datas)->Cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->EES && !((*Datas)->EES = (EES_INFO*)ASN1_item_new(ASN1_ITEM_rptr(EES_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ees.give_Datas(&(*Datas)->EES))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->EES, ASN1_ITEM_rptr(EES_INFO));
		(*Datas)->EES = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->KeyStores && !((*Datas)->KeyStores = (KEYS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(KEYS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_keystores.give_Datas(&(*Datas)->KeyStores))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->KeyStores, ASN1_ITEM_rptr(KEYS_INFO));
		(*Datas)->KeyStores = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Publications && !((*Datas)->Publications = (PUBS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(PUBS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_publications.give_Datas(&(*Datas)->Publications))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Publications, ASN1_ITEM_rptr(PUBS_INFO));
		(*Datas)->Publications = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Ras && !((*Datas)->Ras = (RAS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(RAS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ras.give_Datas(&(*Datas)->Ras))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Ras, ASN1_ITEM_rptr(RAS_INFO));
		(*Datas)->Ras = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Repositories && !((*Datas)->Repositories = SKM_sk_new_null(REP_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_repositories.size() ; i++)
	{
		currrepositories = NULL;
		if(!m_repositories[i].give_Datas(&currrepositories))
		{
			ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
			currrepositories = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(REP_ENTRY_INFO, (*Datas)->Repositories, currrepositories) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->acls && !((*Datas)->acls = (X509_ACL*)ASN1_item_new(ASN1_ITEM_rptr(X509_ACL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_acls.give_Datas(&(*Datas)->acls))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->acls, ASN1_ITEM_rptr(X509_ACL));
		(*Datas)->acls = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->audits && !((*Datas)->audits = SKM_sk_new_null(ENTITY_AUDIT_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_audits.size() ; i++)
	{
		curraudits = NULL;
		if(!m_audits[i].give_Datas(&curraudits))
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			curraudits = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ENTITY_AUDIT_ENTRY, (*Datas)->audits, curraudits) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->body && !((*Datas)->body = (ENTITY_CONF_BODY*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.give_Datas(&(*Datas)->body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->body, ASN1_ITEM_rptr(ENTITY_CONF_BODY));
		(*Datas)->body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->crls && !((*Datas)->crls = (INTERNAL_PKI_CRL*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_crls.give_Datas(&(*Datas)->crls))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->crls, ASN1_ITEM_rptr(INTERNAL_PKI_CRL));
		(*Datas)->crls = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->groups && !((*Datas)->groups = SKM_sk_new_null(USERS_GROUP)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_groups.size() ; i++)
	{
		currgroups = NULL;
		if(!m_groups[i].give_Datas(&currgroups))
		{
			ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
			currgroups = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(USERS_GROUP, (*Datas)->groups, currgroups) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->mail_conf && !((*Datas)->mail_conf = (EMAIL_CONF*)ASN1_item_new(ASN1_ITEM_rptr(EMAIL_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_mailConf.give_Datas(&(*Datas)->mail_conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->mail_conf, ASN1_ITEM_rptr(EMAIL_CONF));
		(*Datas)->mail_conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->version && !((*Datas)->version = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->version, m_version) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->version);
		(*Datas)->version = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConf::operator=(const EntityConf & other)
{
	Clear();
	m_backups = other.m_backups;
	m_cas = other.m_cas;
	m_ees = other.m_ees;
	m_keystores = other.m_keystores;
	m_name = other.m_name;
	m_publications = other.m_publications;
	m_ras = other.m_ras;
	m_repositories = other.m_repositories;
	m_acls = other.m_acls;
	m_audits = other.m_audits;
	m_body = other.m_body;
	m_crls = other.m_crls;
	m_groups = other.m_groups;
	m_mailConf = other.m_mailConf;
	m_version = other.m_version;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF);
}
EntityConfBeta4 EntityConfBeta4::EmptyInstance;
bool EntityConfBeta4::set_backups(const BackupsInfo & c_backups)
{
	m_backups = c_backups;
	return true;
}

const BackupsInfo & EntityConfBeta4::get_backups() const
{
	return m_backups;
}

BackupsInfo & EntityConfBeta4::get_backups()
{
	return m_backups;
}

bool EntityConfBeta4::set_cas(const CasInfo & c_cas)
{
	m_cas = c_cas;
	return true;
}

const CasInfo & EntityConfBeta4::get_cas() const
{
	return m_cas;
}

CasInfo & EntityConfBeta4::get_cas()
{
	return m_cas;
}

bool EntityConfBeta4::set_keystores(const KeysInfo & c_keystores)
{
	m_keystores = c_keystores;
	return true;
}

const KeysInfo & EntityConfBeta4::get_keystores() const
{
	return m_keystores;
}

KeysInfo & EntityConfBeta4::get_keystores()
{
	return m_keystores;
}

bool EntityConfBeta4::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & EntityConfBeta4::get_name() const
{
	return m_name;
}

mString & EntityConfBeta4::get_name()
{
	return m_name;
}

bool EntityConfBeta4::set_publications(const PubsInfo & c_publications)
{
	m_publications = c_publications;
	return true;
}

const PubsInfo & EntityConfBeta4::get_publications() const
{
	return m_publications;
}

PubsInfo & EntityConfBeta4::get_publications()
{
	return m_publications;
}

bool EntityConfBeta4::set_ras(const RasInfo & c_ras)
{
	m_ras = c_ras;
	return true;
}

const RasInfo & EntityConfBeta4::get_ras() const
{
	return m_ras;
}

RasInfo & EntityConfBeta4::get_ras()
{
	return m_ras;
}

bool EntityConfBeta4::set_repositories(const mVector< RepEntryInfo > & c_repositories)
{
	m_repositories = c_repositories;
	return true;
}

const mVector< RepEntryInfo > & EntityConfBeta4::get_repositories() const
{
	return m_repositories;
}

mVector< RepEntryInfo > & EntityConfBeta4::get_repositories()
{
	return m_repositories;
}

bool EntityConfBeta4::set_acls(const X509Acl & c_acls)
{
	m_acls = c_acls;
	return true;
}

const X509Acl & EntityConfBeta4::get_acls() const
{
	return m_acls;
}

X509Acl & EntityConfBeta4::get_acls()
{
	return m_acls;
}

bool EntityConfBeta4::set_audits(const mVector< EntityAuditEntry > & c_audits)
{
	m_audits = c_audits;
	return true;
}

const mVector< EntityAuditEntry > & EntityConfBeta4::get_audits() const
{
	return m_audits;
}

mVector< EntityAuditEntry > & EntityConfBeta4::get_audits()
{
	return m_audits;
}

bool EntityConfBeta4::set_body(const EntityConfBody & c_body)
{
	m_body = c_body;
	return true;
}

const EntityConfBody & EntityConfBeta4::get_body() const
{
	return m_body;
}

EntityConfBody & EntityConfBeta4::get_body()
{
	return m_body;
}

bool EntityConfBeta4::set_crls(const InternalPkiCrl & c_crls)
{
	m_crls = c_crls;
	return true;
}

const InternalPkiCrl & EntityConfBeta4::get_crls() const
{
	return m_crls;
}

InternalPkiCrl & EntityConfBeta4::get_crls()
{
	return m_crls;
}

bool EntityConfBeta4::set_groups(const mVector< UsersGroup > & c_groups)
{
	m_groups = c_groups;
	return true;
}

const mVector< UsersGroup > & EntityConfBeta4::get_groups() const
{
	return m_groups;
}

mVector< UsersGroup > & EntityConfBeta4::get_groups()
{
	return m_groups;
}

bool EntityConfBeta4::set_mailConf(const EmailConf & c_mailConf)
{
	m_mailConf = c_mailConf;
	return true;
}

const EmailConf & EntityConfBeta4::get_mailConf() const
{
	return m_mailConf;
}

EmailConf & EntityConfBeta4::get_mailConf()
{
	return m_mailConf;
}

bool EntityConfBeta4::set_version(unsigned long c_version)
{
	m_version = c_version;
	return true;
}

unsigned long EntityConfBeta4::get_version() const
{
	return m_version;
}

bool EntityConfBeta4::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	ENTITY_CONF_BETA4 * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool EntityConfBeta4::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	ENTITY_CONF_BETA4 * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

EntityConfBeta4::EntityConfBeta4():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

EntityConfBeta4::EntityConfBeta4(const EntityConfBeta4 & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

EntityConfBeta4::~EntityConfBeta4()
{
	Clear();
}

void EntityConfBeta4::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfBeta4::freeAll()
{
}

void EntityConfBeta4::resetAll()
{
	m_backups.Clear();
	m_cas.Clear();
	m_keystores.Clear();
	m_name = "";
	m_publications.Clear();
	m_ras.Clear();
	m_repositories.clear();
	m_acls.Clear();
	m_audits.clear();
	m_body.Clear();
	m_crls.Clear();
	m_groups.clear();
	m_mailConf.Clear();
	m_version = 0;
}

bool EntityConfBeta4::load_Datas(const ENTITY_CONF_BETA4 * Datas)
{
	Clear();
	USERS_GROUP * currgroups;
	ENTITY_AUDIT_ENTRY * curraudits;
	int i;
	REP_ENTRY_INFO * currrepositories;
	if(Datas->Backups)
	{
		if(!m_backups.load_Datas(Datas->Backups))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Cas)
	{
		if(!m_cas.load_Datas(Datas->Cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->KeyStores)
	{
		if(!m_keystores.load_Datas(Datas->KeyStores))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	if(Datas->Publications)
	{
		if(!m_publications.load_Datas(Datas->Publications))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Ras)
	{
		if(!m_ras.load_Datas(Datas->Ras))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->Repositories)
	{
		for(i=0; i<SKM_sk_num(REP_ENTRY_INFO, Datas->Repositories); i++)
		{
			currrepositories = SKM_sk_value(REP_ENTRY_INFO, Datas->Repositories, i);
			if(!currrepositories)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_repositories.insert(m_repositories.begin() + i);
			if(!m_repositories[i].load_Datas(currrepositories))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->acls)
	{
		if(!m_acls.load_Datas(Datas->acls))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->audits)
	{
		for(i=0; i<SKM_sk_num(ENTITY_AUDIT_ENTRY, Datas->audits); i++)
		{
			curraudits = SKM_sk_value(ENTITY_AUDIT_ENTRY, Datas->audits, i);
			if(!curraudits)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_audits.insert(m_audits.begin() + i);
			if(!m_audits[i].load_Datas(curraudits))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->body)
	{
		if(!m_body.load_Datas(Datas->body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->crls)
	{
		if(!m_crls.load_Datas(Datas->crls))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->groups)
	{
		for(i=0; i<SKM_sk_num(USERS_GROUP, Datas->groups); i++)
		{
			currgroups = SKM_sk_value(USERS_GROUP, Datas->groups, i);
			if(!currgroups)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_groups.insert(m_groups.begin() + i);
			if(!m_groups[i].load_Datas(currgroups))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->mail_conf)
	{
		if(!m_mailConf.load_Datas(Datas->mail_conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->version)
	{
		m_version = ASN1_INTEGER_GET(Datas->version);
	}
	m_isOk=true;
	return true;
}

bool EntityConfBeta4::give_Datas(ENTITY_CONF_BETA4 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_BETA4*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	USERS_GROUP * currgroups;
	ENTITY_AUDIT_ENTRY * curraudits;
	REP_ENTRY_INFO * currrepositories;
	size_t i;
	if(!(*Datas)->Backups && !((*Datas)->Backups = (BACKUPS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(BACKUPS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_backups.give_Datas(&(*Datas)->Backups))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Backups, ASN1_ITEM_rptr(BACKUPS_INFO));
		(*Datas)->Backups = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Cas && !((*Datas)->Cas = (CAS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(CAS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->Cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Cas, ASN1_ITEM_rptr(CAS_INFO));
		(*Datas)->Cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->KeyStores && !((*Datas)->KeyStores = (KEYS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(KEYS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_keystores.give_Datas(&(*Datas)->KeyStores))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->KeyStores, ASN1_ITEM_rptr(KEYS_INFO));
		(*Datas)->KeyStores = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Publications && !((*Datas)->Publications = (PUBS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(PUBS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_publications.give_Datas(&(*Datas)->Publications))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Publications, ASN1_ITEM_rptr(PUBS_INFO));
		(*Datas)->Publications = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Ras && !((*Datas)->Ras = (RAS_INFO*)ASN1_item_new(ASN1_ITEM_rptr(RAS_INFO))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ras.give_Datas(&(*Datas)->Ras))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Ras, ASN1_ITEM_rptr(RAS_INFO));
		(*Datas)->Ras = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Repositories && !((*Datas)->Repositories = SKM_sk_new_null(REP_ENTRY_INFO)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_repositories.size() ; i++)
	{
		currrepositories = NULL;
		if(!m_repositories[i].give_Datas(&currrepositories))
		{
			ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
			currrepositories = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(REP_ENTRY_INFO, (*Datas)->Repositories, currrepositories) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->acls && !((*Datas)->acls = (X509_ACL*)ASN1_item_new(ASN1_ITEM_rptr(X509_ACL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_acls.give_Datas(&(*Datas)->acls))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->acls, ASN1_ITEM_rptr(X509_ACL));
		(*Datas)->acls = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->audits && !((*Datas)->audits = SKM_sk_new_null(ENTITY_AUDIT_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_audits.size() ; i++)
	{
		curraudits = NULL;
		if(!m_audits[i].give_Datas(&curraudits))
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			curraudits = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ENTITY_AUDIT_ENTRY, (*Datas)->audits, curraudits) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->body && !((*Datas)->body = (ENTITY_CONF_BODY*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.give_Datas(&(*Datas)->body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->body, ASN1_ITEM_rptr(ENTITY_CONF_BODY));
		(*Datas)->body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->crls && !((*Datas)->crls = (INTERNAL_PKI_CRL*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CRL))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_crls.give_Datas(&(*Datas)->crls))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->crls, ASN1_ITEM_rptr(INTERNAL_PKI_CRL));
		(*Datas)->crls = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->groups && !((*Datas)->groups = SKM_sk_new_null(USERS_GROUP)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_groups.size() ; i++)
	{
		currgroups = NULL;
		if(!m_groups[i].give_Datas(&currgroups))
		{
			ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
			currgroups = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(USERS_GROUP, (*Datas)->groups, currgroups) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->mail_conf && !((*Datas)->mail_conf = (EMAIL_CONF*)ASN1_item_new(ASN1_ITEM_rptr(EMAIL_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_mailConf.give_Datas(&(*Datas)->mail_conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->mail_conf, ASN1_ITEM_rptr(EMAIL_CONF));
		(*Datas)->mail_conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->version && !((*Datas)->version = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->version, m_version) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->version);
		(*Datas)->version = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool EntityConfBeta4::operator=(const EntityConfBeta4 & other)
{
	Clear();
	m_backups = other.m_backups;
	m_cas = other.m_cas;
	m_keystores = other.m_keystores;
	m_name = other.m_name;
	m_publications = other.m_publications;
	m_ras = other.m_ras;
	m_repositories = other.m_repositories;
	m_acls = other.m_acls;
	m_audits = other.m_audits;
	m_body = other.m_body;
	m_crls = other.m_crls;
	m_groups = other.m_groups;
	m_mailConf = other.m_mailConf;
	m_version = other.m_version;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfBeta4::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_BETA4);
}
EntityConfCrypted EntityConfCrypted::EmptyInstance;
bool EntityConfCrypted::set_crypted(const Asn1EncryptSign & c_crypted)
{
	m_crypted = c_crypted;
	return true;
}

const Asn1EncryptSign & EntityConfCrypted::get_crypted() const
{
	return m_crypted;
}

Asn1EncryptSign & EntityConfCrypted::get_crypted()
{
	return m_crypted;
}

bool EntityConfCrypted::set_recipient(const X509_PUBKEY * c_recipient)
{
	if(m_recipient)
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)c_recipient);
	if(!m_recipient)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_PUBKEY * EntityConfCrypted::get_recipient() const
{
	if(!m_recipient)
		((EntityConfCrypted*)this)->m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

X509_PUBKEY * EntityConfCrypted::get_recipient()
{
	if(!m_recipient)
		m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

bool EntityConfCrypted::to_PEM(mString & PemDatas) const
{
	ENTITY_CONF_CRYPTED * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI CRYPTED ENTITY CONF", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool EntityConfCrypted::from_PEM(const mString & PemDatas)
{
	ENTITY_CONF_CRYPTED * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI CRYPTED ENTITY CONF", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

EntityConfCrypted::EntityConfCrypted():NewPKIObject()
{
	resetAll();
}

EntityConfCrypted::EntityConfCrypted(const EntityConfCrypted & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

EntityConfCrypted::~EntityConfCrypted()
{
	Clear();
}

void EntityConfCrypted::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void EntityConfCrypted::freeAll()
{
	if(m_recipient)
	{
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	}
}

void EntityConfCrypted::resetAll()
{
	m_crypted.Clear();
	m_recipient = NULL;
}

bool EntityConfCrypted::load_Datas(const ENTITY_CONF_CRYPTED * Datas)
{
	Clear();
	if(Datas->crypted)
	{
		if(!m_crypted.load_Datas(Datas->crypted))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool EntityConfCrypted::give_Datas(ENTITY_CONF_CRYPTED ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ENTITY_CONF_CRYPTED*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->crypted && !((*Datas)->crypted = (ASN1_ENCRYPT_SIGN*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_crypted.give_Datas(&(*Datas)->crypted))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->crypted, ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN));
		(*Datas)->crypted = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_recipient)
	{
		if((*Datas)->recipient)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		if(!((*Datas)->recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (ASN1_VALUE*)m_recipient)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->recipient)
		{
			(*Datas)->recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
			if(!(*Datas)->recipient)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool EntityConfCrypted::operator=(const EntityConfCrypted & other)
{
	Clear();
	m_crypted = other.m_crypted;
	if(other.m_recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)other.m_recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * EntityConfCrypted::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ENTITY_CONF_CRYPTED);
}
ExportedPkiConfBody ExportedPkiConfBody::EmptyInstance;
bool ExportedPkiConfBody::set_allConfs(const mVector< EntityConfCrypted > & c_allConfs)
{
	m_allConfs = c_allConfs;
	return true;
}

const mVector< EntityConfCrypted > & ExportedPkiConfBody::get_allConfs() const
{
	return m_allConfs;
}

mVector< EntityConfCrypted > & ExportedPkiConfBody::get_allConfs()
{
	return m_allConfs;
}

bool ExportedPkiConfBody::set_version(unsigned long c_version)
{
	m_version = c_version;
	return true;
}

unsigned long ExportedPkiConfBody::get_version() const
{
	return m_version;
}

ExportedPkiConfBody::ExportedPkiConfBody():NewPKIObject()
{
	resetAll();
}

ExportedPkiConfBody::ExportedPkiConfBody(const ExportedPkiConfBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ExportedPkiConfBody::~ExportedPkiConfBody()
{
	Clear();
}

void ExportedPkiConfBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ExportedPkiConfBody::freeAll()
{
}

void ExportedPkiConfBody::resetAll()
{
	m_allConfs.clear();
	m_version = 0;
}

bool ExportedPkiConfBody::load_Datas(const EXPORTED_PKI_CONF_BODY * Datas)
{
	Clear();
	int i;
	ENTITY_CONF_CRYPTED * currallConfs;
	if(Datas->all_confs)
	{
		for(i=0; i<SKM_sk_num(ENTITY_CONF_CRYPTED, Datas->all_confs); i++)
		{
			currallConfs = SKM_sk_value(ENTITY_CONF_CRYPTED, Datas->all_confs, i);
			if(!currallConfs)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_allConfs.insert(m_allConfs.begin() + i);
			if(!m_allConfs[i].load_Datas(currallConfs))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->version)
	{
		m_version = ASN1_INTEGER_GET(Datas->version);
	}
	m_isOk=true;
	return true;
}

bool ExportedPkiConfBody::give_Datas(EXPORTED_PKI_CONF_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EXPORTED_PKI_CONF_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ENTITY_CONF_CRYPTED * currallConfs;
	size_t i;
	if(!(*Datas)->all_confs && !((*Datas)->all_confs = SKM_sk_new_null(ENTITY_CONF_CRYPTED)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_allConfs.size() ; i++)
	{
		currallConfs = NULL;
		if(!m_allConfs[i].give_Datas(&currallConfs))
		{
			ASN1_item_free((ASN1_VALUE*)currallConfs, ASN1_ITEM_rptr(ENTITY_CONF_CRYPTED));
			currallConfs = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ENTITY_CONF_CRYPTED, (*Datas)->all_confs, currallConfs) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currallConfs, ASN1_ITEM_rptr(ENTITY_CONF_CRYPTED));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->version && !((*Datas)->version = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->version, m_version) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->version);
		(*Datas)->version = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool ExportedPkiConfBody::operator=(const ExportedPkiConfBody & other)
{
	Clear();
	m_allConfs = other.m_allConfs;
	m_version = other.m_version;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ExportedPkiConfBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EXPORTED_PKI_CONF_BODY);
}
ExportedPkiConf ExportedPkiConf::EmptyInstance;
bool ExportedPkiConf::set_confs(const ExportedPkiConfBody & c_confs)
{
	m_confs = c_confs;
	return true;
}

const ExportedPkiConfBody & ExportedPkiConf::get_confs() const
{
	return m_confs;
}

ExportedPkiConfBody & ExportedPkiConf::get_confs()
{
	return m_confs;
}

bool ExportedPkiConf::set_repPath(const STACK_OF(X509_PUBKEY) * c_repPath)
{
	if(!m_repPath)
	{
		m_repPath = sk_new_null();
		if(!m_repPath)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(!STACK_cpy(ASN1_ITEM_rptr(X509_PUBKEY), c_repPath, m_repPath))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const STACK_OF(X509_PUBKEY) * ExportedPkiConf::get_repPath() const
{
	if(!m_repPath)
		((ExportedPkiConf*)this)->m_repPath = SKM_sk_new_null(X509_PUBKEY);
	return m_repPath;
}

STACK_OF(X509_PUBKEY) * ExportedPkiConf::get_repPath()
{
	if(!m_repPath)
		m_repPath = SKM_sk_new_null(X509_PUBKEY);
	return m_repPath;
}

bool ExportedPkiConf::set_sig(const X509_SIG * c_sig)
{
	if(m_sig)
		ASN1_item_free((ASN1_VALUE*)m_sig, ASN1_ITEM_rptr(X509_SIG));
	m_sig = (X509_SIG*)ASN1_item_dup(ASN1_ITEM_rptr(X509_SIG), (void*)c_sig);
	if(!m_sig)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_SIG * ExportedPkiConf::get_sig() const
{
	if(!m_sig)
		((ExportedPkiConf*)this)->m_sig = (X509_SIG*)ASN1_item_new(ASN1_ITEM_rptr(X509_SIG));
	return m_sig;
}

X509_SIG * ExportedPkiConf::get_sig()
{
	if(!m_sig)
		m_sig = (X509_SIG*)ASN1_item_new(ASN1_ITEM_rptr(X509_SIG));
	return m_sig;
}

bool ExportedPkiConf::to_PEM(mString & PemDatas) const
{
	EXPORTED_PKI_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI PKI CONF", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool ExportedPkiConf::from_PEM(const mString & PemDatas)
{
	EXPORTED_PKI_CONF * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI PKI CONF", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

ExportedPkiConf::ExportedPkiConf():NewPKIObject()
{
	resetAll();
}

ExportedPkiConf::ExportedPkiConf(const ExportedPkiConf & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ExportedPkiConf::~ExportedPkiConf()
{
	Clear();
}

void ExportedPkiConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ExportedPkiConf::freeAll()
{
	if(m_repPath)
	{
		STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath);
	}
	if(m_sig)
	{
		ASN1_item_free((ASN1_VALUE*)m_sig, ASN1_ITEM_rptr(X509_SIG));
	}
}

void ExportedPkiConf::resetAll()
{
	m_confs.Clear();
	m_repPath = NULL;
	m_sig = NULL;
}

bool ExportedPkiConf::load_Datas(const EXPORTED_PKI_CONF * Datas)
{
	Clear();
	if(Datas->confs)
	{
		if(!m_confs.load_Datas(Datas->confs))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->rep_path)
	{
		if(m_repPath)
			STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath);
		m_repPath = STACK_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->rep_path);
		if(!m_repPath)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->sig)
	{
		if(m_sig)
			ASN1_item_free((ASN1_VALUE*)m_sig, ASN1_ITEM_rptr(X509_SIG));
		m_sig = (X509_SIG*)ASN1_item_dup(ASN1_ITEM_rptr(X509_SIG), Datas->sig);
		if(!m_sig)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool ExportedPkiConf::give_Datas(EXPORTED_PKI_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EXPORTED_PKI_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->confs && !((*Datas)->confs = (EXPORTED_PKI_CONF_BODY*)ASN1_item_new(ASN1_ITEM_rptr(EXPORTED_PKI_CONF_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_confs.give_Datas(&(*Datas)->confs))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->confs, ASN1_ITEM_rptr(EXPORTED_PKI_CONF_BODY));
		(*Datas)->confs = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_repPath)
	{
		if((*Datas)->rep_path)
			STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), (*Datas)->rep_path);
		if(!((*Datas)->rep_path = STACK_dup(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->rep_path)
		{
			(*Datas)->rep_path = SKM_sk_new_null(X509_PUBKEY);
			if(!(*Datas)->rep_path)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_sig)
	{
		if((*Datas)->sig)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sig, ASN1_ITEM_rptr(X509_SIG));
		if(!((*Datas)->sig = (X509_SIG*)ASN1_item_dup(ASN1_ITEM_rptr(X509_SIG), (ASN1_VALUE*)m_sig)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sig)
		{
			(*Datas)->sig = (X509_SIG*)ASN1_item_new(ASN1_ITEM_rptr(X509_SIG));
			if(!(*Datas)->sig)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool ExportedPkiConf::operator=(const ExportedPkiConf & other)
{
	Clear();
	m_confs = other.m_confs;
	if(other.m_repPath)
	{
		if(!m_repPath && !(m_repPath = SKM_sk_new_null(X509_PUBKEY)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!STACK_cpy(ASN1_ITEM_rptr(X509_PUBKEY), other.m_repPath, m_repPath))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_sig)
	{
		if(m_sig)
			ASN1_item_free((ASN1_VALUE*)m_sig, ASN1_ITEM_rptr(X509_SIG));
		m_sig = (X509_SIG*)ASN1_item_dup(ASN1_ITEM_rptr(X509_SIG), (void*)other.m_sig);
		if(!m_sig)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ExportedPkiConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EXPORTED_PKI_CONF);
}
NewpkiProfile NewpkiProfile::EmptyInstance;
bool NewpkiProfile::set_eeValidation(unsigned long c_eeValidation)
{
	m_eeValidation = c_eeValidation;
	return true;
}

unsigned long NewpkiProfile::get_eeValidation() const
{
	return m_eeValidation;
}

bool NewpkiProfile::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * NewpkiProfile::get_dn() const
{
	if(!m_dn)
		((NewpkiProfile*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * NewpkiProfile::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool NewpkiProfile::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiProfile::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiProfile::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiProfile::set_ownerGroupSerial(unsigned long c_ownerGroupSerial)
{
	m_ownerGroupSerial = c_ownerGroupSerial;
	return true;
}

unsigned long NewpkiProfile::get_ownerGroupSerial() const
{
	return m_ownerGroupSerial;
}

bool NewpkiProfile::to_PEM(mString & PemDatas) const
{
	NEWPKI_PROFILE * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI PROFILE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool NewpkiProfile::from_PEM(const mString & PemDatas)
{
	NEWPKI_PROFILE * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI PROFILE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

NewpkiProfile::NewpkiProfile():NewPKIObject()
{
	resetAll();
}

NewpkiProfile::NewpkiProfile(const NewpkiProfile & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiProfile::~NewpkiProfile()
{
	Clear();
}

void NewpkiProfile::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiProfile::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void NewpkiProfile::resetAll()
{
	m_eeValidation = 0;
	m_dn = NULL;
	m_ldapUid = "";
	m_ownerGroupSerial = 0;
}

bool NewpkiProfile::load_Datas(const NEWPKI_PROFILE * Datas)
{
	Clear();
	if(Datas->EE_Validation)
	{
		m_eeValidation = ASN1_INTEGER_GET(Datas->EE_Validation);
	}
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->owner_group_serial)
	{
		m_ownerGroupSerial = ASN1_INTEGER_GET(Datas->owner_group_serial);
	}
	m_isOk=true;
	return true;
}

bool NewpkiProfile::give_Datas(NEWPKI_PROFILE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PROFILE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->EE_Validation && !((*Datas)->EE_Validation = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->EE_Validation, m_eeValidation) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->EE_Validation);
		(*Datas)->EE_Validation = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->owner_group_serial && !((*Datas)->owner_group_serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->owner_group_serial, m_ownerGroupSerial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->owner_group_serial);
		(*Datas)->owner_group_serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiProfile::operator=(const NewpkiProfile & other)
{
	Clear();
	m_eeValidation = other.m_eeValidation;
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_ldapUid = other.m_ldapUid;
	m_ownerGroupSerial = other.m_ownerGroupSerial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiProfile::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PROFILE);
}
NewpkiProfileDatasCert NewpkiProfileDatasCert::EmptyInstance;
bool NewpkiProfileDatasCert::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiProfileDatasCert::get_id() const
{
	return m_id;
}

bool NewpkiProfileDatasCert::set_adminMail(const mString & c_adminMail)
{
	m_adminMail = c_adminMail;
	return true;
}

const mString & NewpkiProfileDatasCert::get_adminMail() const
{
	return m_adminMail;
}

mString & NewpkiProfileDatasCert::get_adminMail()
{
	return m_adminMail;
}

bool NewpkiProfileDatasCert::set_caName(const mString & c_caName)
{
	m_caName = c_caName;
	return true;
}

const mString & NewpkiProfileDatasCert::get_caName() const
{
	return m_caName;
}

mString & NewpkiProfileDatasCert::get_caName()
{
	return m_caName;
}

bool NewpkiProfileDatasCert::set_cert(const PKI_CERT & c_cert)
{
	m_cert = c_cert;
	return true;
}

const PKI_CERT & NewpkiProfileDatasCert::get_cert() const
{
	return m_cert;
}

PKI_CERT & NewpkiProfileDatasCert::get_cert()
{
	return m_cert;
}

bool NewpkiProfileDatasCert::set_error(const mString & c_error)
{
	m_error = c_error;
	return true;
}

const mString & NewpkiProfileDatasCert::get_error() const
{
	return m_error;
}

mString & NewpkiProfileDatasCert::get_error()
{
	return m_error;
}

bool NewpkiProfileDatasCert::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * NewpkiProfileDatasCert::get_flags() const
{
	if(!m_flags)
		((NewpkiProfileDatasCert*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * NewpkiProfileDatasCert::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool NewpkiProfileDatasCert::set_p12(const PKI_PKCS12 & c_p12)
{
	m_p12 = c_p12;
	return true;
}

const PKI_PKCS12 & NewpkiProfileDatasCert::get_p12() const
{
	return m_p12;
}

PKI_PKCS12 & NewpkiProfileDatasCert::get_p12()
{
	return m_p12;
}

bool NewpkiProfileDatasCert::set_p7b(const PKI_P7B & c_p7b)
{
	m_p7b = c_p7b;
	return true;
}

const PKI_P7B & NewpkiProfileDatasCert::get_p7b() const
{
	return m_p7b;
}

PKI_P7B & NewpkiProfileDatasCert::get_p7b()
{
	return m_p7b;
}

bool NewpkiProfileDatasCert::set_state(unsigned long c_state)
{
	m_state = c_state;
	return true;
}

unsigned long NewpkiProfileDatasCert::get_state() const
{
	return m_state;
}

bool NewpkiProfileDatasCert::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long NewpkiProfileDatasCert::get_type() const
{
	return m_type;
}

NewpkiProfileDatasCert::NewpkiProfileDatasCert():NewPKIObject()
{
	resetAll();
}

NewpkiProfileDatasCert::NewpkiProfileDatasCert(const NewpkiProfileDatasCert & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiProfileDatasCert::~NewpkiProfileDatasCert()
{
	Clear();
}

void NewpkiProfileDatasCert::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiProfileDatasCert::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void NewpkiProfileDatasCert::resetAll()
{
	m_id = 0;
	m_adminMail = "";
	m_caName = "";
	m_cert.Clear();
	m_error = "";
	m_flags = NULL;
	m_p12.Clear();
	m_p7b.Clear();
	m_state = 0;
	m_type = 0;
}

bool NewpkiProfileDatasCert::load_Datas(const NEWPKI_PROFILE_DATAS_CERT * Datas)
{
	Clear();
	if(Datas->Id)
	{
		m_id = ASN1_INTEGER_GET(Datas->Id);
	}
	if(Datas->admin_mail)
	{
		m_adminMail = Datas->admin_mail;
	}
	if(Datas->ca_name)
	{
		m_caName = Datas->ca_name;
	}
	if(Datas->cert)
	{
		if(!m_cert.load_Datas(Datas->cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->error)
	{
		m_error = Datas->error;
	}
	if(Datas->flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->p12)
	{
		if(!m_p12.load_Datas(Datas->p12))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->p7b)
	{
		if(!m_p7b.load_Datas(Datas->p7b))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->state)
	{
		m_state = ASN1_INTEGER_GET(Datas->state);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	m_isOk=true;
	return true;
}

bool NewpkiProfileDatasCert::give_Datas(NEWPKI_PROFILE_DATAS_CERT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PROFILE_DATAS_CERT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Id && !((*Datas)->Id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Id);
		(*Datas)->Id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->admin_mail && !((*Datas)->admin_mail = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_adminMail.c_ASN1_UTF8STRING(&(*Datas)->admin_mail))
	{
		ASN1_UTF8STRING_free((*Datas)->admin_mail);
		(*Datas)->admin_mail = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ca_name && !((*Datas)->ca_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caName.c_ASN1_UTF8STRING(&(*Datas)->ca_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ca_name);
		(*Datas)->ca_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_cert)
	{
		if(!(*Datas)->cert && !((*Datas)->cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_cert.give_Datas(&(*Datas)->cert))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->cert, ASN1_ITEM_rptr(X509));
			(*Datas)->cert = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->cert)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->cert, ASN1_ITEM_rptr(X509));
			(*Datas)->cert = NULL;
		}
	}
	if(!(*Datas)->error && !((*Datas)->error = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_error.c_ASN1_UTF8STRING(&(*Datas)->error))
	{
		ASN1_UTF8STRING_free((*Datas)->error);
		(*Datas)->error = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_flags)
	{
		if((*Datas)->flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->flags)
		{
			(*Datas)->flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_p12)
	{
		if(!(*Datas)->p12 && !((*Datas)->p12 = (PKCS12*)ASN1_item_new(ASN1_ITEM_rptr(PKCS12))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p12.give_Datas(&(*Datas)->p12))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p12)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
		}
	}
	if(m_p7b)
	{
		if(!(*Datas)->p7b && !((*Datas)->p7b = (PKCS7*)ASN1_item_new(ASN1_ITEM_rptr(PKCS7))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p7b.give_Datas(&(*Datas)->p7b))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p7b)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
		}
	}
	if(!(*Datas)->state && !((*Datas)->state = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->state, m_state) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->state);
		(*Datas)->state = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiProfileDatasCert::operator=(const NewpkiProfileDatasCert & other)
{
	Clear();
	m_id = other.m_id;
	m_adminMail = other.m_adminMail;
	m_caName = other.m_caName;
	m_cert = other.m_cert;
	m_error = other.m_error;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_p12 = other.m_p12;
	m_p7b = other.m_p7b;
	m_state = other.m_state;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiProfileDatasCert::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS_CERT);
}
NewpkiProfileDatas NewpkiProfileDatas::EmptyInstance;
bool NewpkiProfileDatas::set_certs(const mVector< NewpkiProfileDatasCert > & c_certs)
{
	m_certs = c_certs;
	return true;
}

const mVector< NewpkiProfileDatasCert > & NewpkiProfileDatas::get_certs() const
{
	return m_certs;
}

mVector< NewpkiProfileDatasCert > & NewpkiProfileDatas::get_certs()
{
	return m_certs;
}

bool NewpkiProfileDatas::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiProfileDatas::get_id() const
{
	return m_id;
}

bool NewpkiProfileDatas::set_profile(const NewpkiProfile & c_profile)
{
	m_profile = c_profile;
	return true;
}

const NewpkiProfile & NewpkiProfileDatas::get_profile() const
{
	return m_profile;
}

NewpkiProfile & NewpkiProfileDatas::get_profile()
{
	return m_profile;
}

bool NewpkiProfileDatas::set_state(unsigned long c_state)
{
	m_state = c_state;
	return true;
}

unsigned long NewpkiProfileDatas::get_state() const
{
	return m_state;
}

bool NewpkiProfileDatas::set_eeId(const mString & c_eeId)
{
	m_eeId = c_eeId;
	return true;
}

const mString & NewpkiProfileDatas::get_eeId() const
{
	return m_eeId;
}

mString & NewpkiProfileDatas::get_eeId()
{
	return m_eeId;
}

NewpkiProfileDatas::NewpkiProfileDatas():NewPKIObject()
{
	resetAll();
}

NewpkiProfileDatas::NewpkiProfileDatas(const NewpkiProfileDatas & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiProfileDatas::~NewpkiProfileDatas()
{
	Clear();
}

void NewpkiProfileDatas::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiProfileDatas::freeAll()
{
}

void NewpkiProfileDatas::resetAll()
{
	m_certs.clear();
	m_id = 0;
	m_profile.Clear();
	m_state = 0;
	m_eeId = "";
}

bool NewpkiProfileDatas::load_Datas(const NEWPKI_PROFILE_DATAS * Datas)
{
	Clear();
	int i;
	NEWPKI_PROFILE_DATAS_CERT * currcerts;
	if(Datas->Certs)
	{
		for(i=0; i<SKM_sk_num(NEWPKI_PROFILE_DATAS_CERT, Datas->Certs); i++)
		{
			currcerts = SKM_sk_value(NEWPKI_PROFILE_DATAS_CERT, Datas->Certs, i);
			if(!currcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_certs.insert(m_certs.begin() + i);
			if(!m_certs[i].load_Datas(currcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Id)
	{
		m_id = ASN1_INTEGER_GET(Datas->Id);
	}
	if(Datas->Profile)
	{
		if(!m_profile.load_Datas(Datas->Profile))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->State)
	{
		m_state = ASN1_INTEGER_GET(Datas->State);
	}
	if(Datas->ee_id)
	{
		m_eeId = Datas->ee_id;
	}
	m_isOk=true;
	return true;
}

bool NewpkiProfileDatas::give_Datas(NEWPKI_PROFILE_DATAS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PROFILE_DATAS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	NEWPKI_PROFILE_DATAS_CERT * currcerts;
	size_t i;
	if(!(*Datas)->Certs && !((*Datas)->Certs = SKM_sk_new_null(NEWPKI_PROFILE_DATAS_CERT)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_certs.size() ; i++)
	{
		currcerts = NULL;
		if(!m_certs[i].give_Datas(&currcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currcerts, ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS_CERT));
			currcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(NEWPKI_PROFILE_DATAS_CERT, (*Datas)->Certs, currcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currcerts, ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS_CERT));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->Id && !((*Datas)->Id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Id);
		(*Datas)->Id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Profile && !((*Datas)->Profile = (NEWPKI_PROFILE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PROFILE))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_profile.give_Datas(&(*Datas)->Profile))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Profile, ASN1_ITEM_rptr(NEWPKI_PROFILE));
		(*Datas)->Profile = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->State && !((*Datas)->State = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->State, m_state) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->State);
		(*Datas)->State = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ee_id && !((*Datas)->ee_id = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_eeId.c_ASN1_UTF8STRING(&(*Datas)->ee_id))
	{
		ASN1_UTF8STRING_free((*Datas)->ee_id);
		(*Datas)->ee_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool NewpkiProfileDatas::operator=(const NewpkiProfileDatas & other)
{
	Clear();
	m_certs = other.m_certs;
	m_id = other.m_id;
	m_profile = other.m_profile;
	m_state = other.m_state;
	m_eeId = other.m_eeId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiProfileDatas::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS);
}
NewpkiEeUser NewpkiEeUser::EmptyInstance;
bool NewpkiEeUser::set_certs(const mVector< NewpkiProfileDatasCert > & c_certs)
{
	m_certs = c_certs;
	return true;
}

const mVector< NewpkiProfileDatasCert > & NewpkiEeUser::get_certs() const
{
	return m_certs;
}

mVector< NewpkiProfileDatasCert > & NewpkiEeUser::get_certs()
{
	return m_certs;
}

bool NewpkiEeUser::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiEeUser::get_id() const
{
	return m_id;
}

bool NewpkiEeUser::set_activated(unsigned long c_activated)
{
	m_activated = c_activated;
	return true;
}

unsigned long NewpkiEeUser::get_activated() const
{
	return m_activated;
}

bool NewpkiEeUser::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * NewpkiEeUser::get_dn() const
{
	if(!m_dn)
		((NewpkiEeUser*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * NewpkiEeUser::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool NewpkiEeUser::set_email(const mString & c_email)
{
	m_email = c_email;
	return true;
}

const mString & NewpkiEeUser::get_email() const
{
	return m_email;
}

mString & NewpkiEeUser::get_email()
{
	return m_email;
}

bool NewpkiEeUser::set_lastSend(unsigned long c_lastSend)
{
	m_lastSend = c_lastSend;
	return true;
}

unsigned long NewpkiEeUser::get_lastSend() const
{
	return m_lastSend;
}

bool NewpkiEeUser::set_raValidated(unsigned long c_raValidated)
{
	m_raValidated = c_raValidated;
	return true;
}

unsigned long NewpkiEeUser::get_raValidated() const
{
	return m_raValidated;
}

bool NewpkiEeUser::set_sendCount(unsigned long c_sendCount)
{
	m_sendCount = c_sendCount;
	return true;
}

unsigned long NewpkiEeUser::get_sendCount() const
{
	return m_sendCount;
}

NewpkiEeUser::NewpkiEeUser():NewPKIObject()
{
	resetAll();
}

NewpkiEeUser::NewpkiEeUser(const NewpkiEeUser & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeUser::~NewpkiEeUser()
{
	Clear();
}

void NewpkiEeUser::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeUser::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void NewpkiEeUser::resetAll()
{
	m_certs.clear();
	m_id = 0;
	m_activated = 0;
	m_dn = NULL;
	m_email = "";
	m_lastSend = 0;
	m_raValidated = 0;
	m_sendCount = 0;
}

bool NewpkiEeUser::load_Datas(const NEWPKI_EE_USER * Datas)
{
	Clear();
	int i;
	NEWPKI_PROFILE_DATAS_CERT * currcerts;
	if(Datas->Certs)
	{
		for(i=0; i<SKM_sk_num(NEWPKI_PROFILE_DATAS_CERT, Datas->Certs); i++)
		{
			currcerts = SKM_sk_value(NEWPKI_PROFILE_DATAS_CERT, Datas->Certs, i);
			if(!currcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_certs.insert(m_certs.begin() + i);
			if(!m_certs[i].load_Datas(currcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->Id)
	{
		m_id = ASN1_INTEGER_GET(Datas->Id);
	}
	if(Datas->activated)
	{
		m_activated = ASN1_INTEGER_GET(Datas->activated);
	}
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->email)
	{
		m_email = Datas->email;
	}
	if(Datas->last_send)
	{
		m_lastSend = ASN1_INTEGER_GET(Datas->last_send);
	}
	if(Datas->ra_validated)
	{
		m_raValidated = ASN1_INTEGER_GET(Datas->ra_validated);
	}
	if(Datas->send_count)
	{
		m_sendCount = ASN1_INTEGER_GET(Datas->send_count);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeUser::give_Datas(NEWPKI_EE_USER ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_USER*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	NEWPKI_PROFILE_DATAS_CERT * currcerts;
	size_t i;
	if(!(*Datas)->Certs && !((*Datas)->Certs = SKM_sk_new_null(NEWPKI_PROFILE_DATAS_CERT)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_certs.size() ; i++)
	{
		currcerts = NULL;
		if(!m_certs[i].give_Datas(&currcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currcerts, ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS_CERT));
			currcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(NEWPKI_PROFILE_DATAS_CERT, (*Datas)->Certs, currcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currcerts, ASN1_ITEM_rptr(NEWPKI_PROFILE_DATAS_CERT));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->Id && !((*Datas)->Id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Id);
		(*Datas)->Id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->activated && !((*Datas)->activated = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->activated, m_activated) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->activated);
		(*Datas)->activated = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->email && !((*Datas)->email = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_email.c_ASN1_UTF8STRING(&(*Datas)->email))
	{
		ASN1_UTF8STRING_free((*Datas)->email);
		(*Datas)->email = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->last_send && !((*Datas)->last_send = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->last_send, m_lastSend) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->last_send);
		(*Datas)->last_send = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ra_validated && !((*Datas)->ra_validated = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_validated, m_raValidated) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_validated);
		(*Datas)->ra_validated = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->send_count && !((*Datas)->send_count = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->send_count, m_sendCount) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->send_count);
		(*Datas)->send_count = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeUser::operator=(const NewpkiEeUser & other)
{
	Clear();
	m_certs = other.m_certs;
	m_id = other.m_id;
	m_activated = other.m_activated;
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_email = other.m_email;
	m_lastSend = other.m_lastSend;
	m_raValidated = other.m_raValidated;
	m_sendCount = other.m_sendCount;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeUser::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_USER);
}

#include "../lbintl.h"


typedef struct md_ACL_MESSAGE_ENTRY
{
	ACL_TYPE uID;
	char * Text;
}ACL_MESSAGE_ENTRY;


ACL_MESSAGE_ENTRY AclMessagesStatus[]={
	{ ACL_TYPE_AUTHENTICATE_ON_ENTITY,			_lb("Authenticate on entity") }, 
	{ ACL_TYPE_MANAGE_USERS,					_lb("Manage users") }, 
	{ ACL_TYPE_MANAGE_ENTITIES,					_lb("Manage entities") }, 
	{ ACL_TYPE_VIEW_LOGS,						_lb("View logs") }, 
	{ ACL_TYPE_MANAGE_ACLS,						_lb("Manage ACLs") }, 
	{ ACL_TYPE_MODIFY_PKI_STATUS,				_lb("Modify the PKI status") }, 
	{ ACL_TYPE_IMPORT_CONF,						_lb("Import PKI configuration") },
	{ ACL_TYPE_SEND_ADMIN_MAIL,					_lb("Send an administrative mail") },
	{ ACL_TYPE_CREATE_ROOT_CA,					_lb("CA: Create a ROOT CA") },
	{ ACL_TYPE_CREATE_CHILD_CA,					_lb("CA: Create a Child CA") },
	{ ACL_TYPE_CA_SIGN_CERT,					_lb("CA: Sign a certificate") },
	{ ACL_TYPE_CA_REVOKE_CERT,					_lb("CA: Revoke a certificate") },
	{ ACL_TYPE_CA_GENERATE_CRL,					_lb("CA: Generate CRL") },
	{ ACL_TYPE_IMPORT_NEWPKI_OBJECTS,			_lb("Import NewPKI objects") },
	{ ACL_TYPE_RA_MANAGE_PROFILES,				_lb("RA: Manage profiles") },
	{ ACL_TYPE_RA_DELEGATE_PROFILE_OWNERSHIP,	_lb("RA: Delegate profile ownership") },
	{ ACL_TYPE_RA_REQUEST_CERT,					_lb("RA: Request a certificate") },
	{ ACL_TYPE_RA_REVOKE_CERT,					_lb("RA: Revoke a certificate") },
	{ ACL_TYPE_EE_MANAGE_PROFILES,				_lb("EE: Manage profiles") },
	{ ACL_TYPE_MANAGE_USERS,					NULL }
};





char * GetACL_String(ACL_TYPE Type)
{
	for(int i=0; AclMessagesStatus[i].Text; i++)
	{
		if(AclMessagesStatus[i].uID == Type) return AclMessagesStatus[i].Text;
	}

	return _lb("Unknown");
}

bool Upgrade_EntityConf_From_Beta4_To_2_0_0(const EntityConfBeta4 & Beta4Conf, EntityConf & Conf)
{
	if(!Conf.set_acls(Beta4Conf.get_acls()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_audits(Beta4Conf.get_audits()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_backups(Beta4Conf.get_backups()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_cas(Beta4Conf.get_cas()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_crls(Beta4Conf.get_crls()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_groups(Beta4Conf.get_groups()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_keystores(Beta4Conf.get_keystores()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_mailConf(Beta4Conf.get_mailConf()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_name(Beta4Conf.get_name()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_publications(Beta4Conf.get_publications()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_ras(Beta4Conf.get_ras()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_repositories(Beta4Conf.get_repositories()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Conf.set_version(Beta4Conf.get_version()))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		return false;
	}

	switch(Beta4Conf.get_body().get_type())
	{
		case ENTITY_TYPE_RA:
			if(!Conf.get_body().set_type(ENTITY_TYPE_RA))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().set_type(CONF_VERSION_1))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_dnspecs(
				Beta4Conf.get_body().get_raConf().get_conf0().get_dnspecs()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_flags(
				Beta4Conf.get_body().get_raConf().get_conf0().get_flags()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_minkeylen(
				Beta4Conf.get_body().get_raConf().get_conf0().get_minkeylen()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_minpwdlen(
				Beta4Conf.get_body().get_raConf().get_conf0().get_minpwdlen()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_policies(
				Beta4Conf.get_body().get_raConf().get_conf0().get_policies()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_defaultValidity(
				Beta4Conf.get_body().get_raConf().get_conf0().get_defaultValidity()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapAttrName(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapAttrName()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapBase(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapBase()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapFilters(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapFilters()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapPassword(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapPassword()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapPort(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapPort()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapProfilesGroup(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapProfilesGroup()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapServer(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapServer()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapUsername(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapUsername()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_raConf().get_conf1().set_ldapUtf8(
				Beta4Conf.get_body().get_raConf().get_conf0().get_ldapUtf8()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case ENTITY_TYPE_CA:
			if(!Conf.get_body().set_type(ENTITY_TYPE_CA))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().set_type(CONF_VERSION_1))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().get_conf1().set_crlexts(
				Beta4Conf.get_body().get_caConf().get_conf0().get_crlexts()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().get_conf1().set_crlvaliditydays(
				Beta4Conf.get_body().get_caConf().get_conf0().get_crlvaliditydays()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().get_conf1().set_crlvalidityhours(
				Beta4Conf.get_body().get_caConf().get_conf0().get_crlvalidityhours()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().get_conf1().set_exts(
				Beta4Conf.get_body().get_caConf().get_conf0().get_exts()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			if(!Conf.get_body().get_caConf().get_conf1().set_plugca(
				Beta4Conf.get_body().get_caConf().get_conf0().get_plugca()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		default:
			if(!Conf.set_body(Beta4Conf.get_body()))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

