/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageAudits.cpp: implementation of the DlgManageAudits class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddAudit.h"
#include "DlgManageAudits.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageAudits, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageAudits::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageAudits::OnCancel)
    EVT_BUTTON(IDC_ADD_AUDIT, DlgManageAudits::OnAddAudit)
    EVT_BUTTON(IDC_DEL_AUDIT, DlgManageAudits::OnDelAudit)
    EVT_BUTTON(IDC_MODIFY_AUDIT, DlgManageAudits::OnModAudit)
END_EVENT_TABLE()

DlgManageAudits::DlgManageAudits(wxWindow * wParent, const mVector<unsigned long> & Types, mVector<EntityAuditEntry> & audits):wxDialog(wParent, (wxWindowID)-1, _("Manage Audits"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION), m_audits(audits), m_Types(Types)
{
	m_IsOK = false;

	DlgManageAudits_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LIST_AUDITS));
	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(DlgManageAudits_GetBitmap(0));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Log type"), wxLIST_ALIGN_DEFAULT, 300);
	m_listCtrl->InsertColumn(1, _("Log status"), wxLIST_ALIGN_DEFAULT, 100);
	m_listCtrl->InsertColumn(2, _("Object"), wxLIST_ALIGN_DEFAULT, 100);
	m_listCtrl->InsertColumn(3, _("User"), wxLIST_ALIGN_DEFAULT, 100);


	w_audits = m_audits;

	if(!ReloadList())
	{
		Close(TRUE);
		return;
	}


	CenterOnScreen();
	ShowModal();
}

DlgManageAudits::~DlgManageAudits()
{
	m_listCtrl->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

bool DlgManageAudits::ReloadList()
{
	size_t i;
	wxString cValue;

	m_listCtrl->DeleteAllItems();

	for(i=0; i<w_audits.size(); i++)
	{
		//Type
		if(w_audits[i].get_type())
		{
			cValue = ASN1_logs_get_TypeString((LOG_MESSAGE_TYPE)w_audits[i].get_type());
		}
		else
		{
			cValue = "";
		}
		m_listCtrl->InsertItem(i, cValue, 0);
		m_listCtrl->SetItemData(i, (long)i);

		//Status
		if(w_audits[i].get_status())
		{
			cValue = ASN1_logs_get_StatusString((LOG_MESSAGE_STATUS)w_audits[i].get_status());
		}
		else
		{
			cValue = "";
		}
		m_listCtrl->SetItem(i, 1, cValue );

		//Object name
		if(w_audits[i].get_object().size())
			cValue = w_audits[i].get_object().c_str();
		else
			cValue = "";		
		m_listCtrl->SetItem(i, 2, cValue );

		//User name
		if( w_audits[i].get_user().size() )
			cValue = w_audits[i].get_user().c_str();
		else
			cValue = "";		
		m_listCtrl->SetItem(i, 3, cValue );
	}
	return true;
}

void DlgManageAudits::OnAddAudit(wxCommandEvent& event)
{
	DlgAddAudit Dlg(this, m_Types, EntityAuditEntry::EmptyInstance);
	if(!Dlg.IsOK()) return;
	const EntityAuditEntry & Audit = Dlg.GetAudit();
	w_audits.push_back(Audit);
	ReloadList();
}

void DlgManageAudits::OnDelAudit(wxCommandEvent& event)
{
	int SelectedItem;
	long pos;
	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	pos = (long)m_listCtrl->GetItemData(SelectedItem);

	w_audits.erase(w_audits.begin() + pos); 
	ReloadList();
}

void DlgManageAudits::OnOk(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure to want to modify the audits ?"), wxYES_NO) == wxNO) return;

	m_audits = w_audits;
	m_IsOK = true;
	Close(TRUE);
}

void DlgManageAudits::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

void DlgManageAudits::OnModAudit(wxCommandEvent &event)
{
	int SelectedItem;
	long pos;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	pos = (long)m_listCtrl->GetItemData(SelectedItem);

	DlgAddAudit Dlg(this, m_Types, w_audits[pos]);
	if(!Dlg.IsOK()) return;
	w_audits[pos] = Dlg.GetAudit();
	ReloadList();
}

bool DlgManageAudits::IsOK()
{
	return m_IsOK;
}
