/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgMailConf.cpp: implementation of the DlgMailConf class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMailConf.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgMailConf, wxDialog)
    EVT_BUTTON(IDC_OK, DlgMailConf::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgMailConf::OnCancel)
END_EVENT_TABLE()


DlgMailConf::DlgMailConf(wxWindow * wParent, EmailConf & conf, const mString & MailFrom):wxDialog(wParent, (wxWindowID)-1, _("Manage Email Conf"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION), m_conf(conf)
{
	m_IsOK = false;

	DlgMailConf_SetWindow(this);


	w_conf = m_conf;

	
	((wxTextCtrl *)FindWindow(IDC_SERVER))->SetValue(w_conf.get_server().c_str());
	
	wxString Value;
	Value.sprintf("%ld", w_conf.get_port());
	if(Value == "0")
		Value = "25";
	((wxTextCtrl *)FindWindow(IDC_PORT))->SetValue(Value);
	((wxTextCtrl *)FindWindow(IDC_MAIL_FROM))->SetValue(MailFrom.c_str());
	
	((wxTextCtrl *)FindWindow(IDC_MAIL_FROM))->SetBackgroundColour(GetBackgroundColour());

	CenterOnScreen();
	ShowModal();		
}

DlgMailConf::~DlgMailConf()
{
}

void DlgMailConf::OnOk(wxCommandEvent& event)
{
	wxString Value;
	unsigned int port;

	Value = ((wxTextCtrl *)FindWindow(IDC_SERVER))->GetValue();
	w_conf.set_server(Value.GetData());

	Value = ((wxTextCtrl *)FindWindow(IDC_PORT))->GetValue();
	sscanf(Value.GetData(), "%d", &port);
	w_conf.set_port(port);

	if(DisplayMessage(this, _("Are you sure to want to modify the email configuration ?"), wxYES_NO) == wxNO) return;
	
	m_conf = w_conf;
	m_IsOK = true;
	Close(TRUE);
}

void DlgMailConf::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

bool DlgMailConf::IsOK()
{
	return m_IsOK;
}
