/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgDisplayLogs.h: interface for the DlgDisplayLogs class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGDISPLAYLOGS_H
#define DLGDISPLAYLOGS_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/app.h>
#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/treectrl.h>
#include <wx/frame.h>
#include <wx/timer.h>
#include <wx/tooltip.h>


#include <stdio.h>
#include <PkiClient.h>
#include "Error.h"
#include <PEM_DER.h>
#include <PKI_CERT.h>
#include "Functions.h"
#include <mString.h>
#include <libxml/parserInternals.h>
#include <libxml/parser.h>



class DlgDisplayLogsListCtrl: public wxListCtrl
{
public:
    DlgDisplayLogsListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,
            const wxSize& size, long style):
        wxListCtrl(parent, id, pos, size, style)
        {
        }
    void OnItemRightClick(wxListEvent& event);
    void OnItemClick(wxListEvent& event);
private:
    DECLARE_EVENT_TABLE()
};



class DlgDisplayLogs: public wxDialog
{
public:
	DlgDisplayLogs(wxWindow * wParent, PkiClient * ClientPki, const PKI_CERT & SigningCert);
	virtual ~DlgDisplayLogs();

public:
	void OnExportLogs(wxCommandEvent &event);
	void OnCheckLogsIntegrity(wxCommandEvent &event);
	void OnItemClick(wxListEvent& event);
	void OnItemRightClick(wxListEvent& event);
	void OnSetLogFilters(wxCommandEvent &event);
	void OnShowProperties(wxCommandEvent& event);
	void OnRefreshEntries(wxCommandEvent& event);

private:
	mVector<LogEntry> logs;
	mVector<unsigned long> Types;
	PkiClient * m_ClientPki;
	wxImageList *m_imageListSmall;
	DlgDisplayLogsListCtrl *m_listCtrl;
	AdminReqEnumLogs m_LogFilters;

	bool AddNode(FILE * fp, xmlDocPtr xDoc, const LogEntry & currLog);
	void ShowNextEntries(int NumEntries);
	void ShowPrevEntries(int NumEntries);
	bool DisplayLOG(int NumEntries);
	void PrintPagePosition(int NumEntries);
	void RefreshDisplay(int NumEntries);
	void ShowLog();
	const LogEntry & GetSelectedLog();

	int LogIconId;
	const PKI_CERT & m_SigningCert;

	DECLARE_EVENT_TABLE()
};

#endif
