/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddValuePlugin.cpp: implementation of the DlgAddValuePlugin class.
//
//////////////////////////////////////////////////////////////////////
#include "Error.h"
#include "DlgAddValuePlugin.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddValuePlugin, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddValuePlugin::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddValuePlugin::OnCancel)
	EVT_COMBOBOX(IDC_NAME, DlgAddValuePlugin::OnSelectionChanged)
	EVT_TEXT(IDC_VALUE, DlgAddValuePlugin::OnTextChanged)
END_EVENT_TABLE()



DlgAddValuePlugin::DlgAddValuePlugin(wxWindow * wParent, const mString & Name, const mString & Value, xmlParserCtxtPtr ctxt):wxDialog(wParent, (wxWindowID)-1, (Name.size()?_("Modify Plug-in option"):_("Add Plug-in option")), wxDefaultPosition)
{
	m_IsOK = false;
	m_ctxt = ctxt;

	DlgAddValuePlugin_SetWindow(this);

	if(Value.size())
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(Value.c_str());


	xmlNodePtr root;
	xmlNodePtr currOption;
	int Selection = 0;
	int index;
	unsigned char * OptionName;

	root = xmlDocGetRootElement(m_ctxt->myDoc);
	if(!root)
	{
		Close(TRUE);
		return;
	}

	for(currOption = root->children, index=0; currOption; currOption=currOption->next, index++)
	{
		if(xmlIsBlankNode(currOption)) continue;
		OptionName = xmlNodeGetContent(currOption);
		if(!OptionName) continue;

		if(*OptionName)
		{
			((wxComboBox *)FindWindow(IDC_NAME))->Append(OptionName, (void*)currOption);
			if(Name.size() && xmlStrcasecmp(OptionName, (unsigned char*)Name.c_str()) == 0) 
				Selection = index;
			xmlFree(OptionName);
		}

	}
	((wxComboBox *)FindWindow(IDC_NAME))->SetSelection(Selection);

	wxCommandEvent event;
	OnSelectionChanged(event);

	CenterOnScreen();
	ShowModal();
}

DlgAddValuePlugin::~DlgAddValuePlugin()
{
}


const mString & DlgAddValuePlugin::GetName()
{
	return m_Name;
}

const mString & DlgAddValuePlugin::GetValue()
{
	return m_Value;
}

void DlgAddValuePlugin::OnOk(wxCommandEvent& event)
{
	wxString type;
	wxString Name;
	wxString Value;

	Name = ((wxTextCtrl *)FindWindow(IDC_NAME))->GetValue();
	Value = ((wxTextCtrl *)FindWindow(IDC_VALUE))->GetValue();

	if(!Name.Len() || !Value.Len()) return;

	type = ((wxStaticText *)FindWindow(IDC_TYPE))->GetLabel();
	if(type == "uri" && Value.Left(7) != "http://" && Value.Left(7) != "ldap://")
	{
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS), this);
		return;
	}
	else if(type == "dn")
	{
		//TODO Find a way to verify a dn syntax
	}
	else if(type == "ip")
	{
	//	m_Value.str.
	}

	m_Name = Name.GetData();
	m_Value = Value.GetData();


	m_IsOK = true;
	Close(TRUE);
}

void DlgAddValuePlugin::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

bool DlgAddValuePlugin::IsOK()
{
	return m_IsOK;
}

void DlgAddValuePlugin::OnSelectionChanged(wxCommandEvent& event)
{
	xmlNodePtr currOption;
	int index;
	xmlAttrPtr currAttr;
	xmlChar * AttrValue;

	index = ((wxComboBox *)FindWindow(IDC_NAME))->GetSelection();
	if(index == -1) return;
	currOption = (xmlNodePtr)((wxComboBox *)FindWindow(IDC_NAME))->GetClientData(index);
	if(!currOption) return;

	for(currAttr = currOption->properties; currAttr; currAttr = currAttr->next)
	{				
		//Convert datas to SQL format
		AttrValue = xmlGetProp(currOption, currAttr->name);
		if(xmlStrcasecmp(currAttr->name, (unsigned char*)"help") == 0)
			((wxStaticText *)FindWindow(IDC_HELP_TXT))->SetLabel(AttrValue);
		else if(xmlStrcasecmp(currAttr->name, (unsigned char*)"type") == 0)
			((wxStaticText *)FindWindow(IDC_TYPE))->SetLabel(AttrValue);
		xmlFree(AttrValue);
	}
}

void DlgAddValuePlugin::OnTextChanged(wxCommandEvent& event)
{
	wxString type;
	wxString value;
	long lng_value;
	value = ((wxTextCtrl *)FindWindow(IDC_VALUE))->GetValue();	
	if(!value.Len()) return;

	type = ((wxStaticText *)FindWindow(IDC_TYPE))->GetLabel();
	if(type == "number")
	{
		value.ToLong(&lng_value);
		value.sprintf("%ld", lng_value);
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(value);
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetInsertionPointEnd();
	}
	else if(type == "port")
	{
		value.ToLong(&lng_value);
		if(lng_value <= 1)
			lng_value = 1;
		else if(lng_value >= 65536)
			lng_value = 65535;
		value.sprintf("%ld", lng_value);
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(value);
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetInsertionPointEnd();
	}
}


