/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPkiEntity.cpp: implementation of the DlgAddPkiEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgAddPkiEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddPkiEntity, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddPkiEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddPkiEntity::OnCancel)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ROOT, DlgAddPkiEntity::OnServerKeyROOT)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ROOT, DlgAddPkiEntity::OnEngineKeyROOT)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ENTITIES, DlgAddPkiEntity::OnServerKeyENTITIES)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ENTITIES, DlgAddPkiEntity::OnEngineKeyENTITIES)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_USERS, DlgAddPkiEntity::OnServerKeyUSERS)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_USERS, DlgAddPkiEntity::OnEngineKeyUSERS)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_OCSP, DlgAddPkiEntity::OnServerKeyOCSP)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_OCSP, DlgAddPkiEntity::OnEngineKeyOCSP)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_PKI, DlgAddPkiEntity::OnServerKeyPKI)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_PKI, DlgAddPkiEntity::OnEngineKeyPKI)
    EVT_RADIOBUTTON(IDC_KEY_SOFTWARE, DlgAddPkiEntity::OnSoftwareKey)
    EVT_RADIOBUTTON(IDC_KEY_HARDWARE, DlgAddPkiEntity::OnHardwareKey)
END_EVENT_TABLE()


DlgAddPkiEntity::DlgAddPkiEntity(wxWindow * wParent, PkiClient * ClientPki):DlgAddEntity(wParent, _("Add PKI Entity"), ClientPki)
{
	DlgAddPkiEntity_SetWindow(this);

	UserCreation.set_Parent(this);

	Frames = ((wxNotebook *)FindWindow(ID_NOTEBOOK));

	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN));
	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN_ROOT));
	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN_USERS));
	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN_OCSP));
	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN_ENTITIES));
	LoadKeyLen((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN_PKI));

	wxComboBox * Country;

	Country = (wxComboBox *)Frames->FindWindow(IDC_C);

	Country->Append("AD", (void*)NULL);
	Country->Append("AE", (void*)NULL);
	Country->Append("AF", (void*)NULL);
	Country->Append("AG", (void*)NULL);
	Country->Append("AI", (void*)NULL);
	Country->Append("AL", (void*)NULL);
	Country->Append("AM", (void*)NULL);
	Country->Append("AN", (void*)NULL);
	Country->Append("AO", (void*)NULL);
	Country->Append("AQ", (void*)NULL);
	Country->Append("AR", (void*)NULL);
	Country->Append("AS", (void*)NULL);
	Country->Append("AT", (void*)NULL);
	Country->Append("AU", (void*)NULL);
	Country->Append("AW", (void*)NULL);
	Country->Append("AZ", (void*)NULL);
	Country->Append("BA", (void*)NULL);
	Country->Append("BB", (void*)NULL);
	Country->Append("BD", (void*)NULL);
	Country->Append("BE", (void*)NULL);
	Country->Append("BF", (void*)NULL);
	Country->Append("BG", (void*)NULL);
	Country->Append("BH", (void*)NULL);
	Country->Append("BI", (void*)NULL);
	Country->Append("BJ", (void*)NULL);
	Country->Append("BM", (void*)NULL);
	Country->Append("BN", (void*)NULL);
	Country->Append("BO", (void*)NULL);
	Country->Append("BR", (void*)NULL);
	Country->Append("BS", (void*)NULL);
	Country->Append("BT", (void*)NULL);
	Country->Append("BV", (void*)NULL);
	Country->Append("BW", (void*)NULL);
	Country->Append("BY", (void*)NULL);
	Country->Append("BZ", (void*)NULL);
	Country->Append("CA", (void*)NULL);
	Country->Append("CC", (void*)NULL);
	Country->Append("CD", (void*)NULL);
	Country->Append("CF", (void*)NULL);
	Country->Append("CG", (void*)NULL);
	Country->Append("CH", (void*)NULL);
	Country->Append("CI", (void*)NULL);
	Country->Append("CK", (void*)NULL);
	Country->Append("CL", (void*)NULL);
	Country->Append("CM", (void*)NULL);
	Country->Append("CN", (void*)NULL);
	Country->Append("CO", (void*)NULL);
	Country->Append("CR", (void*)NULL);
	Country->Append("CU", (void*)NULL);
	Country->Append("CV", (void*)NULL);
	Country->Append("CX", (void*)NULL);
	Country->Append("CY", (void*)NULL);
	Country->Append("CZ", (void*)NULL);
	Country->Append("DE", (void*)NULL);
	Country->Append("DJ", (void*)NULL);
	Country->Append("DK", (void*)NULL);
	Country->Append("DM", (void*)NULL);
	Country->Append("DO", (void*)NULL);
	Country->Append("DZ", (void*)NULL);
	Country->Append("EC", (void*)NULL);
	Country->Append("EE", (void*)NULL);
	Country->Append("EG", (void*)NULL);
	Country->Append("EH", (void*)NULL);
	Country->Append("ER", (void*)NULL);
	Country->Append("ES", (void*)NULL);
	Country->Append("ET", (void*)NULL);
	Country->Append("FI", (void*)NULL);
	Country->Append("FJ", (void*)NULL);
	Country->Append("FK", (void*)NULL);
	Country->Append("FM", (void*)NULL);
	Country->Append("FO", (void*)NULL);
	Country->Append("FR", (void*)NULL);
	Country->Append("GA", (void*)NULL);
	Country->Append("GB", (void*)NULL);
	Country->Append("GD", (void*)NULL);
	Country->Append("GE", (void*)NULL);
	Country->Append("GF", (void*)NULL);
	Country->Append("GH", (void*)NULL);
	Country->Append("GI", (void*)NULL);
	Country->Append("GL", (void*)NULL);
	Country->Append("GM", (void*)NULL);
	Country->Append("GN", (void*)NULL);
	Country->Append("GP", (void*)NULL);
	Country->Append("GQ", (void*)NULL);
	Country->Append("GR", (void*)NULL);
	Country->Append("GS", (void*)NULL);
	Country->Append("GT", (void*)NULL);
	Country->Append("GU", (void*)NULL);
	Country->Append("GW", (void*)NULL);
	Country->Append("GY", (void*)NULL);
	Country->Append("HK", (void*)NULL);
	Country->Append("HM", (void*)NULL);
	Country->Append("HN", (void*)NULL);
	Country->Append("HR", (void*)NULL);
	Country->Append("HT", (void*)NULL);
	Country->Append("HU", (void*)NULL);
	Country->Append("ID", (void*)NULL);
	Country->Append("IE", (void*)NULL);
	Country->Append("IL", (void*)NULL);
	Country->Append("IN", (void*)NULL);
	Country->Append("IO", (void*)NULL);
	Country->Append("IQ", (void*)NULL);
	Country->Append("IR", (void*)NULL);
	Country->Append("IS", (void*)NULL);
	Country->Append("IT", (void*)NULL);
	Country->Append("JM", (void*)NULL);
	Country->Append("JO", (void*)NULL);
	Country->Append("JP", (void*)NULL);
	Country->Append("KE", (void*)NULL);
	Country->Append("KG", (void*)NULL);
	Country->Append("KH", (void*)NULL);
	Country->Append("KI", (void*)NULL);
	Country->Append("KM", (void*)NULL);
	Country->Append("KN", (void*)NULL);
	Country->Append("KP", (void*)NULL);
	Country->Append("KR", (void*)NULL);
	Country->Append("KW", (void*)NULL);
	Country->Append("KY", (void*)NULL);
	Country->Append("KZ", (void*)NULL);
	Country->Append("LA", (void*)NULL);
	Country->Append("LB", (void*)NULL);
	Country->Append("LC", (void*)NULL);
	Country->Append("LI", (void*)NULL);
	Country->Append("LK", (void*)NULL);
	Country->Append("LR", (void*)NULL);
	Country->Append("LS", (void*)NULL);
	Country->Append("LT", (void*)NULL);
	Country->Append("LU", (void*)NULL);
	Country->Append("LV", (void*)NULL);
	Country->Append("LY", (void*)NULL);
	Country->Append("MA", (void*)NULL);
	Country->Append("MC", (void*)NULL);
	Country->Append("MD", (void*)NULL);
	Country->Append("MG", (void*)NULL);
	Country->Append("MH", (void*)NULL);
	Country->Append("MK", (void*)NULL);
	Country->Append("ML", (void*)NULL);
	Country->Append("MM", (void*)NULL);
	Country->Append("MN", (void*)NULL);
	Country->Append("MO", (void*)NULL);
	Country->Append("MP", (void*)NULL);
	Country->Append("MQ", (void*)NULL);
	Country->Append("MR", (void*)NULL);
	Country->Append("MS", (void*)NULL);
	Country->Append("MT", (void*)NULL);
	Country->Append("MU", (void*)NULL);
	Country->Append("MV", (void*)NULL);
	Country->Append("MW", (void*)NULL);
	Country->Append("MX", (void*)NULL);
	Country->Append("MY", (void*)NULL);
	Country->Append("MZ", (void*)NULL);
	Country->Append("NA", (void*)NULL);
	Country->Append("NC", (void*)NULL);
	Country->Append("NE", (void*)NULL);
	Country->Append("NF", (void*)NULL);
	Country->Append("NG", (void*)NULL);
	Country->Append("NI", (void*)NULL);
	Country->Append("NL", (void*)NULL);
	Country->Append("NO", (void*)NULL);
	Country->Append("NP", (void*)NULL);
	Country->Append("NR", (void*)NULL);
	Country->Append("NU", (void*)NULL);
	Country->Append("NZ", (void*)NULL);
	Country->Append("OM", (void*)NULL);
	Country->Append("PA", (void*)NULL);
	Country->Append("PE", (void*)NULL);
	Country->Append("PF", (void*)NULL);
	Country->Append("PG", (void*)NULL);
	Country->Append("PH", (void*)NULL);
	Country->Append("PK", (void*)NULL);
	Country->Append("PL", (void*)NULL);
	Country->Append("PM", (void*)NULL);
	Country->Append("PN", (void*)NULL);
	Country->Append("PR", (void*)NULL);
	Country->Append("PS", (void*)NULL);
	Country->Append("PT", (void*)NULL);
	Country->Append("PW", (void*)NULL);
	Country->Append("PY", (void*)NULL);
	Country->Append("QA", (void*)NULL);
	Country->Append("RE", (void*)NULL);
	Country->Append("RO", (void*)NULL);
	Country->Append("RU", (void*)NULL);
	Country->Append("RW", (void*)NULL);
	Country->Append("SA", (void*)NULL);
	Country->Append("SB", (void*)NULL);
	Country->Append("SC", (void*)NULL);
	Country->Append("SD", (void*)NULL);
	Country->Append("SE", (void*)NULL);
	Country->Append("SG", (void*)NULL);
	Country->Append("SH", (void*)NULL);
	Country->Append("SI", (void*)NULL);
	Country->Append("SJ", (void*)NULL);
	Country->Append("SK", (void*)NULL);
	Country->Append("SL", (void*)NULL);
	Country->Append("SM", (void*)NULL);
	Country->Append("SN", (void*)NULL);
	Country->Append("SO", (void*)NULL);
	Country->Append("SR", (void*)NULL);
	Country->Append("ST", (void*)NULL);
	Country->Append("SV", (void*)NULL);
	Country->Append("SY", (void*)NULL);
	Country->Append("SZ", (void*)NULL);
	Country->Append("TC", (void*)NULL);
	Country->Append("TD", (void*)NULL);
	Country->Append("TF", (void*)NULL);
	Country->Append("TG", (void*)NULL);
	Country->Append("TH", (void*)NULL);
	Country->Append("TJ", (void*)NULL);
	Country->Append("TK", (void*)NULL);
	Country->Append("TM", (void*)NULL);
	Country->Append("TN", (void*)NULL);
	Country->Append("TO", (void*)NULL);
	Country->Append("TP", (void*)NULL);
	Country->Append("TR", (void*)NULL);
	Country->Append("TT", (void*)NULL);
	Country->Append("TV", (void*)NULL);
	Country->Append("TW", (void*)NULL);
	Country->Append("TZ", (void*)NULL);
	Country->Append("UA", (void*)NULL);
	Country->Append("UG", (void*)NULL);
	Country->Append("UM", (void*)NULL);
	Country->Append("US", (void*)NULL);
	Country->Append("UY", (void*)NULL);
	Country->Append("UZ", (void*)NULL);
	Country->Append("VA", (void*)NULL);
	Country->Append("VC", (void*)NULL);
	Country->Append("VE", (void*)NULL);
	Country->Append("VG", (void*)NULL);
	Country->Append("VI", (void*)NULL);
	Country->Append("VN", (void*)NULL);
	Country->Append("VU", (void*)NULL);
	Country->Append("WF", (void*)NULL);
	Country->Append("WS", (void*)NULL);
	Country->Append("YE", (void*)NULL);
	Country->Append("YT", (void*)NULL);
	Country->Append("YU", (void*)NULL);
	Country->Append("ZA", (void*)NULL);
	Country->Append("ZM", (void*)NULL);
	Country->Append("ZW", (void*)NULL);
	Country->SetSelection(0);

	PkiUserCreation::LoadProviders((wxComboBox *)Frames->FindWindow(IDC_KEY_CONTAINER));

#ifndef _WIN32
	((wxRadioButton *)Frames->FindWindow(IDC_KEY_HARDWARE))->Enable(FALSE);
#endif

	wxCommandEvent event2;
	OnServerKeyROOT(event2);
	OnServerKeyUSERS(event2);
	OnServerKeyENTITIES(event2);
	OnServerKeyOCSP(event2);
	OnServerKeyPKI(event2);
	OnSoftwareKey(event2);

	CenterOnScreen();
	ShowModal();
}

DlgAddPkiEntity::~DlgAddPkiEntity()
{
}

void DlgAddPkiEntity::OnOk(wxCommandEvent& event)
{
	wxString m_EntityName;
	wxString m_Email;
	wxString m_P12Pwd1;
	wxString m_P12Pwd2;
	wxString strDays;
	int Days;
	int RsaLen;
	int nItem;
	EntityCreationResp creation_resp;
	HashTable_Dn Dn;
	DlgMessage Msg(this);
	EntityCreationReq entry;

	if(!entry.get_datas().set_type(ENTITY_TYPE_PKI))
	{
		HandleError(NEWPKIerrGetStr(ERROR_MALLOC), this);
		return;
	}

	//Load entity name
	m_EntityName = ((wxTextCtrl *)Frames->FindWindow(IDC_ENTITY_NAME))->GetValue();
	if(!m_EntityName.Len())
	{
		return;
	}
	
	//Load Admin mail
	m_Email = ((wxTextCtrl *)Frames->FindWindow(IDC_ADMIN_MAIL))->GetValue();
	if(!m_Email.Len())
	{
		return;
	}

	m_P12Pwd1 = m_EntityName;
	m_P12Pwd1 += " - PKI Administrator";

	UserCreation.set_Info(m_P12Pwd1.GetData(), m_Email.GetData(), 1);

	
	//Load entity mail
	m_Email = ((wxTextCtrl *)Frames->FindWindow(IDC_EMAIL))->GetValue();
	if(!m_Email.Len())
	{
		return;
	}
	entry.get_datas().get_pkiCreate().set_email((char*)m_Email.GetData());

	//Load DN
	if(!SetX509_NAME(entry.get_datas().get_pkiCreate().get_dn(), Dn))
	{
		return;
	}

	//Loading validity len
	strDays = ((wxTextCtrl *)Frames->FindWindow(IDC_DAYS))->GetValue();
	if(!strDays.Len())
	{
		return;
	}
	sscanf(strDays.GetData(), "%d", &Days);
	if(Days <= 0)
	{
		return;
	}
	entry.get_datas().get_pkiCreate().set_validity(Days);

	
	//Loading PKI Entity Key
	if(!FormatCA(entry.get_datas().get_pkiCreate().get_entityKey(), IDC_KEY_ENGINE_PKI, IDC_KEY_ID_PKI, IDC_KEY_SERVER_PKI, IDC_LIST_LEN_PKI))
	{
		return;
	}

	//Loading ROOT CA Key
	if(!FormatCA(entry.get_datas().get_pkiCreate().get_rootCa(), IDC_KEY_ENGINE_ROOT, IDC_KEY_ID_ROOT, IDC_KEY_SERVER_ROOT, IDC_LIST_LEN_ROOT))
	{
		return;
	}

	//Loading USERS CA Key
	if(!FormatCA(entry.get_datas().get_pkiCreate().get_usersCa(), IDC_KEY_ENGINE_USERS, IDC_KEY_ID_USERS, IDC_KEY_SERVER_USERS, IDC_LIST_LEN_USERS))
	{
		return;
	}

	//Loading ENTITIES CA Key
	if(!FormatCA(entry.get_datas().get_pkiCreate().get_entitiesCa(), IDC_KEY_ENGINE_ENTITIES, IDC_KEY_ID_ENTITIES, IDC_KEY_SERVER_ENTITIES, IDC_LIST_LEN_ENTITIES))
	{
		return;
	}

	//Loading OCSP CA Key
	if(!FormatCA(entry.get_datas().get_pkiCreate().get_ocspCa(), IDC_KEY_ENGINE_OCSP, IDC_KEY_ID_OCSP, IDC_KEY_SERVER_OCSP, IDC_LIST_LEN_OCSP))
	{
		return;
	}

	entry.set_name((char*)m_EntityName.GetData());


	// Now doing the admin certificate request
	nItem = ((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN))->GetSelection();
	RsaLen = (long)((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN))->GetClientData(nItem);

	if(((wxRadioButton *)FindWindow(IDC_KEY_HARDWARE))->GetValue())
	{
#ifdef _WIN32
		wxString ProviderName;

		ProviderName = ((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->GetValue();
		if(!ProviderName.Len())
		{
			return;
		}
		UserCreation.set_HardwareKey(RsaLen, ProviderName.GetData());
#else
		return;
#endif
	}
	else
	{
		m_P12Pwd1 = ((wxTextCtrl *)Frames->FindWindow(IDC_PWD1))->GetValue();
		if(!m_P12Pwd1.Len())
		{
			return;
		}
		m_P12Pwd2 = ((wxTextCtrl *)Frames->FindWindow(IDC_PWD2))->GetValue();
		if(!m_P12Pwd2.Len())
		{
			return;
		}
		if(m_P12Pwd1 != m_P12Pwd2)
		{
			HandleError(_("The two passwords don't match."), this);
			return;
		}

		UserCreation.set_SoftwareKey(RsaLen, m_P12Pwd1.GetData());
	}

	if(!UserCreation.generate_Request(entry.get_datas().get_pkiCreate().get_admincreate()))
	{
		UserCreation.Cancel();
		return;
	}

	//Send the request
	Msg.wShow(_("Creating New Entity..."));
	if(!m_ClientPki->CreateEntity(entry, creation_resp))
	{
		UserCreation.Cancel();
		Msg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Msg.wHide();

	if(creation_resp.get_type() != ENTITY_TYPE_PKI)
	{
		UserCreation.Cancel();
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS), this);
		m_ClientPki->DeleteEntity((char*)m_EntityName.GetData());
		return;
	}

	if(!UserCreation.import_Response(creation_resp.get_pkiCreate()))
	{
		UserCreation.Cancel();
		m_ClientPki->DeleteEntity((char*)m_EntityName.GetData());
		return;
	}

	m_IsOK = true;
	Close(TRUE);
}

void DlgAddPkiEntity::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgAddPkiEntity::OnSoftwareKey(wxCommandEvent &event)
{
	((wxStaticText *)Frames->FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN))->Enable(TRUE);

	((wxComboBox *)Frames->FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);

	((wxTextCtrl *)Frames->FindWindow(IDC_PWD1))->Enable(TRUE);
	((wxTextCtrl *)Frames->FindWindow(IDC_PWD2))->Enable(TRUE);
	((wxStaticText *)Frames->FindWindow(IDC_STATIC_PWD1))->Enable(TRUE);
	((wxStaticText *)Frames->FindWindow(IDC_STATIC_PWD2))->Enable(TRUE);
}

void DlgAddPkiEntity::OnHardwareKey(wxCommandEvent &event)
{
	((wxStaticText *)Frames->FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxComboBox *)Frames->FindWindow(IDC_LIST_LEN))->Enable(TRUE);

	((wxComboBox *)Frames->FindWindow(IDC_KEY_CONTAINER))->Enable(TRUE);

	((wxTextCtrl *)Frames->FindWindow(IDC_PWD1))->Enable(FALSE);
	((wxTextCtrl *)Frames->FindWindow(IDC_PWD2))->Enable(FALSE);
	((wxStaticText *)Frames->FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
	((wxStaticText *)Frames->FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);
}


bool DlgAddPkiEntity::SetX509_NAME(X509_NAME *name, HashTable_Dn & Dn)
{
	wxString tmpValue;
	Dn.Clear();

	tmpValue = ((wxTextCtrl *)Frames->FindWindow(IDC_OU))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("organizationalUnitName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)Frames->FindWindow(IDC_O))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("organizationName", (char*)tmpValue.GetData());

	tmpValue = ((wxComboBox *)Frames->FindWindow(IDC_C))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("countryName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)Frames->FindWindow(IDC_ST))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("stateOrProvinceName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)Frames->FindWindow(IDC_L))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("localityName", (char*)tmpValue.GetData());

	if(!Dn.EntriesCount()) return false;

	if(name) Dn.To_X509_NAME(name);

	return true;
}

bool DlgAddPkiEntity::FormatCA(GenPrivateKey & genkey, int idc_ch_engine, int idc_val_engine, int idc_ch_server, int idc_val_server)
{
	int nItem;
	wxString tmpValue;
	wxString m_KeyId;
	int RsaLen;

	if( ((wxRadioButton *)Frames->FindWindow(idc_ch_engine))->GetValue() )
	{
		if( !((wxTextCtrl *)Frames->FindWindow(idc_val_engine))->GetValue().Len() ) return false;
		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)Frames->FindWindow(idc_val_engine))->GetValue();
		
		if(!genkey.set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleError(NEWPKIerrGetStr(ERROR_MALLOC), this);
			return false;
		}
		genkey.set_keyid((char*)m_KeyId.GetData());

	}
	else
	{
		nItem = ((wxComboBox *)Frames->FindWindow(idc_val_server))->GetSelection();
		RsaLen = (long)((wxComboBox *)Frames->FindWindow(idc_val_server))->GetClientData(nItem);

		if(!genkey.set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleError(NEWPKIerrGetStr(ERROR_MALLOC), this);
			return false;
		}
		genkey.set_keylen(RsaLen);
	}

	return true;
}


void DlgAddPkiEntity::OnServerKeyROOT(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_ROOT, IDC_KEY_ID_ROOT, IDC_LBL_KEYLEN_ROOT, IDC_LIST_LEN_ROOT);
}

void DlgAddPkiEntity::OnEngineKeyROOT(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_ROOT, IDC_KEY_ID_ROOT, IDC_LBL_KEYLEN_ROOT, IDC_LIST_LEN_ROOT);
}

void DlgAddPkiEntity::OnServerKeyUSERS(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_USERS, IDC_KEY_ID_USERS, IDC_LBL_KEYLEN_USERS, IDC_LIST_LEN_USERS);
}

void DlgAddPkiEntity::OnEngineKeyUSERS(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_USERS, IDC_KEY_ID_USERS, IDC_LBL_KEYLEN_USERS, IDC_LIST_LEN_USERS);
}

void DlgAddPkiEntity::OnServerKeyENTITIES(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_ENTITIES, IDC_KEY_ID_ENTITIES, IDC_LBL_KEYLEN_ENTITIES, IDC_LIST_LEN_ENTITIES);
}

void DlgAddPkiEntity::OnEngineKeyENTITIES(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_ENTITIES, IDC_KEY_ID_ENTITIES, IDC_LBL_KEYLEN_ENTITIES, IDC_LIST_LEN_ENTITIES);
}

void DlgAddPkiEntity::OnServerKeyOCSP(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_OCSP, IDC_KEY_ID_OCSP, IDC_LBL_KEYLEN_OCSP, IDC_LIST_LEN_OCSP);
}

void DlgAddPkiEntity::OnEngineKeyOCSP(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_OCSP, IDC_KEY_ID_OCSP, IDC_LBL_KEYLEN_OCSP, IDC_LIST_LEN_OCSP);
}

void DlgAddPkiEntity::OnServerKeyPKI(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_PKI, IDC_KEY_ID_PKI, IDC_LBL_KEYLEN_PKI, IDC_LIST_LEN_PKI);
}

void DlgAddPkiEntity::OnEngineKeyPKI(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_PKI, IDC_KEY_ID_PKI, IDC_LBL_KEYLEN_PKI, IDC_LIST_LEN_PKI);
}

