geometry = ngsolve/pde_tutorial/ferrit.geo
mesh = ngsolve/pde_tutorial/ferrit.vol

define constant geometryorder = 3
define constant secondorder = 0
#define constant heapsize = 100000000

define coefficient nu
1, 1, 1.e-3

define coefficient sigma
1e-6, 1e-6, 1e-6,

define coefficient cs1
( x2 / sqrt( x1*x1 + x2*x2 ) ), 0, 0, 
define coefficient cs2
( -x1 / sqrt(x1*x1 + x2*x2 ) ), 0, 0, 
define coefficient cs3
0, 0, 0

define coefficient penalty
1e6, 0, 0, 0, 0, 0


define fespace v -hcurlho -order=3 -nograds -noeliminate_internal 
#define fespace vb -l2ho -order=2 -dim=3 

define gridfunction u -fespace=v -novisual

define linearform f -fespace=v
sourceedge cs1 cs2 cs3 -definedon=1

define bilinearform a -fespace=v -symmetric -noeliminate_internal -linearform=f
curlcurledge nu 
massedge sigma -order=2
#robinedge penalty


define bilinearform acurl -fespace=v -symmetric -nonassemble
curlcurledge nu 


define preconditioner c -type=multigrid -bilinearform=a -cylce=1 -smoother=block -coarsetype=direct -coarsesmoothingsteps=5 -notest
#define preconditioner c -type=amg -bilinearform=a -hcurl -coefe=sigma -coeff=nu -notiming -notest
# define preconditioner c -type=direct -bilinearform=a

numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=50 -prec=1.e-8

numproc drawflux np5 -bilinearform=acurl -solution=u  -label=B-field
numproc drawflux np6 -bilinearform=acurl -solution=u  -label=H-field -applyd

#numproc evaluate npevalb -text=evalb -bilinearform=acurl -gridfunction=u -point=[0,0,0] 
#numproc evaluate npevalh -text=evalh -bilinearform=acurl -gridfunction=u -applyd -point=[0,0,0] 

#numproc tclmenu nptc1 -menuname=solve -text=Slice-Bz -comp=3 -centerpoint=[0,0,0] -clipvec=[0,1,0] -fieldname=B-field -minval=-0.5 -maxval=0.5

