geometry = examples/coilshield.geo
mesh = examples/coilshield.vol


define constant geometryorder = 3
define constant secondorder = 0


define coefficient nu material
iron 1e-4
default 1


define coefficient kappa material
default 1e-6


define coefficient cs1
0, ( y ), 0, 0, 0, 
define coefficient cs2
0, ( -x ), 0, 0, 0, 
define coefficient cs3
0, 0, 0, 0, 0, 

# define coefficient penalty
# 1, 0, 0, 0, 0, 0


define fespace v -hcurlho -order=0 #-nograds
define fespace vb -l2 -dim=3 -order=1

define gridfunction u -fespace=v
define gridfunction b -fespace=vb

define bilinearform a -fespace=v -symmetric -noprintelmat
curlcurledge nu 
massedge kappa  #-order=2
#robinedge penalty
	
define bilinearform acurl -fespace=v -symmetric 
curlcurledge nu

define linearform f -fespace=v -noprintelvec
sourceedge cs1 cs2 cs3  -definedon=2

define preconditioner c -type=multigrid -bilinearform=a -smoother=block -cycle=1 -coarsetype=direct -test
# define preconditioner c -type=direct -bilinearform=a

numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=400 -prec=1.e-8

numproc calcflux np2 -bilinearform=acurl -solution=u -flux=b
numproc drawflux np3 -bilinearform=acurl -solution=u -label=flux

# numproc zzerrorestimator np3 -bilinearform=a -solution=u -error=err
# numproc markelements np4 -error=err -factor=0.1

