#ifndef FILE_FEM
#define FILE_FEM

/*********************************************************************/
/* File:   fem.hpp                                                   */
/* Author: Joachim Schoeberl                                         */
/* Date:   25. Mar. 2000                                             */
/*********************************************************************/

/* 
   Finite Element kernel functions
*/


#ifdef NETGEN_ELTRANS
#include <nginterface.h>
#endif

/// namespace for finite elements
namespace ngfem
{
  using namespace std;
  using namespace ngstd;
  using ngstd::INT;
  using namespace ngbla;


#include "elementtopology.hpp"
#include "intrule.hpp"
#include "recursive_pol.hpp"
#include "recursive_pol_trig.hpp"
#include "recursive_pol_tet.hpp"

#include "finiteelement.hpp"
#include "elementtransformation.hpp"
#include "highorderfe.hpp"
#include "h1hofe.hpp"
#include "l2hofe.hpp"
#include "hdivfe.hpp"
#include "hcurlfe.hpp"
#include "specialelement.hpp"
#include "coefficient.hpp"
#include "integrator.hpp"
#include "bdbequations.hpp"
#include "equilibrium.hpp"
#include "hdiv_equations.hpp"

#include "hdivhofe.hpp"
#include "hdiv_equations.hpp"

#include "hcurlhofe.hpp" 
}


#endif
