// ng_teststle

// loads triangles and edge from file


#include <iostream.h>
#include <fstream.h>

namespace nglib {
#include "../libsrc/interface/nglib.h"
}

using namespace nglib;



int main (int argc, char ** argv)
{
  cout << "STL Meshing" << endl;

  if (argc < 2)
    {
      cerr << "use: ng_stl filename" << endl;
      return 1;
    }

  int i, j, rv;

  Ng_Mesh * mesh;
  Ng_STL_Geometry * geom;


  Ng_Meshing_Parameters mp;
  mp.maxh=100000;
  mp.fineness = 0.5;
  mp.secondorder = 0;
  mp.meshsize_filename = "hinge.msz";

  Ng_Init();

  geom = Ng_STL_LoadGeometry (argv[1]);
  if (!geom)
    {
      cerr << "Ng_STL_LoadGeometry return NULL" << endl;
      exit(1);
    }

  rv = Ng_STL_InitSTLGeometry(geom);
  cout << "InitSTLGeometry: NG_result=" << rv << endl;

  mesh = Ng_NewMesh ();

  rv = Ng_STL_MakeEdges (geom, mesh, &mp);
  cout << "Make Edges: Ng_result=" << rv << endl;

  rv = Ng_STL_GenerateSurfaceMesh (geom, mesh, &mp);
  cout << "Generate Surface Mesh: Ng_result=" << rv << endl;
	
  Ng_SaveMesh (mesh, "surface.vol");
  
  rv = Ng_GenerateVolumeMesh(mesh,&mp);
  cout << "Generate Volume Mesh: Ng_result=" << rv << endl;

  Ng_SaveMesh (mesh, "volume.vol");
  
  Ng_Exit();
}
