#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>

#include "../libsrc/interface/nglib.h"


int main (int argc, char ** argv)
{
  cout << "Netgen 2D" << endl;

  if (argc < 4)
    {
      cerr << "use: ng_2d infilename outfile meshsize" << endl;
      return 1;
    }

  cout << "Infile = " << argv[1] << endl;
  cout << "Outfile = " << argv[2] << endl;
  cout << "Meshsize = " << atof(argv[3]) << endl;


  Ng_Mesh * mesh;
  Ng_Geometry_2D * geom;


  Ng_Init();


  geom = Ng_LoadGeometry_2D (argv[1]);

  // generate volume mesh
  Ng_Meshing_Parameters mp;
  mp.maxh = atof (argv[3]);
  mp.fineness = 1;
  mp.secondorder = 0;

  Ng_GenerateMesh_2D (geom, &mesh, &mp);



  // mesh output
  ofstream outfile (argv[2]);
  outfile.precision(8);

  int i, nseg, ne, np, matnum;
  int nodes[3];
  double point[2];

  np = Ng_GetNP_2D (mesh);
  ne = Ng_GetNE_2D (mesh);
  nseg = Ng_GetNSeg_2D (mesh);

  outfile << nseg << endl;
  for (i = 1; i <= nseg; i++)
    {
      Ng_GetSegment_2D (mesh, i, nodes, &matnum);
      outfile << matnum << " " << nodes[0] << " " << nodes[1] << endl;
    }

  outfile << ne << endl;
  for (i = 1; i <= ne; i++)
    {
      Ng_GetElement_2D (mesh, i, nodes, &matnum);
      outfile << matnum << " " << nodes[0] << " " << nodes[1] << " " << nodes[2] << endl;
    }

  outfile << np << endl;
  for (i = 1; i <= np; i++)
    {
      Ng_GetPoint_2D (mesh, i, point);
      outfile << point[0] << " " << point[1] << endl;
    }

  return 0;
}
