/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.pdf;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;

import org.openide.util.NbBundle;

/** Simple panel for a dialog asking users to choose a PDF viewer.
 * Offers a file chooser.
 * @author Jesse Glick
 */
public class ReconfigureReaderPanel extends javax.swing.JPanel {

    private Settings settings;
    private final File defaultViewer;
    private ResourceBundle bundle = NbBundle.getBundle (ReconfigureReaderPanel.class);

    public ReconfigureReaderPanel (File defaultViewer, String exceptionMessage) {
        settings = Settings.getDefault ();
        this.defaultViewer = defaultViewer;
        initComponents ();
        initAccessibility ();            
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString ("LBL_reconfigure"));
        viewerField.getAccessibleContext().setAccessibleDescription(bundle.getString ("ACS_Field"));
        chooseButton.getAccessibleContext().setAccessibleDescription(bundle.getString ("ACS_LBL_choose"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        topLabel = new javax.swing.JLabel();
        currentViewerLabel = new javax.swing.JLabel();
        viewerField = new javax.swing.JTextField();
        chooseButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        topLabel.setText(bundle.getString ("LBL_reconfigure"));
        topLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 11);
        add(topLabel, gridBagConstraints);

        currentViewerLabel.setText(bundle.getString ("LBL_current_viewer"));
        currentViewerLabel.setLabelFor(viewerField);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 12, 12);
        add(currentViewerLabel, gridBagConstraints);

        viewerField.setText(settings.getPDFViewer() != null ? settings.getPDFViewer().getPath() : PDFOpenSupport.FALLBACK_VIEWER_NAME);
        viewerField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                viewerFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(viewerField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(chooseButton, org.openide.util.NbBundle.getMessage(ReconfigureReaderPanel.class, "LBL_choose")); // NOI18N
        chooseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 12, 11);
        add(chooseButton, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // accessibility
    private void viewerFieldFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_viewerFieldFocusGained
        viewerField.selectAll();
    }//GEN-LAST:event_viewerFieldFocusGained

    private void chooseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseButtonActionPerformed
        File dir = defaultViewer.getParentFile();
        JFileChooser chooser = (dir != null)
                               ? new JFileChooser(dir)
                               : new JFileChooser();
        String chooserTitle = bundle.getString("LBL_select_viewer");    //NOI18N
        if (chooser.showDialog (this, chooserTitle)
                == JFileChooser.APPROVE_OPTION) {
            viewerField.setText(chooser.getSelectedFile().getPath());
        }
    }//GEN-LAST:event_chooseButtonActionPerformed

    /**
     */
    File getSelectedFile() {
        return new File(viewerField.getText().trim());
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton chooseButton;
    private javax.swing.JLabel currentViewerLabel;
    private javax.swing.JLabel topLabel;
    private javax.swing.JTextField viewerField;
    // End of variables declaration//GEN-END:variables

}
