/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xslt.model.AttributeSet;
import org.netbeans.modules.xslt.model.LiteralResultElement;
import org.netbeans.modules.xslt.model.SequenceElement;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.StylesheetChild;
import org.netbeans.modules.xslt.model.Template;
import org.netbeans.modules.xslt.model.XslModel;


/**
 * @author ads
 *
 */
public class SyncTest extends AbstractXslTestCase {
    
    public String TEST_MODIFIED                = "test_modified.xsl";
    
    public String TEST_MODIFIED_LITERAL_DELETE = "test_modified_literal_delete.xsl"; 
    
    public String TEST_MODIFIED_LITERAL        = "test_modified_literal.xsl";

    public SyncTest( String testName ) {
        super(testName);
    }
    
    public void setUp ( ) {
        myListener = new Listener();
    }
    //will put back after fix xam whitespace filter
    public void FIXME_testStylesheetChildAdd() throws IOException {
        Stylesheet stylesheet = getStyleSheet( TEST , true );
        
        List<StylesheetChild> oldList = stylesheet.getStylesheetChildren();
        XslModel model = stylesheet.getModel();

        model.addPropertyChangeListener( getListener() );
        model.addComponentListener(getListener());
        
        Utils.setNewContentFromFile( model, TEST_MODIFIED );
        
        model.removePropertyChangeListener( getListener() );
        model.removeComponentListener(getListener());
        
        List<StylesheetChild> list = stylesheet.getStylesheetChildren();
        boolean nextShouldBeAttributeSet = false;
        boolean found = false;
        int count = 0;
        for (StylesheetChild child : list) {
            if ( child.getComponentType() == Template.class && 
                    !nextShouldBeAttributeSet ) 
            {
                assert child.getComponentType() == 
                    oldList.get( count ).getComponentType(): "Expected "+
                    oldList.get( count ).getComponentType()+" but got "+
                    child.getComponentType();
                nextShouldBeAttributeSet = true;
                found = true;
                count++;
            }
            else if ( nextShouldBeAttributeSet && found ){
                assert child.getComponentType() == AttributeSet.class:
                    "Expected AttributeSet class for child component "+
                    "but got "+child.getComponentType();
                found = false;
            }
            else {
                assert child.getComponentType() == 
                    oldList.get( count ).getComponentType(): "Expected "+
                    oldList.get( count ).getComponentType()+" but got "+
                    child.getComponentType();
                count++;
            }
        }
        
        assertEquals("Event count", 1, getListener().getPropertyChangeEvents().size());
        assert getListener().getPropertyChangeEvents().get( 0 ).getPropertyName().
            equals(Stylesheet.STYLESHEET_TOP_LEVEL_ELEMENTS): "Property name event" +
                    " mismatch";
        assert getListener().getPropertyChangeEvents().get( 0 ).getSource().
            equals( stylesheet ) : "Property change source mismatch";
        
        assert getListener().getDeletedEvents().size() ==0 : 
            "No deleted events should occur";
        assert getListener().getValueChangedEvents().size() ==0 :
            "No value change events should occur";
        assert getListener().getAddedEvents().size() ==1 : "There should be exactly " +
                "one add event";
        assert getListener().getAddedEvents().get(0).getSource().equals( 
                stylesheet) : "Source mismatch in added event";
                
        getListener().clearEvents();
    }
    
    public void testStylesheetLiteralDelete() throws IOException {
        Stylesheet stylesheet = getStyleSheet( TEST , true);
        
        Template template = stylesheet.getChildren( 
                Template.class).get(0);
        List<SequenceElement> oldList = template.getSequenceChildren();
        XslModel model = stylesheet.getModel();
        model.addPropertyChangeListener( getListener() );
        model.addComponentListener(getListener());
        
        Utils.setNewContentFromFile( model, TEST_MODIFIED_LITERAL_DELETE );
        
        
        model.removePropertyChangeListener( getListener() );
        model.removeComponentListener(getListener());

        List<SequenceElement> list = template.getSequenceChildren();
        int count = 0;
        for (SequenceElement child : oldList) {
            if ( !child.getComponentType().equals( LiteralResultElement.class )) {
                assert child.getComponentType().equals( list.get(count).
                        getComponentType());
                count++;
            }
        }
        assert oldList.size() == list.size()+1 :"Incorrect count of children " +
                "after deletion of element in source, should be " +
                (oldList.size()-1)+" but found :" +list.size();
        
        assert getListener().getPropertyChangeEvents().size()==2 :
            "There should be exactly two property events , found : "+
            getListener().getPropertyChangeEvents().size();
        int i = 0;
        for ( PropertyChangeEvent ev :getListener().getPropertyChangeEvents() ) {
            System.out.println(ev.getPropertyName());
            if ( ev.getPropertyName().equals( Template.TEXT_CONTENT_PROPERTY)) {
                i++;
            }
            else if ( ev.getPropertyName().equals( Template.SEQUENCE_ELEMENT) ) {
                i++;
            }
        }
        assert i==2 : "There should be exactly two property events with" +
                " names " +Template.TEXT_CONTENT_PROPERTY +" and " + 
                Template.SEQUENCE_ELEMENT +", but found "+i;
        
        assert getListener().getPropertyChangeEvents().get( 0 ).getSource().
            equals( template ):"Source mismatch in property change events";
        
        assert getListener().getDeletedEvents().size() ==1 :"There should " +
                "be exactly one deleted event";
        assert getListener().getValueChangedEvents().size() ==1: "There should be" +
                " exactly one value change event";
        assert getListener().getValueChangedEvents().get(0).getSource().equals(
                template ): "Source mismatch in value changed event";
        assert getListener().getAddedEvents().size() ==0 : "No added events " +
                "should occur";
        assert getListener().getDeletedEvents().get(0).getSource().equals( 
                template ) : "Source mismatch in deleted event";
                
        getListener().clearEvents();
    }
    
    //will put back after fix xam whitespace filter
    public void FIXME_testStylesheetLiteralAdd() throws IOException {
        Stylesheet stylesheet = getStyleSheet( TEST , true);
        
        Template template = stylesheet.getChildren( 
                Template.class).get(0);
        List<SequenceElement> oldList = template.getSequenceChildren();
        XslModel model = stylesheet.getModel();
        
        model.addPropertyChangeListener( getListener() );
        model.addComponentListener(getListener());
        
        Utils.setNewContentFromFile( model, TEST_MODIFIED_LITERAL );
        
        
        model.removePropertyChangeListener( getListener() );
        model.removeComponentListener(getListener());

        List<SequenceElement> list = template.getSequenceChildren();
        int count = 0;
        boolean nextIsAdded = false;
        for (SequenceElement child : oldList) {
            if( nextIsAdded ) {
                nextIsAdded = false;
                count++;
                continue;
            }
            if ( child.getComponentType().equals( LiteralResultElement.class )
                    && !nextIsAdded ) {
                nextIsAdded = true;
            }
            child.getComponentType().equals( list.get(count));
            count++;
        }
        
        assert getListener().getPropertyChangeEvents().size()==1:
            "There should be exactly two property events , found : "+
            getListener().getPropertyChangeEvents().size();
        assert getListener().getPropertyChangeEvents().get( 0 ).getPropertyName().
            equals( Template.SEQUENCE_ELEMENT): "Property name event mismatch";
        assert getListener().getPropertyChangeEvents().get( 0 ).getSource().
            equals( template ): "Source mismatch in property event";
        
        assert getListener().getDeletedEvents().size() ==0;
        assert getListener().getValueChangedEvents().size() ==0;
        assert getListener().getAddedEvents().size() ==1 :"There should " +
            "be exactly one deleted event";
        assert getListener().getAddedEvents().get(0).getSource().equals( 
                template ) : "Source mismatch in added event";
        getListener().clearEvents();
    }
    
    private Listener getListener() {
        return myListener;
    }
    
    static class Listener implements PropertyChangeListener, ComponentListener{

        /* (non-Javadoc)
         * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
         */
        public void propertyChange( PropertyChangeEvent event ) {
            myPropEvents.add( event );
        }

        /* (non-Javadoc)
         * @see org.netbeans.modules.xml.xam.ComponentListener#childrenAdded(org.netbeans.modules.xml.xam.ComponentEvent)
         */
        public void childrenAdded( ComponentEvent evt ) {
            myAddedEvents.add(evt);
        }

        /* (non-Javadoc)
         * @see org.netbeans.modules.xml.xam.ComponentListener#childrenDeleted(org.netbeans.modules.xml.xam.ComponentEvent)
         */
        public void childrenDeleted( ComponentEvent evt ) {
            myDeletedEvents.add(evt);
        }

        /* (non-Javadoc)
         * @see org.netbeans.modules.xml.xam.ComponentListener#valueChanged(org.netbeans.modules.xml.xam.ComponentEvent)
         */
        public void valueChanged( ComponentEvent evt ) {
            myValueChangedEvents.add(evt);
        }
        
        List<PropertyChangeEvent> getPropertyChangeEvents(){
            return myPropEvents;
        }
        
        List<ComponentEvent> getAddedEvents() {
            return myAddedEvents;
        }
        
        List<ComponentEvent> getDeletedEvents() {
            return myDeletedEvents;
        }
        
        List<ComponentEvent> getValueChangedEvents() {
            return myValueChangedEvents;
        }
        
        void clearEvents() {
            myPropEvents.clear();
            myAddedEvents.clear();
            myDeletedEvents.clear();
            myValueChangedEvents.clear();
        }

        private List<PropertyChangeEvent> myPropEvents = 
                new LinkedList<PropertyChangeEvent>();
        
        private List<ComponentEvent> myAddedEvents = 
            new LinkedList<ComponentEvent>();
        
        private List<ComponentEvent> myDeletedEvents =
            new LinkedList<ComponentEvent>();
        
        private List<ComponentEvent> myValueChangedEvents =
            new LinkedList<ComponentEvent>();
        
    }
    
    private Listener myListener;

}
