/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.localhistory;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openide.ErrorManager;

/**
 *
 * @author Petr Kuzel
 */
public final class Diagnostics {

    private static PrintWriter log;

    private static String path;

    public static final boolean ON;
    
    private static final SimpleDateFormat defaultFormat = new SimpleDateFormat("dd-MM-yyyy:HH-mm-ss.S"); //DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM);      
    
    static {
//        if (log != null) {
//            return;
//        }
        path = System.getProperty("netbeans.debug.localHistoryLog"); // NOI18N
        if (path != null && !path.trim().equals("")) {
            try {
                log = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(path, true)), "utf8")); // NOI18N
                System.err.println("LocalHistory diagnostics: ON"); // NOI18N                                                
            } catch (IOException ex) {
                ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                log = null;
            }
        }
        ON = log != null;              
    }

    public Diagnostics() {
        //init();        
    }

    public synchronized static void println(String msg) {
        if (log != null) {                         
            StringBuffer sb = new StringBuffer();
            sb.append(defaultFormat.format(new Date(System.currentTimeMillis())));
            sb.append(":");
            sb.append(msg);
            sb.append('\t');
            sb.append(Thread.currentThread().getName());            
            log.println(sb.toString()); // NOI18N
            log.flush();
        }
    }
    
    public synchronized static void logCreate(File file, File storeFile, long ts, String  from, String to) {
        StringBuffer sb = new StringBuffer();
        sb.append("create");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');        
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');        
        sb.append(ts);
        sb.append('\t');        
        sb.append(from);
        sb.append('\t');        
        sb.append(to);               
        println(sb.toString());
    }

    public synchronized static void logChange(File file, File storeFile, long ts) {
        StringBuffer sb = new StringBuffer();
        sb.append("change");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');        
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');        
        sb.append(ts);
        
        println(sb.toString());
    }
    
    
    public synchronized static void logDelete(File file, File storeFile, long ts) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');        
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');        
        sb.append(ts);        
        println(sb.toString());
    }

    public String toString() {
        return "" + path; // NOI18N
    }
}
